/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3.angle;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.internal.gl3.DriverGL3Configuration;
import org.openrndr.internal.gl3.angle.Angle;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0006\u0010\u0002\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0004"}, d2={"logger", "Lio/github/oshai/kotlinlogging/KLogger;", "extractAngleLibraries", "", "openrndr-gl3"})
public final class AngleKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(AngleKt::logger$lambda$0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void extractAngleLibraries() {
        File targetGlesv2;
        logger.info(AngleKt::extractAngleLibraries$lambda$1);
        File targetDirectory = new File(".");
        InputStream inputStream = Angle.class.getResourceAsStream("/org/openrndr/internal/gl3/angle/libEGL.dylib");
        if (inputStream == null) {
            throw new IllegalStateException("libEGL.dylib not found in resources".toString());
        }
        InputStream egl = inputStream;
        File targetEgl = new File(targetDirectory, "libEGL.dylib");
        if (!targetEgl.exists() || DriverGL3Configuration.INSTANCE.getOverwriteExistingAngle()) {
            Closeable closeable = new FileOutputStream(targetEgl);
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)closeable;
                boolean bl = false;
                long l = ByteStreamsKt.copyTo$default(egl, it, 0, 2, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        if (!(targetGlesv2 = new File(targetDirectory, "libGLESv2.dylib")).exists() || DriverGL3Configuration.INSTANCE.getOverwriteExistingAngle()) {
            InputStream inputStream2 = Angle.class.getResourceAsStream("/org/openrndr/internal/gl3/angle/libGLESv2.dylib");
            if (inputStream2 == null) {
                throw new IllegalStateException("libGLESv2.dylib not found in resources".toString());
            }
            InputStream glesv2 = inputStream2;
            Closeable closeable = new FileOutputStream(targetGlesv2);
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)closeable;
                boolean bl = false;
                long l = ByteStreamsKt.copyTo$default(glesv2, it, 0, 2, null);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        if (DriverGL3Configuration.INSTANCE.getDeleteAngleOnExit()) {
            new File(targetDirectory, "libGLESv2.dylib").deleteOnExit();
            new File(targetDirectory, "libEGL.dylib").deleteOnExit();
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object extractAngleLibraries$lambda$1() {
        return "Loading ANGLE libraries from resources";
    }
}

