/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3.extensions;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.libffi.FFICIF;
import org.lwjgl.system.libffi.LibFFI;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015J6\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u001d"}, d2={"Lorg/openrndr/internal/gl3/extensions/AngleExtensions;", "", "functionProvider", "Lorg/lwjgl/system/FunctionProvider;", "<init>", "(Lorg/lwjgl/system/FunctionProvider;)V", "glTexStorage2DMultisampleANGLEAddress", "", "getGlTexStorage2DMultisampleANGLEAddress", "()J", "glGetTexLevelParameterivANGLEAddress", "getGlGetTexLevelParameterivANGLEAddress", "glGetTexLevelParameterfvANGLEAddress", "getGlGetTexLevelParameterfvANGLEAddress", "glTexLevelParameterivANGLE", "", "target", "", "level", "pname", "params", "", "glTexStorage2DMultisampleANGLE", "samples", "internalFormat", "width", "height", "fixedSampleLocations", "", "openrndr-gl3"})
public final class AngleExtensions {
    private final long glTexStorage2DMultisampleANGLEAddress;
    private final long glGetTexLevelParameterivANGLEAddress;
    private final long glGetTexLevelParameterfvANGLEAddress;

    public AngleExtensions(@NotNull FunctionProvider functionProvider) {
        Intrinsics.checkNotNullParameter(functionProvider, "functionProvider");
        this.glTexStorage2DMultisampleANGLEAddress = functionProvider.getFunctionAddress("glTexStorage2DMultisampleANGLE");
        this.glGetTexLevelParameterivANGLEAddress = functionProvider.getFunctionAddress("glGetTexLevelParameterivANGLE");
        this.glGetTexLevelParameterfvANGLEAddress = functionProvider.getFunctionAddress("glGetTexLevelParameterfvANGLE");
    }

    public final long getGlTexStorage2DMultisampleANGLEAddress() {
        return this.glTexStorage2DMultisampleANGLEAddress;
    }

    public final long getGlGetTexLevelParameterivANGLEAddress() {
        return this.glGetTexLevelParameterivANGLEAddress;
    }

    public final long getGlGetTexLevelParameterfvANGLEAddress() {
        return this.glGetTexLevelParameterfvANGLEAddress;
    }

    public final void glTexLevelParameterivANGLE(int target, int level, int pname, @NotNull int[] params) {
        Intrinsics.checkNotNullParameter(params, "params");
        if (!(this.glGetTexLevelParameterivANGLEAddress != 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        JNI.callPV(target, level, pname, params, this.glGetTexLevelParameterivANGLEAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void glTexStorage2DMultisampleANGLE(int target, int samples, int internalFormat, int width, int height, boolean fixedSampleLocations) {
        if (!(this.glTexStorage2DMultisampleANGLEAddress != 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        AutoCloseable autoCloseable = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            MemoryStack stack = (MemoryStack)autoCloseable;
            boolean bl = false;
            IntBuffer ptarget = stack.mallocInt(1);
            IntBuffer psamples = stack.mallocInt(1);
            IntBuffer pinternalFormat = stack.mallocInt(1);
            IntBuffer pwidth = stack.mallocInt(1);
            IntBuffer pheight = stack.mallocInt(1);
            ByteBuffer pfixedSampleLocations = stack.malloc(1);
            ptarget.put(target).flip();
            psamples.put(samples).flip();
            pinternalFormat.put(internalFormat).flip();
            pwidth.put(width).flip();
            pheight.put(height).flip();
            pfixedSampleLocations.put(fixedSampleLocations ? (byte)1 : 0).flip();
            PointerBuffer arguments = stack.mallocPointer(6);
            arguments.put(MemoryUtil.memAddress(ptarget));
            arguments.put(MemoryUtil.memAddress(psamples));
            arguments.put(MemoryUtil.memAddress(pinternalFormat));
            arguments.put(MemoryUtil.memAddress(pwidth));
            arguments.put(MemoryUtil.memAddress(pheight));
            arguments.put(MemoryUtil.memAddress(pfixedSampleLocations));
            arguments.flip();
            PointerBuffer argumentTypes = stack.mallocPointer(6);
            argumentTypes.put(LibFFI.ffi_type_sint);
            argumentTypes.put(LibFFI.ffi_type_sint);
            argumentTypes.put(LibFFI.ffi_type_sint);
            argumentTypes.put(LibFFI.ffi_type_sint);
            argumentTypes.put(LibFFI.ffi_type_sint);
            argumentTypes.put(LibFFI.ffi_type_uint8);
            argumentTypes.flip();
            FFICIF cif = FFICIF.malloc();
            LibFFI.ffi_prep_cif(cif, LibFFI.FFI_DEFAULT_ABI, LibFFI.ffi_type_void, argumentTypes);
            LibFFI.ffi_call(cif, this.glTexStorage2DMultisampleANGLEAddress, null, arguments);
            cif.free();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }
}

