/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.glcommon;

import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferPrimitiveType;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorSampling;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.ShadeStyleKt;
import org.openrndr.draw.ShadeStyleOutput;
import org.openrndr.draw.ShaderStorageElement;
import org.openrndr.draw.ShaderStorageFormat;
import org.openrndr.draw.ShaderStoragePrimitive;
import org.openrndr.draw.ShaderStorageStruct;
import org.openrndr.draw.VertexElementType;
import org.openrndr.draw.font.BufferAccess;
import org.openrndr.draw.font.BufferFlag;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0001H\u0000\"\u0018\u0010\u0006\u001a\u00020\u0001*\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0018\u0010\u0006\u001a\u00020\u0001*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\"\u0018\u0010\u0006\u001a\u00020\u0001*\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\r\"\u0018\u0010\u000e\u001a\u00020\u0001*\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\"\u0018\u0010\u0010\u001a\u00020\u0001*\u00020\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0018\u0010\u0014\u001a\u00020\u0001*\u00020\u00158@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u0018\u0010\u0014\u001a\u00020\u0001*\u00020\u00188@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0019\u00a8\u0006\u001c"}, d2={"imageLayout", "", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "glslType", "Lorg/openrndr/draw/ShadeStyleOutput;", "getGlslType", "(Lorg/openrndr/draw/ShadeStyleOutput;)Ljava/lang/String;", "Lorg/openrndr/draw/BufferPrimitiveType;", "(Lorg/openrndr/draw/BufferPrimitiveType;)Ljava/lang/String;", "Lorg/openrndr/draw/VertexElementType;", "(Lorg/openrndr/draw/VertexElementType;)Ljava/lang/String;", "glslVaryingQualifier", "getGlslVaryingQualifier", "glslLayout", "Lorg/openrndr/draw/ShaderStorageFormat;", "getGlslLayout", "(Lorg/openrndr/draw/ShaderStorageFormat;)Ljava/lang/String;", "glsl", "Lorg/openrndr/draw/font/BufferAccess;", "getGlsl", "(Lorg/openrndr/draw/font/BufferAccess;)Ljava/lang/String;", "Lorg/openrndr/draw/font/BufferFlag;", "(Lorg/openrndr/draw/font/BufferFlag;)Ljava/lang/String;", "mapTypeToUniform", "name", "openrndr-gl-common"})
public final class MappingKt {
    @NotNull
    public static final String imageLayout(@NotNull ColorFormat format, @NotNull ColorType type) {
        String string;
        Intrinsics.checkNotNullParameter((Object)format, "format");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Pair<ColorFormat, ColorType> pair = new Pair<ColorFormat, ColorType>(format, type);
        if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.R, ColorType.UINT8))) {
            string = "r8";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.R, ColorType.UINT8_INT))) {
            string = "r8u";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.R, ColorType.SINT8_INT))) {
            string = "r8i";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.R, ColorType.UINT16))) {
            string = "r16";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.R, ColorType.UINT16_INT))) {
            string = "r16u";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.R, ColorType.SINT16_INT))) {
            string = "r16i";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.R, ColorType.UINT32_INT))) {
            string = "r32u";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.R, ColorType.SINT32_INT))) {
            string = "r32i";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.R, ColorType.FLOAT16))) {
            string = "r16f";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.R, ColorType.FLOAT32))) {
            string = "r32f";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RG, ColorType.UINT8))) {
            string = "rg8";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RG, ColorType.UINT8_INT))) {
            string = "rg8u";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RG, ColorType.SINT8_INT))) {
            string = "rg8i";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RG, ColorType.UINT16))) {
            string = "rg16";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RG, ColorType.UINT16_INT))) {
            string = "rg16u";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RG, ColorType.SINT16_INT))) {
            string = "rg16i";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RG, ColorType.FLOAT16))) {
            string = "rg16f";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RG, ColorType.FLOAT32))) {
            string = "rg32f";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RGBa, ColorType.UINT8))) {
            string = "rgba8";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RGBa, ColorType.UINT8_INT))) {
            string = "rgba8u";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RGBa, ColorType.SINT8_INT))) {
            string = "rgba8i";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RGBa, ColorType.UINT16))) {
            string = "rgba16";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RGBa, ColorType.UINT16_INT))) {
            string = "rgba16u";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RGBa, ColorType.SINT16_INT))) {
            string = "rgba16i";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RGBa, ColorType.FLOAT16))) {
            string = "rgba16f";
        } else if (Intrinsics.areEqual(pair, new Pair<ColorFormat, ColorType>(ColorFormat.RGBa, ColorType.FLOAT32))) {
            string = "rgba32f";
        } else {
            throw new IllegalStateException(("unsupported layout: " + format + " " + type).toString());
        }
        return string;
    }

    @NotNull
    public static final String getGlslType(@NotNull ShadeStyleOutput $this$glslType) {
        String string;
        Intrinsics.checkNotNullParameter($this$glslType, "<this>");
        Pair<Integer, ColorSampling> pair = new Pair<Integer, ColorSampling>($this$glslType.getFormat().getComponentCount(), $this$glslType.getType().getColorSampling());
        if (Intrinsics.areEqual(pair, new Pair<Integer, ColorSampling>(1, ColorSampling.NORMALIZED))) {
            string = "float";
        } else if (Intrinsics.areEqual(pair, new Pair<Integer, ColorSampling>(2, ColorSampling.NORMALIZED))) {
            string = "vec2";
        } else if (Intrinsics.areEqual(pair, new Pair<Integer, ColorSampling>(3, ColorSampling.NORMALIZED))) {
            string = "vec3";
        } else if (Intrinsics.areEqual(pair, new Pair<Integer, ColorSampling>(4, ColorSampling.NORMALIZED))) {
            string = "vec4";
        } else if (Intrinsics.areEqual(pair, new Pair<Integer, ColorSampling>(1, ColorSampling.UNSIGNED_INTEGER))) {
            string = "uint";
        } else if (Intrinsics.areEqual(pair, new Pair<Integer, ColorSampling>(2, ColorSampling.UNSIGNED_INTEGER))) {
            string = "uvec2";
        } else if (Intrinsics.areEqual(pair, new Pair<Integer, ColorSampling>(3, ColorSampling.UNSIGNED_INTEGER))) {
            string = "uvec3";
        } else if (Intrinsics.areEqual(pair, new Pair<Integer, ColorSampling>(4, ColorSampling.UNSIGNED_INTEGER))) {
            string = "uvec4";
        } else if (Intrinsics.areEqual(pair, new Pair<Integer, ColorSampling>(1, ColorSampling.SIGNED_INTEGER))) {
            string = "int";
        } else if (Intrinsics.areEqual(pair, new Pair<Integer, ColorSampling>(2, ColorSampling.SIGNED_INTEGER))) {
            string = "ivec2";
        } else if (Intrinsics.areEqual(pair, new Pair<Integer, ColorSampling>(3, ColorSampling.SIGNED_INTEGER))) {
            string = "ivec3";
        } else if (Intrinsics.areEqual(pair, new Pair<Integer, ColorSampling>(4, ColorSampling.SIGNED_INTEGER))) {
            string = "ivec4";
        } else {
            throw new IllegalStateException("unsupported type".toString());
        }
        return string;
    }

    private static final String getGlslType(BufferPrimitiveType $this$glslType) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$glslType.ordinal()]) {
            case 1 -> "bool";
            case 2 -> "int";
            case 3 -> "uint";
            case 4 -> "float";
            case 5 -> "double";
            case 6 -> "uvec2";
            case 7 -> "bvec2";
            case 8 -> "ivec2";
            case 9 -> "vec2";
            case 10 -> "dvec2";
            case 11 -> "uvec3";
            case 12 -> "bvec3";
            case 13 -> "ivec3";
            case 14 -> "vec3";
            case 15 -> "dvec3";
            case 16 -> "uvec4";
            case 17 -> "bvec4";
            case 18 -> "ivec4";
            case 19 -> "vec4";
            case 20 -> "dvec4";
            case 21 -> "mat2";
            case 22 -> "mat3";
            case 23 -> "mat4";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final String getGlslType(@NotNull VertexElementType $this$glslType) {
        Intrinsics.checkNotNullParameter((Object)$this$glslType, "<this>");
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$glslType.ordinal()]) {
            case 1, 2, 3 -> "int";
            case 4, 5, 6 -> "uint";
            case 7, 8, 9 -> "uvec2";
            case 10, 11, 12 -> "ivec2";
            case 13, 14, 15 -> "uvec3";
            case 16, 17, 18 -> "ivec3";
            case 19, 20, 21 -> "uvec4";
            case 22, 23, 24 -> "ivec4";
            case 25 -> "float";
            case 26 -> "vec2";
            case 27 -> "vec3";
            case 28 -> "vec4";
            case 29 -> "mat2";
            case 30 -> "mat3";
            case 31 -> "mat4";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final String getGlslVaryingQualifier(@NotNull VertexElementType $this$glslVaryingQualifier) {
        Intrinsics.checkNotNullParameter((Object)$this$glslVaryingQualifier, "<this>");
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$glslVaryingQualifier.ordinal()]) {
            case 1, 2, 3 -> "flat ";
            case 4, 5, 6 -> "flat ";
            case 7, 8, 9 -> "flat ";
            case 10, 11, 12 -> "flat ";
            case 13, 14, 15 -> "flat ";
            case 16, 17, 18 -> "flat ";
            case 19, 20, 21 -> "flat ";
            case 22, 23, 24 -> "flat ";
            default -> "";
        };
    }

    @NotNull
    public static final String getGlslLayout(@NotNull ShaderStorageFormat $this$glslLayout) {
        Intrinsics.checkNotNullParameter($this$glslLayout, "<this>");
        return CollectionsKt.joinToString$default($this$glslLayout.getElements(), "\n", null, null, 0, null, MappingKt::_get_glslLayout_$lambda$0, 30, null);
    }

    @NotNull
    public static final String getGlsl(@NotNull BufferAccess $this$glsl) {
        Intrinsics.checkNotNullParameter((Object)$this$glsl, "<this>");
        return switch (WhenMappings.$EnumSwitchMapping$2[$this$glsl.ordinal()]) {
            case 1 -> "readonly";
            case 2 -> "";
            case 3 -> "writeonly";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final String getGlsl(@NotNull BufferFlag $this$glsl) {
        Intrinsics.checkNotNullParameter((Object)$this$glsl, "<this>");
        return switch (WhenMappings.$EnumSwitchMapping$3[$this$glsl.ordinal()]) {
            case 1 -> "restrict";
            case 2 -> "coherent";
            case 3 -> "volatile";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final String mapTypeToUniform(@NotNull String type, @NotNull String name) {
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(name, "name");
        String[] stringArray = new String[]{","};
        List tokens = StringsKt.split$default((CharSequence)type, stringArray, false, 0, 6, null);
        String arraySize = (String)CollectionsKt.getOrNull(tokens, 1);
        String u = "uniform";
        Object object = new String[]{" "};
        List subtokens = StringsKt.split$default((CharSequence)tokens.get(0), (String[])object, false, 0, 6, null);
        return switch ((String)subtokens.get(0)) {
            case "struct" -> u + " " + subtokens.get(1) + " p_" + name + MappingKt.mapTypeToUniform$arraySizeDefinition(arraySize, arraySize, name);
            case "Image3D", "ImageCube", "ImageBuffer", "Image2D", "ImageCubeArray", "Image2DArray" -> {
                String v1 = StringsKt.take((String)tokens.get(0), 1).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(v1, "toLowerCase(...)");
                String sampler = v1 + StringsKt.drop((String)tokens.get(0), 1);
                ColorFormat colorFormat = ColorFormat.valueOf((String)tokens.get(1));
                ColorType colorType = ColorType.valueOf((String)tokens.get(2));
                BufferAccess access = BufferAccess.valueOf((String)tokens.get(3));
                String layout = MappingKt.imageLayout(colorFormat, colorType);
                switch (WhenMappings.$EnumSwitchMapping$2[access.ordinal()]) {
                    case 1: {
                        yield "layout(" + layout + ") readonly " + u + " " + sampler + " p_" + name + ";";
                    }
                    case 2: {
                        yield "layout(" + layout + ") " + u + " " + sampler + " p_" + name + ";";
                    }
                    case 3: {
                        yield "layout(" + layout + ") writeonly " + u + " " + sampler + " p_" + name + ";";
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            default -> u + " " + ShadeStyleKt.shadeStyleTypeToGLSL((String)tokens.get(0)) + " p_" + name + MappingKt.mapTypeToUniform$arraySizeDefinition(arraySize, arraySize, name);
        };
    }

    private static final CharSequence _get_glslLayout_$lambda$0(ShaderStorageElement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        ShaderStorageElement shaderStorageElement = it;
        return shaderStorageElement instanceof ShaderStoragePrimitive ? (CharSequence)(((ShaderStoragePrimitive)it).getArraySize() == 1 ? MappingKt.getGlslType(((ShaderStoragePrimitive)it).getType()) + " " + ((ShaderStoragePrimitive)it).getName() + ";" : MappingKt.getGlslType(((ShaderStoragePrimitive)it).getType()) + "[" + ((ShaderStoragePrimitive)it).getArraySize() + "] " + ((ShaderStoragePrimitive)it).getName() + ";") : (shaderStorageElement instanceof ShaderStorageStruct ? (CharSequence)(((ShaderStorageStruct)it).getArraySize() == 1 ? ((ShaderStorageStruct)it).getStructName() + " " + ((ShaderStorageStruct)it).getName() + ";" : ((ShaderStorageStruct)it).getStructName() + "[" + ((ShaderStorageStruct)it).getArraySize() + "] " + ((ShaderStorageStruct)it).getName() + ";") : (CharSequence)"");
    }

    private static final String mapTypeToUniform$arraySizeDefinition(String $this$mapTypeToUniform_u24arraySizeDefinition, String arraySize, String $name) {
        return $this$mapTypeToUniform_u24arraySizeDefinition == null ? ";" : "[" + arraySize + "]; \n#define p_" + $name + "_SIZE " + arraySize;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[BufferPrimitiveType.values().length];
            try {
                nArray[BufferPrimitiveType.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.INT32.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.UINT32.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.FLOAT32.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.FLOAT64.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR2_UINT32.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR2_BOOLEAN.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR2_INT32.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR2_FLOAT32.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR2_FLOAT64.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR3_UINT32.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR3_BOOLEAN.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR3_INT32.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR3_FLOAT32.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR3_FLOAT64.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR4_UINT32.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR4_BOOLEAN.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR4_INT32.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR4_FLOAT32.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.VECTOR4_FLOAT64.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.MATRIX22_FLOAT32.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.MATRIX33_FLOAT32.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferPrimitiveType.MATRIX44_FLOAT32.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[VertexElementType.values().length];
            try {
                nArray[VertexElementType.INT8.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.INT16.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.INT32.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.UINT8.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.UINT16.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.UINT32.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_UINT8.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_UINT16.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_UINT32.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_INT8.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_INT16.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_INT32.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR3_UINT8.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR3_UINT16.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR3_UINT32.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR3_INT8.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR3_INT16.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR3_INT32.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_UINT8.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_UINT16.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_UINT32.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_INT8.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_INT16.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_INT32.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.FLOAT32.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR2_FLOAT32.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR3_FLOAT32.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.VECTOR4_FLOAT32.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.MATRIX22_FLOAT32.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.MATRIX33_FLOAT32.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VertexElementType.MATRIX44_FLOAT32.ordinal()] = 31;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[BufferAccess.values().length];
            try {
                nArray[BufferAccess.READ.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferAccess.READ_WRITE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferAccess.WRITE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[BufferFlag.values().length];
            try {
                nArray[BufferFlag.RESTRICT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferFlag.COHERENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferFlag.VOLATILE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

