/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.kartifex;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.kartifex.Box2;
import org.openrndr.kartifex.Box3;
import org.openrndr.kartifex.Box4;
import org.openrndr.kartifex.Interval;
import org.openrndr.kartifex.Vec;
import org.openrndr.kartifex.Vec2;
import org.openrndr.kartifex.Vec3;
import org.openrndr.kartifex.Vec4;
import org.openrndr.kartifex.utils.Scalars;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000 5*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u0014\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00002\u00020\u0004:\u00015B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\bJ\r\u0010\t\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\r\u001a\u00028\u00012\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0010J\r\u0010\u0011\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0018\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u0018\u001a\u00028\u00012\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010\u001c\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0016\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0013\u0010%\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010&J\u000b\u0010'\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\bJ\u0013\u0010(\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010&J\u0013\u0010)\u001a\u00028\u00002\u0006\u0010*\u001a\u00020\u0014\u00a2\u0006\u0002\u0010+J\u0013\u0010)\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010&J\u0013\u0010,\u001a\u00028\u00012\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010-\u001a\u00028\u00012\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010.\u001a\u00028\u00012\u0006\u0010*\u001a\u00020\u0014\u00a2\u0006\u0002\u0010/J\u0013\u0010.\u001a\u00028\u00012\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\b\u00100\u001a\u00020$H\u0016J\u0013\u00101\u001a\u00020\u000b2\b\u00102\u001a\u0004\u0018\u00010\u0004H\u0096\u0002J\b\u00103\u001a\u000204H\u0016R\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u00a8\u00066"}, d2={"Lorg/openrndr/kartifex/Box;", "T", "Lorg/openrndr/kartifex/Vec;", "U", "", "<init>", "()V", "lower", "()Lorg/openrndr/kartifex/Vec;", "upper", "isEmpty", "", "()Z", "construct", "a", "b", "(Lorg/openrndr/kartifex/Vec;Lorg/openrndr/kartifex/Vec;)Lorg/openrndr/kartifex/Box;", "empty", "()Lorg/openrndr/kartifex/Box;", "distanceSquared", "", "point", "(Lorg/openrndr/kartifex/Vec;)D", "distance", "union", "(Lorg/openrndr/kartifex/Box;)Lorg/openrndr/kartifex/Box;", "v", "(Lorg/openrndr/kartifex/Vec;)Lorg/openrndr/kartifex/Box;", "intersection", "intersects", "(Lorg/openrndr/kartifex/Box;)Z", "contains", "(Lorg/openrndr/kartifex/Vec;)Z", "nth", "Lorg/openrndr/kartifex/Interval;", "idx", "", "clamp", "(Lorg/openrndr/kartifex/Vec;)Lorg/openrndr/kartifex/Vec;", "size", "normalize", "lerp", "t", "(D)Lorg/openrndr/kartifex/Vec;", "translate", "scale", "expand", "(D)Lorg/openrndr/kartifex/Box;", "hashCode", "equals", "other", "toString", "", "Companion", "openrndr-kartifex"})
public abstract class Box<T extends Vec<T>, U extends Box<T, U>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Function1<Double, Boolean> POSITIVE = Box::POSITIVE$lambda$11;
    @NotNull
    private static final Function1<Double, Boolean> NOT_NEGATIVE = Box::NOT_NEGATIVE$lambda$12;

    @NotNull
    public abstract T lower();

    @NotNull
    public abstract T upper();

    public abstract boolean isEmpty();

    @NotNull
    protected abstract U construct(@NotNull T var1, @NotNull T var2);

    @NotNull
    protected abstract U empty();

    public final double distanceSquared(@NotNull T point) {
        Intrinsics.checkNotNullParameter(point, "point");
        T l = this.lower().sub(point);
        T u = point.sub(this.upper());
        return u.zip(l, Box::distanceSquared$lambda$0).lengthSquared();
    }

    public final double distance(@NotNull T point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return Math.sqrt(this.distanceSquared(point));
    }

    @NotNull
    public final U union(@NotNull U b) {
        Intrinsics.checkNotNullParameter(b, "b");
        if (this.isEmpty()) {
            return b;
        }
        if (((Box)b).isEmpty()) {
            Intrinsics.checkNotNull(this, "null cannot be cast to non-null type U of org.openrndr.kartifex.Box");
            return (U)this;
        }
        return this.construct(this.lower().zip(((Box)b).lower(), Box::union$lambda$1), this.upper().zip(((Box)b).upper(), Box::union$lambda$2));
    }

    @NotNull
    public final U union(@NotNull T v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return this.isEmpty() ? this.construct(v, v) : this.construct(this.lower().zip(v, Box::union$lambda$3), this.upper().zip(v, Box::union$lambda$4));
    }

    @NotNull
    public final U intersection(@NotNull U b) {
        Intrinsics.checkNotNullParameter(b, "b");
        return this.isEmpty() || ((Box)b).isEmpty() || !this.intersects(b) ? this.empty() : this.construct(this.lower().zip(((Box)b).lower(), Box::intersection$lambda$5), this.upper().zip(((Box)b).upper(), Box::intersection$lambda$6));
    }

    public boolean intersects(@NotNull U b) {
        Intrinsics.checkNotNullParameter(b, "b");
        return this.isEmpty() || ((Box)b).isEmpty() ? false : ((Box)b).upper().sub(this.lower()).every(NOT_NEGATIVE) && this.upper().sub(((Box)b).lower()).every(NOT_NEGATIVE);
    }

    public final boolean contains(@NotNull T v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return v.sub(this.lower()).every(NOT_NEGATIVE) && this.upper().sub(v).every(NOT_NEGATIVE);
    }

    @NotNull
    public final Interval nth(int idx) {
        return Interval.Companion.interval(this.lower().nth(idx), this.upper().nth(idx));
    }

    @NotNull
    public final T clamp(@NotNull T v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return v.zip(this.lower(), Box::clamp$lambda$7).zip(this.upper(), Box::clamp$lambda$8);
    }

    @NotNull
    public final T size() {
        return this.upper().sub(this.lower());
    }

    @NotNull
    public final T normalize(@NotNull T v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return v.sub(this.lower()).div(this.size());
    }

    @NotNull
    public final T lerp(double t) {
        return this.lower().add(this.size().mul(t));
    }

    @NotNull
    public final T lerp(@NotNull T v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return this.lower().add(this.size().mul(v));
    }

    @NotNull
    public final U translate(@NotNull T v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return this.construct(this.lower().add(v), this.upper().add(v));
    }

    @NotNull
    public final U scale(@NotNull T v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return this.construct(this.lower().mul(v), this.upper().mul(v));
    }

    @NotNull
    public final U expand(double t) {
        if (this.isEmpty()) {
            Intrinsics.checkNotNull(this, "null cannot be cast to non-null type U of org.openrndr.kartifex.Box");
            return (U)this;
        }
        Object nLower = this.lower().map(arg_0 -> Box.expand$lambda$9(t, arg_0));
        Object nUpper = this.upper().map(arg_0 -> Box.expand$lambda$10(t, arg_0));
        return nUpper.sub(nLower).every(NOT_NEGATIVE) ? this.construct(nLower, nUpper) : this.empty();
    }

    @NotNull
    public final U expand(@NotNull T v) {
        Intrinsics.checkNotNullParameter(v, "v");
        if (this.isEmpty()) {
            Intrinsics.checkNotNull(this, "null cannot be cast to non-null type U of org.openrndr.kartifex.Box");
            return (U)this;
        }
        T nLower = this.lower().sub(v);
        T nUpper = this.upper().add(v);
        return nUpper.sub(nLower).every(NOT_NEGATIVE) ? this.construct(nLower, nUpper) : this.empty();
    }

    public int hashCode() {
        return this.isEmpty() ? 0 : 31 * this.lower().hashCode() ^ this.upper().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof Box) {
            Object b = other;
            return this.isEmpty() ? ((Box)b).isEmpty() : Intrinsics.areEqual(this.lower(), ((Box)b).lower()) && Intrinsics.areEqual(this.upper(), ((Box)b).upper());
        }
        return false;
    }

    @NotNull
    public String toString() {
        return "[" + this.lower() + ", " + this.upper() + "]";
    }

    private static final double distanceSquared$lambda$0(double a, double b) {
        return Scalars.INSTANCE.max(0.0, a, b);
    }

    private static final double union$lambda$1(double x, double y) {
        return Math.min(x, y);
    }

    private static final double union$lambda$2(double x, double y) {
        return Math.max(x, y);
    }

    private static final double union$lambda$3(double a, double b) {
        return Math.min(a, b);
    }

    private static final double union$lambda$4(double a, double b) {
        return Math.max(a, b);
    }

    private static final double intersection$lambda$5(double u, double v) {
        return Math.max(u, v);
    }

    private static final double intersection$lambda$6(double u, double v) {
        return Math.min(u, v);
    }

    private static final double clamp$lambda$7(double a, double b) {
        return Math.max(a, b);
    }

    private static final double clamp$lambda$8(double a, double b) {
        return Math.min(a, b);
    }

    private static final double expand$lambda$9(double $t, double n) {
        return n - $t;
    }

    private static final double expand$lambda$10(double $t, double n) {
        return n + $t;
    }

    private static final boolean POSITIVE$lambda$11(double d) {
        return d > 0.0;
    }

    private static final boolean NOT_NEGATIVE$lambda$12(double d) {
        return d >= 0.0;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0004\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u000bJ\u0016\u0010\u0004\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\rJ\\\u0010\u0015\u001a\u00020\u0012\"\u000e\b\u0002\u0010\u0016*\b\u0012\u0004\u0012\u0002H\u00160\u0017\"\u0014\b\u0003\u0010\u0018*\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u00180\u00192\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u00180\u00192\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u00180\u00192\u0006\u0010\u001a\u001a\u00020\u0011R \u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010j\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R \u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010j\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lorg/openrndr/kartifex/Box$Companion;", "", "<init>", "()V", "box", "Lorg/openrndr/kartifex/Box2;", "a", "Lorg/openrndr/kartifex/Vec2;", "b", "Lorg/openrndr/kartifex/Interval;", "Lorg/openrndr/kartifex/Box3;", "Lorg/openrndr/kartifex/Vec3;", "Lorg/openrndr/kartifex/Box4;", "Lorg/openrndr/kartifex/Vec4;", "POSITIVE", "Lorg/openrndr/kartifex/DoublePredicate;", "Lkotlin/Function1;", "", "", "Lkotlin/jvm/functions/Function1;", "NOT_NEGATIVE", "equals", "T", "Lorg/openrndr/kartifex/Vec;", "U", "Lorg/openrndr/kartifex/Box;", "epsilon", "openrndr-kartifex"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Box2 box(@NotNull Vec2 a, @NotNull Vec2 b) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            return new Box2(a, b);
        }

        @NotNull
        public final Box2 box(@NotNull Interval a, @NotNull Interval b) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            return new Box2(new Vec2(a.getLo(), b.getLo()), new Vec2(a.getHi(), b.getHi()));
        }

        @NotNull
        public final Box3 box(@NotNull Vec3 a, @NotNull Vec3 b) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            return new Box3(a, b);
        }

        @NotNull
        public final Box4 box(@NotNull Vec4 a, @NotNull Vec4 b) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            return new Box4(a, b);
        }

        public final <T extends Vec<T>, U extends Box<T, U>> boolean equals(@NotNull Box<T, U> a, @NotNull Box<T, U> b, double epsilon) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            return Vec.Companion.equals(a.lower(), b.lower(), epsilon) && Vec.Companion.equals(a.upper(), b.upper(), epsilon);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

