/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.kartifex;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.kartifex.Box;
import org.openrndr.kartifex.Box2;
import org.openrndr.kartifex.Curve2;
import org.openrndr.kartifex.Interval;
import org.openrndr.kartifex.Matrix3;
import org.openrndr.kartifex.Vec;
import org.openrndr.kartifex.Vec2;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000 62\u00020\u00012\u00020\u0002:\u00016B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0000H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0016J\u0018\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0016J\u001b\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u001d2\u0006\u0010\u0017\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0016H\u0016J\u0018\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0016H\u0016J\b\u0010\"\u001a\u00020\u0016H\u0016J\b\u0010#\u001a\u00020\u0016H\u0016J\u001b\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160\u001d2\u0006\u0010%\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020(H\u0016J\u000e\u0010)\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0016J\b\u0010*\u001a\u00020+H\u0016J\t\u0010,\u001a\u00020\u0004H\u00c2\u0003J\t\u0010-\u001a\u00020\u0004H\u00c2\u0003J\t\u0010.\u001a\u00020\u0004H\u00c2\u0003J\t\u0010/\u001a\u00020\u0004H\u00c2\u0003J1\u00100\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u00c6\u0001J\u0013\u00101\u001a\u00020\u000e2\b\u00102\u001a\u0004\u0018\u000103H\u00d6\u0003J\t\u00104\u001a\u000205H\u00d6\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/openrndr/kartifex/Line2;", "Lorg/openrndr/kartifex/Curve2;", "Ljava/lang/Record;", "ax", "", "ay", "bx", "by", "<init>", "(DDDD)V", "transform", "m", "Lorg/openrndr/kartifex/Matrix3;", "isFlat", "", "epsilon", "signedArea", "length", "reverse", "inflections", "", "position", "Lorg/openrndr/kartifex/Vec2;", "t", "direction", "range", "tMin", "tMax", "split", "", "(D)[Lorg/openrndr/kartifex/Curve2;", "nearestPoint", "p", "endpoints", "start", "end", "subdivide", "error", "(D)[Lorg/openrndr/kartifex/Vec2;", "bounds", "Lorg/openrndr/kartifex/Box2;", "distance", "toString", "", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "Companion", "openrndr-kartifex"})
@SourceDebugExtension(value={"SMAP\nLine2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Line2.kt\norg/openrndr/kartifex/Line2\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public final class Line2
extends Record
implements Curve2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double ax;
    private final double ay;
    private final double bx;
    private final double by;

    public Line2(double ax, double ay, double bx, double by) {
        this.ax = ax;
        this.ay = ay;
        this.bx = bx;
        this.by = by;
    }

    @Override
    @NotNull
    public Line2 transform(@NotNull Matrix3 m) {
        Intrinsics.checkNotNullParameter(m, "m");
        return Companion.line(this.start().transform(m), this.end().transform(m));
    }

    @Override
    public boolean isFlat(double epsilon) {
        return true;
    }

    @Override
    public double signedArea() {
        return (this.ax * this.by - this.bx * this.ay) / (double)2;
    }

    @Override
    public double length() {
        return this.end().sub(this.start()).length();
    }

    @Override
    @NotNull
    public Line2 reverse() {
        return new Line2(this.bx, this.by, this.ax, this.ay);
    }

    @Override
    @NotNull
    public double[] inflections() {
        return new double[0];
    }

    @Override
    @NotNull
    public Vec2 position(double t) {
        double d = t;
        return d == 0.0 ? this.start() : (d == 1.0 ? this.end() : new Vec2(this.ax + (this.bx - this.ax) * t, this.ay + (this.by - this.ay) * t));
    }

    @Override
    @NotNull
    public Vec2 direction(double t) {
        return new Vec2(this.bx - this.ax, this.by - this.ay);
    }

    @Override
    @NotNull
    public Line2 range(double tMin, double tMax) {
        return Companion.line(this.position(tMin), this.position(tMax));
    }

    @Override
    @NotNull
    public Curve2[] split(double t) {
        if (!(!(t <= 0.0) && !(t >= 1.0))) {
            boolean bl = false;
            String string = "t must be within (0,1)";
            throw new IllegalArgumentException(string.toString());
        }
        Vec2 v = this.position(t);
        Curve2[] curve2Array = new Curve2[]{Companion.line(this.start(), v), Companion.line(v, this.end())};
        return curve2Array;
    }

    @Override
    public double nearestPoint(@NotNull Vec2 p) {
        Intrinsics.checkNotNullParameter(p, "p");
        Vec2 bSa = this.end().sub(this.start());
        Vec2 pSa = p.sub(this.start());
        return Vec.Companion.dot(bSa, pSa) / bSa.lengthSquared();
    }

    @Override
    @NotNull
    public Line2 endpoints(@NotNull Vec2 start, @NotNull Vec2 end) {
        Intrinsics.checkNotNullParameter(start, "start");
        Intrinsics.checkNotNullParameter(end, "end");
        return Companion.line(start, end);
    }

    @Override
    @NotNull
    public Vec2 start() {
        return new Vec2(this.ax, this.ay);
    }

    @Override
    @NotNull
    public Vec2 end() {
        return new Vec2(this.bx, this.by);
    }

    @Override
    @NotNull
    public Vec2[] subdivide(double error) {
        Vec2[] vec2Array = new Vec2[]{this.start(), this.end()};
        return vec2Array;
    }

    @Override
    @NotNull
    public Box2 bounds() {
        return Box.Companion.box(this.start(), this.end());
    }

    public final double distance(@NotNull Vec2 p) {
        Intrinsics.checkNotNullParameter(p, "p");
        double t = this.nearestPoint(p);
        return t <= 0.0 ? p.sub(this.start()).length() : (t >= 1.0 ? p.sub(this.end()).length() : p.sub(this.end().sub(this.start()).mul(t)).length());
    }

    @Override
    @NotNull
    public String toString() {
        return "Line2(ax=" + this.ax + ", ay=" + this.ay + ", bx=" + this.bx + ", by=" + this.by + ")";
    }

    private final double component1() {
        return this.ax;
    }

    private final double component2() {
        return this.ay;
    }

    private final double component3() {
        return this.bx;
    }

    private final double component4() {
        return this.by;
    }

    @NotNull
    public final Line2 copy(double ax, double ay, double bx, double by) {
        return new Line2(ax, ay, bx, by);
    }

    public static /* synthetic */ Line2 copy$default(Line2 line2, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = line2.ax;
        }
        if ((n & 2) != 0) {
            d2 = line2.ay;
        }
        if ((n & 4) != 0) {
            d3 = line2.bx;
        }
        if ((n & 8) != 0) {
            d4 = line2.by;
        }
        return line2.copy(d, d2, d3, d4);
    }

    @Override
    public int hashCode() {
        int result2 = Double.hashCode(this.ax);
        result2 = result2 * 31 + Double.hashCode(this.ay);
        result2 = result2 * 31 + Double.hashCode(this.bx);
        result2 = result2 * 31 + Double.hashCode(this.by);
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Line2)) {
            return false;
        }
        Line2 line2 = (Line2)other;
        if (Double.compare(this.ax, line2.ax) != 0) {
            return false;
        }
        if (Double.compare(this.ay, line2.ay) != 0) {
            return false;
        }
        if (Double.compare(this.bx, line2.bx) != 0) {
            return false;
        }
        return Double.compare(this.by, line2.by) == 0;
    }

    @Override
    @NotNull
    public Curve2[] split(@NotNull double[] unsafeTs) {
        return Curve2.DefaultImpls.split(this, unsafeTs);
    }

    @Override
    @NotNull
    public Curve2 range(@NotNull Interval interval) {
        return Curve2.DefaultImpls.range(this, interval);
    }

    @Override
    @NotNull
    public Vec2[] intersections(@NotNull Curve2 c2) {
        return Curve2.DefaultImpls.intersections(this, c2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/openrndr/kartifex/Line2$Companion;", "", "<init>", "()V", "line", "Lorg/openrndr/kartifex/Line2;", "a", "Lorg/openrndr/kartifex/Vec2;", "b", "Lorg/openrndr/kartifex/Box2;", "openrndr-kartifex"})
    @SourceDebugExtension(value={"SMAP\nLine2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Line2.kt\norg/openrndr/kartifex/Line2$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Line2 line(@NotNull Vec2 a, @NotNull Vec2 b) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            if (!(!Intrinsics.areEqual(a, b))) {
                boolean bl = false;
                String string = "segments must have non-zero length " + a + " " + b;
                throw new IllegalArgumentException(string.toString());
            }
            return new Line2(a.x(), a.y(), b.x(), b.y());
        }

        @NotNull
        public final Line2 line(@NotNull Box2 b) {
            Intrinsics.checkNotNullParameter(b, "b");
            return new Line2(b.getLx(), b.getLy(), b.getUx(), b.getUy());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

