/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.kartifex;

import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.kartifex.Matrix4;
import org.openrndr.kartifex.Vec2;
import org.openrndr.kartifex.Vec3;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u0013\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$BQ\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0004\b\f\u0010\rB\u0011\b\u0012\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\f\u0010\u0010J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0003J\u0019\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0086\u0002J\u000e\u0010\u0014\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0015J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ\b\u0010 \u001a\u00020\u0015H\u0016J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u0096\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/openrndr/kartifex/Matrix3;", "", "m00", "", "m01", "m02", "m10", "m11", "m12", "m20", "m21", "m22", "<init>", "(DDDDDDDDD)V", "elements", "", "([D)V", "mul", "k", "get", "row", "", "column", "Lorg/openrndr/kartifex/Vec3;", "b", "add", "matrix4", "Lorg/openrndr/kartifex/Matrix4;", "transpose", "transform", "Lorg/openrndr/kartifex/Vec2;", "v", "hashCode", "equals", "", "other", "Companion", "openrndr-kartifex"})
public final class Matrix3 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final double[] elements;
    @NotNull
    private static final Matrix3 IDENTITY = new Matrix3(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);

    private Matrix3(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        double[] dArray = new double[]{m00, m01, m02, m10, m11, m12, m20, m21, m22};
        this.elements = dArray;
    }

    private Matrix3(double[] elements) {
        this.elements = elements;
    }

    @NotNull
    public final Matrix3 mul(double k) {
        double[] es = new double[9];
        for (int i = 0; i < 9; ++i) {
            es[i] = this.elements[i] * k;
        }
        return new Matrix3(es);
    }

    public final double get(int row, int column) {
        return this.elements[row * 3 + column];
    }

    @NotNull
    public final Vec3 row(int row) {
        int idx = row * 2;
        return new Vec3(this.elements[idx], this.elements[idx + 1], this.elements[idx + 2]);
    }

    @NotNull
    public final Vec3 column(int column) {
        return new Vec3(this.elements[column], this.elements[column + 3], this.elements[column + 6]);
    }

    @NotNull
    public final Matrix3 mul(@NotNull Matrix3 b) {
        Intrinsics.checkNotNullParameter(b, "b");
        double[] es = new double[9];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                double n = 0.0;
                for (int k = 0; k < 3; ++k) {
                    n += b.get(k, j) * this.get(i, k);
                }
                es[i * 3 + j] = n;
            }
        }
        return new Matrix3(es);
    }

    @NotNull
    public final Matrix3 add(@NotNull Matrix3 b) {
        Intrinsics.checkNotNullParameter(b, "b");
        double[] es = new double[9];
        for (int i = 0; i < 9; ++i) {
            es[i] = this.elements[i] + b.elements[i];
        }
        return new Matrix3(es);
    }

    @NotNull
    public final Matrix4 matrix4() {
        return new Matrix4(this.elements[0], this.elements[1], 0.0, this.elements[2], this.elements[3], this.elements[4], 0.0, this.elements[5], this.elements[6], this.elements[7], this.elements[8], 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public final Matrix3 transpose() {
        return new Matrix3(this.elements[0], this.elements[3], this.elements[6], this.elements[1], this.elements[4], this.elements[7], this.elements[2], this.elements[5], this.elements[8]);
    }

    @NotNull
    public final Vec2 transform(@NotNull Vec2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new Vec2(v.x() * this.elements[0] + v.y() * this.elements[1] + this.elements[2], v.x() * this.elements[3] + v.y() * this.elements[4] + this.elements[5]);
    }

    public int hashCode() {
        int hash = 0;
        for (double n : this.elements) {
            hash = hash * 31 + Double.hashCode(n);
        }
        return hash;
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        if (this == other) {
            bl = true;
        } else {
            if (other instanceof Matrix3) {
                String string = "";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            bl = false;
        }
        return bl;
    }

    public /* synthetic */ Matrix3(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, DefaultConstructorMarker $constructor_marker) {
        this(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0016\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\nJ\u0016\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0010J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0010J\u001f\u0010\u0017\u001a\u00020\u00052\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0019\"\u00020\u0005\u00a2\u0006\u0002\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lorg/openrndr/kartifex/Matrix3$Companion;", "", "<init>", "()V", "IDENTITY", "Lorg/openrndr/kartifex/Matrix3;", "getIDENTITY", "()Lorg/openrndr/kartifex/Matrix3;", "from", "a", "Lorg/openrndr/kartifex/Vec2;", "b", "Lorg/openrndr/kartifex/Vec3;", "c", "translate", "x", "", "y", "v", "scale", "k", "rotate", "radians", "mul", "matrices", "", "([Lorg/openrndr/kartifex/Matrix3;)Lorg/openrndr/kartifex/Matrix3;", "openrndr-kartifex"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Matrix3 getIDENTITY() {
            return IDENTITY;
        }

        @NotNull
        public final Matrix3 from(@NotNull Vec2 a, @NotNull Vec2 b) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            return new Matrix3(a.x(), b.x(), 0.0, a.y(), b.y(), 0.0, 0.0, 0.0, 1.0, null);
        }

        @NotNull
        public final Matrix3 from(@NotNull Vec3 a, @NotNull Vec3 b) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            return new Matrix3(a.x(), a.x(), 0.0, a.y(), b.y(), 0.0, a.z(), b.z(), 1.0, null);
        }

        @NotNull
        public final Matrix3 from(@NotNull Vec3 a, @NotNull Vec3 b, @NotNull Vec3 c2) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            Intrinsics.checkNotNullParameter(c2, "c");
            return new Matrix3(a.x(), b.x(), c2.x(), a.y(), b.y(), c2.y(), a.z(), b.z(), c2.z(), null);
        }

        @NotNull
        public final Matrix3 translate(double x, double y) {
            return new Matrix3(1.0, 0.0, x, 0.0, 1.0, y, 0.0, 0.0, 1.0, null);
        }

        @NotNull
        public final Matrix3 translate(@NotNull Vec2 v) {
            Intrinsics.checkNotNullParameter(v, "v");
            return this.translate(v.x(), v.y());
        }

        @NotNull
        public final Matrix3 scale(double x, double y) {
            return new Matrix3(x, 0.0, 0.0, 0.0, y, 0.0, 0.0, 0.0, 1.0, null);
        }

        @NotNull
        public final Matrix3 scale(@NotNull Vec2 v) {
            Intrinsics.checkNotNullParameter(v, "v");
            return this.scale(v.x(), v.y());
        }

        @NotNull
        public final Matrix3 scale(double k) {
            return this.scale(k, k);
        }

        @NotNull
        public final Matrix3 rotate(double radians) {
            double c2 = Math.cos(radians);
            double s = Math.sin(radians);
            return new Matrix3(c2, -s, 0.0, s, c2, 0.0, 0.0, 0.0, 1.0, null);
        }

        @NotNull
        public final Matrix3 mul(Matrix3 ... matrices) {
            Intrinsics.checkNotNullParameter(matrices, "matrices");
            Matrix3 m = matrices[0];
            int n = matrices.length;
            for (int i = 1; i < n; ++i) {
                m = m.mul(matrices[i]);
            }
            return m;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

