/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.kartifex;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.kartifex.Vec3;
import org.openrndr.kartifex.Vec4;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0010\u0013\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B\u0089\u0001\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014B\u0011\b\u0012\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0003J\u0019\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0086\u0002J\u000e\u0010\u001b\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001cJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0000J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0000J\u0006\u0010!\u001a\u00020\u0000J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/openrndr/kartifex/Matrix4;", "", "m00", "", "m01", "m02", "m03", "m10", "m11", "m12", "m13", "m20", "m21", "m22", "m23", "m30", "m31", "m32", "m33", "<init>", "(DDDDDDDDDDDDDDDD)V", "elements", "", "([D)V", "mul", "k", "get", "row", "", "column", "Lorg/openrndr/kartifex/Vec4;", "b", "add", "transpose", "transform", "Lorg/openrndr/kartifex/Vec3;", "v", "Companion", "openrndr-kartifex"})
public final class Matrix4 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final double[] elements;
    @NotNull
    private static final Matrix4 IDENTITY = new Matrix4(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);

    public Matrix4(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23, double m30, double m31, double m32, double m33) {
        double[] dArray = new double[]{m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33};
        this.elements = dArray;
    }

    private Matrix4(double[] elements) {
        this.elements = elements;
    }

    @NotNull
    public final Matrix4 mul(double k) {
        double[] es = new double[16];
        for (int i = 0; i < 16; ++i) {
            es[i] = this.elements[i] * k;
        }
        return new Matrix4(es);
    }

    public final double get(int row, int column) {
        return this.elements[(row << 2) + column];
    }

    @NotNull
    public final Vec4 row(int row) {
        int idx = row << 2;
        return new Vec4(this.elements[idx], this.elements[idx + 1], this.elements[idx + 2], this.elements[idx + 3]);
    }

    @NotNull
    public final Vec4 column(int column) {
        return new Vec4(this.elements[column], this.elements[column + 4], this.elements[column + 8], this.elements[column + 12]);
    }

    @NotNull
    public final Matrix4 mul(@NotNull Matrix4 b) {
        Intrinsics.checkNotNullParameter(b, "b");
        double[] es = new double[16];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                double n = 0.0;
                for (int k = 0; k < 4; ++k) {
                    n += b.get(k, j) * this.get(i, k);
                }
                es[(i << 2) + j] = n;
            }
        }
        return new Matrix4(es);
    }

    @NotNull
    public final Matrix4 add(@NotNull Matrix4 b) {
        Intrinsics.checkNotNullParameter(b, "b");
        double[] es = new double[16];
        for (int i = 0; i < 16; ++i) {
            es[i] = this.elements[i] + b.elements[i];
        }
        return new Matrix4(es);
    }

    @NotNull
    public final Matrix4 transpose() {
        return new Matrix4(this.elements[0], this.elements[4], this.elements[8], this.elements[12], this.elements[1], this.elements[5], this.elements[9], this.elements[13], this.elements[2], this.elements[6], this.elements[10], this.elements[14], this.elements[3], this.elements[7], this.elements[11], this.elements[15]);
    }

    @NotNull
    public final Vec3 transform(@NotNull Vec3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new Vec3(v.x() * this.elements[0] + v.y() * this.elements[1] + v.z() * this.elements[2] + this.elements[3], v.x() * this.elements[4] + v.y() * this.elements[5] + v.z() * this.elements[6] + this.elements[7], v.x() * this.elements[8] + v.y() * this.elements[9] + v.z() * this.elements[10] + this.elements[11]);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nJ&\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011J\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\nJ\u001e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0011J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0011J\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0011J\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0011J\u001f\u0010\u001b\u001a\u00020\u00052\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u001d\"\u00020\u0005\u00a2\u0006\u0002\u0010\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lorg/openrndr/kartifex/Matrix4$Companion;", "", "<init>", "()V", "IDENTITY", "Lorg/openrndr/kartifex/Matrix4;", "getIDENTITY", "()Lorg/openrndr/kartifex/Matrix4;", "from", "a", "Lorg/openrndr/kartifex/Vec3;", "b", "c", "Lorg/openrndr/kartifex/Vec4;", "d", "translate", "x", "", "y", "z", "v", "scale", "k", "rotateX", "radians", "rotateY", "rotateZ", "mul", "matrices", "", "([Lorg/openrndr/kartifex/Matrix4;)Lorg/openrndr/kartifex/Matrix4;", "openrndr-kartifex"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Matrix4 getIDENTITY() {
            return IDENTITY;
        }

        @NotNull
        public final Matrix4 from(@NotNull Vec3 a, @NotNull Vec3 b, @NotNull Vec3 c2) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            Intrinsics.checkNotNullParameter(c2, "c");
            return new Matrix4(a.x(), b.x(), c2.x(), 0.0, a.y(), b.y(), c2.y(), 0.0, a.z(), b.z(), c2.z(), 0.0, 0.0, 0.0, 0.0, 1.0);
        }

        @NotNull
        public final Matrix4 from(@NotNull Vec4 a, @NotNull Vec4 b, @NotNull Vec4 c2, @NotNull Vec4 d) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            Intrinsics.checkNotNullParameter(c2, "c");
            Intrinsics.checkNotNullParameter(d, "d");
            return new Matrix4(a.x(), b.x(), c2.x(), d.x(), a.y(), b.y(), c2.y(), d.y(), a.z(), b.z(), c2.z(), d.z(), a.w(), b.w(), c2.w(), d.w());
        }

        @NotNull
        public final Matrix4 translate(double x, double y, double z) {
            return new Matrix4(1.0, 0.0, 0.0, x, 0.0, 1.0, 0.0, y, 0.0, 0.0, 1.0, z, 0.0, 0.0, 0.0, 1.0);
        }

        @NotNull
        public final Matrix4 translate(@NotNull Vec3 v) {
            Intrinsics.checkNotNullParameter(v, "v");
            return this.translate(v.x(), v.y(), v.z());
        }

        @NotNull
        public final Matrix4 scale(double x, double y, double z) {
            return new Matrix4(x, 0.0, 0.0, 0.0, 0.0, y, 0.0, 0.0, 0.0, 0.0, z, 0.0, 0.0, 0.0, 0.0, 1.0);
        }

        @NotNull
        public final Matrix4 scale(@NotNull Vec3 v) {
            Intrinsics.checkNotNullParameter(v, "v");
            return this.scale(v.x(), v.y(), v.z());
        }

        @NotNull
        public final Matrix4 scale(double k) {
            return this.scale(k, k, k);
        }

        @NotNull
        public final Matrix4 rotateX(double radians) {
            double c2 = Math.cos(radians);
            double s = Math.sin(radians);
            return new Matrix4(1.0, 0.0, 0.0, 0.0, 0.0, c2, -s, 0.0, 0.0, s, c2, 0.0, 0.0, 0.0, 0.0, 1.0);
        }

        @NotNull
        public final Matrix4 rotateY(double radians) {
            double c2 = Math.cos(radians);
            double s = Math.sin(radians);
            return new Matrix4(c2, 0.0, s, 0.0, 0.0, 1.0, 0.0, 0.0, -s, 0.0, c2, 0.0, 0.0, 0.0, 0.0, 1.0);
        }

        @NotNull
        public final Matrix4 rotateZ(double radians) {
            double c2 = Math.cos(radians);
            double s = Math.sin(radians);
            return new Matrix4(c2, -s, 0.0, 0.0, s, c2, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        }

        @NotNull
        public final Matrix4 mul(Matrix4 ... matrices) {
            Intrinsics.checkNotNullParameter(matrices, "matrices");
            Matrix4 m = matrices[0];
            int n = matrices.length;
            for (int i = 1; i < n; ++i) {
                m = m.mul(matrices[i]);
            }
            return m;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

