/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.kartifex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.kartifex.Box;
import org.openrndr.kartifex.Box2;
import org.openrndr.kartifex.Matrix3;
import org.openrndr.kartifex.Ring2;
import org.openrndr.kartifex.Vec2;
import org.openrndr.kartifex.utils.regions.Clip;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0017\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\u0004\b\u0005\u0010\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0011\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0086\u0002J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0000J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0000J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0000R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lorg/openrndr/kartifex/Region2;", "", "rings", "", "Lorg/openrndr/kartifex/Ring2;", "<init>", "([Lorg/openrndr/kartifex/Ring2;)V", "", "(Ljava/lang/Iterable;)V", "getRings", "()[Lorg/openrndr/kartifex/Ring2;", "[Lorg/openrndr/kartifex/Ring2;", "bounds", "Lorg/openrndr/kartifex/Box2;", "getBounds", "()Lorg/openrndr/kartifex/Box2;", "test", "Lorg/openrndr/kartifex/Ring2$Result;", "p", "Lorg/openrndr/kartifex/Vec2;", "contains", "", "transform", "m", "Lorg/openrndr/kartifex/Matrix3;", "intersection", "region", "union", "difference", "Companion", "openrndr-kartifex"})
@SourceDebugExtension(value={"SMAP\nRegion2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Region2.kt\norg/openrndr/kartifex/Region2\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,64:1\n6180#2,2:65\n11102#2:67\n11437#2,3:68\n11102#2:76\n11437#2,3:77\n1797#3,3:71\n37#4,2:74\n37#4,2:80\n*S KotlinDebug\n*F\n+ 1 Region2.kt\norg/openrndr/kartifex/Region2\n*L\n57#1:65,2\n60#1:67\n60#1:68,3\n30#1:76\n30#1:77,3\n61#1:71,3\n9#1:74,2\n34#1:80,2\n*E\n"})
public final class Region2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ring2[] rings;
    @NotNull
    private final Box2 bounds;

    /*
     * WARNING - void declaration
     */
    public Region2(@NotNull Ring2[] rings) {
        void $this$fold$iv;
        void initial$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(rings, "rings");
        this.rings = rings;
        Ring2[] $this$sortBy$iv = this.rings;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.length > 1) {
            ArraysKt.sortWith($this$sortBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Ring2 it = (Ring2)a;
                    boolean bl = false;
                    Comparable comparable = Double.valueOf(it.getArea());
                    it = (Ring2)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.getArea());
                }
            });
        }
        $this$sortBy$iv = this.rings;
        Region2 region2 = this;
        boolean $i$f$map22 = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void r;
            void item$iv$iv;
            void var10_16 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(r.getBounds());
        }
        $this$map$iv = (List)destination$iv$iv;
        Box2 $i$f$map22 = Box2.Companion.getEMPTY();
        boolean $i$f$fold = false;
        Box2 accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void b;
            Box2 box2 = (Box2)element$iv;
            void obj = accumulator$iv;
            boolean bl = false;
            accumulator$iv = (Box2)obj.union((Box)b);
        }
        region2.bounds = accumulator$iv;
    }

    @NotNull
    public final Ring2[] getRings() {
        return this.rings;
    }

    @NotNull
    public final Box2 getBounds() {
        return this.bounds;
    }

    public Region2(@NotNull Iterable<Ring2> rings) {
        Intrinsics.checkNotNullParameter(rings, "rings");
        Collection $this$toTypedArray$iv = CollectionsKt.toList(rings);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this(thisCollection$iv.toArray(new Ring2[0]));
    }

    @NotNull
    public final Ring2.Result test(@NotNull Vec2 p) {
        Intrinsics.checkNotNullParameter(p, "p");
        for (Ring2 r : this.rings) {
            Ring2.Result result2 = r.test(p);
            if (!result2.getInside()) continue;
            return result2.getCurve() == null && r.isClockwise() ? Ring2.Result.Companion.getOUTSIDE() : result2;
        }
        return Ring2.Result.Companion.getOUTSIDE();
    }

    public final boolean contains(@NotNull Vec2 p) {
        Intrinsics.checkNotNullParameter(p, "p");
        return this.test(p).getInside();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Region2 transform(@NotNull Matrix3 m) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(m, "m");
        Ring2[] $this$map$iv = this.rings;
        boolean $i$f$map = false;
        Ring2[] ring2Array = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void r;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(r.transform(m));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Ring2[] ring2Array2 = thisCollection$iv.toArray(new Ring2[0]);
        return new Region2(ring2Array2);
    }

    @NotNull
    public final Region2 intersection(@NotNull Region2 region) {
        Intrinsics.checkNotNullParameter(region, "region");
        return Clip.INSTANCE.intersection(this, region);
    }

    @NotNull
    public final Region2 union(@NotNull Region2 region) {
        Intrinsics.checkNotNullParameter(region, "region");
        return Clip.INSTANCE.union(this, region);
    }

    @NotNull
    public final Region2 difference(@NotNull Region2 region) {
        Intrinsics.checkNotNullParameter(region, "region");
        return Clip.INSTANCE.difference(this, region);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/openrndr/kartifex/Region2$Companion;", "", "<init>", "()V", "of", "Lorg/openrndr/kartifex/Region2;", "rings", "", "Lorg/openrndr/kartifex/Ring2;", "([Lorg/openrndr/kartifex/Ring2;)Lorg/openrndr/kartifex/Region2;", "openrndr-kartifex"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Region2 of(Ring2 ... rings) {
            Intrinsics.checkNotNullParameter(rings, "rings");
            return new Region2((Iterable<Ring2>)ArraysKt.toList(rings));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

