/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.kartifex;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.kartifex.Matrix3;
import org.openrndr.kartifex.Polar2;
import org.openrndr.kartifex.Vec;
import org.openrndr.kartifex.Vec3;
import org.openrndr.kartifex.Vec4;
import org.openrndr.utils.Hashes;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u0000 A2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001AB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\t\u001a\u00020\u00002\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\fj\u0002`\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ3\u0010\u000e\u001a\u00020\u00042\u001c\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0010j\u0002`\u000f2\u0006\u0010\u0011\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0012J+\u0010\u000e\u001a\u00020\u00042\u001c\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0010j\u0002`\u000fH\u0016\u00a2\u0006\u0002\u0010\u0013J3\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00002\u001c\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0010j\u0002`\u000fH\u0016\u00a2\u0006\u0002\u0010\u0016J%\u0010\u0017\u001a\u00020\u00182\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00180\fj\u0002`\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ%\u0010\u001b\u001a\u00020\u00182\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00180\fj\u0002`\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0016\u0010\"\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0016\u0010#\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0006\u0010$\u001a\u00020\u0000J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0004J\u0016\u0010(\u001a\u00020)2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0004J\u000e\u0010(\u001a\u00020)2\u0006\u0010\u0015\u001a\u00020\u0000J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u0004J\u0006\u00100\u001a\u000201J\b\u00102\u001a\u00020\u001eH\u0016J\u0013\u00103\u001a\u00020\u00182\b\u00104\u001a\u0004\u0018\u000105H\u0096\u0002J\u0011\u00106\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010\"\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000H\u0016J\u0010\u0010\"\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0004H\u0016J\b\u00108\u001a\u00020\u0000H\u0016J\u0010\u0010#\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000H\u0016J\u0010\u0010#\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0004H\u0016J\u0010\u00109\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000H\u0016J\u0010\u00109\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u0004H\u0016J\u0011\u0010;\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000H\u0096\u0002J\b\u0010<\u001a\u00020=H\u0016J\t\u0010>\u001a\u00020\u0004H\u00c6\u0003J\t\u0010?\u001a\u00020\u0004H\u00c6\u0003J\u001d\u0010@\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\b\u00a8\u0006B"}, d2={"Lorg/openrndr/kartifex/Vec2;", "Lorg/openrndr/kartifex/Vec;", "Ljava/lang/Record;", "x", "", "y", "<init>", "(DD)V", "()D", "map", "f", "Lorg/openrndr/kartifex/DoubleUnaryOperator;", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Lorg/openrndr/kartifex/Vec2;", "reduce", "Lorg/openrndr/kartifex/DoubleBinaryOperator;", "Lkotlin/Function2;", "init", "(Lkotlin/jvm/functions/Function2;D)D", "(Lkotlin/jvm/functions/Function2;)D", "zip", "v", "(Lorg/openrndr/kartifex/Vec2;Lkotlin/jvm/functions/Function2;)Lorg/openrndr/kartifex/Vec2;", "every", "", "Lorg/openrndr/kartifex/DoublePredicate;", "(Lkotlin/jvm/functions/Function1;)Z", "any", "nth", "idx", "", "dim", "array", "", "add", "sub", "swap", "vec3", "Lorg/openrndr/kartifex/Vec3;", "z", "vec4", "Lorg/openrndr/kartifex/Vec4;", "w", "transform", "m", "Lorg/openrndr/kartifex/Matrix3;", "rotate", "radians", "polar2", "Lorg/openrndr/kartifex/Polar2;", "hashCode", "equals", "other", "", "compareTo", "n", "negate", "mul", "k", "div", "toString", "", "component1", "component2", "copy", "Companion", "openrndr-kartifex"})
public final class Vec2
extends Record
implements Vec<Vec2> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;
    @NotNull
    private static final Comparator<Vec2> COMPARATOR;
    @NotNull
    private static final Vec2 ORIGIN;
    @NotNull
    private static final Vec2 X_AXIS;
    @NotNull
    private static final Vec2 Y_AXIS;

    public Vec2(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public final double x() {
        return this.x;
    }

    public final double y() {
        return this.y;
    }

    @Override
    @NotNull
    public Vec2 map(@NotNull Function1<? super Double, Double> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        return new Vec2(((Number)f.invoke((Double)this.x)).doubleValue(), ((Number)f.invoke((Double)this.y)).doubleValue());
    }

    @Override
    public double reduce(@NotNull Function2<? super Double, ? super Double, Double> f, double init) {
        Intrinsics.checkNotNullParameter(f, "f");
        return ((Number)f.invoke(f.invoke((Double)this.x, (Double)this.y), (Double)init)).doubleValue();
    }

    @Override
    public double reduce(@NotNull Function2<? super Double, ? super Double, Double> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        return ((Number)f.invoke((Double)this.x, (Double)this.y)).doubleValue();
    }

    @Override
    @NotNull
    public Vec2 zip(@NotNull Vec2 v, @NotNull Function2<? super Double, ? super Double, Double> f) {
        Intrinsics.checkNotNullParameter(v, "v");
        Intrinsics.checkNotNullParameter(f, "f");
        return new Vec2(((Number)f.invoke((Double)this.x, (Double)v.x)).doubleValue(), ((Number)f.invoke((Double)this.y, (Double)v.y)).doubleValue());
    }

    @Override
    public boolean every(@NotNull Function1<? super Double, Boolean> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        return f.invoke((Double)this.x) != false && f.invoke((Double)this.y) != false;
    }

    @Override
    public boolean any(@NotNull Function1<? super Double, Boolean> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        return f.invoke((Double)this.x) != false || f.invoke((Double)this.y) != false;
    }

    @Override
    public double nth(int idx) {
        return switch (idx) {
            case 0 -> this.x;
            case 1 -> this.y;
            default -> throw new IndexOutOfBoundsException();
        };
    }

    @Override
    public int dim() {
        return 2;
    }

    @Override
    @NotNull
    public double[] array() {
        double[] dArray = new double[]{this.x, this.y};
        return dArray;
    }

    @NotNull
    public final Vec2 add(double x, double y) {
        return new Vec2(this.x + x, this.y + y);
    }

    @NotNull
    public final Vec2 sub(double x, double y) {
        return new Vec2(this.x - x, this.y - y);
    }

    @NotNull
    public final Vec2 swap() {
        return new Vec2(this.y, this.x);
    }

    @NotNull
    public final Vec3 vec3(double z) {
        return new Vec3(this.x, this.y, z);
    }

    @NotNull
    public final Vec4 vec4(double z, double w) {
        return new Vec4(this.x, this.y, z, w);
    }

    @NotNull
    public final Vec4 vec4(@NotNull Vec2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new Vec4(this.x, this.y, v.x, v.y);
    }

    @NotNull
    public final Vec2 transform(@NotNull Matrix3 m) {
        Intrinsics.checkNotNullParameter(m, "m");
        return m.transform(this);
    }

    @NotNull
    public final Vec2 rotate(double radians) {
        double s = Math.sin(radians);
        double c2 = Math.cos(radians);
        return new Vec2(c2 * this.x + -s * this.y, s * this.x + c2 * this.y);
    }

    @NotNull
    public final Polar2 polar2() {
        return new Polar2(Math.atan2(this.y, this.x), this.length());
    }

    @Override
    public int hashCode() {
        return Hashes.INSTANCE.hash(this.x, this.y);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other instanceof Vec2) {
            Object v = other;
            return ((Vec2)v).x == this.x && ((Vec2)v).y == this.y;
        }
        return false;
    }

    @Override
    public int compareTo(@NotNull Vec2 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return COMPARATOR.compare(this, other);
    }

    @Override
    @NotNull
    public Vec2 add(@NotNull Vec2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new Vec2(this.x + v.x, this.y + v.y);
    }

    @Override
    @NotNull
    public Vec2 add(double n) {
        return new Vec2(this.x + n, this.y + n);
    }

    @Override
    @NotNull
    public Vec2 negate() {
        return new Vec2(-this.x, -this.y);
    }

    @Override
    @NotNull
    public Vec2 sub(@NotNull Vec2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new Vec2(this.x - v.x, this.y - v.y);
    }

    @Override
    @NotNull
    public Vec2 sub(double n) {
        return new Vec2(this.x - n, this.y - n);
    }

    @Override
    @NotNull
    public Vec2 mul(@NotNull Vec2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new Vec2(this.x * v.x, this.y * v.y);
    }

    @Override
    @NotNull
    public Vec2 mul(double k) {
        return new Vec2(this.x * k, this.y * k);
    }

    @Override
    @NotNull
    public Vec2 div(@NotNull Vec2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new Vec2(this.x / v.x, this.y / v.y);
    }

    @Override
    @NotNull
    public String toString() {
        return "Vec2(x=" + this.x + ", y=" + this.y + ")";
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    @NotNull
    public final Vec2 copy(double x, double y) {
        return new Vec2(x, y);
    }

    public static /* synthetic */ Vec2 copy$default(Vec2 vec2, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = vec2.x;
        }
        if ((n & 2) != 0) {
            d2 = vec2.y;
        }
        return vec2.copy(d, d2);
    }

    @Override
    @NotNull
    public Vec2 div(double k) {
        return Vec.DefaultImpls.div(this, k);
    }

    @Override
    @NotNull
    public Vec2 abs() {
        return Vec.DefaultImpls.abs(this);
    }

    @Override
    public double lengthSquared() {
        return Vec.DefaultImpls.lengthSquared(this);
    }

    @Override
    public double length() {
        return Vec.DefaultImpls.length(this);
    }

    @Override
    @NotNull
    public Vec2 norm() {
        return Vec.DefaultImpls.norm(this);
    }

    @Override
    @NotNull
    public Vec2 pseudoNorm() {
        return Vec.DefaultImpls.pseudoNorm(this);
    }

    @Override
    @NotNull
    public Vec2 clamp(double min, double max) {
        return (Vec2)Vec.DefaultImpls.clamp(this, min, max);
    }

    @Override
    @NotNull
    public Vec2 clamp(@NotNull Vec2 min, @NotNull Vec2 max) {
        return (Vec2)Vec.DefaultImpls.clamp(this, (Vec)min, (Vec)max);
    }

    private static final Comparable COMPARATOR$lambda$0(Vec2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return Double.valueOf(v.x);
    }

    private static final Comparable COMPARATOR$lambda$1(Vec2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return Double.valueOf(v.y);
    }

    static {
        Function1[] function1Array = new Function1[]{Vec2::COMPARATOR$lambda$0, Vec2::COMPARATOR$lambda$1};
        COMPARATOR = ComparisonsKt.compareBy(function1Array);
        ORIGIN = new Vec2(0.0, 0.0);
        X_AXIS = new Vec2(1.0, 0.0);
        Y_AXIS = new Vec2(0.0, 1.0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lorg/openrndr/kartifex/Vec2$Companion;", "", "<init>", "()V", "COMPARATOR", "Ljava/util/Comparator;", "Lorg/openrndr/kartifex/Vec2;", "getCOMPARATOR", "()Ljava/util/Comparator;", "ORIGIN", "getORIGIN", "()Lorg/openrndr/kartifex/Vec2;", "X_AXIS", "getX_AXIS", "Y_AXIS", "getY_AXIS", "cross", "", "a", "b", "angleBetween", "oa", "ob", "between", "", "c", "openrndr-kartifex"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Comparator<Vec2> getCOMPARATOR() {
            return COMPARATOR;
        }

        @NotNull
        public final Vec2 getORIGIN() {
            return ORIGIN;
        }

        @NotNull
        public final Vec2 getX_AXIS() {
            return X_AXIS;
        }

        @NotNull
        public final Vec2 getY_AXIS() {
            return Y_AXIS;
        }

        public final double cross(@NotNull Vec2 a, @NotNull Vec2 b) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            return a.x() * b.y() - a.y() * b.x();
        }

        public final double angleBetween(@NotNull Vec2 oa, @NotNull Vec2 ob) {
            Intrinsics.checkNotNullParameter(oa, "oa");
            Intrinsics.checkNotNullParameter(ob, "ob");
            Vec2 a = (Vec2)oa.pseudoNorm();
            Vec2 b = (Vec2)ob.pseudoNorm();
            double theta = Math.atan2(this.cross(a, b), Vec.Companion.dot(a, b));
            if (theta > 0.0) {
                theta -= Math.PI * 2;
            }
            return theta;
        }

        public final boolean between(@NotNull Vec2 a, @NotNull Vec2 b, @NotNull Vec2 c2) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            Intrinsics.checkNotNullParameter(c2, "c");
            return this.cross(a, b) * this.cross(c2, b) < 0.0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

