/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.kartifex.utils;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.kartifex.utils.Scalars;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0005H\u0002J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u001e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005J&\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\bJ\u001e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005J.\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\bJ&\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/openrndr/kartifex/utils/Equations;", "", "<init>", "()V", "DISCRIMINANT_EPSILON", "", "SOLUTION_EPSILON", "trim", "", "acc", "len", "", "split", "n", "discriminant", "a", "b", "c", "solveLinear", "solveQuadratic", "solveCubic", "d", "openrndr-kartifex"})
public final class Equations {
    @NotNull
    public static final Equations INSTANCE = new Equations();
    private static final double DISCRIMINANT_EPSILON = 1.0E-10;
    private static final double SOLUTION_EPSILON = 1.0E-8;

    private Equations() {
    }

    /*
     * WARNING - void declaration
     */
    private final double[] trim(double[] acc, int len) {
        double[] dArray;
        if (len == acc.length) {
            dArray = acc;
        } else if (len == 0) {
            dArray = new double[]{};
        } else {
            void var3_3;
            double[] result2 = new double[len];
            ArraysKt.copyInto(acc, result2, 0, 0, len);
            dArray = var3_3;
        }
        return dArray;
    }

    private final double[] split(double n) {
        double x = n * (double)0x8000001;
        double y = n - x;
        double hi = y + x;
        double lo = n - hi;
        double[] dArray = new double[]{hi, lo};
        return dArray;
    }

    private final double discriminant(double a, double b, double c2) {
        double D2 = b * b - a * c2;
        double E = b * b + a * c2;
        if (Math.abs(D2) * (double)3 < E) {
            double[] ad = this.split(a);
            double[] bd = this.split(b);
            double[] cd = this.split(c2);
            double p = b * b;
            double dp = bd[0] * bd[0] - p + (double)2 * bd[0] * bd[1] + bd[1] * bd[1];
            double q = a * c2;
            double dq = ad[0] * cd[0] - q + ad[0] * cd[1] + ad[1] * cd[0] + ad[1] * cd[1];
            D2 = p - q + (dp - dq);
        }
        return D2;
    }

    public final int solveLinear(double a, double b, @NotNull double[] acc) {
        int n;
        Intrinsics.checkNotNullParameter(acc, "acc");
        if (Math.abs(a) < 1.0E-14) {
            n = 0;
        } else {
            acc[0] = -b / a;
            n = 1;
        }
        return n;
    }

    @NotNull
    public final double[] solveLinear(double a, double b) {
        double[] acc = new double[1];
        return this.trim(acc, this.solveLinear(a, b, acc));
    }

    public final int solveQuadratic(double a, double b, double c2, @NotNull double[] acc) {
        int n;
        double k;
        double D2;
        Intrinsics.checkNotNullParameter(acc, "acc");
        double a2 = a;
        double b2 = b;
        double c3 = c2;
        if (Math.abs(a2) < 1.0E-14) {
            return this.solveLinear(b2, c3, acc);
        }
        b2 *= -0.5;
        if ((D2 = this.discriminant(a2 *= (k = Scalars.INSTANCE.normalizationFactor(a2, b2, c3)), b2 *= k, c3 *= k)) >= -1.0E-10) {
            double Q = D2 < 0.0 ? 0.0 : Math.sqrt(D2);
            double R2 = b2 + (b2 < 0.0 ? -Q : Q);
            if (R2 == 0.0) {
                acc[0] = c3 / a2;
                acc[1] = -c3 / a2;
            } else {
                acc[0] = R2 / a2;
                acc[1] = c3 / R2;
            }
            int writeIdx = 0;
            for (int readIdx = 0; readIdx < 2; ++readIdx) {
                double x = acc[readIdx];
                double y = a2 * x * x + (double)-2 * b2 * x + c3;
                if (!(Math.abs(y) < 1.0E-8)) continue;
                acc[writeIdx++] = x;
            }
            n = writeIdx;
        } else {
            n = 0;
        }
        return n;
    }

    @NotNull
    public final double[] solveQuadratic(double a, double b, double c2) {
        double[] acc = new double[2];
        return this.trim(acc, this.solveQuadratic(a, b, c2, acc));
    }

    public final int solveCubic(double a, double b, double c2, double d, @NotNull double[] acc) {
        Intrinsics.checkNotNullParameter(acc, "acc");
        double a2 = a;
        double b2 = b;
        double c3 = c2;
        double d2 = d;
        double k = Scalars.INSTANCE.normalizationFactor(a2, b2, c3, d2);
        a2 *= k;
        b2 *= k;
        c3 *= k;
        d2 *= k;
        double x = 0.0;
        double b1 = 0.0;
        double c22 = 0.0;
        double qd = 0.0;
        double q = 0.0;
        if (Math.abs(a2) < 1.0E-14) {
            return this.solveQuadratic(b2, c3, d2, acc);
        }
        if (Math.abs(d2) < 1.0E-14) {
            b1 = b2;
            c22 = c3;
            x = 0.0;
        } else {
            double td;
            double rd;
            x = -(b2 / a2) / (double)3;
            b1 = a2 * x + b2;
            c22 = b1 * x + c3;
            qd = (a2 * x + b1) * x + c22;
            q = c22 * x + d2;
            double t = q / a2;
            double r = Math.pow(Math.abs(t), 0.3333333333333333);
            double s = t < 0.0 ? -1.0 : 1.0;
            double x0 = x - s * (rd = (td = -qd / a2) > 0.0 ? 1.324717957244746 * Math.max(r, Math.sqrt(td)) : r);
            if (!(x0 == x)) {
                do {
                    x = x0;
                    b1 = a2 * x + b2;
                    c22 = b1 * x + c3;
                    qd = (a2 * x + b1) * x + c22;
                    q = c22 * x + d2;
                } while (s * (x0 = qd == 0.0 ? x : x - q / (qd / (1.0 + Scalars.INSTANCE.getMACHINE_EPSILON()))) > s * x);
                if (Math.abs(a2) * x * x > Math.abs(d2 / x)) {
                    c22 = -d2 / x;
                    b1 = (c22 - c3) / x;
                }
            }
        }
        int solutions = this.solveQuadratic(a2, b1, c22, acc);
        int n = solutions;
        for (int i = 0; i < n; ++i) {
            if (!(acc[i] == x)) continue;
            return solutions;
        }
        double y = a2 * x * x * x + b2 * x * x + c3 * x + d2;
        if (Math.abs(y) < 1.0E-8) {
            acc[solutions++] = x;
        }
        return solutions;
    }

    @NotNull
    public final double[] solveCubic(double a, double b, double c2, double d) {
        double[] acc = new double[3];
        return this.trim(acc, this.solveCubic(a, b, c2, d, acc));
    }
}

