/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.kartifex.utils;

import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.collections.PriorityQueue;
import org.openrndr.kartifex.utils.SweepQueueKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u0000 \u0019*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\u000fJ\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0086\u0002J\r\u0010\u0014\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0015J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017R \u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0004R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/openrndr/kartifex/utils/SweepQueue;", "T", "", "<init>", "()V", "queue", "Lorg/openrndr/collections/PriorityQueue;", "Lorg/openrndr/kartifex/utils/SweepQueue$Event;", "getQueue$annotations", "set", "", "add", "", "value", "a", "", "b", "(Ljava/lang/Object;DD)V", "peek", "next", "take", "()Ljava/lang/Object;", "active", "", "Event", "Companion", "openrndr-kartifex"})
public final class SweepQueue<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PriorityQueue<Event<T>> queue;
    @NotNull
    private final Set<T> set;
    public static final int OPEN = 0;
    public static final int CLOSED = 1;

    public SweepQueue() {
        Comparator<Event<?>> comparator = Event.Companion.getCOMPARATOR();
        Intrinsics.checkNotNull(comparator, "null cannot be cast to non-null type java.util.Comparator<org.openrndr.kartifex.utils.SweepQueue.Event<T of org.openrndr.kartifex.utils.SweepQueue>>");
        this.queue = new PriorityQueue(comparator);
        this.set = new LinkedHashSet();
    }

    private static /* synthetic */ void getQueue$annotations() {
    }

    public final void add(T value2, double a, double b) {
        this.queue.add(new Event<T>(Math.min(a, b) - 1.0E-14, value2, 0));
        this.queue.add(new Event<T>(Math.max(a, b) + 1.0E-14, value2, 1));
    }

    public final double peek() {
        return this.queue.isEmpty() ? Double.MAX_VALUE : this.queue.peek().getKey();
    }

    @NotNull
    public final Event<T> next() {
        Event<T> event = this.queue.poll();
        if (event == null) {
            throw new IllegalStateException("queue empty".toString());
        }
        Event<T> e = event;
        boolean bl = e.getType() == 1 ? this.set.remove(e.getValue()) : this.set.add(e.getValue());
        return e;
    }

    @Nullable
    public final T take() {
        while (!this.queue.isEmpty()) {
            Event<T> e = this.next();
            if (e.getType() != 0) continue;
            return e.getValue();
        }
        return null;
    }

    @NotNull
    public final Set<T> active() {
        return this.set;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0007\u001a\u00020\u0005\"\u0004\b\u0001\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\b0\nH\u0002J1\u0010\f\u001a\u00020\u0005\"\u0004\b\u0001\u0010\b2\u001e\u0010\r\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\b0\n0\u000e\"\b\u0012\u0004\u0012\u0002H\b0\n\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/openrndr/kartifex/utils/SweepQueue$Companion;", "", "<init>", "()V", "OPEN", "", "CLOSED", "compare", "T", "a", "Lorg/openrndr/kartifex/utils/SweepQueue;", "b", "next", "queues", "", "([Lorg/openrndr/kartifex/utils/SweepQueue;)I", "openrndr-kartifex"})
    public static final class Companion {
        private Companion() {
        }

        private final <T> int compare(SweepQueue<T> a, SweepQueue<T> b) {
            return Event.Companion.getCOMPARATOR().compare((Event<?>)((SweepQueue)a).queue.peek(), (Event<?>)((SweepQueue)b).queue.peek());
        }

        public final <T> int next(SweepQueue<T> ... queues) {
            Intrinsics.checkNotNullParameter(queues, "queues");
            while (true) {
                int minIdx = 0;
                int n = queues.length;
                for (int i = 1; i < n; ++i) {
                    if (!((SweepQueue)queues[minIdx]).queue.isEmpty()) {
                        if (((SweepQueue)queues[i]).queue.isEmpty()) continue;
                        if (this.compare(queues[i], queues[minIdx]) >= 0) continue;
                    }
                    minIdx = i;
                }
                SweepQueue<T> q = queues[minIdx];
                if (((SweepQueue)q).queue.isEmpty() || ((Event)((SweepQueue)q).queue.peek()).getType() == 0) {
                    return minIdx;
                }
                q.next();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u0000 \u0011*\u0004\b\u0001\u0010\u00012\u00020\u0002:\u0001\u0011B!\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/openrndr/kartifex/utils/SweepQueue$Event;", "T", "", "key", "", "value", "type", "", "<init>", "(DLjava/lang/Object;I)V", "getKey", "()D", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getType", "()I", "Companion", "openrndr-kartifex"})
    public static final class Event<T> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final double key;
        private final T value;
        private final int type;
        @NotNull
        private static final Comparator<Event<?>> COMPARATOR = Event::COMPARATOR$lambda$0;

        public Event(double key, T value2, int type) {
            this.key = key;
            this.value = value2;
            this.type = type;
        }

        public final double getKey() {
            return this.key;
        }

        public final T getValue() {
            return this.value;
        }

        public final int getType() {
            return this.type;
        }

        private static final int COMPARATOR$lambda$0(Event a, Event b) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            double diff = a.key - b.key;
            return diff == 0.0 ? a.type - b.type : (int)SweepQueueKt.access$copySign(1.0, diff);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R+\u0010\u0004\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0007j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006`\u0005\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lorg/openrndr/kartifex/utils/SweepQueue$Event$Companion;", "", "<init>", "()V", "COMPARATOR", "Lkotlin/Comparator;", "Lorg/openrndr/kartifex/utils/SweepQueue$Event;", "Ljava/util/Comparator;", "getCOMPARATOR", "()Ljava/util/Comparator;", "Ljava/util/Comparator;", "openrndr-kartifex"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Comparator<Event<?>> getCOMPARATOR() {
                return COMPARATOR;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

