/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.kartifex.utils.graphs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.kartifex.utils.graphs.DirectedGraphKt;
import org.openrndr.kartifex.utils.graphs.Edge;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003BE\u0012 \b\u0002\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00050\u0005\u0012\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012J\u0018\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00150\u0014J\u001b\u0010\u0016\u001a\u00028\u00012\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00122\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00122\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001aJ#\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001dJ=\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u00012\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00010\u001f\u00a2\u0006\u0002\u0010 J\u001b\u0010!\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\"J\u001f\u0010#\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010$J \u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012J\b\u0010'\u001a\u00020\u000eH\u0016J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0096\u0002R)\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006+"}, d2={"Lorg/openrndr/kartifex/utils/graphs/DirectedGraph;", "V", "E", "", "out", "", "in", "", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "getOut", "()Ljava/util/Map;", "getIn", "indexOf", "", "vertex", "(Ljava/lang/Object;)I", "vertices", "", "edges", "", "Lorg/openrndr/kartifex/utils/graphs/Edge;", "edge", "from", "to", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "(Ljava/lang/Object;)Ljava/util/Set;", "link", "", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "merge", "Lkotlin/Function2;", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)V", "unlink", "(Ljava/lang/Object;Ljava/lang/Object;)V", "add", "(Ljava/lang/Object;)Lorg/openrndr/kartifex/utils/graphs/DirectedGraph;", "select", "selection", "hashCode", "equals", "", "other", "openrndr-kartifex"})
@SourceDebugExtension(value={"SMAP\nDirectedGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectedGraph.kt\norg/openrndr/kartifex/utils/graphs/DirectedGraph\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,461:1\n381#2,7:462\n381#2,7:469\n487#2,7:476\n774#3:483\n865#3,2:484\n*S KotlinDebug\n*F\n+ 1 DirectedGraph.kt\norg/openrndr/kartifex/utils/graphs/DirectedGraph\n*L\n98#1:462,7\n99#1:469,7\n137#1:476,7\n142#1:483\n142#1:484,2\n*E\n"})
public final class DirectedGraph<V, E> {
    @NotNull
    private final Map<V, Map<V, E>> out;
    @NotNull
    private final Map<V, Set<V>> in;

    public DirectedGraph(@NotNull Map<V, Map<V, E>> out, @NotNull Map<V, Set<V>> in) {
        Intrinsics.checkNotNullParameter(out, "out");
        Intrinsics.checkNotNullParameter(in, "in");
        this.out = out;
        this.in = in;
    }

    public /* synthetic */ DirectedGraph(Map map2, Map map3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map2 = new LinkedHashMap();
        }
        if ((n & 2) != 0) {
            map3 = new LinkedHashMap();
        }
        this(map2, map3);
    }

    @NotNull
    public final Map<V, Map<V, E>> getOut() {
        return this.out;
    }

    @NotNull
    public final Map<V, Set<V>> getIn() {
        return this.in;
    }

    public final int indexOf(V vertex) {
        return DirectedGraphKt.indexOf(this.out.keySet(), vertex);
    }

    @NotNull
    public final Set<V> vertices() {
        return this.out.keySet();
    }

    @NotNull
    public final Iterable<Edge<V, E>> edges() {
        return new Iterable<Edge<V, E>>(this){
            final /* synthetic */ DirectedGraph this$0;
            {
                this.this$0 = directedGraph;
            }

            /*
             * WARNING - void declaration
             */
            public Iterator<Edge<V, E>> iterator() {
                void $this$flatMapTo$iv$iv;
                boolean bl = false;
                Iterable $this$flatMap$iv = this.this$0.getOut().entrySet();
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Map.Entry outer = (Map.Entry)element$iv$iv;
                    boolean bl2 = false;
                    Iterable iterable2 = ((Map)outer.getValue()).entrySet();
                    boolean $i$f$map = false;
                    void var13_13 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void inner;
                        Map.Entry entry = (Map.Entry)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl3 = false;
                        collection.add(new Edge<K, V>(inner.getValue(), inner.getKey(), outer.getKey()));
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv2;
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                return ((List)destination$iv$iv).iterator();
            }
        };
    }

    public final E edge(V from, V to) {
        Map<V, E> map2 = this.out.get(from);
        if (map2 == null) {
            throw new IllegalStateException("no such edge".toString());
        }
        Map<V, E> m = map2;
        E e = m.get(to);
        if (e == null) {
            throw new IllegalStateException("no such edge".toString());
        }
        E e2 = e;
        return e2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final Set<V> in(V vertex) {
        Set<Object> set;
        Set<V> s = this.in.get(vertex);
        if (s == null) {
            if (!this.out.containsKey(vertex)) throw new IllegalStateException("no such vertex".toString());
            set = SetsKt.emptySet();
            return set;
        } else {
            set = s;
        }
        return set;
    }

    @NotNull
    public final Set<V> out(V vertex) {
        Map<V, E> map2 = this.out.get(vertex);
        if (map2 == null || (map2 = map2.keySet()) == null) {
            throw new IllegalStateException(("no such vertex " + vertex).toString());
        }
        return map2;
    }

    public final void link(V from, V to, E edge) {
        this.link(from, to, edge, DirectedGraph::link$lambda$3);
    }

    public final void link(V from, V to, E edge, @NotNull Function2<? super E, ? super E, ? extends E> merge) {
        Object object;
        Intrinsics.checkNotNullParameter(merge, "merge");
        this.add(from);
        this.add(to);
        Map<V, E> map2 = this.out.get(from);
        if (map2 == null) {
            throw new IllegalStateException("no from vertex".toString());
        }
        E e = map2.get(to);
        if (e == null) {
            Map<E, E> map3 = this.out.get(from);
            Intrinsics.checkNotNull(map3);
            map3.put(to, edge);
        } else {
            Map<E, E> map4 = this.out.get(from);
            Intrinsics.checkNotNull(map4);
            map4.put(to, merge.invoke(e, edge));
        }
        Map<Object, Object> $this$getOrPut$iv = this.out;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(to);
        if (value$iv == null) {
            boolean bl = false;
            Map answer$iv = new LinkedHashMap();
            $this$getOrPut$iv.put(to, answer$iv);
        }
        $this$getOrPut$iv = this.in;
        $i$f$getOrPut = false;
        value$iv = $this$getOrPut$iv.get(to);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(to, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((Set)object).add(from);
    }

    public final void unlink(V from, V to) {
        Map<V, E> map2 = this.out.get(from);
        if (map2 == null) {
            throw new IllegalStateException("no from vertex".toString());
        }
        map2.remove(to);
        Set<V> set = this.in.get(to);
        Intrinsics.checkNotNull(set);
        set.remove(from);
    }

    @NotNull
    public final DirectedGraph<V, E> add(V vertex) {
        DirectedGraph directedGraph;
        if (this.out.containsKey(vertex)) {
            directedGraph = this;
        } else {
            this.out.put((Map)vertex, new LinkedHashMap());
            this.in.put((Set)vertex, new LinkedHashSet());
            directedGraph = this;
        }
        return directedGraph;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DirectedGraph<V, E> select(@NotNull Set<? extends V> selection) {
        Object result$iv;
        V v;
        Map map2;
        Intrinsics.checkNotNullParameter(selection, "selection");
        Map newOut = new LinkedHashMap();
        Map newIn = new LinkedHashMap();
        for (Map.Entry<V, Map<V, E>> entry : this.out.entrySet()) {
            if (!selection.contains(entry.getKey())) continue;
            map2 = newOut;
            v = entry.getKey();
            Map<Object, Object> $this$filterKeys$iv = entry.getValue();
            boolean $i$f$filterKeys = false;
            result$iv = new LinkedHashMap();
            for (Map.Entry<V, E> entry$iv : $this$filterKeys$iv.entrySet()) {
                V key = entry$iv.getKey();
                boolean bl = false;
                if (!selection.contains(key)) continue;
                ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$filterKeys$iv = MapsKt.toMutableMap((Map)result$iv);
            map2.put(v, $this$filterKeys$iv);
        }
        for (Map.Entry<V, Object> entry : this.in.entrySet()) {
            void $this$filterTo$iv$iv;
            if (!selection.contains(entry.getKey())) continue;
            map2 = newIn;
            v = entry.getKey();
            Iterable $this$filter$iv = (Iterable)entry.getValue();
            boolean $i$f$filter = false;
            result$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv;
                Object it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!selection.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Set set = CollectionsKt.toMutableSet((List)destination$iv$iv);
            map2.put(v, set);
        }
        return new DirectedGraph<V, E>(newOut, newIn);
    }

    public int hashCode() {
        return ((Object)this.out).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof DirectedGraph ? Intrinsics.areEqual(((DirectedGraph)other).out, this.out) : false;
    }

    private static final Object link$lambda$3(Object object, Object b) {
        return b;
    }

    public DirectedGraph() {
        this(null, null, 3, null);
    }
}

