/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.kartifex.utils.graphs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.collections.PriorityQueue;
import org.openrndr.kartifex.utils.graphs.DirectedGraph;
import org.openrndr.kartifex.utils.graphs.Edge;
import org.openrndr.kartifex.utils.graphs.IEdge;
import org.openrndr.kartifex.utils.graphs.TarjanState;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00050\u0005\"\u0004\b\u0000\u0010\u00062\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u0002H\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\nJ@\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\r0\b0\f\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\r2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\r0\b2\u0006\u0010\t\u001a\u00020\nJ2\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\f0\f\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\r2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\r0\bJ9\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0010\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0011\u001a\u0002H\u00062\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00140\u0013\u00a2\u0006\u0002\u0010\u0015J:\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0010\"\u0004\b\u0000\u0010\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00142\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00140\u0013Jp\u0010\u0016\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\f\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\r2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\r0\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00142\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\n0\u00132\u001e\u0010\u0018\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\r0\u0019\u0012\u0004\u0012\u00020\u001a0\u0013\u00a8\u0006\u001c"}, d2={"Lorg/openrndr/kartifex/utils/graphs/Graphs;", "", "<init>", "()V", "stronglyConnectedComponents", "", "V", "graph", "Lorg/openrndr/kartifex/utils/graphs/DirectedGraph;", "includeSingletons", "", "stronglyConnectedSubgraphs", "", "E", "cycles", "bfsVertices", "", "start", "adjacent", "Lkotlin/Function1;", "", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/util/Iterator;", "shortestPath", "accept", "cost", "Lorg/openrndr/kartifex/utils/graphs/IEdge;", "", "ShortestPathState", "openrndr-kartifex"})
@SourceDebugExtension(value={"SMAP\nDirectedGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectedGraph.kt\norg/openrndr/kartifex/utils/graphs/Graphs\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,461:1\n1863#2,2:462\n1734#2,3:464\n1863#2,2:468\n1863#2:470\n1864#2:478\n1863#2,2:479\n1#3:467\n381#4,7:471\n381#4,7:481\n*S KotlinDebug\n*F\n+ 1 DirectedGraph.kt\norg/openrndr/kartifex/utils/graphs/Graphs\n*L\n265#1:462,2\n286#1:464,3\n331#1:468,2\n336#1:470\n336#1:478\n356#1:479,2\n336#1:471,7\n428#1:481,7\n*E\n"})
public final class Graphs {
    @NotNull
    public static final Graphs INSTANCE = new Graphs();

    private Graphs() {
    }

    @NotNull
    public final <V> Set<Set<V>> stronglyConnectedComponents(@NotNull DirectedGraph<V, ?> graph, boolean includeSingletons) {
        Intrinsics.checkNotNullParameter(graph, "graph");
        Map state = new LinkedHashMap();
        ArrayDeque stack = new ArrayDeque();
        List path = new ArrayList();
        List branches = new ArrayList();
        Set result2 = new LinkedHashSet();
        for (V seed : graph.vertices()) {
            if (state.containsKey(seed)) continue;
            Object[] objectArray = new Object[]{seed};
            branches.add(CollectionsKt.mutableListOf(objectArray).iterator());
            do {
                Object x;
                TarjanState ws;
                Object w;
                if (((Iterator)CollectionsKt.last(branches)).hasNext()) {
                    w = ((Iterator)CollectionsKt.last(branches)).next();
                    ws = (TarjanState)state.get(w);
                    if (ws == null) {
                        ws = new TarjanState(state.size());
                        state.put(w, ws);
                        stack.addLast(w);
                        path.add(w);
                        branches.add(graph.out(w).iterator());
                        continue;
                    }
                    if (!ws.getOnStack()) continue;
                    Object v = state.get(CollectionsKt.last(path));
                    Intrinsics.checkNotNull(v);
                    TarjanState vs = (TarjanState)v;
                    vs.setLowlink(Math.min(vs.getLowlink(), ws.getIndex()));
                    continue;
                }
                CollectionsKt.removeLast(branches);
                w = CollectionsKt.removeLast(path);
                Object v = state.get(w);
                Intrinsics.checkNotNull(v);
                ws = (TarjanState)v;
                if (path.size() > 0) {
                    Object v2 = CollectionsKt.last(path);
                    Object v3 = state.get(v2);
                    Intrinsics.checkNotNull(v3);
                    TarjanState vs = (TarjanState)v3;
                    vs.setLowlink(Math.min(vs.getLowlink(), ws.getLowlink()));
                }
                if (ws.getLowlink() != ws.getIndex()) continue;
                if (!includeSingletons && stack.last() == w) {
                    stack.removeLast();
                    Object v4 = state.get(w);
                    Intrinsics.checkNotNull(v4);
                    ((TarjanState)v4).setOnStack(false);
                    continue;
                }
                Set group = new LinkedHashSet();
                do {
                    x = stack.removeLast();
                    group.add(x);
                    Object v5 = state.get(x);
                    Intrinsics.checkNotNull(v5);
                    ((TarjanState)v5).setOnStack(false);
                } while (x != w);
                result2.add(group);
            } while (path.size() > 0);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <V, E> List<DirectedGraph<V, E>> stronglyConnectedSubgraphs(@NotNull DirectedGraph<V, E> graph, boolean includeSingletons) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter(graph, "graph");
        List result2 = new ArrayList();
        Iterable iterable = this.stronglyConnectedComponents(graph, includeSingletons);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Set s = (Set)element$iv;
            boolean bl = false;
            result2.add(graph.select(s));
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <V, E> List<List<V>> cycles(@NotNull DirectedGraph<V, E> graph) {
        Intrinsics.checkNotNullParameter(graph, "graph");
        List path = new ArrayList();
        List branches = new ArrayList();
        Set blocked = new LinkedHashSet();
        Map blocking = new LinkedHashMap();
        List result2 = new ArrayList();
        for (DirectedGraph directedGraph : this.stronglyConnectedSubgraphs(graph, true)) {
            Object v;
            boolean bl;
            block19: {
                void $this$all$iv;
                Iterable iterable = directedGraph.vertices();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator2 = $this$all$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv;
                        v = element$iv = iterator2.next();
                        boolean bl2 = false;
                        if (directedGraph.out(v).size() == 1) continue;
                        bl = false;
                        break block19;
                    }
                    bl = true;
                }
            }
            if (bl) {
                Object seed = directedGraph.vertices().iterator().next();
                directedGraph.out(seed);
                result2.add(CollectionsKt.plus((Collection)SequencesKt.toList(SequencesKt.asSequence(this.bfsVertices(seed, arg_0 -> Graphs.cycles$lambda$2(directedGraph, arg_0)))), (Iterable)CollectionsKt.listOf(seed)));
                continue;
            }
            for (Object seed : directedGraph.vertices()) {
                int threshold = directedGraph.indexOf(seed);
                path.add(seed);
                branches.add(directedGraph.out(seed).iterator());
                blocked.clear();
                blocking.clear();
                int depth = 1;
                do {
                    Boolean bl2;
                    if (((Iterator)CollectionsKt.last(branches)).hasNext()) {
                        v = ((Iterator)CollectionsKt.last(branches)).next();
                        if (directedGraph.indexOf(v) < threshold) continue;
                        if (Intrinsics.areEqual(seed, v)) {
                            result2.add(CollectionsKt.plus((Collection)path, (Iterable)CollectionsKt.listOf(seed)));
                            depth = 0;
                        } else if (!blocked.contains(v)) {
                            path.add(v);
                            ++depth;
                            branches.add(directedGraph.out(v).iterator());
                        }
                        bl2 = blocked.add(v);
                        continue;
                    }
                    v = CollectionsKt.removeLast(path);
                    if ((depth = Math.max(-1, depth - 1)) < 0) {
                        ArrayDeque arrayDeque;
                        ArrayDeque $this$cycles_u24lambda_u243 = arrayDeque = new ArrayDeque();
                        boolean bl422 = false;
                        $this$cycles_u24lambda_u243.addFirst(v);
                        ArrayDeque stack = arrayDeque;
                        while (stack.size() > 0) {
                            Object u = stack.removeLast();
                            if (!blocked.contains(u)) continue;
                            blocked.remove(u);
                            Object object = (Set)blocking.get(u);
                            if (object == null) {
                                void $this$forEach$iv;
                                Iterable bl422 = SetsKt.emptySet();
                                boolean $i$f$forEach = false;
                                Iterator iterator3 = $this$forEach$iv.iterator();
                                while (iterator3.hasNext()) {
                                    Object element$iv;
                                    Object value2 = element$iv = iterator3.next();
                                    boolean bl5 = false;
                                    stack.addLast(value2);
                                }
                                object = Unit.INSTANCE;
                            }
                            blocking.remove(u);
                        }
                    } else {
                        Iterable $this$forEach$iv = graph.out(v);
                        boolean $i$f$forEach = false;
                        Iterator iterator4 = $this$forEach$iv.iterator();
                        while (iterator4.hasNext()) {
                            Object object;
                            Object element$iv;
                            Object u = element$iv = iterator4.next();
                            boolean bl6 = false;
                            Map $this$getOrPut$iv = blocking;
                            boolean $i$f$getOrPut = false;
                            Object value$iv = $this$getOrPut$iv.get(u);
                            if (value$iv == null) {
                                boolean bl7 = false;
                                Set answer$iv = new LinkedHashSet();
                                $this$getOrPut$iv.put(u, answer$iv);
                                object = answer$iv;
                            } else {
                                object = value$iv;
                            }
                            ((Set)object).add(v);
                        }
                    }
                    bl2 = CollectionsKt.removeLast(branches);
                } while (path.size() > 0);
            }
        }
        return result2;
    }

    @NotNull
    public final <V> Iterator<V> bfsVertices(V start, @NotNull Function1<? super V, ? extends Iterable<? extends V>> adjacent) {
        Intrinsics.checkNotNullParameter(adjacent, "adjacent");
        return this.bfsVertices((Iterable)CollectionsKt.listOf(start), adjacent);
    }

    @NotNull
    public final <V> Iterator<V> bfsVertices(@NotNull Iterable<? extends V> start, @NotNull Function1<? super V, ? extends Iterable<? extends V>> adjacent) {
        Intrinsics.checkNotNullParameter(start, "start");
        Intrinsics.checkNotNullParameter(adjacent, "adjacent");
        ArrayDeque<V> queue = new ArrayDeque<V>();
        Set traversed = new LinkedHashSet();
        Iterable<V> $this$forEach$iv = start;
        boolean $i$f$forEach = false;
        Iterator<V> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            V element$iv;
            V value2 = element$iv = iterator2.next();
            boolean bl = false;
            queue.add(value2);
        }
        return new Iterator<V>(queue, traversed, adjacent){
            final /* synthetic */ ArrayDeque<V> $queue;
            final /* synthetic */ Set<V> $traversed;
            final /* synthetic */ Function1<V, Iterable<V>> $adjacent;
            {
                this.$queue = $queue;
                this.$traversed = $traversed;
                this.$adjacent = $adjacent;
            }

            public boolean hasNext() {
                return this.$queue.size() > 0;
            }

            /*
             * WARNING - void declaration
             */
            public V next() {
                void $this$forEach$iv;
                V v = this.$queue.removeFirst();
                this.$traversed.add(v);
                Iterable<V> iterable = this.$adjacent.invoke(v);
                Set<V> set = this.$traversed;
                ArrayDeque<V> arrayDeque = this.$queue;
                boolean $i$f$forEach = false;
                Iterator<T> iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    T element$iv;
                    T w = element$iv = iterator2.next();
                    boolean bl = false;
                    if (set.contains(w)) continue;
                    arrayDeque.addLast(w);
                }
                return v;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final <V, E> List<V> shortestPath(@NotNull DirectedGraph<V, E> graph, @NotNull Iterable<? extends V> start, @NotNull Function1<? super V, Boolean> accept, @NotNull Function1<? super IEdge<V, E>, Double> cost) {
        Intrinsics.checkNotNullParameter(graph, "graph");
        Intrinsics.checkNotNullParameter(start, "start");
        Intrinsics.checkNotNullParameter(accept, "accept");
        Intrinsics.checkNotNullParameter(cost, "cost");
        originStates = new LinkedHashMap<K, V>();
        queue = new PriorityQueue<ShortestPathState<V>>(new Comparator(){

            public final int compare(T a, T b) {
                ShortestPathState it = (ShortestPathState)a;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getDistance());
                it = (ShortestPathState)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getDistance());
            }
        });
        for (V v : start) {
            if (!graph.vertices().contains(v)) continue;
            init = new ShortestPathState<V>(v);
            $this$getOrPut$iv = originStates;
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(v);
            if (value$iv == null) {
                $i$a$-getOrPut-Graphs$shortestPath$1 = false;
                answer$iv = new LinkedHashMap<K, V>();
                $this$getOrPut$iv.put(v, answer$iv);
                v0 /* !! */  = answer$iv;
            } else {
                v0 /* !! */  = value$iv;
            }
            ((Map)v0 /* !! */ ).put(v, init);
            queue.add(init);
        }
        curr = null;
        block1: while (true) {
            if ((curr = (ShortestPathState)queue.poll()) == null) {
                return null;
            }
            if ((Map)originStates.get(curr.getOrigin()) == null) {
                throw new IllegalStateException("no state".toString());
            }
            if (states.get(curr.getNode()) != curr) continue;
            if (curr.getPrev() != null && accept.invoke(curr.getNode()).booleanValue()) {
                return curr.path();
            }
            var9_9 = graph.out(curr.getNode()).iterator();
            while (true) {
                if (var9_9.hasNext()) ** break;
                continue block1;
                v = var9_9.next();
                edge = ((Number)cost.invoke(new Edge<V, E>(graph.edge(curr.getNode(), v), curr.getNode(), v))).doubleValue();
                if (!(edge >= 0.0)) {
                    $i$a$-require-Graphs$shortestPath$2 = false;
                    var14_17 = "negative edge weights are unsupported";
                    throw new IllegalArgumentException(var14_17.toString());
                }
                next = (ShortestPathState<V>)states.get(v);
                if (next == null) {
                    v1 = new ShortestPathState<V>(v, curr, edge);
                } else {
                    if (!(curr.getDistance() + edge < next.getDistance())) continue;
                    v1 = new ShortestPathState<V>(v, curr, edge);
                }
                next = v1;
                states.put(v, next);
                queue.add(next);
            }
            break;
        }
    }

    private static final Iterable cycles$lambda$2(DirectedGraph $subgraph, Object vertex) {
        Intrinsics.checkNotNullParameter($subgraph, "$subgraph");
        return $subgraph.out(vertex);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010 \n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005B'\b\u0016\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000e\u0010\fR\u0019\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lorg/openrndr/kartifex/utils/graphs/Graphs$ShortestPathState;", "V", "", "origin", "<init>", "(Ljava/lang/Object;)V", "node", "prev", "edge", "", "(Ljava/lang/Object;Lorg/openrndr/kartifex/utils/graphs/Graphs$ShortestPathState;D)V", "getOrigin", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getNode", "getPrev", "()Lorg/openrndr/kartifex/utils/graphs/Graphs$ShortestPathState;", "distance", "getDistance", "()D", "path", "", "openrndr-kartifex"})
    private static final class ShortestPathState<V> {
        private final V origin;
        private final V node;
        @Nullable
        private final ShortestPathState<V> prev;
        private final double distance;

        public final V getOrigin() {
            return this.origin;
        }

        public final V getNode() {
            return this.node;
        }

        @Nullable
        public final ShortestPathState<V> getPrev() {
            return this.prev;
        }

        public final double getDistance() {
            return this.distance;
        }

        public ShortestPathState(V origin2) {
            this.origin = origin2;
            this.prev = null;
            this.node = origin2;
            this.distance = 0.0;
        }

        public ShortestPathState(V node, @NotNull ShortestPathState<V> prev, double edge) {
            Intrinsics.checkNotNullParameter(prev, "prev");
            this.origin = prev.origin;
            this.node = node;
            this.prev = prev;
            this.distance = prev.distance + edge;
        }

        @NotNull
        public final List<V> path() {
            ArrayDeque<V> result2 = new ArrayDeque<V>();
            ShortestPathState<V> curr = this;
            while (true) {
                ShortestPathState<V> shortestPathState = curr;
                Intrinsics.checkNotNull(shortestPathState);
                result2.addFirst(shortestPathState.node);
                if (Intrinsics.areEqual(curr.node, curr.origin)) break;
                curr = curr.prev;
            }
            return result2;
        }
    }
}

