/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.ktessellation;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.ktessellation.ArrayUtilsKt;
import org.openrndr.ktessellation.PriorityQ;
import org.openrndr.ktessellation.PriorityQHeap;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 72\u00020\u0001:\u000267B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020$H\u0016J\u0012\u0010/\u001a\u00020\u001b2\b\u00100\u001a\u0004\u0018\u00010\u000eH\u0016J\n\u00101\u001a\u0004\u0018\u00010\u000eH\u0016J\n\u00102\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u00103\u001a\u00020$H\u0016J\u0010\u00104\u001a\u00020-2\u0006\u00105\u001a\u00020\u001bH\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR&\u0010\f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010\u0005\u00a8\u00068"}, d2={"Lorg/openrndr/ktessellation/PriorityQSort;", "Lorg/openrndr/ktessellation/PriorityQ;", "leq", "Lorg/openrndr/ktessellation/PriorityQ$Leq;", "<init>", "(Lorg/openrndr/ktessellation/PriorityQ$Leq;)V", "heap", "Lorg/openrndr/ktessellation/PriorityQHeap;", "getHeap", "()Lorg/openrndr/ktessellation/PriorityQHeap;", "setHeap", "(Lorg/openrndr/ktessellation/PriorityQHeap;)V", "keys", "", "", "getKeys", "()[Ljava/lang/Object;", "setKeys", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "order", "", "getOrder", "()[I", "setOrder", "([I)V", "size", "", "getSize", "()I", "setSize", "(I)V", "max", "getMax", "setMax", "initialized", "", "getInitialized", "()Z", "setInitialized", "(Z)V", "getLeq", "()Lorg/openrndr/ktessellation/PriorityQ$Leq;", "setLeq", "pqDeletePriorityQ", "", "pqInit", "pqInsert", "keyNew", "pqExtractMin", "pqMinimum", "pqIsEmpty", "pqDelete", "hCurr", "Stack", "Companion", "openrndr-ktessellation"})
public final class PriorityQSort
extends PriorityQ {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private PriorityQHeap heap;
    @Nullable
    private Object[] keys;
    @Nullable
    private int[] order;
    private int size;
    private int max;
    private boolean initialized;
    @NotNull
    private PriorityQ.Leq leq;

    public PriorityQSort(@NotNull PriorityQ.Leq leq) {
        Intrinsics.checkNotNullParameter(leq, "leq");
        this.heap = new PriorityQHeap(leq);
        this.keys = new Object[32];
        this.size = 0;
        this.max = 32;
        this.initialized = false;
        this.leq = leq;
    }

    @Nullable
    public final PriorityQHeap getHeap() {
        return this.heap;
    }

    public final void setHeap(@Nullable PriorityQHeap priorityQHeap) {
        this.heap = priorityQHeap;
    }

    @Nullable
    public final Object[] getKeys() {
        return this.keys;
    }

    public final void setKeys(@Nullable Object[] objectArray) {
        this.keys = objectArray;
    }

    @Nullable
    public final int[] getOrder() {
        return this.order;
    }

    public final void setOrder(@Nullable int[] nArray) {
        this.order = nArray;
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int n) {
        this.size = n;
    }

    public final int getMax() {
        return this.max;
    }

    public final void setMax(int n) {
        this.max = n;
    }

    public final boolean getInitialized() {
        return this.initialized;
    }

    public final void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    @NotNull
    public final PriorityQ.Leq getLeq() {
        return this.leq;
    }

    public final void setLeq(@NotNull PriorityQ.Leq leq) {
        Intrinsics.checkNotNullParameter(leq, "<set-?>");
        this.leq = leq;
    }

    @Override
    public void pqDeletePriorityQ() {
        if (this.heap != null) {
            PriorityQHeap priorityQHeap = this.heap;
            Intrinsics.checkNotNull(priorityQHeap);
            priorityQHeap.pqDeletePriorityQ();
        }
        this.order = null;
        this.keys = null;
    }

    @Override
    public boolean pqInit() {
        int p = 0;
        int r = 0;
        int i = 0;
        int j = 0;
        int piv = 0;
        Stack[] stack = new Stack[50];
        int n = stack.length;
        for (int k = 0; k < n; ++k) {
            stack[k] = new Stack();
        }
        int top = 0;
        int seed = 2016473283;
        this.order = new int[this.size + 1];
        p = 0;
        r = this.size - 1;
        piv = 0;
        for (i = p; i <= r; ++i) {
            Intrinsics.checkNotNull(this.order);
            this.order[i] = piv++;
        }
        Stack stack2 = stack[top];
        Intrinsics.checkNotNull(stack2);
        stack2.setP(p);
        Stack stack3 = stack[top];
        Intrinsics.checkNotNull(stack3);
        stack3.setR(r);
        ++top;
        while (--top >= 0) {
            Stack stack4 = stack[top];
            Intrinsics.checkNotNull(stack4);
            p = stack4.getP();
            Stack stack5 = stack[top];
            Intrinsics.checkNotNull(stack5);
            r = stack5.getR();
            while (r > p + 10) {
                seed = Math.abs(seed * 1539415821 + 1);
                i = p + seed % (r - p + 1);
                Intrinsics.checkNotNull(this.order);
                piv = this.order[i];
                Intrinsics.checkNotNull(this.order);
                Intrinsics.checkNotNull(this.order);
                this.order[i] = this.order[p];
                Intrinsics.checkNotNull(this.order);
                this.order[p] = piv;
                i = p - 1;
                j = r + 1;
                while (true) {
                    Object object;
                    Object object2;
                    Intrinsics.checkNotNull(this.keys);
                    Intrinsics.checkNotNull(this.order);
                    Object object3 = this.keys[this.order[++i]];
                    Intrinsics.checkNotNull(object3);
                    Intrinsics.checkNotNull(this.keys);
                    Object object4 = this.keys[piv];
                    Intrinsics.checkNotNull(object4);
                    if (PriorityQSort.Companion.GT(this.leq, object3, object4)) continue;
                    do {
                        Intrinsics.checkNotNull(this.keys);
                        Intrinsics.checkNotNull(this.order);
                        object2 = this.keys[this.order[--j]];
                        Intrinsics.checkNotNull(object2);
                        Intrinsics.checkNotNull(this.keys);
                        object = this.keys[piv];
                        Intrinsics.checkNotNull(object);
                    } while (PriorityQSort.Companion.LT(this.leq, object2, object));
                    Intrinsics.checkNotNull(this.order);
                    PriorityQSort.Companion.Swap(this.order, i, j);
                    if (i >= j) break;
                }
                Intrinsics.checkNotNull(this.order);
                PriorityQSort.Companion.Swap(this.order, i, j);
                if (i - p < r - j) {
                    Stack stack6 = stack[top];
                    Intrinsics.checkNotNull(stack6);
                    stack6.setP(j + 1);
                    Stack stack7 = stack[top];
                    Intrinsics.checkNotNull(stack7);
                    stack7.setR(r);
                    ++top;
                    r = i - 1;
                    continue;
                }
                Stack stack8 = stack[top];
                Intrinsics.checkNotNull(stack8);
                stack8.setP(p);
                Stack stack9 = stack[top];
                Intrinsics.checkNotNull(stack9);
                stack9.setR(i - 1);
                ++top;
                p = j + 1;
            }
            for (i = p + 1; i <= r; ++i) {
                Intrinsics.checkNotNull(this.order);
                piv = this.order[i];
                for (j = i; j > p; --j) {
                    Intrinsics.checkNotNull(this.keys);
                    Intrinsics.checkNotNull(this.order);
                    Object object = this.keys[this.order[j - 1]];
                    Intrinsics.checkNotNull(object);
                    Intrinsics.checkNotNull(this.keys);
                    Object object5 = this.keys[piv];
                    Intrinsics.checkNotNull(object5);
                    if (!PriorityQSort.Companion.LT(this.leq, object, object5)) break;
                    Intrinsics.checkNotNull(this.order);
                    Intrinsics.checkNotNull(this.order);
                    this.order[j] = this.order[j - 1];
                }
                Intrinsics.checkNotNull(this.order);
                this.order[j] = piv;
            }
        }
        this.max = this.size;
        this.initialized = true;
        PriorityQHeap priorityQHeap = this.heap;
        Intrinsics.checkNotNull(priorityQHeap);
        priorityQHeap.pqInit();
        return true;
    }

    @Override
    public int pqInsert(@Nullable Object keyNew) {
        int curr = 0;
        if (this.initialized) {
            PriorityQHeap priorityQHeap = this.heap;
            Intrinsics.checkNotNull(priorityQHeap);
            return priorityQHeap.pqInsert(keyNew);
        }
        curr = this.size++;
        if (this.size >= this.max) {
            Object[] saveKey = this.keys;
            this.max <<= 1;
            Object[] pqKeys = new Object[this.max];
            Intrinsics.checkNotNull(this.keys);
            Intrinsics.checkNotNull(this.keys);
            ArrayUtilsKt.arraycopy(this.keys, 0, pqKeys, 0, this.keys.length);
            this.keys = pqKeys;
            if (this.keys == null) {
                this.keys = saveKey;
                return Integer.MAX_VALUE;
            }
        }
        if (!(curr != Integer.MAX_VALUE)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull(this.keys);
        this.keys[curr] = keyNew;
        return -(curr + 1);
    }

    @Override
    @Nullable
    public Object pqExtractMin() {
        Object sortMin = null;
        Object heapMin = null;
        if (this.size == 0) {
            PriorityQHeap priorityQHeap = this.heap;
            Intrinsics.checkNotNull(priorityQHeap);
            return priorityQHeap.pqExtractMin();
        }
        Intrinsics.checkNotNull(this.keys);
        Intrinsics.checkNotNull(this.order);
        Object object = this.keys[this.order[this.size - 1]];
        Intrinsics.checkNotNull(object);
        sortMin = object;
        PriorityQHeap priorityQHeap = this.heap;
        Intrinsics.checkNotNull(priorityQHeap);
        if (!priorityQHeap.pqIsEmpty()) {
            PriorityQHeap priorityQHeap2 = this.heap;
            Intrinsics.checkNotNull(priorityQHeap2);
            Object object2 = heapMin = priorityQHeap2.pqMinimum();
            Intrinsics.checkNotNull(object2);
            if (PriorityQ.Companion.LEQ(this.leq, object2, sortMin)) {
                PriorityQHeap priorityQHeap3 = this.heap;
                Intrinsics.checkNotNull(priorityQHeap3);
                return priorityQHeap3.pqExtractMin();
            }
        }
        do {
            this.size += -1;
            if (this.size <= 0) break;
            Intrinsics.checkNotNull(this.keys);
            Intrinsics.checkNotNull(this.order);
        } while (this.keys[this.order[this.size - 1]] == null);
        return sortMin;
    }

    @Override
    @Nullable
    public Object pqMinimum() {
        Object sortMin = null;
        Object heapMin = null;
        if (this.size == 0) {
            PriorityQHeap priorityQHeap = this.heap;
            Intrinsics.checkNotNull(priorityQHeap);
            return priorityQHeap.pqMinimum();
        }
        Intrinsics.checkNotNull(this.keys);
        Intrinsics.checkNotNull(this.order);
        Object object = this.keys[this.order[this.size - 1]];
        Intrinsics.checkNotNull(object);
        sortMin = object;
        PriorityQHeap priorityQHeap = this.heap;
        Intrinsics.checkNotNull(priorityQHeap);
        if (!priorityQHeap.pqIsEmpty()) {
            PriorityQHeap priorityQHeap2 = this.heap;
            Intrinsics.checkNotNull(priorityQHeap2);
            Object object2 = heapMin = priorityQHeap2.pqMinimum();
            Intrinsics.checkNotNull(object2);
            if (PriorityQ.Companion.LEQ(this.leq, object2, sortMin)) {
                return heapMin;
            }
        }
        return sortMin;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean pqIsEmpty() {
        if (this.size != 0) return false;
        PriorityQHeap priorityQHeap = this.heap;
        Intrinsics.checkNotNull(priorityQHeap);
        if (!priorityQHeap.pqIsEmpty()) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void pqDelete(int hCurr) {
        curr = hCurr;
        if (curr >= 0) {
            v0 = this.heap;
            Intrinsics.checkNotNull(v0);
            v0.pqDelete(curr);
            return;
        }
        if ((curr = -(curr + 1)) >= this.max) ** GOTO lbl-1000
        Intrinsics.checkNotNull(this.keys);
        if (this.keys[curr] != null) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        if (!v1) {
            var3_3 = "Failed requirement.";
            throw new IllegalArgumentException(var3_3.toString());
        }
        Intrinsics.checkNotNull(this.keys);
        this.keys[curr] = null;
        while (this.size > 0) {
            Intrinsics.checkNotNull(this.keys);
            Intrinsics.checkNotNull(this.order);
            if (this.keys[this.order[this.size - 1]] != null) break;
            this.size += -1;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0002J \u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/openrndr/ktessellation/PriorityQSort$Companion;", "", "<init>", "()V", "LT", "", "leq", "Lorg/openrndr/ktessellation/PriorityQ$Leq;", "x", "y", "GT", "Swap", "", "array", "", "a", "", "b", "openrndr-ktessellation"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean LT(PriorityQ.Leq leq, Object x, Object y) {
            return !PriorityQ.Companion.LEQ(leq, y, x);
        }

        private final boolean GT(PriorityQ.Leq leq, Object x, Object y) {
            return !PriorityQ.Companion.LEQ(leq, x, y);
        }

        private final void Swap(int[] array, int a, int b) {
            int tmp = array[a];
            array[a] = array[b];
            array[b] = tmp;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lorg/openrndr/ktessellation/PriorityQSort$Stack;", "", "<init>", "()V", "p", "", "getP", "()I", "setP", "(I)V", "r", "getR", "setR", "openrndr-ktessellation"})
    private static final class Stack {
        private int p;
        private int r;

        public final int getP() {
            return this.p;
        }

        public final void setP(int n) {
            this.p = n;
        }

        public final int getR() {
            return this.r;
        }

        public final void setR(int n) {
            this.r = n;
        }
    }
}

