/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.LinearType;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a&\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0001\u001a&\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0001\u001a&\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\r\u001a.\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0001\u001a.\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0001\u001a.\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0001\u001a&\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0001\u001a&\u0010\u0000\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0001\u001a&\u0010\u0000\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0001\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a.\u0010\u0000\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0001\u001a.\u0010\u0000\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0001\u001a;\u0010\u0000\u001a\u0002H\u0013\"\u000e\b\u0000\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00130\u00142\u0006\u0010\u0002\u001a\u0002H\u00132\u0006\u0010\u0003\u001a\u0002H\u00132\u0006\u0010\u0004\u001a\u0002H\u00132\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0015\u001aC\u0010\u0000\u001a\u0002H\u0013\"\u000e\b\u0000\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00130\u00142\u0006\u0010\u0002\u001a\u0002H\u00132\u0006\u0010\u0003\u001a\u0002H\u00132\u0006\u0010\u0012\u001a\u0002H\u00132\u0006\u0010\u0004\u001a\u0002H\u00132\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"bezier", "", "x0", "c0", "x1", "t", "derivative", "Lorg/openrndr/math/Vector2;", "safeDerivative", "p0", "p1", "Lorg/openrndr/math/Vector3;", "roots", "", "p", "p2", "p3", "normal", "c1", "T", "Lorg/openrndr/math/LinearType;", "(Lorg/openrndr/math/LinearType;Lorg/openrndr/math/LinearType;Lorg/openrndr/math/LinearType;D)Lorg/openrndr/math/LinearType;", "(Lorg/openrndr/math/LinearType;Lorg/openrndr/math/LinearType;Lorg/openrndr/math/LinearType;Lorg/openrndr/math/LinearType;D)Lorg/openrndr/math/LinearType;", "openrndr-math"})
public final class BezierKt {
    public static final double bezier(double x0, double c0, double x1, double t) {
        double it = 1.0 - t;
        double it2 = it * it;
        double t2 = t * t;
        return it2 * x0 + 2.0 * it * t * c0 + t2 * x1;
    }

    public static final double derivative(double x0, double c0, double x1, double t) {
        double it = 1.0 - t;
        return 2.0 * it * (c0 - x0) + 2.0 * t * (x1 - c0);
    }

    @NotNull
    public static final Vector2 derivative(@NotNull Vector2 x0, @NotNull Vector2 c0, @NotNull Vector2 x1, double t) {
        Intrinsics.checkNotNullParameter(x0, "x0");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(x1, "x1");
        double it = 1.0 - t;
        return new Vector2((double)2 * it * (c0.x() - x0.x()) + (double)2 * t * (x1.x() - c0.x()), (double)2 * it * (c0.y() - x0.y()) + (double)2 * t * (x1.y() - c0.y()));
    }

    @NotNull
    public static final Vector2 safeDerivative(@NotNull Vector2 p0, @NotNull Vector2 c0, @NotNull Vector2 p1, double t) {
        Intrinsics.checkNotNullParameter(p0, "p0");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(p1, "p1");
        double epsilon = 1.0E-5;
        double u = t;
        Vector2 d10 = c0.minus(p0);
        Vector2 d21 = c0.minus(p1);
        if (u < epsilon && d10.squaredLength() < epsilon) {
            u = epsilon;
        }
        if (u > 1.0 - epsilon && d21.squaredLength() < epsilon) {
            u = 1.0 - epsilon;
        }
        double iu = 1.0 - u;
        return new Vector2((double)2 * iu * (c0.x() - p0.x()) + (double)2 * u * (p1.x() - c0.x()), (double)2 * iu * (c0.y() - p0.y()) + (double)2 * u * (p1.y() - c0.y()));
    }

    @NotNull
    public static final Vector3 derivative(@NotNull Vector3 x0, @NotNull Vector3 c0, @NotNull Vector3 x1, double t) {
        Intrinsics.checkNotNullParameter(x0, "x0");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(x1, "x1");
        double it = 1.0 - t;
        return new Vector3((double)2 * it * (c0.x() - x0.x()) + (double)2 * t * (x1.x() - c0.x()), (double)2 * it * (c0.y() - x0.y()) + (double)2 * t * (x1.y() - c0.y()), (double)2 * it * (c0.z() - x0.z()) + (double)2 * t * (x1.z() - c0.z()));
    }

    @NotNull
    public static final List<Double> roots(@NotNull List<Double> p) {
        Intrinsics.checkNotNullParameter(p, "p");
        if (p.size() == 3) {
            double c2;
            double b;
            double a = ((Number)p.get(0)).doubleValue();
            double d = a - (double)2 * (b = ((Number)p.get(1)).doubleValue()) + (c2 = ((Number)p.get(2)).doubleValue());
            if (!(d == 0.0)) {
                double m1 = -Math.sqrt(b * b - a * c2);
                double m2 = -a + b;
                double v1 = -(m1 + m2) / d;
                double v2 = -(-m1 + m2) / d;
                Double[] doubleArray = new Double[]{v1, v2};
                return CollectionsKt.listOf(doubleArray);
            }
            if (!(b == c2) && d == 0.0) {
                return CollectionsKt.listOf((double)2 * b * c2 / ((double)2 * (b - c2)));
            }
            return CollectionsKt.emptyList();
        }
        if (p.size() == 2) {
            double b;
            double a = ((Number)p.get(0)).doubleValue();
            return !(a == (b = ((Number)p.get(1)).doubleValue())) ? CollectionsKt.listOf(a / (a - b)) : CollectionsKt.emptyList();
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public static final Vector3 derivative(@NotNull Vector3 p0, @NotNull Vector3 p1, @NotNull Vector3 p2, @NotNull Vector3 p3, double t) {
        Intrinsics.checkNotNullParameter(p0, "p0");
        Intrinsics.checkNotNullParameter(p1, "p1");
        Intrinsics.checkNotNullParameter(p2, "p2");
        Intrinsics.checkNotNullParameter(p3, "p3");
        double it = 1.0 - t;
        return p1.minus(p0).times(3.0 * it * it).plus(p2.minus(p1).times(6.0 * it * t)).plus(p3.minus(p2).times(3.0 * t * t));
    }

    @NotNull
    public static final Vector2 derivative(@NotNull Vector2 p0, @NotNull Vector2 p1, @NotNull Vector2 p2, @NotNull Vector2 p3, double t) {
        Intrinsics.checkNotNullParameter(p0, "p0");
        Intrinsics.checkNotNullParameter(p1, "p1");
        Intrinsics.checkNotNullParameter(p2, "p2");
        Intrinsics.checkNotNullParameter(p3, "p3");
        double it = 1.0 - t;
        return p1.minus(p0).times(3.0 * it * it).plus(p2.minus(p1).times(6.0 * it * t)).plus(p3.minus(p2).times(3.0 * t * t));
    }

    @NotNull
    public static final Vector2 safeDerivative(@NotNull Vector2 p0, @NotNull Vector2 p1, @NotNull Vector2 p2, @NotNull Vector2 p3, double t) {
        Intrinsics.checkNotNullParameter(p0, "p0");
        Intrinsics.checkNotNullParameter(p1, "p1");
        Intrinsics.checkNotNullParameter(p2, "p2");
        Intrinsics.checkNotNullParameter(p3, "p3");
        double epsilon = 1.0E-5;
        double u = t;
        Vector2 d10 = p1.minus(p0);
        Vector2 d32 = p3.minus(p2);
        if (u < epsilon && d10.squaredLength() < epsilon) {
            u = epsilon;
        }
        if (u > 1.0 - epsilon && d32.squaredLength() < epsilon) {
            u = 1.0 - epsilon;
        }
        double iu = 1.0 - u;
        return d10.times(3.0 * iu * iu).plus(p2.minus(p1).times(6.0 * iu * u)).plus(d32.times(3.0 * u * u));
    }

    @NotNull
    public static final Vector2 normal(@NotNull Vector2 x0, @NotNull Vector2 c0, @NotNull Vector2 x1, double t) {
        Intrinsics.checkNotNullParameter(x0, "x0");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(x1, "x1");
        Vector2 vector2 = BezierKt.derivative(x0, c0, x1, t);
        double x = vector2.component1();
        double y = vector2.component2();
        return (Vector2)new Vector2(-y, x).getNormalized();
    }

    @NotNull
    public static final Vector2 bezier(@NotNull Vector2 x0, @NotNull Vector2 c0, @NotNull Vector2 x1, double t) {
        Intrinsics.checkNotNullParameter(x0, "x0");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(x1, "x1");
        double it = 1.0 - t;
        double it2 = it * it;
        double t2 = t * t;
        return new Vector2(it2 * x0.x() + (double)2 * it * t * c0.x() + t2 * x1.x(), it2 * x0.y() + (double)2 * it * t * c0.y() + t2 * x1.y());
    }

    @NotNull
    public static final Vector3 bezier(@NotNull Vector3 x0, @NotNull Vector3 c0, @NotNull Vector3 x1, double t) {
        Intrinsics.checkNotNullParameter(x0, "x0");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(x1, "x1");
        double it = 1.0 - t;
        double it2 = it * it;
        double t2 = t * t;
        return new Vector3(it2 * x0.x() + (double)2 * it * t * c0.x() + t2 * x1.x(), it2 * x0.y() + (double)2 * it * t * c0.y() + t2 * x1.y(), it2 * x0.z() + (double)2 * it * t * c0.z() + t2 * x1.z());
    }

    public static final double bezier(double x0, double c0, double c1, double x1, double t) {
        double it = 1.0 - t;
        double it2 = it * it;
        double it3 = it2 * it;
        double t2 = t * t;
        double t3 = t2 * t;
        return it3 * x0 + 3.0 * it2 * t * c0 + 3.0 * it * t2 * c1 + t3 * x1;
    }

    @NotNull
    public static final Vector2 bezier(@NotNull Vector2 x0, @NotNull Vector2 c0, @NotNull Vector2 c1, @NotNull Vector2 x1, double t) {
        Intrinsics.checkNotNullParameter(x0, "x0");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(c1, "c1");
        Intrinsics.checkNotNullParameter(x1, "x1");
        double it = 1.0 - t;
        double it2 = it * it;
        double it3 = it2 * it;
        double t2 = t * t;
        double t3 = t2 * t;
        return new Vector2(it3 * x0.x() + (double)3 * it2 * t * c0.x() + (double)3 * it * t2 * c1.x() + t3 * x1.x(), it3 * x0.y() + (double)3 * it2 * t * c0.y() + (double)3 * it * t2 * c1.y() + t3 * x1.y());
    }

    @NotNull
    public static final Vector3 bezier(@NotNull Vector3 x0, @NotNull Vector3 c0, @NotNull Vector3 c1, @NotNull Vector3 x1, double t) {
        Intrinsics.checkNotNullParameter(x0, "x0");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(c1, "c1");
        Intrinsics.checkNotNullParameter(x1, "x1");
        double it = 1.0 - t;
        double it2 = it * it;
        double it3 = it2 * it;
        double t2 = t * t;
        double t3 = t2 * t;
        return new Vector3(it3 * x0.x() + (double)3 * it2 * t * c0.x() + (double)3 * it * t2 * c1.x() + t3 * x1.x(), it3 * x0.y() + (double)3 * it2 * t * c0.y() + (double)3 * it * t2 * c1.y() + t3 * x1.y(), it3 * x0.z() + (double)3 * it2 * t * c0.z() + (double)3 * it * t2 * c1.z() + t3 * x1.z());
    }

    @NotNull
    public static final <T extends LinearType<T>> T bezier(@NotNull T x0, @NotNull T c0, @NotNull T x1, double t) {
        Intrinsics.checkNotNullParameter(x0, "x0");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(x1, "x1");
        double it = 1.0 - t;
        double it2 = it * it;
        double t2 = t * t;
        return x0.times(it2).plus(c0.times(2.0 * it * t)).plus(x1.times(t2));
    }

    @NotNull
    public static final <T extends LinearType<T>> T bezier(@NotNull T x0, @NotNull T c0, @NotNull T c1, @NotNull T x1, double t) {
        Intrinsics.checkNotNullParameter(x0, "x0");
        Intrinsics.checkNotNullParameter(c0, "c0");
        Intrinsics.checkNotNullParameter(c1, "c1");
        Intrinsics.checkNotNullParameter(x1, "x1");
        double it = 1.0 - t;
        double it2 = it * it;
        double it3 = it2 * it;
        double t2 = t * t;
        double t3 = t2 * t;
        return x0.times(it3).plus(c0.times((double)3 * it2 * t)).plus(c1.times((double)3 * it * t2)).plus(x1.times(t3));
    }
}

