/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.IntVector2;
import org.openrndr.math.IntVector3;
import org.openrndr.math.IntVector4;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\u0007\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u0016\u0010\u0000\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0000\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0005\u001a\u0016\u0010\u0000\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0006\u001a\u0019\u0010\u0007\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0007\u00a2\u0006\u0002\b\b\u001a\u0019\u0010\u0007\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\b\t\u001a\u0019\u0010\u0007\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\n\u001a\u0019\u0010\u0007\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\b\u000b\u001a\u0012\u0010\u0000\u001a\u00020\f*\u00020\f2\u0006\u0010\u0003\u001a\u00020\f\u001a\u0012\u0010\u0000\u001a\u00020\r*\u00020\r2\u0006\u0010\u0003\u001a\u00020\r\u001a\u0012\u0010\u0000\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u000e\u001a\u0012\u0010\u0000\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u000f\u001a\u0012\u0010\u0000\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0010\u001a\u0012\u0010\u0000\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0011\u001a\u001e\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001\u001a\u001e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004\u001a!\u0010\u0012\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001H\u0007\u00a2\u0006\u0002\b\u0016\u001a!\u0010\u0012\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\b\u0017\u001a\u001a\u0010\u0012\u001a\u00020\f*\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f\u001a\u001a\u0010\u0012\u001a\u00020\r*\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r\u001a\u001a\u0010\u0012\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e\u001a\u001a\u0010\u0012\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f\u001a\u001a\u0010\u0012\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010\u001a\u001a\u0010\u0012\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011\"\u0016\u0010\u0018\u001a\u00020\u0001*\u00020\u00018\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\"\u0016\u0010\u001b\u001a\u00020\u0001*\u00020\u00018\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001a\"\u0015\u0010\u001d\u001a\u00020\u0004*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\"\u000e\u0010 \u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010!\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\"\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"mod", "", "a", "b", "", "", "", "mod_", "modDouble", "modInt", "modFloat", "modLong", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/math/Vector3;", "Lorg/openrndr/math/Vector4;", "Lorg/openrndr/math/IntVector2;", "Lorg/openrndr/math/IntVector3;", "Lorg/openrndr/math/IntVector4;", "clamp", "value", "min", "max", "doubleClamp", "intClamp", "asRadians", "getAsRadians", "(D)D", "asDegrees", "getAsDegrees", "asExponent", "getAsExponent", "(D)I", "EXP_BIT_MASK", "SIGNIFICAND_WIDTH", "EXP_BIAS", "openrndr-math"})
public final class FunctionsKt {
    private static final long EXP_BIT_MASK = 0x7FF0000000000000L;
    private static final int SIGNIFICAND_WIDTH = 53;
    private static final int EXP_BIAS = 1023;

    public static final double mod(double a, double b) {
        return (a % b + b) % b;
    }

    public static final int mod(int a, int b) {
        return (a % b + b) % b;
    }

    public static final float mod(float a, float b) {
        return (a % b + b) % b;
    }

    public static final long mod(long a, long b) {
        return (a % b + b) % b;
    }

    @Deprecated(message="deprecated", replaceWith=@ReplaceWith(expression="mod", imports={}))
    @JvmName(name="modDouble")
    public static final double modDouble(double $this$mod_, double b) {
        return FunctionsKt.mod($this$mod_, b);
    }

    @Deprecated(message="deprecated", replaceWith=@ReplaceWith(expression="mod", imports={}))
    @JvmName(name="modInt")
    public static final int modInt(int $this$mod_, int b) {
        return FunctionsKt.mod($this$mod_, b);
    }

    @Deprecated(message="deprecated", replaceWith=@ReplaceWith(expression="mod", imports={}))
    @JvmName(name="modFloat")
    public static final float modFloat(float $this$mod_, float b) {
        return FunctionsKt.mod($this$mod_, b);
    }

    @Deprecated(message="deprecated", replaceWith=@ReplaceWith(expression="mod", imports={}))
    @JvmName(name="modLong")
    public static final long modLong(long $this$mod_, long b) {
        return FunctionsKt.mod($this$mod_, b);
    }

    @NotNull
    public static final Vector2 mod(@NotNull Vector2 $this$mod, @NotNull Vector2 b) {
        Intrinsics.checkNotNullParameter($this$mod, "<this>");
        Intrinsics.checkNotNullParameter(b, "b");
        double d = $this$mod.x();
        double d2 = b.x();
        double d3 = d % d2;
        double d4 = !(d3 == 0.0) && !(Math.signum(d3) == Math.signum(d2)) ? d3 + d2 : d3;
        d = $this$mod.y();
        d2 = b.y();
        d3 = d % d2;
        return new Vector2(d4, !(d3 == 0.0) && !(Math.signum(d3) == Math.signum(d2)) ? d3 + d2 : d3);
    }

    @NotNull
    public static final Vector3 mod(@NotNull Vector3 $this$mod, @NotNull Vector3 b) {
        Intrinsics.checkNotNullParameter($this$mod, "<this>");
        Intrinsics.checkNotNullParameter(b, "b");
        double d = $this$mod.x();
        double d2 = b.x();
        double d3 = d % d2;
        double d4 = !(d3 == 0.0) && !(Math.signum(d3) == Math.signum(d2)) ? d3 + d2 : d3;
        d = $this$mod.y();
        d2 = b.y();
        d3 = d % d2;
        double d5 = !(d3 == 0.0) && !(Math.signum(d3) == Math.signum(d2)) ? d3 + d2 : d3;
        d = $this$mod.z();
        d2 = b.z();
        d3 = d % d2;
        return new Vector3(d4, d5, !(d3 == 0.0) && !(Math.signum(d3) == Math.signum(d2)) ? d3 + d2 : d3);
    }

    @NotNull
    public static final Vector4 mod(@NotNull Vector4 $this$mod, @NotNull Vector4 b) {
        Intrinsics.checkNotNullParameter($this$mod, "<this>");
        Intrinsics.checkNotNullParameter(b, "b");
        double d = $this$mod.x();
        double d2 = b.x();
        double d3 = d % d2;
        double d4 = !(d3 == 0.0) && !(Math.signum(d3) == Math.signum(d2)) ? d3 + d2 : d3;
        d = $this$mod.y();
        d2 = b.y();
        d3 = d % d2;
        double d5 = !(d3 == 0.0) && !(Math.signum(d3) == Math.signum(d2)) ? d3 + d2 : d3;
        d = $this$mod.z();
        d2 = b.z();
        d3 = d % d2;
        double d6 = !(d3 == 0.0) && !(Math.signum(d3) == Math.signum(d2)) ? d3 + d2 : d3;
        d = $this$mod.w();
        d2 = b.w();
        d3 = d % d2;
        return new Vector4(d4, d5, d6, !(d3 == 0.0) && !(Math.signum(d3) == Math.signum(d2)) ? d3 + d2 : d3);
    }

    @NotNull
    public static final IntVector2 mod(@NotNull IntVector2 $this$mod, @NotNull IntVector2 b) {
        Intrinsics.checkNotNullParameter($this$mod, "<this>");
        Intrinsics.checkNotNullParameter(b, "b");
        int n = $this$mod.x();
        int n2 = b.x();
        int n3 = n % n2;
        int n4 = n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31);
        n = $this$mod.y();
        n2 = b.y();
        n3 = n % n2;
        return new IntVector2(n4, n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31));
    }

    @NotNull
    public static final IntVector3 mod(@NotNull IntVector3 $this$mod, @NotNull IntVector3 b) {
        Intrinsics.checkNotNullParameter($this$mod, "<this>");
        Intrinsics.checkNotNullParameter(b, "b");
        int n = $this$mod.x();
        int n2 = b.x();
        int n3 = n % n2;
        int n4 = n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31);
        n = $this$mod.y();
        n2 = b.y();
        n3 = n % n2;
        int n5 = n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31);
        n = $this$mod.z();
        n2 = b.z();
        n3 = n % n2;
        return new IntVector3(n4, n5, n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31));
    }

    @NotNull
    public static final IntVector4 mod(@NotNull IntVector4 $this$mod, @NotNull IntVector4 b) {
        Intrinsics.checkNotNullParameter($this$mod, "<this>");
        Intrinsics.checkNotNullParameter(b, "b");
        int n = $this$mod.x();
        int n2 = b.x();
        int n3 = n % n2;
        int n4 = n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31);
        n = $this$mod.y();
        n2 = b.y();
        n3 = n % n2;
        int n5 = n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31);
        n = $this$mod.z();
        n2 = b.z();
        n3 = n % n2;
        int n6 = n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31);
        n = $this$mod.w();
        n2 = b.w();
        n3 = n % n2;
        return new IntVector4(n4, n5, n6, n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31));
    }

    public static final double clamp(double value2, double min, double max) {
        return Math.max(min, Math.min(max, value2));
    }

    public static final int clamp(int value2, int min, int max) {
        return Math.max(min, Math.min(max, value2));
    }

    @JvmName(name="doubleClamp")
    public static final double doubleClamp(double $this$clamp, double min, double max) {
        return FunctionsKt.clamp($this$clamp, min, max);
    }

    @JvmName(name="intClamp")
    public static final int intClamp(int $this$clamp, int min, int max) {
        return FunctionsKt.clamp($this$clamp, min, max);
    }

    @NotNull
    public static final Vector2 clamp(@NotNull Vector2 $this$clamp, @NotNull Vector2 min, @NotNull Vector2 max) {
        Intrinsics.checkNotNullParameter($this$clamp, "<this>");
        Intrinsics.checkNotNullParameter(min, "min");
        Intrinsics.checkNotNullParameter(max, "max");
        return new Vector2(FunctionsKt.doubleClamp($this$clamp.x(), min.x(), max.x()), FunctionsKt.doubleClamp($this$clamp.y(), min.y(), max.y()));
    }

    @NotNull
    public static final Vector3 clamp(@NotNull Vector3 $this$clamp, @NotNull Vector3 min, @NotNull Vector3 max) {
        Intrinsics.checkNotNullParameter($this$clamp, "<this>");
        Intrinsics.checkNotNullParameter(min, "min");
        Intrinsics.checkNotNullParameter(max, "max");
        return new Vector3(FunctionsKt.doubleClamp($this$clamp.x(), min.x(), max.x()), FunctionsKt.doubleClamp($this$clamp.y(), min.y(), max.y()), FunctionsKt.doubleClamp($this$clamp.z(), min.y(), max.z()));
    }

    @NotNull
    public static final Vector4 clamp(@NotNull Vector4 $this$clamp, @NotNull Vector4 min, @NotNull Vector4 max) {
        Intrinsics.checkNotNullParameter($this$clamp, "<this>");
        Intrinsics.checkNotNullParameter(min, "min");
        Intrinsics.checkNotNullParameter(max, "max");
        return new Vector4(FunctionsKt.doubleClamp($this$clamp.x(), min.x(), max.x()), FunctionsKt.doubleClamp($this$clamp.y(), min.y(), max.y()), FunctionsKt.doubleClamp($this$clamp.z(), min.z(), max.z()), FunctionsKt.doubleClamp($this$clamp.w(), min.w(), max.w()));
    }

    @NotNull
    public static final IntVector2 clamp(@NotNull IntVector2 $this$clamp, @NotNull IntVector2 min, @NotNull IntVector2 max) {
        Intrinsics.checkNotNullParameter($this$clamp, "<this>");
        Intrinsics.checkNotNullParameter(min, "min");
        Intrinsics.checkNotNullParameter(max, "max");
        return new IntVector2(FunctionsKt.intClamp($this$clamp.x(), min.x(), max.x()), FunctionsKt.intClamp($this$clamp.y(), min.y(), max.y()));
    }

    @NotNull
    public static final IntVector3 clamp(@NotNull IntVector3 $this$clamp, @NotNull IntVector3 min, @NotNull IntVector3 max) {
        Intrinsics.checkNotNullParameter($this$clamp, "<this>");
        Intrinsics.checkNotNullParameter(min, "min");
        Intrinsics.checkNotNullParameter(max, "max");
        return new IntVector3(FunctionsKt.intClamp($this$clamp.x(), min.x(), max.x()), FunctionsKt.intClamp($this$clamp.y(), min.y(), max.y()), FunctionsKt.intClamp($this$clamp.z(), min.y(), max.z()));
    }

    @NotNull
    public static final IntVector4 clamp(@NotNull IntVector4 $this$clamp, @NotNull IntVector4 min, @NotNull IntVector4 max) {
        Intrinsics.checkNotNullParameter($this$clamp, "<this>");
        Intrinsics.checkNotNullParameter(min, "min");
        Intrinsics.checkNotNullParameter(max, "max");
        return new IntVector4(FunctionsKt.intClamp($this$clamp.x(), min.x(), max.x()), FunctionsKt.intClamp($this$clamp.y(), min.y(), max.y()), FunctionsKt.intClamp($this$clamp.z(), min.z(), max.z()), FunctionsKt.intClamp($this$clamp.w(), min.w(), max.w()));
    }

    public static final double getAsRadians(double $this$asRadians) {
        boolean $i$f$getAsRadians = false;
        return $this$asRadians * (Math.PI / 180);
    }

    public static final double getAsDegrees(double $this$asDegrees) {
        boolean $i$f$getAsDegrees = false;
        return $this$asDegrees * 57.29577951308232;
    }

    public static final int getAsExponent(double $this$asExponent) {
        return (int)(((Double.doubleToRawLongBits($this$asExponent) & 0x7FF0000000000000L) >> 52) - (long)1023);
    }
}

