/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.IntVector2$;
import org.openrndr.math.Vector2;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 12\u00020\u0001:\u000212B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B+\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0005\u0010\nJ\u0011\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003H\u0086\u0002J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020\u0003H\u00d6\u0001J\t\u0010'\u001a\u00020(H\u00d6\u0001J%\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0001\u00a2\u0006\u0002\b0R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0012\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0015\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001e\u00a8\u00063"}, d2={"Lorg/openrndr/math/IntVector2;", "Ljava/lang/Record;", "x", "", "y", "<init>", "(II)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IIILkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()I", "length", "", "()D", "squaredLength", "dot", "right", "yx", "()Lorg/openrndr/math/IntVector2;", "xx", "yy", "plus", "v", "minus", "times", "d", "div", "vector2", "Lorg/openrndr/math/Vector2;", "()Lorg/openrndr/math/Vector2;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_math", "Companion", "$serializer", "openrndr-math"})
public final class IntVector2
extends Record {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int x;
    private final int y;
    @NotNull
    private static final IntVector2 ZERO = new IntVector2(0, 0);
    @NotNull
    private static final IntVector2 ONE = new IntVector2(1, 1);
    @NotNull
    private static final IntVector2 UNIT_X = new IntVector2(1, 0);
    @NotNull
    private static final IntVector2 UNIT_Y = new IntVector2(0, 1);

    public IntVector2(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public final int x() {
        return this.x;
    }

    public final int y() {
        return this.y;
    }

    public final double length() {
        return Math.sqrt(1.0 * (double)this.x * (double)this.x + (double)(this.y * this.y));
    }

    public final int squaredLength() {
        return this.x * this.x + this.y * this.y;
    }

    public final int dot(@NotNull IntVector2 right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return this.x * right.x + this.y * right.y;
    }

    @NotNull
    public final IntVector2 yx() {
        return new IntVector2(this.y, this.x);
    }

    @NotNull
    public final IntVector2 xx() {
        return new IntVector2(this.x, this.x);
    }

    @NotNull
    public final IntVector2 yy() {
        return new IntVector2(this.y, this.y);
    }

    @NotNull
    public final IntVector2 plus(@NotNull IntVector2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new IntVector2(this.x + v.x, this.y + v.y);
    }

    @NotNull
    public final IntVector2 minus(@NotNull IntVector2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new IntVector2(this.x - v.x, this.y - v.y);
    }

    @NotNull
    public final IntVector2 times(int d) {
        return new IntVector2(this.x * d, this.y * d);
    }

    @NotNull
    public final IntVector2 div(int d) {
        return new IntVector2(this.x / d, this.y / d);
    }

    @NotNull
    public final Vector2 vector2() {
        return new Vector2(this.x, this.y);
    }

    public final int component1() {
        return this.x;
    }

    public final int component2() {
        return this.y;
    }

    @NotNull
    public final IntVector2 copy(int x, int y) {
        return new IntVector2(x, y);
    }

    public static /* synthetic */ IntVector2 copy$default(IntVector2 intVector2, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = intVector2.x;
        }
        if ((n3 & 2) != 0) {
            n2 = intVector2.y;
        }
        return intVector2.copy(n, n2);
    }

    @Override
    @NotNull
    public String toString() {
        return "IntVector2(x=" + this.x + ", y=" + this.y + ")";
    }

    @Override
    public int hashCode() {
        int result2 = Integer.hashCode(this.x);
        result2 = result2 * 31 + Integer.hashCode(this.y);
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IntVector2)) {
            return false;
        }
        IntVector2 intVector2 = (IntVector2)other;
        if (this.x != intVector2.x) {
            return false;
        }
        return this.y == intVector2.y;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_math(IntVector2 self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeIntElement(serialDesc, 0, self.x);
        output.encodeIntElement(serialDesc, 1, self.y);
    }

    public /* synthetic */ IntVector2(int seen0, int x, int y, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 3, $serializer.INSTANCE.getDescriptor());
        }
        this.x = x;
        this.y = y;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/openrndr/math/IntVector2$Companion;", "", "<init>", "()V", "ZERO", "Lorg/openrndr/math/IntVector2;", "getZERO", "()Lorg/openrndr/math/IntVector2;", "ONE", "getONE", "UNIT_X", "getUNIT_X", "UNIT_Y", "getUNIT_Y", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-math"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntVector2 getZERO() {
            return ZERO;
        }

        @NotNull
        public final IntVector2 getONE() {
            return ONE;
        }

        @NotNull
        public final IntVector2 getUNIT_X() {
            return UNIT_X;
        }

        @NotNull
        public final IntVector2 getUNIT_Y() {
            return UNIT_Y;
        }

        @NotNull
        public final KSerializer<IntVector2> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

