/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.IntVector2;
import org.openrndr.math.IntVector3$;
import org.openrndr.math.Vector3;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 52\u00020\u0001:\u000256B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B3\b\u0010\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0006\u0010\u000bJ\u0011\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003H\u0086\u0002J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J'\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020\u0003H\u00d6\u0001J\t\u0010+\u001a\u00020,H\u00d6\u0001J%\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0001\u00a2\u0006\u0002\b4R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0017\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0015R\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!\u00a8\u00067"}, d2={"Lorg/openrndr/math/IntVector3;", "Ljava/lang/Record;", "x", "", "y", "z", "<init>", "(III)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IIIILkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()I", "length", "", "()D", "squaredLength", "dot", "right", "xy", "Lorg/openrndr/math/IntVector2;", "()Lorg/openrndr/math/IntVector2;", "yx", "xx", "yy", "plus", "v", "minus", "times", "d", "div", "vector3", "Lorg/openrndr/math/Vector3;", "()Lorg/openrndr/math/Vector3;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_math", "Companion", "$serializer", "openrndr-math"})
public final class IntVector3
extends Record {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int x;
    private final int y;
    private final int z;
    @NotNull
    private static final IntVector3 ZERO = new IntVector3(0, 0, 0);
    @NotNull
    private static final IntVector3 ONE = new IntVector3(1, 1, 1);
    @NotNull
    private static final IntVector3 UNIT_X = new IntVector3(1, 0, 0);
    @NotNull
    private static final IntVector3 UNIT_Y = new IntVector3(0, 1, 0);
    @NotNull
    private static final IntVector3 UNIT_Z = new IntVector3(0, 0, 1);

    public IntVector3(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final int x() {
        return this.x;
    }

    public final int y() {
        return this.y;
    }

    public final int z() {
        return this.z;
    }

    public final double length() {
        return Math.sqrt(1.0 * (double)this.x * (double)this.x + (double)(this.y * this.y) + (double)(this.z * this.z));
    }

    public final int squaredLength() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final int dot(@NotNull IntVector3 right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return this.x * right.x + this.y * right.y + this.z * right.z;
    }

    @NotNull
    public final IntVector2 xy() {
        return new IntVector2(this.x, this.y);
    }

    @NotNull
    public final IntVector2 yx() {
        return new IntVector2(this.y, this.x);
    }

    @NotNull
    public final IntVector2 xx() {
        return new IntVector2(this.x, this.x);
    }

    @NotNull
    public final IntVector2 yy() {
        return new IntVector2(this.y, this.y);
    }

    @NotNull
    public final IntVector3 plus(@NotNull IntVector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new IntVector3(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    @NotNull
    public final IntVector3 minus(@NotNull IntVector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new IntVector3(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    @NotNull
    public final IntVector3 times(int d) {
        return new IntVector3(this.x * d, this.y * d, this.z * d);
    }

    @NotNull
    public final IntVector3 div(int d) {
        return new IntVector3(this.x / d, this.y / d, this.z / d);
    }

    @NotNull
    public final Vector3 vector3() {
        return new Vector3(this.x, this.y, this.z);
    }

    public final int component1() {
        return this.x;
    }

    public final int component2() {
        return this.y;
    }

    public final int component3() {
        return this.z;
    }

    @NotNull
    public final IntVector3 copy(int x, int y, int z) {
        return new IntVector3(x, y, z);
    }

    public static /* synthetic */ IntVector3 copy$default(IntVector3 intVector3, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = intVector3.x;
        }
        if ((n4 & 2) != 0) {
            n2 = intVector3.y;
        }
        if ((n4 & 4) != 0) {
            n3 = intVector3.z;
        }
        return intVector3.copy(n, n2, n3);
    }

    @Override
    @NotNull
    public String toString() {
        return "IntVector3(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ")";
    }

    @Override
    public int hashCode() {
        int result2 = Integer.hashCode(this.x);
        result2 = result2 * 31 + Integer.hashCode(this.y);
        result2 = result2 * 31 + Integer.hashCode(this.z);
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IntVector3)) {
            return false;
        }
        IntVector3 intVector3 = (IntVector3)other;
        if (this.x != intVector3.x) {
            return false;
        }
        if (this.y != intVector3.y) {
            return false;
        }
        return this.z == intVector3.z;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_math(IntVector3 self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeIntElement(serialDesc, 0, self.x);
        output.encodeIntElement(serialDesc, 1, self.y);
        output.encodeIntElement(serialDesc, 2, self.z);
    }

    public /* synthetic */ IntVector3(int seen0, int x, int y, int z, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 7, $serializer.INSTANCE.getDescriptor());
        }
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/openrndr/math/IntVector3$Companion;", "", "<init>", "()V", "ZERO", "Lorg/openrndr/math/IntVector3;", "getZERO", "()Lorg/openrndr/math/IntVector3;", "ONE", "getONE", "UNIT_X", "getUNIT_X", "UNIT_Y", "getUNIT_Y", "UNIT_Z", "getUNIT_Z", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-math"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntVector3 getZERO() {
            return ZERO;
        }

        @NotNull
        public final IntVector3 getONE() {
            return ONE;
        }

        @NotNull
        public final IntVector3 getUNIT_X() {
            return UNIT_X;
        }

        @NotNull
        public final IntVector3 getUNIT_Y() {
            return UNIT_Y;
        }

        @NotNull
        public final IntVector3 getUNIT_Z() {
            return UNIT_Z;
        }

        @NotNull
        public final KSerializer<IntVector3> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

