/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.FunctionsKt;
import org.openrndr.math.LinearType;
import org.openrndr.math.Polar$;
import org.openrndr.math.Vector2;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0002*+B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B+\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\u0006\u0010\u000e\u001a\u00020\u0000J\u0011\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0004H\u0096\u0002J\u0011\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0004H\u0096\u0002J\t\u0010\u0018\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0004H\u00c6\u0003J\u001d\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020\tH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001J%\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0001\u00a2\u0006\u0002\b)R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\rR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006,"}, d2={"Lorg/openrndr/math/Polar;", "Lorg/openrndr/math/LinearType;", "Ljava/lang/Record;", "theta", "", "radius", "<init>", "(DD)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IDDLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()D", "makeSafe", "cartesian", "Lorg/openrndr/math/Vector2;", "()Lorg/openrndr/math/Vector2;", "plus", "right", "minus", "times", "scale", "div", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_math", "Companion", "$serializer", "openrndr-math"})
public final class Polar
extends Record
implements LinearType<Polar> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double theta;
    private final double radius;

    public Polar(double theta, double radius) {
        this.theta = theta;
        this.radius = radius;
    }

    public /* synthetic */ Polar(double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d2 = 1.0;
        }
        this(d, d2);
    }

    public final double theta() {
        return this.theta;
    }

    public final double radius() {
        return this.radius;
    }

    @NotNull
    public final Polar makeSafe() {
        return new Polar(FunctionsKt.mod(this.theta, 360.0), this.radius);
    }

    @NotNull
    public final Vector2 cartesian() {
        return Vector2.Companion.fromPolar(this);
    }

    @Override
    @NotNull
    public Polar plus(@NotNull Polar right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Polar(this.theta + right.theta, this.radius + right.radius);
    }

    @Override
    @NotNull
    public Polar minus(@NotNull Polar right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Polar(this.theta - right.theta, this.radius - right.radius);
    }

    @NotNull
    public final Polar times(@NotNull Polar scale) {
        Intrinsics.checkNotNullParameter(scale, "scale");
        return new Polar(this.theta * scale.theta, this.radius * scale.radius);
    }

    @Override
    @NotNull
    public Polar times(double scale) {
        return new Polar(this.theta * scale, this.radius * scale);
    }

    @Override
    @NotNull
    public Polar div(double scale) {
        return new Polar(this.theta / scale, this.radius / scale);
    }

    public final double component1() {
        return this.theta;
    }

    public final double component2() {
        return this.radius;
    }

    @NotNull
    public final Polar copy(double theta, double radius) {
        return new Polar(theta, radius);
    }

    public static /* synthetic */ Polar copy$default(Polar polar, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = polar.theta;
        }
        if ((n & 2) != 0) {
            d2 = polar.radius;
        }
        return polar.copy(d, d2);
    }

    @Override
    @NotNull
    public String toString() {
        return "Polar(theta=" + this.theta + ", radius=" + this.radius + ")";
    }

    @Override
    public int hashCode() {
        int result2 = Double.hashCode(this.theta);
        result2 = result2 * 31 + Double.hashCode(this.radius);
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Polar)) {
            return false;
        }
        Polar polar = (Polar)other;
        if (Double.compare(this.theta, polar.theta) != 0) {
            return false;
        }
        return Double.compare(this.radius, polar.radius) == 0;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_math(Polar self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeDoubleElement(serialDesc, 0, self.theta);
        if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : Double.compare(self.radius, 1.0) != 0) {
            output.encodeDoubleElement(serialDesc, 1, self.radius);
        }
    }

    public /* synthetic */ Polar(int seen0, double theta, double radius, SerializationConstructorMarker serializationConstructorMarker) {
        if (1 != (1 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 1, $serializer.INSTANCE.getDescriptor());
        }
        this.theta = theta;
        this.radius = (seen0 & 2) == 0 ? 1.0 : radius;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a8\u0006\n"}, d2={"Lorg/openrndr/math/Polar$Companion;", "", "<init>", "()V", "fromVector", "Lorg/openrndr/math/Polar;", "vector", "Lorg/openrndr/math/Vector2;", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-math"})
    @SourceDebugExtension(value={"SMAP\nPolar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Polar.kt\norg/openrndr/math/Polar$Companion\n+ 2 Functions.kt\norg/openrndr/math/FunctionsKt\n*L\n1#1,49:1\n111#2:50\n*S KotlinDebug\n*F\n+ 1 Polar.kt\norg/openrndr/math/Polar$Companion\n*L\n30#1:50\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Polar fromVector(@NotNull Vector2 vector) {
            double d;
            Intrinsics.checkNotNullParameter(vector, "vector");
            double r = vector.length();
            if (r == 0.0) {
                d = 0.0;
            } else {
                void $this$asDegrees$iv;
                double d2 = Math.atan2(vector.y(), vector.x());
                boolean $i$f$getAsDegrees = false;
                d = $this$asDegrees$iv * 57.29577951308232;
            }
            return new Polar(d, r);
        }

        @NotNull
        public final KSerializer<Polar> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

