/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.Matrix33;
import org.openrndr.math.Quaternion$;
import org.openrndr.math.Vector3;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 02\u00020\u0001:\u000201B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB;\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u0007\u0010\rJ\u0011\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0010\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0086\u0002J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J1\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020\nH\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001J%\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0001\u00a2\u0006\u0002\b/R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0014\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0017\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000eR\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001b\u00a8\u00062"}, d2={"Lorg/openrndr/math/Quaternion;", "Ljava/lang/Record;", "x", "", "y", "z", "w", "<init>", "(DDDD)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IDDDDLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()D", "length", "times", "q", "Lorg/openrndr/math/Vector3;", "vec", "negated", "()Lorg/openrndr/math/Quaternion;", "inversed", "normalized", "norm", "matrix", "Lorg/openrndr/math/Matrix33;", "()Lorg/openrndr/math/Matrix33;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_math", "Companion", "$serializer", "openrndr-math"})
public final class Quaternion
extends Record {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;
    private final double z;
    private final double w;
    @NotNull
    private static final Quaternion IDENTITY = new Quaternion(0.0, 0.0, 0.0, 1.0);
    @NotNull
    private static final Quaternion ZERO = new Quaternion(0.0, 0.0, 0.0, 0.0);

    public Quaternion(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public final double x() {
        return this.x;
    }

    public final double y() {
        return this.y;
    }

    public final double z() {
        return this.z;
    }

    public final double w() {
        return this.w;
    }

    public final double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    @NotNull
    public final Quaternion times(@NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter(q, "q");
        return new Quaternion(this.x * q.w + this.y * q.z - this.z * q.y + this.w * q.x, -this.x * q.z + this.y * q.w + this.z * q.x + this.w * q.y, this.x * q.y - this.y * q.x + this.z * q.w + this.w * q.z, -this.x * q.x - this.y * q.y - this.z * q.z + this.w * q.w);
    }

    @NotNull
    public final Vector3 times(@NotNull Vector3 vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        double s = 2.0 / this.norm();
        double xs = this.x * s;
        double ys = this.y * s;
        double zs = this.z * s;
        double xxs = this.x * xs;
        double yys = this.y * ys;
        double zzs = this.z * zs;
        double xys = this.x * ys;
        double xzs = this.x * zs;
        double yzs = this.y * zs;
        double wxs = this.w * xs;
        double wys = this.w * ys;
        double wzs = this.w * zs;
        return new Vector3((1.0 - (yys + zzs)) * vec.x() + (xys - wzs) * vec.y() + (xzs + wys) * vec.z(), (xys + wzs) * vec.x() + (1.0 - (xxs + zzs)) * vec.y() + (yzs - wxs) * vec.z(), (xzs - wys) * vec.x() + (yzs + wxs) * vec.y() + (1.0 - (xxs + yys)) * vec.z());
    }

    @NotNull
    public final Quaternion negated() {
        return new Quaternion(-this.x, -this.y, -this.z, -this.w);
    }

    @NotNull
    public final Quaternion inversed() {
        double n = this.norm();
        if (n > 0.0) {
            double invNorm = 1.0 / n;
            return new Quaternion(-this.x * invNorm, -this.y * invNorm, -this.z * invNorm, this.w * invNorm);
        }
        throw new IllegalStateException("norm <= 0 => quaternion is not invertible".toString());
    }

    @NotNull
    public final Quaternion normalized() {
        double l = this.length();
        return new Quaternion(this.x / l, this.y / l, this.z / l, this.w / l);
    }

    public final double norm() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    @NotNull
    public final Matrix33 matrix() {
        double norm = this.norm();
        double s = norm == 1.0 ? 2.0 : (norm > 0.0 ? 2.0 / norm : 0.0);
        double xs = this.x * s;
        double ys = this.y * s;
        double zs = this.z * s;
        double xx = this.x * xs;
        double xy = this.x * ys;
        double xz = this.x * zs;
        double xw = this.w * xs;
        double yy = this.y * ys;
        double yz = this.y * zs;
        double yw = this.w * ys;
        double zz = this.z * zs;
        double zw = this.w * zs;
        return new Matrix33(1.0 - (yy + zz), xy - zw, xz + yw, xy + zw, 1.0 - (xx + zz), yz - xw, xz - yw, yz + xw, 1.0 - (xx + yy));
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    public final double component4() {
        return this.w;
    }

    @NotNull
    public final Quaternion copy(double x, double y, double z, double w) {
        return new Quaternion(x, y, z, w);
    }

    public static /* synthetic */ Quaternion copy$default(Quaternion quaternion, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = quaternion.x;
        }
        if ((n & 2) != 0) {
            d2 = quaternion.y;
        }
        if ((n & 4) != 0) {
            d3 = quaternion.z;
        }
        if ((n & 8) != 0) {
            d4 = quaternion.w;
        }
        return quaternion.copy(d, d2, d3, d4);
    }

    @Override
    @NotNull
    public String toString() {
        return "Quaternion(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + ")";
    }

    @Override
    public int hashCode() {
        int result2 = Double.hashCode(this.x);
        result2 = result2 * 31 + Double.hashCode(this.y);
        result2 = result2 * 31 + Double.hashCode(this.z);
        result2 = result2 * 31 + Double.hashCode(this.w);
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Quaternion)) {
            return false;
        }
        Quaternion quaternion = (Quaternion)other;
        if (Double.compare(this.x, quaternion.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, quaternion.y) != 0) {
            return false;
        }
        if (Double.compare(this.z, quaternion.z) != 0) {
            return false;
        }
        return Double.compare(this.w, quaternion.w) == 0;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_math(Quaternion self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeDoubleElement(serialDesc, 0, self.x);
        output.encodeDoubleElement(serialDesc, 1, self.y);
        output.encodeDoubleElement(serialDesc, 2, self.z);
        output.encodeDoubleElement(serialDesc, 3, self.w);
    }

    public /* synthetic */ Quaternion(int seen0, double x, double y, double z, double w, SerializationConstructorMarker serializationConstructorMarker) {
        if (15 != (0xF & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 15, $serializer.INSTANCE.getDescriptor());
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\fJ\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fJ\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0018J\u001e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0018J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lorg/openrndr/math/Quaternion$Companion;", "", "<init>", "()V", "IDENTITY", "Lorg/openrndr/math/Quaternion;", "getIDENTITY", "()Lorg/openrndr/math/Quaternion;", "ZERO", "getZERO", "fromLookAt", "from", "Lorg/openrndr/math/Vector3;", "to", "up", "fromAxes", "x", "y", "z", "fromMatrix", "m", "Lorg/openrndr/math/Matrix33;", "fromAngles", "pitch", "", "roll", "yaw", "fromAnglesRadian", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-math"})
    @SourceDebugExtension(value={"SMAP\nQuaternion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Quaternion.kt\norg/openrndr/math/Quaternion$Companion\n+ 2 Functions.kt\norg/openrndr/math/FunctionsKt\n*L\n1#1,230:1\n110#2:231\n*S KotlinDebug\n*F\n+ 1 Quaternion.kt\norg/openrndr/math/Quaternion$Companion\n*L\n84#1:231\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Quaternion getIDENTITY() {
            return IDENTITY;
        }

        @NotNull
        public final Quaternion getZERO() {
            return ZERO;
        }

        @NotNull
        public final Quaternion fromLookAt(@NotNull Vector3 from, @NotNull Vector3 to, @NotNull Vector3 up) {
            Intrinsics.checkNotNullParameter(from, "from");
            Intrinsics.checkNotNullParameter(to, "to");
            Intrinsics.checkNotNullParameter(up, "up");
            Vector3 direction = to.minus(from);
            Vector3 z = (Vector3)direction.getNormalized();
            Vector3 y = (Vector3)up.getNormalized();
            Vector3 x = (Vector3)y.cross(z).getNormalized();
            Vector3 y2 = (Vector3)z.cross(x).getNormalized();
            return this.fromAxes(x, y2, z).normalized();
        }

        public static /* synthetic */ Quaternion fromLookAt$default(Companion companion, Vector3 vector3, Vector3 vector32, Vector3 vector33, int n, Object object) {
            if ((n & 4) != 0) {
                vector33 = Vector3.Companion.getUNIT_Y();
            }
            return companion.fromLookAt(vector3, vector32, vector33);
        }

        @NotNull
        public final Quaternion fromAxes(@NotNull Vector3 x, @NotNull Vector3 y, @NotNull Vector3 z) {
            Intrinsics.checkNotNullParameter(x, "x");
            Intrinsics.checkNotNullParameter(y, "y");
            Intrinsics.checkNotNullParameter(z, "z");
            Matrix33 m = Matrix33.Companion.fromColumnVectors(x, y, z);
            return this.fromMatrix(m);
        }

        @NotNull
        public final Quaternion fromMatrix(@NotNull Matrix33 m) {
            Intrinsics.checkNotNullParameter(m, "m");
            double t = m.trace() + 1.0;
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            double w = 0.0;
            if (t > 0.0) {
                double s = 0.5 / Math.sqrt(t);
                w = 0.25 / s;
                x = (m.c1r2() - m.c2r1()) * s;
                y = (m.c2r0() - m.c0r2()) * s;
                z = (m.c0r1() - m.c1r0()) * s;
            } else if (m.c0r0() > m.c1r1() && m.c0r0() > m.c2r2()) {
                double s = 0.5 / Math.sqrt(1.0 + m.c0r0() - m.c1r1() - m.c2r2());
                w = (m.c1r2() - m.c2r1()) * s;
                x = (double)0.25f / s;
                y = (m.c0r1() + m.c1r0()) * s;
                z = (m.c2r0() + m.c0r2()) * s;
            } else if (m.c1r1() > m.c2r2()) {
                double s = (double)0.5f / Math.sqrt(1.0 + m.c1r1() - m.c0r0() - m.c2r2());
                w = (m.c2r0() - m.c0r2()) * s;
                x = (m.c0r2() + m.c1r0()) * s;
                y = (double)0.25f / s;
                z = (m.c1r2() + m.c2r1()) * s;
            } else {
                double s = (double)0.5f / Math.sqrt(1.0 + m.c2r2() - m.c0r0() - m.c1r1());
                w = (m.c0r1() - m.c1r0()) * s;
                x = (m.c2r0() + m.c0r2()) * s;
                y = (m.c1r2() + m.c2r1()) * s;
                z = (double)0.25f / s;
            }
            return new Quaternion(x, y, z, w);
        }

        @NotNull
        public final Quaternion fromAngles(double pitch, double roll, double yaw) {
            double $this$asRadians$iv = pitch;
            boolean $i$f$getAsRadians = false;
            double d = $this$asRadians$iv * (Math.PI / 180);
            $this$asRadians$iv = roll;
            $i$f$getAsRadians = false;
            double d2 = $this$asRadians$iv * (Math.PI / 180);
            $this$asRadians$iv = yaw;
            $i$f$getAsRadians = false;
            return this.fromAnglesRadian(d, d2, $this$asRadians$iv * (Math.PI / 180));
        }

        @NotNull
        public final Quaternion fromAnglesRadian(double pitch, double roll, double yaw) {
            double cy = Math.cos(yaw * 0.5);
            double sy = Math.sin(yaw * 0.5);
            double cr = Math.cos(roll * 0.5);
            double sr = Math.sin(roll * 0.5);
            double cp = Math.cos(pitch * 0.5);
            double sp = Math.sin(pitch * 0.5);
            return new Quaternion(cy * sr * cp - sy * cr * sp, cy * cr * sp + sy * sr * cp, sy * cr * cp - cy * sr * sp, cy * cr * cp + sy * sr * sp);
        }

        @NotNull
        public final KSerializer<Quaternion> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

