/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Quaternion;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u001e\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0001\u00a8\u0006\u0007"}, d2={"dot", "", "q1", "Lorg/openrndr/math/Quaternion;", "q2", "slerp", "x", "openrndr-math"})
public final class QuaternionKt {
    public static final double dot(@NotNull Quaternion q1, @NotNull Quaternion q2) {
        Intrinsics.checkNotNullParameter(q1, "q1");
        Intrinsics.checkNotNullParameter(q2, "q2");
        return q1.w() * q2.w() + q1.x() * q2.x() + q1.y() * q2.y() + q2.z() * q2.z();
    }

    @NotNull
    public static final Quaternion slerp(@NotNull Quaternion q1, @NotNull Quaternion q2, double x) {
        Intrinsics.checkNotNullParameter(q1, "q1");
        Intrinsics.checkNotNullParameter(q2, "q2");
        if (q1.x() == q2.x() && q1.y() == q2.y() && q1.z() == q2.z() && q1.w() == q2.w()) {
            return q1;
        }
        Quaternion q2e = q2;
        double result2 = q1.x() * q2.x() + q1.y() * q2.y() + q1.z() * q2.z() + q1.w() * q2.w();
        if (result2 < 0.0) {
            q2e = q2.negated();
            result2 = -result2;
        }
        double scale0 = 1.0 - x;
        double scale1 = x;
        if (1.0 - result2 > 0.1) {
            double theta = Math.acos(result2);
            double invSinTheta = 1.0 / Math.sin(theta);
            scale0 = Math.sin((1.0 - x) * theta) * invSinTheta;
            scale1 = Math.sin(x * theta) * invSinTheta;
        }
        return new Quaternion(scale0 * q1.x() + scale1 * q2e.x(), scale0 * q1.y() + scale1 * q2e.y(), scale0 * q1.z() + scale1 * q2e.z(), scale0 * q1.w() + scale1 * q2e.w());
    }
}

