/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.FunctionsKt;
import org.openrndr.math.LinearType;
import org.openrndr.math.Spherical$;
import org.openrndr.math.Vector3;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 ,2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0002,-B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bB3\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u0007\u0010\rJ\u0006\u0010\u000f\u001a\u00020\u0000J\u0011\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0004H\u0096\u0002J\u0011\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0004H\u0096\u0002J\t\u0010\u0019\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0004H\u00c6\u0003J'\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\nH\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001J%\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0001\u00a2\u0006\u0002\b+R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000eR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012\u00a8\u0006."}, d2={"Lorg/openrndr/math/Spherical;", "Lorg/openrndr/math/LinearType;", "Ljava/lang/Record;", "theta", "", "phi", "radius", "<init>", "(DDD)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IDDDLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()D", "makeSafe", "cartesian", "Lorg/openrndr/math/Vector3;", "()Lorg/openrndr/math/Vector3;", "plus", "right", "minus", "times", "scale", "div", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_math", "Companion", "$serializer", "openrndr-math"})
public final class Spherical
extends Record
implements LinearType<Spherical> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double theta;
    private final double phi;
    private final double radius;

    public Spherical(double theta, double phi, double radius) {
        this.theta = theta;
        this.phi = phi;
        this.radius = radius;
    }

    public final double theta() {
        return this.theta;
    }

    public final double phi() {
        return this.phi;
    }

    public final double radius() {
        return this.radius;
    }

    @NotNull
    public final Spherical makeSafe() {
        return new Spherical(this.theta, FunctionsKt.clamp(this.phi, 1.0E-6, 179.999999), this.radius);
    }

    @NotNull
    public final Vector3 cartesian() {
        return Vector3.Companion.fromSpherical(this);
    }

    @Override
    @NotNull
    public Spherical plus(@NotNull Spherical right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Spherical(this.theta + right.theta, this.phi + right.phi, this.radius + right.radius);
    }

    @Override
    @NotNull
    public Spherical minus(@NotNull Spherical right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Spherical(this.theta - right.theta, this.phi - right.phi, this.radius - right.radius);
    }

    @NotNull
    public final Spherical times(@NotNull Spherical scale) {
        Intrinsics.checkNotNullParameter(scale, "scale");
        return new Spherical(this.theta * scale.theta, this.phi * scale.phi, this.radius * scale.radius);
    }

    @Override
    @NotNull
    public Spherical times(double scale) {
        return new Spherical(this.theta * scale, this.phi * scale, this.radius * scale);
    }

    @Override
    @NotNull
    public Spherical div(double scale) {
        return new Spherical(this.theta / scale, this.phi / scale, this.radius / scale);
    }

    public final double component1() {
        return this.theta;
    }

    public final double component2() {
        return this.phi;
    }

    public final double component3() {
        return this.radius;
    }

    @NotNull
    public final Spherical copy(double theta, double phi, double radius) {
        return new Spherical(theta, phi, radius);
    }

    public static /* synthetic */ Spherical copy$default(Spherical spherical, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = spherical.theta;
        }
        if ((n & 2) != 0) {
            d2 = spherical.phi;
        }
        if ((n & 4) != 0) {
            d3 = spherical.radius;
        }
        return spherical.copy(d, d2, d3);
    }

    @Override
    @NotNull
    public String toString() {
        return "Spherical(theta=" + this.theta + ", phi=" + this.phi + ", radius=" + this.radius + ")";
    }

    @Override
    public int hashCode() {
        int result2 = Double.hashCode(this.theta);
        result2 = result2 * 31 + Double.hashCode(this.phi);
        result2 = result2 * 31 + Double.hashCode(this.radius);
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Spherical)) {
            return false;
        }
        Spherical spherical = (Spherical)other;
        if (Double.compare(this.theta, spherical.theta) != 0) {
            return false;
        }
        if (Double.compare(this.phi, spherical.phi) != 0) {
            return false;
        }
        return Double.compare(this.radius, spherical.radius) == 0;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_math(Spherical self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeDoubleElement(serialDesc, 0, self.theta);
        output.encodeDoubleElement(serialDesc, 1, self.phi);
        output.encodeDoubleElement(serialDesc, 2, self.radius);
    }

    public /* synthetic */ Spherical(int seen0, double theta, double phi, double radius, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 7, $serializer.INSTANCE.getDescriptor());
        }
        this.theta = theta;
        this.phi = phi;
        this.radius = radius;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a8\u0006\n"}, d2={"Lorg/openrndr/math/Spherical$Companion;", "", "<init>", "()V", "fromVector", "Lorg/openrndr/math/Spherical;", "vector", "Lorg/openrndr/math/Vector3;", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-math"})
    @SourceDebugExtension(value={"SMAP\nSpherical.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Spherical.kt\norg/openrndr/math/Spherical$Companion\n+ 2 Functions.kt\norg/openrndr/math/FunctionsKt\n*L\n1#1,48:1\n111#2:49\n111#2:50\n*S KotlinDebug\n*F\n+ 1 Spherical.kt\norg/openrndr/math/Spherical$Companion\n*L\n31#1:49\n32#1:50\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Spherical fromVector(@NotNull Vector3 vector) {
            double d;
            double $this$asDegrees$iv;
            boolean $i$f$getAsDegrees;
            double d2;
            Intrinsics.checkNotNullParameter(vector, "vector");
            double r = vector.length();
            if (r == 0.0) {
                d2 = 0.0;
            } else {
                double d3 = Math.atan2(vector.x(), vector.z());
                $i$f$getAsDegrees = false;
                d2 = $this$asDegrees$iv * 57.29577951308232;
            }
            if (r == 0.0) {
                d = 0.0;
            } else {
                $this$asDegrees$iv = Math.acos(FunctionsKt.clamp(vector.y() / r, -1.0, 1.0));
                $i$f$getAsDegrees = false;
                d = $this$asDegrees$iv * 57.29577951308232;
            }
            return new Spherical(d2, d, r);
        }

        @NotNull
        public final KSerializer<Spherical> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

