/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.EuclideanVector;
import org.openrndr.math.IntVector2;
import org.openrndr.math.LinearType;
import org.openrndr.math.Polar;
import org.openrndr.math.Vector2$;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;
import org.openrndr.math.YPolarity;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 V2\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\u00020\u0003:\u0002VWB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\tB+\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u0007\u0010\u000eJ\u001c\u0010\u0012\u001a\u00020\u00002\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\u0011\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0000H\u0096\u0004J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H\u0086\u0004J\u0018\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00052\b\b\u0002\u0010!\u001a\u00020\u0000J$\u0010-\u001a\u00020&2\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010.\u001a\u00020\u0005J.\u0010/\u001a\u00020*2\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010.\u001a\u00020\u00052\b\b\u0002\u00100\u001a\u00020\u0005J\u0011\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u000bH\u0086\u0002J\t\u00103\u001a\u00020\u0000H\u0086\u0002J\u0011\u00104\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0000H\u0096\u0002J\u0011\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0005H\u0086\u0002J\u0011\u00106\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0000H\u0096\u0002J\u0011\u00106\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0005H\u0086\u0002J\u0011\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u0005H\u0096\u0002J\u0011\u00107\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010:\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u0005H\u0096\u0002J\u0011\u0010:\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0000H\u0086\u0002J\u0010\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\u0000H\u0016J\u0010\u0010=\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\u0000H\u0016J\u0010\u0010>\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\u0000H\u0016J\u0016\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\u0005J\u0006\u0010A\u001a\u00020BJ\u0006\u0010C\u001a\u00020DJ\t\u0010E\u001a\u00020\u0005H\u00c6\u0003J\t\u0010F\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010G\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010H\u001a\u00020I2\b\u0010<\u001a\u0004\u0018\u00010JH\u00d6\u0003J\t\u0010K\u001a\u00020\u000bH\u00d6\u0001J\t\u0010L\u001a\u00020MH\u00d6\u0001J%\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020\u00002\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020TH\u0001\u00a2\u0006\u0002\bUR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0018\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\"\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0019R\u0011\u0010#\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0019R\u0011\u0010$\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0019R\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010'R\u0011\u0010(\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010'R\u0011\u0010)\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010+R\u0011\u0010,\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010+\u00a8\u0006X"}, d2={"Lorg/openrndr/math/Vector2;", "Lorg/openrndr/math/LinearType;", "Lorg/openrndr/math/EuclideanVector;", "Ljava/lang/Record;", "x", "", "y", "<init>", "(DD)V", "(D)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IDDLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()D", "length", "squaredLength", "map", "function", "Lkotlin/Function1;", "perpendicular", "polarity", "Lorg/openrndr/math/YPolarity;", "zero", "()Lorg/openrndr/math/Vector2;", "cross", "right", "dot", "reflect", "surfaceNormal", "rotate", "degrees", "origin", "yx", "xx", "yy", "xy0", "Lorg/openrndr/math/Vector3;", "()Lorg/openrndr/math/Vector3;", "xy1", "xy00", "Lorg/openrndr/math/Vector4;", "()Lorg/openrndr/math/Vector4;", "xy01", "vector3", "z", "vector4", "w", "get", "i", "unaryMinus", "plus", "d", "minus", "times", "scale", "v", "div", "distanceTo", "other", "squaredDistanceTo", "areaBetween", "mix", "o", "toDoubleArray", "", "toInt", "Lorg/openrndr/math/IntVector2;", "component1", "component2", "copy", "equals", "", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_math", "Companion", "$serializer", "openrndr-math"})
@SourceDebugExtension(value={"SMAP\nVector2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vector2.kt\norg/openrndr/math/Vector2\n+ 2 Functions.kt\norg/openrndr/math/FunctionsKt\n*L\n1#1,201:1\n110#2:202\n*S KotlinDebug\n*F\n+ 1 Vector2.kt\norg/openrndr/math/Vector2\n*L\n65#1:202\n*E\n"})
public final class Vector2
extends Record
implements LinearType<Vector2>,
EuclideanVector<Vector2> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;
    @NotNull
    private static final Vector2 ZERO = new Vector2(0.0, 0.0);
    @NotNull
    private static final Vector2 ONE = new Vector2(1.0, 1.0);
    @NotNull
    private static final Vector2 UNIT_X = new Vector2(1.0, 0.0);
    @NotNull
    private static final Vector2 UNIT_Y = new Vector2(0.0, 1.0);
    @NotNull
    private static final Vector2 INFINITY = new Vector2(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    public Vector2(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public final double x() {
        return this.x;
    }

    public final double y() {
        return this.y;
    }

    public Vector2(double x) {
        this(x, x);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double squaredLength() {
        return this.x * this.x + this.y * this.y;
    }

    @Override
    @NotNull
    public Vector2 map(@NotNull Function1<? super Double, Double> function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        return new Vector2(((Number)function2.invoke((Double)this.x)).doubleValue(), ((Number)function2.invoke((Double)this.y)).doubleValue());
    }

    @NotNull
    public final Vector2 perpendicular(@NotNull YPolarity polarity) {
        Intrinsics.checkNotNullParameter((Object)polarity, "polarity");
        return switch (WhenMappings.$EnumSwitchMapping$0[polarity.ordinal()]) {
            case 1 -> new Vector2(-this.y, this.x);
            case 2 -> new Vector2(this.y, -this.x);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ Vector2 perpendicular$default(Vector2 vector2, YPolarity yPolarity, int n, Object object) {
        if ((n & 1) != 0) {
            yPolarity = YPolarity.CW_NEGATIVE_Y;
        }
        return vector2.perpendicular(yPolarity);
    }

    @NotNull
    public Vector2 zero() {
        return ZERO;
    }

    public final double cross(@NotNull Vector2 right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return this.x * right.y - this.y * right.x;
    }

    @Override
    public double dot(@NotNull Vector2 right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return this.x * right.x + this.y * right.y;
    }

    @NotNull
    public final Vector2 reflect(@NotNull Vector2 surfaceNormal) {
        Intrinsics.checkNotNullParameter(surfaceNormal, "surfaceNormal");
        return this.minus(surfaceNormal.times(this.dot(surfaceNormal)).times(2.0));
    }

    @NotNull
    public final Vector2 rotate(double degrees, @NotNull Vector2 origin2) {
        Intrinsics.checkNotNullParameter(origin2, "origin");
        Vector2 p = this.minus(origin2);
        double $this$asRadians$iv = degrees;
        boolean $i$f$getAsRadians = false;
        double a = $this$asRadians$iv * (Math.PI / 180);
        Vector2 w = new Vector2(p.x * Math.cos(a) - p.y * Math.sin(a), p.y * Math.cos(a) + p.x * Math.sin(a));
        return w.plus(origin2);
    }

    public static /* synthetic */ Vector2 rotate$default(Vector2 vector2, double d, Vector2 vector22, int n, Object object) {
        if ((n & 2) != 0) {
            vector22 = ZERO;
        }
        return vector2.rotate(d, vector22);
    }

    @NotNull
    public final Vector2 yx() {
        return new Vector2(this.y, this.x);
    }

    @NotNull
    public final Vector2 xx() {
        return new Vector2(this.x, this.x);
    }

    @NotNull
    public final Vector2 yy() {
        return new Vector2(this.y, this.y);
    }

    @NotNull
    public final Vector3 xy0() {
        return new Vector3(this.x, this.y, 0.0);
    }

    @NotNull
    public final Vector3 xy1() {
        return new Vector3(this.x, this.y, 1.0);
    }

    @NotNull
    public final Vector4 xy00() {
        return new Vector4(this.x, this.y, 0.0, 0.0);
    }

    @NotNull
    public final Vector4 xy01() {
        return new Vector4(this.x, this.y, 0.0, 1.0);
    }

    @NotNull
    public final Vector3 vector3(double x, double y, double z) {
        return new Vector3(x, y, z);
    }

    public static /* synthetic */ Vector3 vector3$default(Vector2 vector2, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = vector2.x;
        }
        if ((n & 2) != 0) {
            d2 = vector2.y;
        }
        if ((n & 4) != 0) {
            d3 = 0.0;
        }
        return vector2.vector3(d, d2, d3);
    }

    @NotNull
    public final Vector4 vector4(double x, double y, double z, double w) {
        return new Vector4(x, y, z, w);
    }

    public static /* synthetic */ Vector4 vector4$default(Vector2 vector2, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = vector2.x;
        }
        if ((n & 2) != 0) {
            d2 = vector2.y;
        }
        if ((n & 4) != 0) {
            d3 = 0.0;
        }
        if ((n & 8) != 0) {
            d4 = 0.0;
        }
        return vector2.vector4(d, d2, d3, d4);
    }

    public final double get(int i) {
        return switch (i) {
            case 0 -> this.x;
            case 1 -> this.y;
            default -> throw new RuntimeException("unsupported index");
        };
    }

    @NotNull
    public final Vector2 unaryMinus() {
        return new Vector2(-this.x, -this.y);
    }

    @Override
    @NotNull
    public Vector2 plus(@NotNull Vector2 right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Vector2(this.x + right.x, this.y + right.y);
    }

    @Override
    @NotNull
    public final Vector2 plus(double d) {
        return new Vector2(this.x + d, this.y + d);
    }

    @Override
    @NotNull
    public Vector2 minus(@NotNull Vector2 right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Vector2(this.x - right.x, this.y - right.y);
    }

    @Override
    @NotNull
    public final Vector2 minus(double d) {
        return new Vector2(this.x - d, this.y - d);
    }

    @Override
    @NotNull
    public Vector2 times(double scale) {
        return new Vector2(this.x * scale, this.y * scale);
    }

    @NotNull
    public final Vector2 times(@NotNull Vector2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new Vector2(this.x * v.x, this.y * v.y);
    }

    @Override
    @NotNull
    public Vector2 div(double scale) {
        return new Vector2(this.x / scale, this.y / scale);
    }

    @NotNull
    public final Vector2 div(@NotNull Vector2 d) {
        Intrinsics.checkNotNullParameter(d, "d");
        return new Vector2(this.x / d.x, this.y / d.y);
    }

    @Override
    public double distanceTo(@NotNull Vector2 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        double dx = other.x - this.x;
        double dy = other.y - this.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    public double squaredDistanceTo(@NotNull Vector2 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        double dx = other.x - this.x;
        double dy = other.y - this.y;
        return dx * dx + dy * dy;
    }

    @Override
    public double areaBetween(@NotNull Vector2 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Math.abs(this.x * other.y - this.y * other.x);
    }

    @NotNull
    public final Vector2 mix(@NotNull Vector2 o, double mix) {
        Intrinsics.checkNotNullParameter(o, "o");
        return this.times(1.0 - mix).plus(o.times(mix));
    }

    @NotNull
    public final double[] toDoubleArray() {
        double[] dArray = new double[]{this.x, this.y};
        return dArray;
    }

    @NotNull
    public final IntVector2 toInt() {
        return new IntVector2((int)this.x, (int)this.y);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    @NotNull
    public final Vector2 copy(double x, double y) {
        return new Vector2(x, y);
    }

    public static /* synthetic */ Vector2 copy$default(Vector2 vector2, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = vector2.x;
        }
        if ((n & 2) != 0) {
            d2 = vector2.y;
        }
        return vector2.copy(d, d2);
    }

    @Override
    @NotNull
    public String toString() {
        return "Vector2(x=" + this.x + ", y=" + this.y + ")";
    }

    @Override
    public int hashCode() {
        int result2 = Double.hashCode(this.x);
        result2 = result2 * 31 + Double.hashCode(this.y);
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vector2)) {
            return false;
        }
        Vector2 vector2 = (Vector2)other;
        if (Double.compare(this.x, vector2.x) != 0) {
            return false;
        }
        return Double.compare(this.y, vector2.y) == 0;
    }

    @NotNull
    public Vector2 normalized() {
        return EuclideanVector.DefaultImpls.getNormalized(this);
    }

    @Override
    @NotNull
    public Vector2 projectedOn(@NotNull Vector2 on) {
        return (Vector2)EuclideanVector.DefaultImpls.projectedOn(this, (EuclideanVector)on);
    }

    @Override
    @NotNull
    public Vector2 reflectedOver(@NotNull Vector2 surfaceNormal) {
        return (Vector2)EuclideanVector.DefaultImpls.reflectedOver(this, (EuclideanVector)surfaceNormal);
    }

    @Override
    public double atan2(@NotNull Vector2 other) {
        return EuclideanVector.DefaultImpls.atan2(this, (EuclideanVector)other);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_math(Vector2 self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeDoubleElement(serialDesc, 0, self.x);
        output.encodeDoubleElement(serialDesc, 1, self.y);
    }

    public /* synthetic */ Vector2(int seen0, double x, double y, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 3, $serializer.INSTANCE.getDescriptor());
        }
        this.x = x;
        this.y = y;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/openrndr/math/Vector2$Companion;", "", "<init>", "()V", "ZERO", "Lorg/openrndr/math/Vector2;", "getZERO", "()Lorg/openrndr/math/Vector2;", "ONE", "getONE", "UNIT_X", "getUNIT_X", "UNIT_Y", "getUNIT_Y", "INFINITY", "getINFINITY", "fromPolar", "polar", "Lorg/openrndr/math/Polar;", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-math"})
    @SourceDebugExtension(value={"SMAP\nVector2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vector2.kt\norg/openrndr/math/Vector2$Companion\n+ 2 Functions.kt\norg/openrndr/math/FunctionsKt\n*L\n1#1,201:1\n110#2:202\n*S KotlinDebug\n*F\n+ 1 Vector2.kt\norg/openrndr/math/Vector2$Companion\n*L\n160#1:202\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Vector2 getZERO() {
            return ZERO;
        }

        @NotNull
        public final Vector2 getONE() {
            return ONE;
        }

        @NotNull
        public final Vector2 getUNIT_X() {
            return UNIT_X;
        }

        @NotNull
        public final Vector2 getUNIT_Y() {
            return UNIT_Y;
        }

        @NotNull
        public final Vector2 getINFINITY() {
            return INFINITY;
        }

        @NotNull
        public final Vector2 fromPolar(@NotNull Polar polar) {
            Intrinsics.checkNotNullParameter(polar, "polar");
            double $this$asRadians$iv = polar.theta();
            boolean $i$f$getAsRadians = false;
            double theta = $this$asRadians$iv * (Math.PI / 180);
            double x = Math.cos(theta);
            double y = Math.sin(theta);
            return new Vector2(x, y).times(polar.radius());
        }

        @NotNull
        public final KSerializer<Vector2> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[YPolarity.values().length];
            try {
                nArray[YPolarity.CCW_POSITIVE_Y.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[YPolarity.CW_NEGATIVE_Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

