/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.EuclideanVector;
import org.openrndr.math.IntVector4;
import org.openrndr.math.LinearType;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4$;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 L2\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u00022\u00020\u0003:\u0002LMB'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\u000bB;\b\u0010\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\t\u0010\u0010J\u001c\u0010 \u001a\u00020\u00002\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\"H\u0016J\t\u0010%\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010&\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0005H\u0086\u0002J\u0011\u0010)\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010)\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0005H\u0086\u0002J\u0011\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010*\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0005H\u0096\u0002J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0005H\u0096\u0002J\u0011\u0010-\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0000H\u0096\u0004J\u0011\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\rH\u0086\u0002J\u0010\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0000H\u0016J\u0010\u00102\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0000H\u0016J\u0016\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0005J\u0006\u00105\u001a\u000206J\u0006\u00107\u001a\u000208J\t\u00109\u001a\u00020\u0005H\u00c6\u0003J\t\u0010:\u001a\u00020\u0005H\u00c6\u0003J\t\u0010;\u001a\u00020\u0005H\u00c6\u0003J\t\u0010<\u001a\u00020\u0005H\u00c6\u0003J1\u0010=\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010>\u001a\u00020?2\b\u00101\u001a\u0004\u0018\u00010@H\u00d6\u0003J\t\u0010A\u001a\u00020\rH\u00d6\u0001J\t\u0010B\u001a\u00020CH\u00d6\u0001J%\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u00002\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020JH\u0001\u00a2\u0006\u0002\bKR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0016\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0017\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\u0018\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\u0019\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0014R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0011R\u0014\u0010\u001f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0011R\u0014\u0010#\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006N"}, d2={"Lorg/openrndr/math/Vector4;", "Lorg/openrndr/math/LinearType;", "Lorg/openrndr/math/EuclideanVector;", "Ljava/lang/Record;", "x", "", "y", "z", "w", "<init>", "(DDDD)V", "(D)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IDDDDLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()D", "xy", "Lorg/openrndr/math/Vector2;", "()Lorg/openrndr/math/Vector2;", "yx", "xz", "yz", "zx", "zy", "xyz", "Lorg/openrndr/math/Vector3;", "()Lorg/openrndr/math/Vector3;", "div", "length", "squaredLength", "map", "function", "Lkotlin/Function1;", "zero", "()Lorg/openrndr/math/Vector4;", "unaryMinus", "plus", "right", "d", "minus", "times", "v", "scale", "dot", "get", "i", "distanceTo", "other", "squaredDistanceTo", "mix", "o", "toDoubleArray", "", "toInt", "Lorg/openrndr/math/IntVector4;", "component1", "component2", "component3", "component4", "copy", "equals", "", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_math", "Companion", "$serializer", "openrndr-math"})
public final class Vector4
extends Record
implements LinearType<Vector4>,
EuclideanVector<Vector4> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;
    private final double z;
    private final double w;
    @NotNull
    private static final Vector4 UNIT_X = new Vector4(1.0, 0.0, 0.0, 0.0);
    @NotNull
    private static final Vector4 UNIT_Y = new Vector4(0.0, 1.0, 0.0, 0.0);
    @NotNull
    private static final Vector4 UNIT_Z = new Vector4(0.0, 0.0, 1.0, 0.0);
    @NotNull
    private static final Vector4 UNIT_W = new Vector4(0.0, 0.0, 0.0, 1.0);
    @NotNull
    private static final Vector4 ZERO = new Vector4(0.0, 0.0, 0.0, 0.0);
    @NotNull
    private static final Vector4 ONE = new Vector4(1.0, 1.0, 1.0, 1.0);
    @NotNull
    private static final Vector4 INFINITY = new Vector4(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    public Vector4(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public final double x() {
        return this.x;
    }

    public final double y() {
        return this.y;
    }

    public final double z() {
        return this.z;
    }

    public final double w() {
        return this.w;
    }

    public Vector4(double x) {
        this(x, x, x, x);
    }

    @NotNull
    public final Vector2 xy() {
        return new Vector2(this.x, this.y);
    }

    @NotNull
    public final Vector2 yx() {
        return new Vector2(this.y, this.x);
    }

    @NotNull
    public final Vector2 xz() {
        return new Vector2(this.x, this.z);
    }

    @NotNull
    public final Vector2 yz() {
        return new Vector2(this.y, this.z);
    }

    @NotNull
    public final Vector2 zx() {
        return new Vector2(this.z, this.x);
    }

    @NotNull
    public final Vector2 zy() {
        return new Vector2(this.z, this.y);
    }

    @NotNull
    public final Vector3 xyz() {
        return new Vector3(this.x, this.y, this.z);
    }

    @NotNull
    public final Vector3 div() {
        return new Vector3(this.x / this.w, this.y / this.w, this.z / this.w);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    public double squaredLength() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    @Override
    @NotNull
    public Vector4 map(@NotNull Function1<? super Double, Double> function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        return new Vector4(((Number)function2.invoke((Double)this.x)).doubleValue(), ((Number)function2.invoke((Double)this.y)).doubleValue(), ((Number)function2.invoke((Double)this.z)).doubleValue(), ((Number)function2.invoke((Double)this.w)).doubleValue());
    }

    @NotNull
    public Vector4 zero() {
        return ZERO;
    }

    @NotNull
    public final Vector4 unaryMinus() {
        return new Vector4(-this.x, -this.y, -this.z, -this.w);
    }

    @Override
    @NotNull
    public Vector4 plus(@NotNull Vector4 right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Vector4(this.x + right.x, this.y + right.y, this.z + right.z, this.w + right.w);
    }

    @Override
    @NotNull
    public final Vector4 plus(double d) {
        return new Vector4(this.x + d, this.y + d, this.z + d, this.w + d);
    }

    @Override
    @NotNull
    public Vector4 minus(@NotNull Vector4 right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new Vector4(this.x - right.x, this.y - right.y, this.z - right.z, this.w - right.w);
    }

    @Override
    @NotNull
    public final Vector4 minus(double d) {
        return new Vector4(this.x - d, this.y - d, this.z - d, this.w - d);
    }

    @NotNull
    public final Vector4 times(@NotNull Vector4 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new Vector4(this.x * v.x, this.y * v.y, this.z * v.z, this.w * v.w);
    }

    @Override
    @NotNull
    public Vector4 times(double scale) {
        return new Vector4(this.x * scale, this.y * scale, this.z * scale, this.w * scale);
    }

    @NotNull
    public final Vector4 div(@NotNull Vector4 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return new Vector4(this.x / v.x, this.y / v.y, this.z / v.z, this.w / v.w);
    }

    @Override
    @NotNull
    public Vector4 div(double scale) {
        return new Vector4(this.x / scale, this.y / scale, this.z / scale, this.w / scale);
    }

    @Override
    public double dot(@NotNull Vector4 right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return this.x * right.x + this.y * right.y + this.z * right.z + this.w * right.w;
    }

    public final double get(int i) {
        return switch (i) {
            case 0 -> this.x;
            case 1 -> this.y;
            case 2 -> this.z;
            case 3 -> this.w;
            default -> throw new IllegalArgumentException("unsupported index");
        };
    }

    @Override
    public double distanceTo(@NotNull Vector4 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        double dx = other.x - this.x;
        double dy = other.y - this.y;
        double dz = other.z - this.z;
        double dw = other.z - this.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz + dw * dw);
    }

    @Override
    public double squaredDistanceTo(@NotNull Vector4 other) {
        Intrinsics.checkNotNullParameter(other, "other");
        double dx = other.x - this.x;
        double dy = other.y - this.y;
        double dz = other.z - this.z;
        double dw = other.w - this.w;
        return dx * dx + dy * dy + dz * dz + dw * dw;
    }

    @NotNull
    public final Vector4 mix(@NotNull Vector4 o, double mix) {
        Intrinsics.checkNotNullParameter(o, "o");
        return this.times(1.0 - mix).plus(o.times(mix));
    }

    @NotNull
    public final double[] toDoubleArray() {
        double[] dArray = new double[]{this.x, this.y, this.z, this.w};
        return dArray;
    }

    @NotNull
    public final IntVector4 toInt() {
        return new IntVector4((int)this.x, (int)this.y, (int)this.z, (int)this.w);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    public final double component4() {
        return this.w;
    }

    @NotNull
    public final Vector4 copy(double x, double y, double z, double w) {
        return new Vector4(x, y, z, w);
    }

    public static /* synthetic */ Vector4 copy$default(Vector4 vector4, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = vector4.x;
        }
        if ((n & 2) != 0) {
            d2 = vector4.y;
        }
        if ((n & 4) != 0) {
            d3 = vector4.z;
        }
        if ((n & 8) != 0) {
            d4 = vector4.w;
        }
        return vector4.copy(d, d2, d3, d4);
    }

    @Override
    @NotNull
    public String toString() {
        return "Vector4(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + ")";
    }

    @Override
    public int hashCode() {
        int result2 = Double.hashCode(this.x);
        result2 = result2 * 31 + Double.hashCode(this.y);
        result2 = result2 * 31 + Double.hashCode(this.z);
        result2 = result2 * 31 + Double.hashCode(this.w);
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vector4)) {
            return false;
        }
        Vector4 vector4 = (Vector4)other;
        if (Double.compare(this.x, vector4.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, vector4.y) != 0) {
            return false;
        }
        if (Double.compare(this.z, vector4.z) != 0) {
            return false;
        }
        return Double.compare(this.w, vector4.w) == 0;
    }

    @NotNull
    public Vector4 normalized() {
        return EuclideanVector.DefaultImpls.getNormalized(this);
    }

    @Override
    public double areaBetween(@NotNull Vector4 other) {
        return EuclideanVector.DefaultImpls.areaBetween(this, (EuclideanVector)other);
    }

    @Override
    @NotNull
    public Vector4 projectedOn(@NotNull Vector4 on) {
        return (Vector4)EuclideanVector.DefaultImpls.projectedOn(this, (EuclideanVector)on);
    }

    @Override
    @NotNull
    public Vector4 reflectedOver(@NotNull Vector4 surfaceNormal) {
        return (Vector4)EuclideanVector.DefaultImpls.reflectedOver(this, (EuclideanVector)surfaceNormal);
    }

    @Override
    public double atan2(@NotNull Vector4 other) {
        return EuclideanVector.DefaultImpls.atan2(this, (EuclideanVector)other);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_math(Vector4 self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeDoubleElement(serialDesc, 0, self.x);
        output.encodeDoubleElement(serialDesc, 1, self.y);
        output.encodeDoubleElement(serialDesc, 2, self.z);
        output.encodeDoubleElement(serialDesc, 3, self.w);
    }

    public /* synthetic */ Vector4(int seen0, double x, double y, double z, double w, SerializationConstructorMarker serializationConstructorMarker) {
        if (15 != (0xF & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 15, $serializer.INSTANCE.getDescriptor());
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/openrndr/math/Vector4$Companion;", "", "<init>", "()V", "UNIT_X", "Lorg/openrndr/math/Vector4;", "getUNIT_X", "()Lorg/openrndr/math/Vector4;", "UNIT_Y", "getUNIT_Y", "UNIT_Z", "getUNIT_Z", "UNIT_W", "getUNIT_W", "ZERO", "getZERO", "ONE", "getONE", "INFINITY", "getINFINITY", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-math"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Vector4 getUNIT_X() {
            return UNIT_X;
        }

        @NotNull
        public final Vector4 getUNIT_Y() {
            return UNIT_Y;
        }

        @NotNull
        public final Vector4 getUNIT_Z() {
            return UNIT_Z;
        }

        @NotNull
        public final Vector4 getUNIT_W() {
            return UNIT_W;
        }

        @NotNull
        public final Vector4 getZERO() {
            return ZERO;
        }

        @NotNull
        public final Vector4 getONE() {
            return ONE;
        }

        @NotNull
        public final Vector4 getINFINITY() {
            return INFINITY;
        }

        @NotNull
        public final KSerializer<Vector4> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

