/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Vector4;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\b\u0002\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001H\u0086\u0002\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u001e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0002\u001a\u0010\u0010\t\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\n\u001a\u0010\u0010\u000b\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\n\u00a8\u0006\f"}, d2={"times", "Lorg/openrndr/math/Vector4;", "", "v", "min", "a", "b", "max", "mix", "sum", "", "average", "openrndr-math"})
public final class Vector4Kt {
    @NotNull
    public static final Vector4 times(double $this$times, @NotNull Vector4 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return v.times($this$times);
    }

    @NotNull
    public static final Vector4 min(@NotNull Vector4 a, @NotNull Vector4 b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return new Vector4(Math.min(a.x(), b.x()), Math.min(a.y(), b.y()), Math.min(a.z(), b.z()), Math.min(a.w(), b.w()));
    }

    @NotNull
    public static final Vector4 max(@NotNull Vector4 a, @NotNull Vector4 b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return new Vector4(Math.max(a.x(), b.x()), Math.max(a.y(), b.y()), Math.max(a.z(), b.z()), Math.max(a.w(), b.w()));
    }

    @NotNull
    public static final Vector4 mix(@NotNull Vector4 a, @NotNull Vector4 b, double mix) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return a.times(1.0 - mix).plus(b.times(mix));
    }

    @NotNull
    public static final Vector4 sum(@NotNull Iterable<Vector4> $this$sum) {
        Intrinsics.checkNotNullParameter($this$sum, "<this>");
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double w = 0.0;
        for (Vector4 v : $this$sum) {
            x += v.x();
            y += v.y();
            z += v.z();
            w += v.w();
        }
        return new Vector4(x, y, z, w);
    }

    @NotNull
    public static final Vector4 average(@NotNull Iterable<Vector4> $this$average) {
        Intrinsics.checkNotNullParameter($this$average, "<this>");
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double w = 0.0;
        int count2 = 0;
        for (Vector4 v : $this$average) {
            x += v.x();
            y += v.y();
            z += v.z();
            w += v.w();
            ++count2;
        }
        return new Vector4(x / (double)count2, y / (double)count2, z / (double)count2, w / (double)count2);
    }
}

