/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math.transforms;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Quaternion;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.transforms.TransformsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\b\b\u0002\u0010\u0018\u001a\u00020\rJ\u000e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\rJ \u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\b\b\u0002\u0010\u001c\u001a\u00020\rJ\u000e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0011J\u000e\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0003R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0005\u00a8\u0006\u001f"}, d2={"Lorg/openrndr/math/transforms/TransformBuilder;", "", "baseTransform", "Lorg/openrndr/math/Matrix44;", "<init>", "(Lorg/openrndr/math/Matrix44;)V", "transform", "getTransform", "()Lorg/openrndr/math/Matrix44;", "setTransform", "rotate", "", "degreesInAngles", "", "quaternion", "Lorg/openrndr/math/Quaternion;", "axis", "Lorg/openrndr/math/Vector3;", "degrees", "translate", "offset", "Lorg/openrndr/math/Vector2;", "x", "y", "z", "scale", "scaleX", "scaleY", "scaleZ", "multiply", "matrix", "openrndr-math"})
public final class TransformBuilder {
    @NotNull
    private Matrix44 transform;

    public TransformBuilder(@NotNull Matrix44 baseTransform) {
        Intrinsics.checkNotNullParameter(baseTransform, "baseTransform");
        this.transform = baseTransform;
    }

    public /* synthetic */ TransformBuilder(Matrix44 matrix44, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            matrix44 = Matrix44.Companion.getIDENTITY();
        }
        this(matrix44);
    }

    @NotNull
    public final Matrix44 getTransform() {
        return this.transform;
    }

    public final void setTransform(@NotNull Matrix44 matrix44) {
        Intrinsics.checkNotNullParameter(matrix44, "<set-?>");
        this.transform = matrix44;
    }

    public final void rotate(double degreesInAngles) {
        this.rotate(Vector3.Companion.getUNIT_Z(), degreesInAngles);
    }

    public final void rotate(@NotNull Quaternion quaternion) {
        Intrinsics.checkNotNullParameter(quaternion, "quaternion");
        if (quaternion != Quaternion.Companion.getIDENTITY()) {
            this.transform = this.transform.times(quaternion.matrix().matrix44());
        }
    }

    public final void rotate(@NotNull Vector3 axis, double degrees) {
        Intrinsics.checkNotNullParameter(axis, "axis");
        if (!(degrees == 0.0)) {
            this.transform = this.transform.times(TransformsKt.rotate(Matrix44.Companion, axis, degrees));
        }
    }

    public static /* synthetic */ void rotate$default(TransformBuilder transformBuilder, Vector3 vector3, double d, int n, Object object) {
        if ((n & 1) != 0) {
            vector3 = Vector3.Companion.getUNIT_Z();
        }
        transformBuilder.rotate(vector3, d);
    }

    public final void translate(@NotNull Vector3 offset) {
        Intrinsics.checkNotNullParameter(offset, "offset");
        if (offset != Vector3.Companion.getZERO()) {
            this.transform = this.transform.times(TransformsKt.translate(Matrix44.Companion, offset));
        }
    }

    public final void translate(@NotNull Vector2 offset) {
        Intrinsics.checkNotNullParameter(offset, "offset");
        if (offset != Vector2.Companion.getZERO()) {
            this.transform = this.transform.times(TransformsKt.translate(Matrix44.Companion, offset.xy0()));
        }
    }

    public final void translate(double x, double y, double z) {
        this.transform = this.transform.times(TransformsKt.translate(Matrix44.Companion, new Vector3(x, y, z)));
    }

    public static /* synthetic */ void translate$default(TransformBuilder transformBuilder, double d, double d2, double d3, int n, Object object) {
        if ((n & 4) != 0) {
            d3 = 0.0;
        }
        transformBuilder.translate(d, d2, d3);
    }

    public final void scale(double scale) {
        if (!(scale == 1.0)) {
            this.transform = this.transform.times(TransformsKt.scale(Matrix44.Companion, scale, scale, scale));
        }
    }

    public final void scale(double scaleX, double scaleY, double scaleZ) {
        this.transform = this.transform.times(TransformsKt.scale(Matrix44.Companion, scaleX, scaleY, scaleZ));
    }

    public static /* synthetic */ void scale$default(TransformBuilder transformBuilder, double d, double d2, double d3, int n, Object object) {
        if ((n & 4) != 0) {
            d3 = 1.0;
        }
        transformBuilder.scale(d, d2, d3);
    }

    public final void scale(@NotNull Vector3 scale) {
        Intrinsics.checkNotNullParameter(scale, "scale");
        if (scale != Vector3.Companion.getONE()) {
            this.transform = this.transform.times(TransformsKt.scale(Matrix44.Companion, scale.x(), scale.y(), scale.z()));
        }
    }

    public final void multiply(@NotNull Matrix44 matrix) {
        Intrinsics.checkNotNullParameter(matrix, "matrix");
        this.transform = this.transform.times(matrix);
    }

    public TransformBuilder() {
        this(null, 1, null);
    }
}

