/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math.transforms;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0004\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003\u001a6\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003\u001a6\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003\u001a6\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003\u001a&\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003\u001a6\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003\u001a \u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u0014\u001a\u001a\u0010\u0017\u001a\u00020\u0001*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0003\u001a\u0012\u0010\u001b\u001a\u00020\u0001*\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0003\u001a\u0012\u0010\u001c\u001a\u00020\u0001*\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0003\u001a\u0012\u0010\u001d\u001a\u00020\u0001*\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0003\u001a\u0012\u0010\u001e\u001a\u00020\u0001*\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u0014\u001a\"\u0010\u001e\u001a\u00020\u0001*\u00020\u00182\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003\u001a\u0012\u0010#\u001a\u00020\u0001*\u00020\u00182\u0006\u0010$\u001a\u00020\u0014\u001a\"\u0010#\u001a\u00020\u0001*\u00020\u00182\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003\u001a.\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*\u001a.\u0010,\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*\u001a\u000e\u0010-\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u0001\u00a8\u0006."}, d2={"perspective", "Lorg/openrndr/math/Matrix44;", "fovY", "", "aspectRatio", "zNear", "zFar", "xOffset", "yOffset", "perspectiveHorizontal", "frustum", "left", "right", "bottom", "top", "ortho", "xMag", "yMag", "lookAt", "eye", "Lorg/openrndr/math/Vector3;", "target", "up", "rotate", "Lorg/openrndr/math/Matrix44$Companion;", "axis", "angle", "rotateX", "rotateY", "rotateZ", "translate", "translation", "x", "y", "z", "scale", "scaleFactor", "project", "point", "projection", "view", "width", "", "height", "unproject", "normalMatrix", "openrndr-math"})
@SourceDebugExtension(value={"SMAP\nTransforms.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Transforms.kt\norg/openrndr/math/transforms/TransformsKt\n+ 2 Functions.kt\norg/openrndr/math/FunctionsKt\n*L\n1#1,350:1\n110#2:351\n110#2:352\n110#2:353\n110#2:354\n110#2:355\n110#2:356\n110#2:357\n110#2:358\n*S KotlinDebug\n*F\n+ 1 Transforms.kt\norg/openrndr/math/transforms/TransformsKt\n*L\n25#1:351\n47#1:352\n68#1:353\n85#1:354\n183#1:355\n218#1:356\n236#1:357\n253#1:358\n*E\n"})
public final class TransformsKt {
    @NotNull
    public static final Matrix44 perspective(double fovY, double aspectRatio, double zNear, double zFar) {
        double $this$asRadians$iv = fovY;
        boolean $i$f$getAsRadians = false;
        double y = $this$asRadians$iv * (Math.PI / 180);
        return new Matrix44(1.0 / (aspectRatio * Math.tan(0.5 * y)), 0.0, 0.0, 0.0, 0.0, 1.0 / Math.tan(0.5 * y), 0.0, 0.0, 0.0, 0.0, (zFar + zNear) / (zNear - zFar), (double)2 * zFar * zNear / (zNear - zFar), 0.0, 0.0, -1.0, 0.0);
    }

    @NotNull
    public static final Matrix44 perspective(double fovY, double aspectRatio, double zNear) {
        double $this$asRadians$iv = fovY;
        boolean $i$f$getAsRadians = false;
        double y = $this$asRadians$iv * (Math.PI / 180);
        return new Matrix44(1.0 / (aspectRatio * Math.tan(0.5 * y)), 0.0, 0.0, 0.0, 0.0, 1.0 / Math.tan(0.5 * y), 0.0, 0.0, 0.0, 0.0, -1.0, -2.0 * zNear, 0.0, 0.0, -1.0, 0.0);
    }

    @NotNull
    public static final Matrix44 perspective(double fovY, double aspectRatio, double zNear, double zFar, double xOffset, double yOffset) {
        double $this$asRadians$iv = fovY;
        boolean $i$f$getAsRadians = false;
        double fW = Math.tan($this$asRadians$iv * (Math.PI / 180) / (double)2) * zNear;
        double fH = fW * aspectRatio;
        return TransformsKt.frustum(-fH + xOffset, fH + xOffset, -fW + yOffset, fW + yOffset, zNear, zFar);
    }

    @NotNull
    public static final Matrix44 perspectiveHorizontal(double fovY, double aspectRatio, double zNear, double zFar, double xOffset, double yOffset) {
        double $this$asRadians$iv = fovY;
        boolean $i$f$getAsRadians = false;
        double fW = Math.tan($this$asRadians$iv * (Math.PI / 180) / (double)2) * zNear;
        double fH = fW / aspectRatio;
        return TransformsKt.frustum(-fW + xOffset, fW + xOffset, -fH + yOffset, fH + yOffset, zNear, zFar);
    }

    @NotNull
    public static final Matrix44 frustum(double left, double right, double bottom, double top, double zNear, double zFar) {
        double rl = 1.0 / (right - left);
        double tb = 1.0 / (top - bottom);
        return new Matrix44(zNear * (double)2 * rl, 0.0, 0.0, (right + left) * rl, 0.0, zNear * (double)2 * tb, 0.0, (top + bottom) * tb, 0.0, 0.0, (zFar + zNear) / (zNear - zFar), (double)2 * zFar * zNear / (zNear - zFar), 0.0, 0.0, -1.0, 0.0);
    }

    @NotNull
    public static final Matrix44 ortho(double xMag, double yMag, double zNear, double zFar) {
        return new Matrix44(1.0 / xMag, 0.0, 0.0, 0.0, 0.0, 1.0 / yMag, 0.0, 0.0, 0.0, 0.0, 2.0 / (zNear - zFar), (zFar + zNear) / (zNear - zFar), 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public static final Matrix44 ortho(double left, double right, double bottom, double top, double zNear, double zFar) {
        double tx = -(right + left) / (right - left);
        double ty = -(top + bottom) / (top - bottom);
        double tz = -(zFar + zNear) / (zFar - zNear);
        return new Matrix44(2.0 / (right - left), 0.0, 0.0, tx, 0.0, 2.0 / (top - bottom), 0.0, ty, 0.0, 0.0, -2.0 / (zFar - zNear), tz, 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public static final Matrix44 lookAt(@NotNull Vector3 eye, @NotNull Vector3 target, @NotNull Vector3 up) {
        Intrinsics.checkNotNullParameter(eye, "eye");
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(up, "up");
        Vector3 f = (Vector3)target.minus(eye).getNormalized();
        Vector3 u = (Vector3)up.getNormalized();
        Vector3 s = (Vector3)f.cross(u).getNormalized();
        u = s.cross(f);
        return new Matrix44(s.x(), s.y(), s.z(), -s.dot(eye), u.x(), u.y(), u.z(), -u.dot(eye), -f.x(), -f.y(), -f.z(), f.dot(eye), 0.0, 0.0, 0.0, 1.0);
    }

    public static /* synthetic */ Matrix44 lookAt$default(Vector3 vector3, Vector3 vector32, Vector3 vector33, int n, Object object) {
        if ((n & 4) != 0) {
            vector33 = Vector3.Companion.getUNIT_Y();
        }
        return TransformsKt.lookAt(vector3, vector32, vector33);
    }

    @NotNull
    public static final Matrix44 rotate(@NotNull Matrix44.Companion $this$rotate, @NotNull Vector3 axis, double angle) {
        Intrinsics.checkNotNullParameter($this$rotate, "<this>");
        Intrinsics.checkNotNullParameter(axis, "axis");
        double $this$asRadians$iv = angle;
        boolean $i$f$getAsRadians = false;
        double r = $this$asRadians$iv * (Math.PI / 180);
        double cosa = Math.cos(r);
        double sina = Math.sin(r);
        Vector3 _axis = (Vector3)axis.getNormalized();
        return new Matrix44(cosa + (1.0 - cosa) * _axis.x() * _axis.x(), (1.0 - cosa) * _axis.x() * _axis.y() - _axis.z() * sina, (1.0 - cosa) * _axis.x() * _axis.z() + _axis.y() * sina, 0.0, (1.0 - cosa) * _axis.x() * _axis.y() + _axis.z() * sina, cosa + (1.0 - cosa) * _axis.y() * _axis.y(), (1.0 - cosa) * _axis.y() * _axis.z() - _axis.x() * sina, 0.0, (1.0 - cosa) * _axis.x() * _axis.z() - _axis.y() * sina, (1.0 - cosa) * _axis.y() * _axis.z() + _axis.x() * sina, cosa + (1.0 - cosa) * _axis.z() * _axis.z(), 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public static final Matrix44 rotateX(@NotNull Matrix44.Companion $this$rotateX, double angle) {
        Intrinsics.checkNotNullParameter($this$rotateX, "<this>");
        double $this$asRadians$iv = angle;
        boolean $i$f$getAsRadians = false;
        double r = $this$asRadians$iv * (Math.PI / 180);
        double cr = Math.cos(r);
        double sr = Math.sin(r);
        return new Matrix44(1.0, 0.0, 0.0, 0.0, 0.0, cr, -sr, 0.0, 0.0, sr, cr, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public static final Matrix44 rotateY(@NotNull Matrix44.Companion $this$rotateY, double angle) {
        Intrinsics.checkNotNullParameter($this$rotateY, "<this>");
        double $this$asRadians$iv = angle;
        boolean $i$f$getAsRadians = false;
        double r = $this$asRadians$iv * (Math.PI / 180);
        double cr = Math.cos(r);
        double sr = Math.sin(r);
        return new Matrix44(cr, 0.0, sr, 0.0, 0.0, 1.0, 0.0, 0.0, -sr, 0.0, cr, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public static final Matrix44 rotateZ(@NotNull Matrix44.Companion $this$rotateZ, double angle) {
        Intrinsics.checkNotNullParameter($this$rotateZ, "<this>");
        double $this$asRadians$iv = angle;
        boolean $i$f$getAsRadians = false;
        double r = $this$asRadians$iv * (Math.PI / 180);
        double cr = Math.cos(r);
        double sr = Math.sin(r);
        return new Matrix44(cr, -sr, 0.0, 0.0, sr, cr, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public static final Matrix44 translate(@NotNull Matrix44.Companion $this$translate, @NotNull Vector3 translation) {
        Intrinsics.checkNotNullParameter($this$translate, "<this>");
        Intrinsics.checkNotNullParameter(translation, "translation");
        return TransformsKt.translate($this$translate, translation.x(), translation.y(), translation.z());
    }

    @NotNull
    public static final Matrix44 translate(@NotNull Matrix44.Companion $this$translate, double x, double y, double z) {
        Intrinsics.checkNotNullParameter($this$translate, "<this>");
        return Matrix44.Companion.fromColumnVectors(Vector4.Companion.getUNIT_X(), Vector4.Companion.getUNIT_Y(), Vector4.Companion.getUNIT_Z(), new Vector4(x, y, z, 1.0));
    }

    @NotNull
    public static final Matrix44 scale(@NotNull Matrix44.Companion $this$scale, @NotNull Vector3 scaleFactor) {
        Intrinsics.checkNotNullParameter($this$scale, "<this>");
        Intrinsics.checkNotNullParameter(scaleFactor, "scaleFactor");
        return TransformsKt.scale($this$scale, scaleFactor.x(), scaleFactor.y(), scaleFactor.z());
    }

    @NotNull
    public static final Matrix44 scale(@NotNull Matrix44.Companion $this$scale, double x, double y, double z) {
        Intrinsics.checkNotNullParameter($this$scale, "<this>");
        return new Matrix44(x, 0.0, 0.0, 0.0, 0.0, y, 0.0, 0.0, 0.0, 0.0, z, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public static final Vector3 project(@NotNull Vector3 point, @NotNull Matrix44 projection, @NotNull Matrix44 view, int width, int height) {
        Intrinsics.checkNotNullParameter(point, "point");
        Intrinsics.checkNotNullParameter(projection, "projection");
        Intrinsics.checkNotNullParameter(view, "view");
        Vector3 projected = projection.times(view).times(point.xyz1()).div();
        return new Vector3((projected.x() + 1.0) * (double)width / (double)2, (1.0 - projected.y()) * (double)height / (double)2, (projected.z() + 1.0) / 2.0);
    }

    @NotNull
    public static final Vector3 unproject(@NotNull Vector3 point, @NotNull Matrix44 projection, @NotNull Matrix44 view, int width, int height) {
        Intrinsics.checkNotNullParameter(point, "point");
        Intrinsics.checkNotNullParameter(projection, "projection");
        Intrinsics.checkNotNullParameter(view, "view");
        Matrix44 ipm = projection.times(view).inversed();
        Vector3 v = new Vector3((double)2 * point.x() / (double)width - 1.0, (double)2 * point.y() / (double)height - 1.0, (double)2 * point.z() - 1.0);
        return ipm.times(v.xyz1()).div();
    }

    @NotNull
    public static final Matrix44 normalMatrix(@NotNull Matrix44 view) {
        Intrinsics.checkNotNullParameter(view, "view");
        Matrix44 subView = new Matrix44(view.c0r0(), view.c1r0(), view.c2r0(), 0.0, view.c0r1(), view.c1r1(), view.c2r1(), 0.0, view.c0r2(), view.c1r2(), view.c2r2(), 0.0, 0.0, 0.0, 0.0, 1.0);
        return Matrix44.copy$default(subView.inversed().transposed(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Short.MAX_VALUE, null);
    }
}

