/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.openal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openal.AL11;
import org.openrndr.openal.AudioBuffer;
import org.openrndr.openal.AudioData;
import org.openrndr.openal.AudioPlayerKt;
import org.openrndr.openal.AudioSource;
import org.openrndr.openal.Queue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\f\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u0012\b\u0002\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bJ\u0006\u0010!\u001a\u00020\u0014J\u0006\u0010\"\u001a\u00020\u0014J\u0006\u0010#\u001a\u00020\u0014J\u0006\u0010$\u001a\u00020\u0014J\u0006\u0010%\u001a\u00020\u0014J\u0006\u0010&\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00120\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001e\u00a8\u0006'"}, d2={"Lorg/openrndr/openal/AudioQueueSource;", "Lorg/openrndr/openal/AudioSource;", "source", "", "bufferCount", "queueSize", "pullFunction", "Lkotlin/Function0;", "Lorg/openrndr/openal/AudioData;", "<init>", "(IIILkotlin/jvm/functions/Function0;)V", "getQueueSize", "()I", "inputQueue", "Lorg/openrndr/openal/Queue;", "queued", "outputQueue", "", "Lkotlin/Pair;", "queue", "", "data", "outputQueueFull", "", "getOutputQueueFull", "()Z", "value", "", "bufferOffset", "getBufferOffset", "()J", "sampleOffset", "getSampleOffset", "play", "stop", "pause", "flush", "resume", "dispose", "openrndr-openal"})
public final class AudioQueueSource
extends AudioSource {
    private final int bufferCount;
    private final int queueSize;
    @Nullable
    private final Function0<AudioData> pullFunction;
    @NotNull
    private final Queue<AudioData> inputQueue;
    private int queued;
    @NotNull
    private List<Pair<Integer, Integer>> outputQueue;
    private long bufferOffset;

    public AudioQueueSource(int source, int bufferCount, int queueSize, @Nullable Function0<AudioData> pullFunction) {
        super(source);
        this.bufferCount = bufferCount;
        this.queueSize = queueSize;
        this.pullFunction = pullFunction;
        this.inputQueue = new Queue(this.queueSize);
        this.outputQueue = new ArrayList();
    }

    public /* synthetic */ AudioQueueSource(int n, int n2, int n3, Function0 function0, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n2 = 2;
        }
        if ((n4 & 4) != 0) {
            n3 = 20;
        }
        if ((n4 & 8) != 0) {
            function0 = null;
        }
        this(n, n2, n3, function0);
    }

    public final int getQueueSize() {
        return this.queueSize;
    }

    public final void queue(@NotNull AudioData data) {
        Intrinsics.checkNotNullParameter(data, "data");
        this.inputQueue.push(data);
    }

    public final boolean getOutputQueueFull() {
        return this.outputQueue.size() >= this.queueSize - 1;
    }

    public final long getBufferOffset() {
        return this.bufferOffset;
    }

    public final long getSampleOffset() {
        return this.bufferOffset + (long)AL11.alGetSourcei(this.getSource(), 4133);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void play() {
        int startBufferCount = Math.min(this.bufferCount, this.inputQueue.size());
        for (int i = 0; i < startBufferCount; ++i) {
            AudioData data = this.inputQueue.pop();
            AudioBuffer buffer = data.createBuffer();
            AL11.alSourcef(this.getSource(), 4099, 1.0f);
            List<Pair<Integer, Integer>> list = this.outputQueue;
            synchronized (list) {
                boolean bl = false;
                AL11.alSourceQueueBuffers(this.getSource(), buffer.getBuffer());
                this.outputQueue.add(new Pair<Integer, Integer>(buffer.getBuffer(), data.getBuffer().capacity() / 4));
                int n = this.queued;
                this.queued = n + 1;
                int n2 = n;
                continue;
            }
        }
        AL11.alSourcePlay(this.getSource());
        ThreadsKt.thread$default(false, true, null, null, 0, () -> AudioQueueSource.play$lambda$5(this), 29, null);
    }

    public final void stop() {
        this.flush();
    }

    public final void pause() {
        AL11.alSourcePause(this.getSource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        while (!this.inputQueue.isEmpty()) {
            this.inputQueue.pop();
        }
        AL11.alSourceStop(this.getSource());
        List<Pair<Integer, Integer>> list = this.outputQueue;
        synchronized (list) {
            boolean bl = false;
            for (Pair<Integer, Integer> i : this.outputQueue) {
                AL11.alDeleteBuffers(((Number)i.getFirst()).intValue());
            }
            this.outputQueue.clear();
            Unit unit = Unit.INSTANCE;
        }
        this.bufferOffset = 0L;
        this.queued = 0;
    }

    public final void resume() {
        AL11.alSourcePlay(this.getSource());
    }

    public final void dispose() {
        this.flush();
        AL11.alDeleteSources(this.getSource());
    }

    private static final Object play$lambda$5$lambda$1() {
        return "audio buffer underrun detected";
    }

    private static final Object play$lambda$5$lambda$4() {
        return "restarting play";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit play$lambda$5(AudioQueueSource this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        boolean playing = true;
        while (true) {
            List<Pair<Integer, Integer>> list;
            if (this$0.inputQueue.size() < this$0.inputQueue.getMaxSize() - 1) {
                AudioData data;
                Function0<AudioData> function0 = this$0.pullFunction;
                AudioData audioData = data = function0 != null ? function0.invoke() : null;
                if (data != null) {
                    this$0.inputQueue.push(data);
                }
            }
            if (this$0.queued == 0) {
                boolean observation;
                boolean bl = observation = AL11.alGetSourcei(this$0.getSource(), 4112) == 4114;
                if (!observation && playing) {
                    AudioPlayerKt.access$getLogger$p().debug(AudioQueueSource::play$lambda$5$lambda$1);
                    playing = false;
                }
            }
            int buffersProcessed = AL11.alGetSourcei(this$0.getSource(), 4118);
            this$0.queued -= buffersProcessed;
            this$0.queued = RangesKt.coerceAtLeast(this$0.queued, 0);
            for (int i = 0; i < buffersProcessed; ++i) {
                int unqueue = AL11.alSourceUnqueueBuffers(this$0.getSource());
                list = this$0.outputQueue;
                synchronized (list) {
                    boolean $i$a$-synchronized-AudioQueueSource$play$2$42 = false;
                    if (!((Collection)this$0.outputQueue).isEmpty()) {
                        AL11.alDeleteBuffers(unqueue);
                        if (unqueue == ((Number)this$0.outputQueue.get(0).getFirst()).intValue()) {
                            this$0.bufferOffset += ((Number)this$0.outputQueue.get(0).getSecond()).longValue();
                            this$0.outputQueue.remove(0);
                        }
                    }
                    Unit $i$a$-synchronized-AudioQueueSource$play$2$42 = Unit.INSTANCE;
                    continue;
                }
            }
            while (this$0.queued <= this$0.bufferCount && !this$0.inputQueue.isEmpty()) {
                AudioData data = this$0.inputQueue.pop();
                AudioBuffer buffer = data.createBuffer();
                list = this$0.outputQueue;
                synchronized (list) {
                    boolean bl = false;
                    this$0.outputQueue.add(new Pair<Integer, Integer>(buffer.getBuffer(), data.getBuffer().capacity() / 4));
                    AL11.alSourceQueueBuffers(this$0.getSource(), buffer.getBuffer());
                    int n = this$0.queued;
                    this$0.queued = n + 1;
                    int n2 = n;
                }
            }
            if (!playing && this$0.queued > 0) {
                AudioPlayerKt.access$getLogger$p().debug(AudioQueueSource::play$lambda$5$lambda$4);
                playing = true;
                AL11.alSourcePlay(this$0.getSource());
            }
            Thread.sleep(0L);
        }
    }
}

