/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.panel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.CharacterEvent;
import org.openrndr.DropEvent;
import org.openrndr.Extension;
import org.openrndr.KeyEvent;
import org.openrndr.KeyModifier;
import org.openrndr.MouseButton;
import org.openrndr.MouseEvent;
import org.openrndr.MouseEventType;
import org.openrndr.PresentationMode;
import org.openrndr.Program;
import org.openrndr.ResourceUrlKt;
import org.openrndr.Window;
import org.openrndr.WindowEvent;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BlendMode;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.DepthBuffer;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetBuilder;
import org.openrndr.draw.RenderTargetKt;
import org.openrndr.draw.TextSettingMode;
import org.openrndr.events.Event;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.panel.ControlManagerKt;
import org.openrndr.panel.FontManager;
import org.openrndr.panel.collections.ObservableHashSet;
import org.openrndr.panel.elements.Element;
import org.openrndr.panel.elements.ElementKt;
import org.openrndr.panel.elements.ElementPseudoClass;
import org.openrndr.panel.elements.FocusEvent;
import org.openrndr.panel.layout.Layouter;
import org.openrndr.panel.style.CompoundSelector;
import org.openrndr.panel.style.DefaultStylesKt;
import org.openrndr.panel.style.Display;
import org.openrndr.panel.style.Overflow;
import org.openrndr.panel.style.StyleSheet;
import org.openrndr.panel.style.StyleSheetKt;
import org.openrndr.panel.style.ZIndex;
import org.openrndr.shape.Rectangle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0004]^_`B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010:\u001a\u00020;J\u0010\u0010@\u001a\u00020;2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010J\u001a\u00020;2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010A\u001a\u00020B2\u0006\u0010G\u001a\u00020BH\u0002J(\u0010K\u001a\u00020;2\u0006\u0010L\u001a\u00020\u00052\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020B2\u0006\u0010P\u001a\u00020BH\u0002J\u001e\u0010U\u001a\u00020;2\u0006\u0010V\u001a\u00020S2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020;0XH\u0002J\u0018\u0010\\\u001a\u00020;2\u0006\u0010M\u001a\u00020N2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001c\u0010-\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0015\u00102\u001a\u000603R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0015\u00106\u001a\u000607R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0015\u0010<\u001a\u00060=R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u001a\u0010A\u001a\u00020BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u001a\u0010G\u001a\u00020BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010D\"\u0004\bI\u0010FR\u001a\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020S\u0012\u0004\u0012\u00020T0RX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010Y\u001a\u00020BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u0010D\"\u0004\b[\u0010F\u00a8\u0006a"}, d2={"Lorg/openrndr/panel/ControlManager;", "Lorg/openrndr/Extension;", "<init>", "()V", "body", "Lorg/openrndr/panel/elements/Element;", "getBody", "()Lorg/openrndr/panel/elements/Element;", "setBody", "(Lorg/openrndr/panel/elements/Element;)V", "layouter", "Lorg/openrndr/panel/layout/Layouter;", "getLayouter", "()Lorg/openrndr/panel/layout/Layouter;", "fontManager", "Lorg/openrndr/panel/FontManager;", "getFontManager", "()Lorg/openrndr/panel/FontManager;", "window", "Lorg/openrndr/Window;", "getWindow", "()Lorg/openrndr/Window;", "setWindow", "(Lorg/openrndr/Window;)V", "renderTargetCache", "Ljava/util/HashMap;", "Lorg/openrndr/draw/RenderTarget;", "program", "Lorg/openrndr/Program;", "getProgram", "()Lorg/openrndr/Program;", "setProgram", "(Lorg/openrndr/Program;)V", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "contentScale", "", "getContentScale", "()D", "setContentScale", "(D)V", "renderTarget", "getRenderTarget", "()Lorg/openrndr/draw/RenderTarget;", "setRenderTarget", "(Lorg/openrndr/draw/RenderTarget;)V", "dropInput", "Lorg/openrndr/panel/ControlManager$DropInput;", "getDropInput", "()Lorg/openrndr/panel/ControlManager$DropInput;", "keyboardInput", "Lorg/openrndr/panel/ControlManager$KeyboardInput;", "getKeyboardInput", "()Lorg/openrndr/panel/ControlManager$KeyboardInput;", "checkForManualRedraw", "", "mouseInput", "Lorg/openrndr/panel/ControlManager$MouseInput;", "getMouseInput", "()Lorg/openrndr/panel/ControlManager$MouseInput;", "setup", "width", "", "getWidth", "()I", "setWidth", "(I)V", "height", "getHeight", "setHeight", "resize", "drawElement", "element", "drawer", "Lorg/openrndr/draw/Drawer;", "zIndex", "zComp", "profiles", "", "", "Lorg/openrndr/panel/ControlManager$ProfileData;", "profile", "name", "f", "Lkotlin/Function0;", "drawCount", "getDrawCount", "setDrawCount", "afterDraw", "DropInput", "KeyboardInput", "MouseInput", "ProfileData", "orx-panel"})
@SourceDebugExtension(value={"SMAP\nControlManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlManager.kt\norg/openrndr/panel/ControlManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,557:1\n1368#2:558\n1454#2,5:559\n1863#2,2:566\n1863#2,2:568\n216#3,2:564\n381#4,7:570\n*S KotlinDebug\n*F\n+ 1 ControlManager.kt\norg/openrndr/panel/ControlManager\n*L\n32#1:558\n32#1:559,5\n360#1:566,2\n377#1:568,2\n337#1:564,2\n412#1:570,7\n*E\n"})
public final class ControlManager
implements Extension {
    @Nullable
    private Element body;
    @NotNull
    private final Layouter layouter = new Layouter();
    @NotNull
    private final FontManager fontManager = new FontManager();
    public Window window;
    @NotNull
    private final HashMap<Element, RenderTarget> renderTargetCache = new HashMap();
    public Program program;
    private boolean enabled = true;
    private double contentScale = 1.0;
    @Nullable
    private RenderTarget renderTarget;
    @NotNull
    private final DropInput dropInput;
    @NotNull
    private final KeyboardInput keyboardInput;
    @NotNull
    private final MouseInput mouseInput;
    private int width;
    private int height;
    @NotNull
    private final Map<String, ProfileData> profiles;
    private int drawCount;

    /*
     * WARNING - void declaration
     */
    public ControlManager() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        this.fontManager.register("default", ResourceUrlKt.resourceUrl$default("/fonts/Roboto-Regular.ttf", null, 2, null));
        Iterable iterable = DefaultStylesKt.defaultStyles$default(null, null, null, null, 0.0, 31, null);
        ArrayList<StyleSheet> arrayList = this.layouter.getStyleSheets();
        boolean $i$f$flatMap = false;
        void var3_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            StyleSheet it = (StyleSheet)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = StyleSheetKt.flatten(it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        arrayList.addAll((List)destination$iv$iv);
        this.dropInput = new DropInput();
        this.keyboardInput = new KeyboardInput();
        this.mouseInput = new MouseInput();
        this.profiles = new LinkedHashMap();
    }

    @Nullable
    public final Element getBody() {
        return this.body;
    }

    public final void setBody(@Nullable Element element) {
        this.body = element;
    }

    @NotNull
    public final Layouter getLayouter() {
        return this.layouter;
    }

    @NotNull
    public final FontManager getFontManager() {
        return this.fontManager;
    }

    @NotNull
    public final Window getWindow() {
        Window window2 = this.window;
        if (window2 != null) {
            return window2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("window");
        return null;
    }

    public final void setWindow(@NotNull Window window2) {
        Intrinsics.checkNotNullParameter(window2, "<set-?>");
        this.window = window2;
    }

    @NotNull
    public final Program getProgram() {
        Program program2 = this.program;
        if (program2 != null) {
            return program2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("program");
        return null;
    }

    public final void setProgram(@NotNull Program program2) {
        Intrinsics.checkNotNullParameter(program2, "<set-?>");
        this.program = program2;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public final double getContentScale() {
        return this.contentScale;
    }

    public final void setContentScale(double d) {
        this.contentScale = d;
    }

    @Nullable
    public final RenderTarget getRenderTarget() {
        return this.renderTarget;
    }

    public final void setRenderTarget(@Nullable RenderTarget renderTarget) {
        this.renderTarget = renderTarget;
    }

    @NotNull
    public final DropInput getDropInput() {
        return this.dropInput;
    }

    @NotNull
    public final KeyboardInput getKeyboardInput() {
        return this.keyboardInput;
    }

    public final void checkForManualRedraw() {
        if (this.getWindow().getPresentationMode() == PresentationMode.MANUAL) {
            boolean redraw;
            Element element = this.body;
            boolean bl = redraw = element != null ? ControlManagerKt.access$any(element, ControlManager::checkForManualRedraw$lambda$1) : false;
            if (redraw) {
                this.getWindow().requestDraw();
            }
        }
    }

    @NotNull
    public final MouseInput getMouseInput() {
        return this.mouseInput;
    }

    @Override
    public void setup(@NotNull Program program2) {
        block0: {
            Intrinsics.checkNotNullParameter(program2, "program");
            this.setProgram(program2);
            this.contentScale = program2.getWindow().getContentScale();
            this.setWindow(program2.getWindow());
            this.fontManager.setContentScale(this.contentScale);
            program2.getMouse().getButtonUp().listen(arg_0 -> ControlManager.setup$lambda$2(this, arg_0));
            program2.getMouse().getMoved().listen(arg_0 -> ControlManager.setup$lambda$3(this, arg_0));
            program2.getMouse().getScrolled().listen(arg_0 -> ControlManager.setup$lambda$4(this, arg_0));
            program2.getMouse().getDragged().listen(arg_0 -> ControlManager.setup$lambda$5(this, arg_0));
            program2.getMouse().getButtonDown().listen(arg_0 -> ControlManager.setup$lambda$6(this, arg_0));
            program2.getKeyboard().getKeyDown().listen(arg_0 -> ControlManager.setup$lambda$7(this, arg_0));
            program2.getKeyboard().getKeyUp().listen(arg_0 -> ControlManager.setup$lambda$8(this, arg_0));
            program2.getKeyboard().getKeyRepeat().listen(arg_0 -> ControlManager.setup$lambda$9(this, arg_0));
            program2.getKeyboard().getCharacter().listen(arg_0 -> ControlManager.setup$lambda$10(this, arg_0));
            program2.getWindow().getDrop().listen(arg_0 -> ControlManager.setup$lambda$11(this, arg_0));
            program2.getWindow().getSized().listen(arg_0 -> ControlManager.setup$lambda$12(this, program2, arg_0));
            this.width = program2.getWidth();
            this.height = program2.getHeight();
            Object object = this.body;
            if (object == null || (object = ((Element)object).getDraw()) == null) break block0;
            ((Element.Draw)object).setDirty(true);
        }
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int n) {
        this.width = n;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int n) {
        this.height = n;
    }

    private final void resize(Program program2, int width, int height) {
        this.width = width;
        this.height = height;
        if (width > 0 && height > 0) {
            Object object = this.body;
            if (object != null && (object = ((Element)object).getDraw()) != null) {
                ((Element.Draw)object).setDirty(true);
            }
            RenderTarget lrc = this.renderTarget;
            if (lrc != null) {
                if (!((Collection)lrc.getColorAttachments()).isEmpty()) {
                    lrc.colorBuffer(0).destroy();
                    DepthBuffer depthBuffer = lrc.getDepthBuffer();
                    if (depthBuffer != null) {
                        depthBuffer.destroy();
                    }
                    lrc.detachColorAttachments();
                    lrc.detachDepthBuffer();
                    lrc.destroy();
                } else {
                    ControlManagerKt.access$getLogger$p().error(ControlManager::resize$lambda$13);
                }
            }
            RenderTarget renderTarget = this.renderTarget = RenderTargetKt.renderTarget$default(program2.getWidth(), program2.getHeight(), this.contentScale, null, null, ControlManager::resize$lambda$14, 24, null);
            if (renderTarget != null) {
                renderTarget.bind();
            }
            program2.getDrawer().clear(ColorRGBa.Companion.getBLACK().opacify(0.0));
            RenderTarget renderTarget2 = this.renderTarget;
            if (renderTarget2 != null) {
                renderTarget2.unbind();
            }
            Map $this$forEach$iv = this.renderTargetCache;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl = false;
                RenderTarget u = (RenderTarget)entry.getValue();
                u.destroy();
            }
            this.renderTargetCache.clear();
        }
    }

    private final void drawElement(Element element, Drawer drawer, int zIndex, int zComp) {
        ZIndex it = StyleSheetKt.getZIndex(element.getComputedStyle());
        boolean bl = false;
        int newZComp = it instanceof ZIndex.Value ? ((ZIndex.Value)it).getValue() : zComp;
        if (StyleSheetKt.getDisplay(element.getComputedStyle()) != Display.NONE) {
            if (Intrinsics.areEqual(StyleSheetKt.getOverflow(element.getComputedStyle()), Overflow.Visible.INSTANCE)) {
                DrawerKt.isolated(drawer, arg_0 -> ControlManager.drawElement$lambda$17(drawer, element, newZComp, zIndex, arg_0));
                Iterable $this$forEach$iv = element.getChildren();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Element it2 = (Element)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull(it2);
                    this.drawElement(it2, drawer, zIndex, newZComp);
                }
            } else {
                Rectangle area = element.getScreenArea();
                RenderTarget renderTarget = this.renderTargetCache.computeIfAbsent(element, arg_0 -> ControlManager.drawElement$lambda$21(arg_0 -> ControlManager.drawElement$lambda$20(this, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue(renderTarget, "computeIfAbsent(...)");
                RenderTarget rt = renderTarget;
                rt.bind();
                drawer.clear(ColorRGBa.Companion.getBLACK().opacify(0.0));
                drawer.pushProjection();
                drawer.ortho(rt);
                Iterable $this$forEach$iv = element.getChildren();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Element it3 = (Element)element$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull(it3);
                    this.drawElement(it3, drawer, zIndex, newZComp);
                }
                rt.unbind();
                drawer.popProjection();
                drawer.pushTransforms();
                drawer.pushStyle();
                Drawer.translate$default(drawer, element.getScreenPosition(), null, 2, null);
                if (newZComp == zIndex) {
                    element.draw(drawer);
                }
                drawer.popStyle();
                drawer.popTransforms();
                drawer.getDrawStyle().setBlendMode(BlendMode.OVER);
                drawer.image(rt.colorBuffer(0), new Rectangle(new Vector2(area.x(), area.y()), area.width(), area.height()), new Rectangle(new Vector2(area.x(), area.y()), area.width(), area.height()));
            }
        }
        element.getDraw().setDirty(false);
    }

    private final void profile(String name, Function0<Unit> f) {
        ProfileData profileData;
        long start = System.currentTimeMillis();
        f.invoke();
        long end = System.currentTimeMillis();
        Map<String, ProfileData> $this$getOrPut$iv = this.profiles;
        boolean $i$f$getOrPut = false;
        ProfileData value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            boolean bl = false;
            ProfileData answer$iv = new ProfileData(0, 0L);
            $this$getOrPut$iv.put(name, answer$iv);
            profileData = answer$iv;
        } else {
            profileData = value$iv;
        }
        ProfileData pd = profileData;
        int n = pd.getHits();
        pd.setHits(n + 1);
        pd.setTime(pd.getTime() + (end - start));
        if (pd.getHits() == 100) {
            pd.setHits(0);
            pd.setTime(0L);
        }
    }

    public final int getDrawCount() {
        return this.drawCount;
    }

    public final void setDrawCount(int n) {
        this.drawCount = n;
    }

    @Override
    public void afterDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        block14: {
            boolean redraw;
            block16: {
                Object object;
                Object object2;
                block15: {
                    Intrinsics.checkNotNullParameter(drawer, "drawer");
                    Intrinsics.checkNotNullParameter(program2, "program");
                    if (program2.getWidth() <= 0 || program2.getHeight() <= 0) break block14;
                    RenderTarget renderTarget = this.renderTarget;
                    boolean bl = renderTarget != null ? program2.getWidth() == renderTarget.getWidth() : false;
                    if (!bl) break block15;
                    renderTarget = this.renderTarget;
                    if (renderTarget != null ? program2.getHeight() == renderTarget.getHeight() : false) break block16;
                }
                if ((object2 = this.body) != null && (object2 = ((Element)object2).getDraw()) != null) {
                    ((Element.Draw)object2).setDirty(true);
                }
                if ((object = this.renderTarget) != null && (object = object.colorBuffer(0)) != null) {
                    ((ColorBuffer)object).destroy();
                }
                RenderTarget renderTarget = this.renderTarget;
                if (renderTarget != null) {
                    renderTarget.destroy();
                }
                this.renderTarget = null;
            }
            if (this.renderTarget == null) {
                RenderTarget renderTarget = this.renderTarget = RenderTargetKt.renderTarget$default(program2.getWidth(), program2.getHeight(), this.contentScale, null, null, ControlManager::afterDraw$lambda$24, 24, null);
                Intrinsics.checkNotNull(renderTarget);
                renderTarget.bind();
                program2.getDrawer().clear(ColorRGBa.Companion.getBLACK().opacify(0.0));
                RenderTarget renderTarget2 = this.renderTarget;
                Intrinsics.checkNotNull(renderTarget2);
                renderTarget2.unbind();
            }
            Element element = this.body;
            boolean bl = redraw = element != null ? ControlManagerKt.access$any(element, ControlManager::afterDraw$lambda$25) : false;
            if (redraw) {
                Object object;
                Object object3;
                drawer.ortho();
                drawer.setView(Matrix44.Companion.getIDENTITY());
                drawer.defaults();
                RenderTarget renderTarget = this.renderTarget;
                Intrinsics.checkNotNull(renderTarget);
                renderTarget.bind();
                Element element2 = this.body;
                if (element2 != null) {
                    element2.setStyle(new StyleSheet(new CompoundSelector()));
                }
                if ((object3 = this.body) != null && (object3 = ((Element)object3).getStyle()) != null) {
                    StyleSheetKt.setWidth((StyleSheet)object3, StyleSheetKt.getPx(program2.getWidth()));
                }
                if ((object = this.body) != null && (object = ((Element)object).getStyle()) != null) {
                    StyleSheetKt.setHeight((StyleSheet)object, StyleSheetKt.getPx(program2.getHeight()));
                }
                Element element3 = this.body;
                if (element3 != null) {
                    Element it = element3;
                    boolean bl2 = false;
                    program2.getDrawer().clear(ColorRGBa.Companion.getBLACK().opacify(0.0));
                    this.layouter.computeStyles(it);
                    this.layouter.layout(it);
                    this.drawElement(it, program2.getDrawer(), 0, 0);
                    this.drawElement(it, program2.getDrawer(), 1, 0);
                    this.drawElement(it, program2.getDrawer(), 1000, 0);
                }
                RenderTarget renderTarget3 = this.renderTarget;
                Intrinsics.checkNotNull(renderTarget3);
                renderTarget3.unbind();
            }
            Element element4 = this.body;
            if (element4 != null) {
                ElementKt.visit(element4, ControlManager::afterDraw$lambda$27);
            }
            drawer.ortho(RenderTarget.Companion.getActive());
            drawer.setView(Matrix44.Companion.getIDENTITY());
            drawer.defaults();
            Drawer drawer2 = program2.getDrawer();
            RenderTarget renderTarget = this.renderTarget;
            Intrinsics.checkNotNull(renderTarget);
            Drawer.image$default(drawer2, renderTarget.colorBuffer(0), 0.0, 0.0, 0.0, 0.0, 24, null);
            int n = this.drawCount;
            this.drawCount = n + 1;
        }
    }

    @Override
    public void beforeDraw(@NotNull Drawer drawer, @NotNull Program program2) {
        Extension.DefaultImpls.beforeDraw(this, drawer, program2);
    }

    @Override
    public void shutdown(@NotNull Program program2) {
        Extension.DefaultImpls.shutdown(this, program2);
    }

    private static final boolean checkForManualRedraw$lambda$1(Element it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getDraw().getDirty();
    }

    private static final Unit setup$lambda$2(ControlManager this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.mouseInput.click(it);
        return Unit.INSTANCE;
    }

    private static final Unit setup$lambda$3(ControlManager this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.mouseInput.move(it);
        return Unit.INSTANCE;
    }

    private static final Unit setup$lambda$4(ControlManager this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.mouseInput.scroll(it);
        return Unit.INSTANCE;
    }

    private static final Unit setup$lambda$5(ControlManager this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.mouseInput.drag(it);
        return Unit.INSTANCE;
    }

    private static final Unit setup$lambda$6(ControlManager this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.mouseInput.press(it);
        return Unit.INSTANCE;
    }

    private static final Unit setup$lambda$7(ControlManager this$0, KeyEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.keyboardInput.press(it);
        return Unit.INSTANCE;
    }

    private static final Unit setup$lambda$8(ControlManager this$0, KeyEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.keyboardInput.release(it);
        return Unit.INSTANCE;
    }

    private static final Unit setup$lambda$9(ControlManager this$0, KeyEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.keyboardInput.repeat(it);
        return Unit.INSTANCE;
    }

    private static final Unit setup$lambda$10(ControlManager this$0, CharacterEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.keyboardInput.character(it);
        return Unit.INSTANCE;
    }

    private static final Unit setup$lambda$11(ControlManager this$0, DropEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.dropInput.drop(it);
        return Unit.INSTANCE;
    }

    private static final Unit setup$lambda$12(ControlManager this$0, Program $program, WindowEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($program, "$program");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.resize($program, (int)it.size().x(), (int)it.size().y());
        return Unit.INSTANCE;
    }

    private static final Object resize$lambda$13() {
        return "that is strange. no color buffers";
    }

    private static final Unit resize$lambda$14(RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter($this$renderTarget, "$this$renderTarget");
        RenderTargetBuilder.colorBuffer$default($this$renderTarget, null, null, 3, null);
        RenderTargetBuilder.depthBuffer$default($this$renderTarget, null, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit drawElement$lambda$17(Drawer $drawer, Element $element, int $newZComp, int $zIndex, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter($drawer, "$drawer");
        Intrinsics.checkNotNullParameter($element, "$element");
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        $drawer.getDrawStyle().setTextSetting(TextSettingMode.PIXEL);
        Drawer.translate$default($drawer, $element.getScreenPosition(), null, 2, null);
        if ($newZComp == $zIndex) {
            $element.draw($drawer);
        }
        return Unit.INSTANCE;
    }

    private static final Unit drawElement$lambda$20$lambda$19(RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter($this$renderTarget, "$this$renderTarget");
        RenderTargetBuilder.colorBuffer$default($this$renderTarget, null, null, 3, null);
        RenderTargetBuilder.depthBuffer$default($this$renderTarget, null, 1, null);
        return Unit.INSTANCE;
    }

    private static final RenderTarget drawElement$lambda$20(ControlManager this$0, Element it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        return RenderTargetKt.renderTarget$default(this$0.width, this$0.height, this$0.contentScale, null, null, ControlManager::drawElement$lambda$20$lambda$19, 24, null);
    }

    private static final RenderTarget drawElement$lambda$21(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (RenderTarget)$tmp0.invoke(p0);
    }

    private static final Unit afterDraw$lambda$24(RenderTargetBuilder $this$renderTarget) {
        Intrinsics.checkNotNullParameter($this$renderTarget, "$this$renderTarget");
        RenderTargetBuilder.colorBuffer$default($this$renderTarget, null, null, 3, null);
        return Unit.INSTANCE;
    }

    private static final boolean afterDraw$lambda$25(Element it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getDraw().getDirty();
    }

    private static final Unit afterDraw$lambda$27(Element $this$visit) {
        Intrinsics.checkNotNullParameter($this$visit, "$this$visit");
        $this$visit.getDraw().setDirty(false);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/openrndr/panel/ControlManager$DropInput;", "", "<init>", "(Lorg/openrndr/panel/ControlManager;)V", "target", "Lorg/openrndr/panel/elements/Element;", "getTarget", "()Lorg/openrndr/panel/elements/Element;", "setTarget", "(Lorg/openrndr/panel/elements/Element;)V", "drop", "", "event", "Lorg/openrndr/DropEvent;", "orx-panel"})
    public final class DropInput {
        @Nullable
        private Element target;

        @Nullable
        public final Element getTarget() {
            return this.target;
        }

        public final void setTarget(@Nullable Element element) {
            this.target = element;
        }

        public final void drop(@NotNull DropEvent event) {
            block0: {
                Intrinsics.checkNotNullParameter(event, "event");
                Object object = this.target;
                if (object == null || (object = ((Element)object).getDrop()) == null || (object = ((Element.DropObserverables)object).getDropped()) == null) break block0;
                ((Event)object).trigger((DropEvent)event);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0005R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/openrndr/panel/ControlManager$KeyboardInput;", "", "<init>", "(Lorg/openrndr/panel/ControlManager;)V", "lastTarget", "Lorg/openrndr/panel/elements/Element;", "value", "target", "getTarget", "()Lorg/openrndr/panel/elements/Element;", "setTarget", "(Lorg/openrndr/panel/elements/Element;)V", "press", "", "event", "Lorg/openrndr/KeyEvent;", "release", "repeat", "character", "Lorg/openrndr/CharacterEvent;", "requestFocus", "element", "orx-panel"})
    @SourceDebugExtension(value={"SMAP\nControlManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlManager.kt\norg/openrndr/panel/ControlManager$KeyboardInput\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,557:1\n1#2:558\n*E\n"})
    public final class KeyboardInput {
        @Nullable
        private Element lastTarget;
        @Nullable
        private Element target;

        @Nullable
        public final Element getTarget() {
            return this.target;
        }

        public final void setTarget(@Nullable Element value2) {
            block5: {
                Object object;
                Event<FocusEvent> event;
                Event<FocusEvent> event2;
                if (Intrinsics.areEqual(value2, this.target)) break block5;
                Object object2 = this.target;
                if (object2 != null && (object2 = ((Element)object2).getPseudoClasses()) != null) {
                    ((ObservableHashSet)object2).remove(new ElementPseudoClass("active"));
                }
                if ((event2 = this.target) != null && (event2 = ((Element)((Object)event2)).getKeyboard()) != null && (event2 = ((Element.KeyboardObservables)((Object)event2)).getFocusLost()) != null) {
                    event2.trigger(new FocusEvent());
                }
                if ((event = value2) != null && (event = ((Element)((Object)event)).getKeyboard()) != null && (event = ((Element.KeyboardObservables)((Object)event)).getFocusGained()) != null) {
                    event.trigger(new FocusEvent());
                }
                if ((object = (this.target = value2)) != null && (object = ((Element)object).getPseudoClasses()) != null) {
                    ((ObservableHashSet)object).add(new ElementPseudoClass("active"));
                }
                Element element = value2;
                if (element != null) {
                    Element it = element;
                    boolean bl = false;
                    this.lastTarget = it;
                }
            }
        }

        public final void press(@NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter(event, "event");
            Element element = this.target;
            if (element != null) {
                Element element2 = element;
                ControlManager controlManager = ControlManager.this;
                Element it = element2;
                boolean bl = false;
                for (Element current = it; current != null; current = current.getParent()) {
                    if (event.getPropagationCancelled()) continue;
                    current.getKeyboard().getPressed().trigger(event);
                }
                controlManager.checkForManualRedraw();
            }
            if (!event.getPropagationCancelled() && event.getKey() == 258) {
                int index;
                Object object = ControlManager.this.getBody();
                if (object == null || (object = ElementKt.findAllVisible((Element)object, KeyboardInput::press$lambda$2)) == null) {
                    object = CollectionsKt.emptyList();
                }
                List<Element> focusableControls = object;
                Element element3 = this.target;
                if (element3 != null) {
                    Element it = element3;
                    boolean bl = false;
                    v3 = focusableControls.indexOf(it);
                } else {
                    Element element4 = this.lastTarget;
                    if (element4 != null) {
                        Element it = element4;
                        boolean bl = false;
                        v3 = focusableControls.indexOf(it);
                    } else {
                        v3 = index = -1;
                    }
                }
                if (!((Collection)focusableControls).isEmpty()) {
                    Element element5;
                    if (this.target != null) {
                        if (event.getModifiers().contains((Object)KeyModifier.SHIFT)) {
                            int n = index - 1;
                            int n2 = focusableControls.size();
                            var6_10 = n % n2;
                            element5 = focusableControls.get(var6_10 + (n2 & ((var6_10 ^ n2) & (var6_10 | -var6_10)) >> 31));
                        } else {
                            int n = index + 1;
                            int n3 = focusableControls.size();
                            var6_10 = n % n3;
                            element5 = focusableControls.get(var6_10 + (n3 & ((var6_10 ^ n3) & (var6_10 | -var6_10)) >> 31));
                        }
                    } else {
                        element5 = this.lastTarget;
                        if (element5 == null) {
                            element5 = focusableControls.get(0);
                        }
                    }
                    this.setTarget(element5);
                }
            }
        }

        public final void release(@NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter(event, "event");
            Object object = this.target;
            if (object != null && (object = ((Element)object).getKeyboard()) != null && (object = ((Element.KeyboardObservables)object).getReleased()) != null) {
                ((Event)object).trigger((KeyEvent)event);
            }
            if (this.target != null) {
                ControlManager.this.checkForManualRedraw();
            }
        }

        public final void repeat(@NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter(event, "event");
            Object object = this.target;
            if (object != null && (object = ((Element)object).getKeyboard()) != null && (object = ((Element.KeyboardObservables)object).getRepeated()) != null) {
                ((Event)object).trigger((KeyEvent)event);
            }
            if (this.target != null) {
                ControlManager.this.checkForManualRedraw();
            }
        }

        public final void character(@NotNull CharacterEvent event) {
            Intrinsics.checkNotNullParameter(event, "event");
            Object object = this.target;
            if (object != null && (object = ((Element)object).getKeyboard()) != null && (object = ((Element.KeyboardObservables)object).getCharacter()) != null) {
                ((Event)object).trigger((CharacterEvent)event);
            }
            if (this.target != null) {
                ControlManager.this.checkForManualRedraw();
            }
        }

        public final void requestFocus(@NotNull Element element) {
            Intrinsics.checkNotNullParameter(element, "element");
            this.setTarget(element);
        }

        private static final boolean press$lambda$2(Element it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return it.getHandlesKeyboardFocus();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lorg/openrndr/panel/ControlManager$MouseInput;", "", "<init>", "(Lorg/openrndr/panel/ControlManager;)V", "dragTarget", "Lorg/openrndr/panel/elements/Element;", "getDragTarget", "()Lorg/openrndr/panel/elements/Element;", "setDragTarget", "(Lorg/openrndr/panel/elements/Element;)V", "clickTarget", "getClickTarget", "setClickTarget", "lastClick", "", "getLastClick", "()J", "setLastClick", "(J)V", "scroll", "", "event", "Lorg/openrndr/MouseEvent;", "click", "press", "drag", "insideElements", "", "getInsideElements", "()Ljava/util/Set;", "move", "orx-panel"})
    @SourceDebugExtension(value={"SMAP\nControlManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlManager.kt\norg/openrndr/panel/ControlManager$MouseInput\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,557:1\n1#2:558\n774#3:559\n865#3,2:560\n1863#3,2:562\n1863#3,2:564\n1863#3,2:566\n1863#3,2:568\n*S KotlinDebug\n*F\n+ 1 ControlManager.kt\norg/openrndr/panel/ControlManager$MouseInput\n*L\n227#1:559\n227#1:560,2\n229#1:562,2\n130#1:564,2\n182#1:566,2\n259#1:568,2\n*E\n"})
    public final class MouseInput {
        @Nullable
        private Element dragTarget;
        @Nullable
        private Element clickTarget;
        private long lastClick = System.currentTimeMillis();
        @NotNull
        private final Set<Element> insideElements = new LinkedHashSet();

        @Nullable
        public final Element getDragTarget() {
            return this.dragTarget;
        }

        public final void setDragTarget(@Nullable Element element) {
            this.dragTarget = element;
        }

        @Nullable
        public final Element getClickTarget() {
            return this.clickTarget;
        }

        public final void setClickTarget(@Nullable Element element) {
            this.clickTarget = element;
        }

        public final long getLastClick() {
            return this.lastClick;
        }

        public final void setLastClick(long l) {
            this.lastClick = l;
        }

        public final void scroll(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter(event, "event");
            Element element = ControlManager.this.getBody();
            if (element != null) {
                Element element2 = element;
                ControlManager controlManager = ControlManager.this;
                Element p0 = element2;
                boolean bl = false;
                MouseInput.scroll$traverse(event, controlManager, p0);
            }
            ControlManager.this.checkForManualRedraw();
        }

        public final void click(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter(event, "event");
            ControlManagerKt.access$getLogger$p().debug(() -> MouseInput.click$lambda$1(event));
            this.dragTarget = null;
            long ct = System.currentTimeMillis();
            ControlManagerKt.access$getLogger$p().debug(() -> MouseInput.click$lambda$2(this));
            Element element = this.clickTarget;
            if (element != null) {
                Element it = element;
                boolean bl = false;
                if (it.getHandlesDoubleClick()) {
                    if (ct - this.lastClick > 500L) {
                        ControlManagerKt.access$getLogger$p().debug(() -> MouseInput.click$lambda$6$lambda$3(this));
                        it.getMouse().getClicked().trigger(event);
                    } else if (this.clickTarget != null) {
                        ControlManagerKt.access$getLogger$p().debug(() -> MouseInput.click$lambda$6$lambda$4(this));
                        it.getMouse().getDoubleClicked().trigger(event);
                    }
                    this.lastClick = ct;
                } else {
                    ControlManagerKt.access$getLogger$p().debug(() -> MouseInput.click$lambda$6$lambda$5(this));
                    it.getMouse().getClicked().trigger(event);
                }
            }
            ControlManager.this.checkForManualRedraw();
        }

        public final void press(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter(event, "event");
            ControlManagerKt.access$getLogger$p().debug(() -> MouseInput.press$lambda$7(event));
            List candidates = new ArrayList();
            Element element = ControlManager.this.getBody();
            if (element != null) {
                Element it = element;
                boolean bl = false;
                MouseInput.press$traverse$9$default(event, candidates, it, 0, 8, null);
            }
            this.clickTarget = null;
            Function1[] function1Array = new Function1[]{MouseInput::press$lambda$11, MouseInput::press$lambda$12};
            CollectionsKt.sortWith(candidates, ComparisonsKt.compareBy(function1Array));
            for (Pair c2 : candidates) {
                if (event.getPropagationCancelled()) continue;
                ((Element)c2.getFirst()).getMouse().getPressed().trigger(event);
                if (!event.getPropagationCancelled()) continue;
                ControlManagerKt.access$getLogger$p().debug(() -> MouseInput.press$lambda$13(c2));
                this.dragTarget = (Element)c2.getFirst();
                this.clickTarget = (Element)c2.getFirst();
                ControlManager.this.getKeyboardInput().setTarget((Element)c2.getFirst());
            }
            if (this.clickTarget == null) {
                this.dragTarget = null;
                ControlManager.this.getKeyboardInput().setTarget(null);
            }
            ControlManager.this.checkForManualRedraw();
        }

        public final void drag(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter(event, "event");
            ControlManagerKt.access$getLogger$p().debug(() -> MouseInput.drag$lambda$14(event));
            Object object = this.dragTarget;
            if (object != null && (object = ((Element)object).getMouse()) != null && (object = ((Element.MouseObservables)object).getDragged()) != null) {
                ((Event)object).trigger((MouseEvent)event);
            }
            if (event.getPropagationCancelled()) {
                ControlManagerKt.access$getLogger$p().debug(() -> MouseInput.drag$lambda$15(this));
                this.clickTarget = null;
            }
            ControlManager.this.checkForManualRedraw();
        }

        @NotNull
        public final Set<Element> getInsideElements() {
            return this.insideElements;
        }

        public final void move(@NotNull MouseEvent event) {
            Iterator $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(event, "event");
            ElementPseudoClass hover = new ElementPseudoClass("hover");
            Iterable $this$filter$iv = this.insideElements;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                Element it = (Element)element$iv$iv;
                boolean bl = false;
                if (!(!it.getScreenArea().contains(event.getPosition()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List toRemove = (List)destination$iv$iv;
            Iterable $this$forEach$iv = toRemove;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Element it = (Element)element$iv;
                boolean bl = false;
                it.getMouse().getExited().trigger(new MouseEvent(event.getPosition(), Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.MOVED, MouseButton.NONE, event.getModifiers()));
            }
            this.insideElements.removeAll(toRemove);
            Element element = ControlManager.this.getBody();
            if (element != null) {
                Element p0 = element;
                boolean bl = false;
                MouseInput.move$traverse$19(event, this, hover, p0);
            }
            ControlManager.this.checkForManualRedraw();
        }

        private static final void scroll$traverse(MouseEvent $event, ControlManager this$0, Element element) {
            Iterable $this$forEach$iv = element.getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Element p0 = (Element)element$iv;
                boolean bl = false;
                MouseInput.scroll$traverse($event, this$0, p0);
            }
            if (!$event.getPropagationCancelled() && element.getScreenArea().contains($event.getPosition()) && StyleSheetKt.getDisplay(element.getComputedStyle()) != Display.NONE) {
                element.getMouse().getScrolled().trigger($event);
                if ($event.getPropagationCancelled()) {
                    this$0.getKeyboardInput().setTarget(element);
                }
            }
        }

        private static final Object click$lambda$1(MouseEvent $event) {
            Intrinsics.checkNotNullParameter($event, "$event");
            return "click event: " + $event;
        }

        private static final Object click$lambda$2(MouseInput this$0) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            return "click target: " + this$0.clickTarget;
        }

        private static final Object click$lambda$6$lambda$3(MouseInput this$0) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            return "normal click on " + this$0.clickTarget;
        }

        private static final Object click$lambda$6$lambda$4(MouseInput this$0) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            return "double-click on " + this$0.clickTarget;
        }

        private static final Object click$lambda$6$lambda$5(MouseInput this$0) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            return "normal click on " + this$0.clickTarget;
        }

        private static final Object press$lambda$7(MouseEvent $event) {
            Intrinsics.checkNotNullParameter($event, "$event");
            return "press event: " + $event;
        }

        private static final void press$traverse$9(MouseEvent $event, List<Pair<Element, Integer>> candidates, Element element, int depth) {
            if (Intrinsics.areEqual(StyleSheetKt.getOverflow(element.getComputedStyle()), Overflow.Scroll.INSTANCE) && !element.getScreenArea().contains($event.getPosition())) {
                return;
            }
            if (StyleSheetKt.getDisplay(element.getComputedStyle()) != Display.NONE) {
                Iterable $this$forEach$iv = element.getChildren();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Element it = (Element)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull(it);
                    MouseInput.press$traverse$9($event, candidates, it, depth + 1);
                }
            }
            if (!$event.getPropagationCancelled() && element.getScreenArea().contains($event.getPosition()) && StyleSheetKt.getDisplay(element.getComputedStyle()) != Display.NONE) {
                candidates.add(new Pair<Element, Integer>(element, depth));
            }
        }

        static /* synthetic */ void press$traverse$9$default(MouseEvent mouseEvent, List list, Element element, int n, int n2, Object object) {
            if ((n2 & 8) != 0) {
                n = 0;
            }
            MouseInput.press$traverse$9(mouseEvent, list, element, n);
        }

        private static final Comparable press$lambda$11(Pair it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return Integer.valueOf(-((Element)it.getFirst()).getLayout().getZIndex());
        }

        private static final Comparable press$lambda$12(Pair it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return Integer.valueOf(-((Number)it.getSecond()).intValue());
        }

        private static final Object press$lambda$13(Pair $c) {
            Intrinsics.checkNotNullParameter($c, "$c");
            return "propagation cancelled by " + $c.getFirst();
        }

        private static final Object drag$lambda$14(MouseEvent $event) {
            Intrinsics.checkNotNullParameter($event, "$event");
            return "drag event " + $event;
        }

        private static final Object drag$lambda$15(MouseInput this$0) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            return "propagation cancelled by " + this$0.dragTarget + " setting clickTarget to null";
        }

        private static final void move$traverse$19(MouseEvent $event, MouseInput this$0, ElementPseudoClass hover, Element element) {
            if (element.getScreenArea().contains($event.getPosition())) {
                if (!this$0.insideElements.contains(element)) {
                    element.getMouse().getEntered().trigger($event);
                }
                this$0.insideElements.add(element);
                if (!element.getPseudoClasses().contains(hover)) {
                    element.getPseudoClasses().add(hover);
                }
                element.getMouse().getMoved().trigger($event);
            } else if (element.getPseudoClasses().contains(hover)) {
                element.getPseudoClasses().remove(hover);
            }
            Iterable $this$forEach$iv = element.getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Element p0 = (Element)element$iv;
                boolean bl = false;
                MouseInput.move$traverse$19($event, this$0, hover, p0);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/openrndr/panel/ControlManager$ProfileData;", "", "hits", "", "time", "", "<init>", "(IJ)V", "getHits", "()I", "setHits", "(I)V", "getTime", "()J", "setTime", "(J)V", "orx-panel"})
    public static final class ProfileData {
        private int hits;
        private long time;

        public ProfileData(int hits, long time) {
            this.hits = hits;
            this.time = time;
        }

        public /* synthetic */ ProfileData(int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            if ((n2 & 2) != 0) {
                l = 0L;
            }
            this(n, l);
        }

        public final int getHits() {
            return this.hits;
        }

        public final void setHits(int n) {
            this.hits = n;
        }

        public final long getTime() {
            return this.time;
        }

        public final void setTime(long l) {
            this.time = l;
        }

        public ProfileData() {
            this(0, 0L, 3, null);
        }
    }
}

