/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.panel;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.FontImageMap;
import org.openrndr.panel.style.LinearDimension;
import org.openrndr.panel.style.StyleSheet;
import org.openrndr.panel.style.StyleSheetKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/openrndr/panel/FontManager;", "", "<init>", "()V", "registry", "", "", "getRegistry", "()Ljava/util/Map;", "contentScale", "", "getContentScale", "()D", "setContentScale", "(D)V", "resolve", "name", "font", "Lorg/openrndr/draw/FontImageMap;", "cs", "Lorg/openrndr/panel/style/StyleSheet;", "register", "", "url", "orx-panel"})
public final class FontManager {
    @NotNull
    private final Map<String, String> registry = new LinkedHashMap();
    private double contentScale = 1.0;

    @NotNull
    public final Map<String, String> getRegistry() {
        return this.registry;
    }

    public final double getContentScale() {
        return this.contentScale;
    }

    public final void setContentScale(double d) {
        this.contentScale = d;
    }

    @Nullable
    public final String resolve(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.registry.get(name);
    }

    @NotNull
    public final FontImageMap font(@NotNull StyleSheet cs) {
        Intrinsics.checkNotNullParameter(cs, "cs");
        String string = this.resolve(StyleSheetKt.getFontFamily(cs));
        if (string == null) {
            string = "cp:fonts/Roboto-Medium.ttf";
        }
        String fontUrl = string;
        LinearDimension linearDimension = StyleSheetKt.getFontSize(cs);
        LinearDimension.PX pX = linearDimension instanceof LinearDimension.PX ? (LinearDimension.PX)linearDimension : null;
        double fontSize = pX != null ? pX.getValue() : 16.0;
        return FontImageMap.Companion.fromUrl$default(FontImageMap.Companion, fontUrl, fontSize, null, this.contentScale, 4, null);
    }

    public final void register(@NotNull String name, @NotNull String url) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(url, "url");
        this.registry.put(name, url);
    }
}

