/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.panel.elements;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.KeyEvent;
import org.openrndr.MouseEvent;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.FontImageMap;
import org.openrndr.events.Event;
import org.openrndr.extra.textwriter.TextWriter;
import org.openrndr.panel.ControlManager;
import org.openrndr.panel.FontManager;
import org.openrndr.panel.elements.Body;
import org.openrndr.panel.elements.Element;
import org.openrndr.panel.elements.ElementKt;
import org.openrndr.panel.elements.ElementType;
import org.openrndr.panel.style.Color;
import org.openrndr.panel.style.LinearDimension;
import org.openrndr.panel.style.StyleSheet;
import org.openrndr.panel.style.StyleSheetKt;
import org.openrndr.shape.RectangleKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002 !B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\""}, d2={"Lorg/openrndr/panel/elements/Button;", "Lorg/openrndr/panel/elements/Element;", "<init>", "()V", "handlesKeyboardFocus", "", "getHandlesKeyboardFocus", "()Z", "label", "", "getLabel", "()Ljava/lang/String;", "setLabel", "(Ljava/lang/String;)V", "data", "", "getData", "()Ljava/lang/Object;", "setData", "(Ljava/lang/Object;)V", "events", "Lorg/openrndr/panel/elements/Button$Events;", "getEvents", "()Lorg/openrndr/panel/elements/Button$Events;", "widthHint", "", "getWidthHint", "()Ljava/lang/Double;", "draw", "", "drawer", "Lorg/openrndr/draw/Drawer;", "ButtonEvent", "Events", "orx-panel"})
public final class Button
extends Element {
    private final boolean handlesKeyboardFocus;
    @NotNull
    private String label = "OK";
    @Nullable
    private Object data;
    @NotNull
    private final Events events = new Events(null, 1, null);

    public Button() {
        super(new ElementType("button"));
        this.handlesKeyboardFocus = true;
        this.getMouse().getPressed().listen(Button::_init_$lambda$0);
        this.getMouse().getClicked().listen(arg_0 -> Button._init_$lambda$1(this, arg_0));
        this.getKeyboard().getPressed().listen(arg_0 -> Button._init_$lambda$2(this, arg_0));
    }

    @Override
    public boolean getHandlesKeyboardFocus() {
        return this.handlesKeyboardFocus;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.label = string;
    }

    @Nullable
    public final Object getData() {
        return this.data;
    }

    public final void setData(@Nullable Object object) {
        this.data = object;
    }

    @NotNull
    public final Events getEvents() {
        return this.events;
    }

    @Override
    @NotNull
    public Double getWidthHint() {
        StyleSheet style = this.getComputedStyle();
        boolean bl = false;
        Element element = this.root();
        Object object = element instanceof Body ? (Body)element : null;
        if (object == null || (object = ((Body)object).getControlManager()) == null || (object = ((ControlManager)object).getFontManager()) == null || (object = ((FontManager)object).resolve(StyleSheetKt.getFontFamily(style))) == null) {
            object = "broken";
        }
        Object fontUrl = object;
        LinearDimension linearDimension = StyleSheetKt.getFontSize(style);
        LinearDimension.PX pX = linearDimension instanceof LinearDimension.PX ? (LinearDimension.PX)linearDimension : null;
        double fontSize = pX != null ? pX.getValue() : 14.0;
        FontImageMap fontMap = FontImageMap.Companion.fromUrl$default(FontImageMap.Companion, (String)fontUrl, fontSize, null, 0.0, 12, null);
        TextWriter writer = new TextWriter(null);
        writer.setBox(RectangleKt.Rectangle(0.0, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
        writer.getDrawStyle().setFontMap(fontMap);
        writer.newLine();
        writer.text(this.label, false);
        return writer.getCursor().getX();
    }

    @Override
    public void draw(@NotNull Drawer drawer) {
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        StyleSheet it = this.getComputedStyle();
        boolean bl = false;
        drawer.pushTransforms();
        drawer.pushStyle();
        Object object = StyleSheetKt.getBackground(it);
        Object object2 = object instanceof Color.RGBa ? (Color.RGBa)object : null;
        if (object2 == null || (object2 = ((Color.RGBa)object2).getColor()) == null) {
            object2 = ColorRGBa.Companion.getPINK();
        }
        drawer.setFill((ColorRGBa)object2);
        DrawerKt.isolated(drawer, arg_0 -> Button.draw$lambda$6$lambda$4(drawer, this, arg_0));
        object = this.root();
        Object object3 = object instanceof Body ? (Body)object : null;
        if (object3 != null && (object3 = ((Body)object3).getControlManager()) != null && (object3 = ((ControlManager)object3).getFontManager()) != null) {
            Object it2 = object3;
            boolean bl2 = false;
            FontImageMap font = ((FontManager)it2).font(this.getComputedStyle());
            TextWriter writer = new TextWriter(drawer);
            drawer.setFontMap(font);
            double textWidth = writer.textWidth(this.label);
            double textHeight = font.getAscenderLength();
            double offset = Math.rint((this.getLayout().getScreenWidth() - textWidth) / 2.0);
            double yOffset = Math.rint(this.getLayout().getScreenHeight() / (double)2 + textHeight / 2.0 - 2.0) * 1.0;
            Color color = StyleSheetKt.getColor(this.getComputedStyle());
            Object object4 = color instanceof Color.RGBa ? (Color.RGBa)color : null;
            if (object4 == null || (object4 = ((Color.RGBa)object4).getColor()) == null) {
                object4 = ColorRGBa.Companion.getWHITE();
            }
            drawer.setFill(((ColorRGBa)object4).opacify(this.getPseudoClasses().contains(ElementKt.getDisabled()) ? 0.25 : 1.0));
            drawer.text(this.label, 0.0 + offset, 0.0 + yOffset);
        }
        drawer.popStyle();
        drawer.popTransforms();
    }

    private static final Unit _init_$lambda$0(MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.cancelPropagation();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(Button this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        if (!this$0.getPseudoClasses().contains(ElementKt.getDisabled())) {
            this$0.events.getClicked().trigger(new ButtonEvent(this$0));
        }
        it.cancelPropagation();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(Button this$0, KeyEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        if (it.getKey() == 32) {
            it.cancelPropagation();
            if (!this$0.getPseudoClasses().contains(ElementKt.getDisabled())) {
                this$0.events.getClicked().trigger(new ButtonEvent(this$0));
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit draw$lambda$6$lambda$4(Drawer $drawer, Button this$0, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter($drawer, "$drawer");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        $drawer.setStroke(StyleSheetKt.getEffectiveBorderColor(this$0.getComputedStyle()));
        $drawer.setStrokeWeight(StyleSheetKt.getEffectiveBorderWidth(this$0.getComputedStyle()));
        $drawer.rectangle(0.0, 0.0, this$0.getLayout().getScreenWidth(), this$0.getLayout().getScreenHeight());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/openrndr/panel/elements/Button$ButtonEvent;", "", "source", "Lorg/openrndr/panel/elements/Button;", "<init>", "(Lorg/openrndr/panel/elements/Button;)V", "getSource", "()Lorg/openrndr/panel/elements/Button;", "orx-panel"})
    public static final class ButtonEvent {
        @NotNull
        private final Button source;

        public ButtonEvent(@NotNull Button source) {
            Intrinsics.checkNotNullParameter(source, "source");
            this.source = source;
        }

        @NotNull
        public final Button getSource() {
            return this.source;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/openrndr/panel/elements/Button$Events;", "", "clicked", "Lorg/openrndr/events/Event;", "Lorg/openrndr/panel/elements/Button$ButtonEvent;", "<init>", "(Lorg/openrndr/events/Event;)V", "getClicked", "()Lorg/openrndr/events/Event;", "orx-panel"})
    public static final class Events {
        @NotNull
        private final Event<ButtonEvent> clicked;

        public Events(@NotNull Event<ButtonEvent> clicked) {
            Intrinsics.checkNotNullParameter(clicked, "clicked");
            this.clicked = clicked;
        }

        public /* synthetic */ Events(Event event, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                event = new Event(null, false, 3, null);
            }
            this(event);
        }

        @NotNull
        public final Event<ButtonEvent> getClicked() {
            return this.clicked;
        }

        public Events() {
            this(null, 1, null);
        }
    }
}

