/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.panel.elements;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.CharacterEvent;
import org.openrndr.KeyEvent;
import org.openrndr.KeyModifier;
import org.openrndr.MouseEvent;
import org.openrndr.color.ColorHSVa;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorBufferKt;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.FontImageMap;
import org.openrndr.events.Event;
import org.openrndr.panel.ControlManager;
import org.openrndr.panel.FontManager;
import org.openrndr.panel.elements.Body;
import org.openrndr.panel.elements.Element;
import org.openrndr.panel.elements.ElementKt;
import org.openrndr.panel.elements.ElementType;
import org.openrndr.panel.elements.FocusEvent;
import org.openrndr.panel.style.Color;
import org.openrndr.panel.style.StyleSheetKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002-.B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020&H\u0002J\u0010\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020,H\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00178F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/openrndr/panel/elements/Colorpicker;", "Lorg/openrndr/panel/elements/Element;", "<init>", "()V", "colorMap", "Lorg/openrndr/draw/ColorBuffer;", "getColorMap$orx_panel", "()Lorg/openrndr/draw/ColorBuffer;", "setColorMap$orx_panel", "(Lorg/openrndr/draw/ColorBuffer;)V", "label", "", "getLabel", "()Ljava/lang/String;", "setLabel", "(Ljava/lang/String;)V", "saturation", "", "getSaturation", "()D", "setSaturation", "(D)V", "value", "Lorg/openrndr/color/ColorRGBa;", "color", "getColor", "()Lorg/openrndr/color/ColorRGBa;", "setColor", "(Lorg/openrndr/color/ColorRGBa;)V", "realColor", "focussed", "", "events", "Lorg/openrndr/panel/elements/Colorpicker$Events;", "getEvents", "()Lorg/openrndr/panel/elements/Colorpicker$Events;", "keyboardInput", "pick", "", "e", "Lorg/openrndr/MouseEvent;", "generateColorMap", "draw", "drawer", "Lorg/openrndr/draw/Drawer;", "ColorChangedEvent", "Events", "orx-panel"})
public final class Colorpicker
extends Element {
    @Nullable
    private ColorBuffer colorMap;
    @NotNull
    private String label = "Color";
    private double saturation = 0.5;
    @NotNull
    private ColorRGBa realColor = ColorRGBa.Companion.getWHITE();
    private boolean focussed;
    @NotNull
    private final Events events = new Events();
    @NotNull
    private String keyboardInput = "";

    @Nullable
    public final ColorBuffer getColorMap$orx_panel() {
        return this.colorMap;
    }

    public final void setColorMap$orx_panel(@Nullable ColorBuffer colorBuffer) {
        this.colorMap = colorBuffer;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.label = string;
    }

    public final double getSaturation() {
        return this.saturation;
    }

    public final void setSaturation(double d) {
        this.saturation = d;
    }

    @NotNull
    public final ColorRGBa getColor() {
        return this.realColor;
    }

    public final void setColor(@NotNull ColorRGBa value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        this.realColor = value2;
        this.saturation = this.getColor().toHSVa().s();
        this.generateColorMap();
        this.getDraw().setDirty(true);
    }

    @NotNull
    public final Events getEvents() {
        return this.events;
    }

    private final void pick(MouseEvent e) {
        double dx = e.getPosition().x() - this.getLayout().getScreenX();
        double dy = e.getPosition().y() - this.getLayout().getScreenY();
        dy = 50.0 - dy;
        ColorRGBa oldColor = this.getColor();
        ColorHSVa hsv = new ColorHSVa(360.0 / this.getLayout().getScreenWidth() * dx, this.saturation, dy / 50.0, 0.0, 8, null);
        this.realColor = hsv.toRGBa();
        this.getDraw().setDirty(true);
        this.events.getColorChanged().trigger(new ColorChangedEvent(this, oldColor, this.realColor));
        e.cancelPropagation();
    }

    public Colorpicker() {
        super(new ElementType("colorpicker"));
        this.generateColorMap();
        this.getMouse().getExited().listen(arg_0 -> Colorpicker._init_$lambda$0(this, arg_0));
        this.getMouse().getScrolled().listen(arg_0 -> Colorpicker._init_$lambda$1(this, arg_0));
        this.getKeyboard().getFocusLost().listen(arg_0 -> Colorpicker._init_$lambda$2(this, arg_0));
        this.getKeyboard().getCharacter().listen(arg_0 -> Colorpicker._init_$lambda$3(this, arg_0));
        this.getKeyboard().getPressed().listen(arg_0 -> Colorpicker._init_$lambda$6(this, arg_0));
        this.getMouse().getPressed().listen(arg_0 -> Colorpicker._init_$lambda$7(this, arg_0));
        this.getMouse().getClicked().listen(arg_0 -> Colorpicker._init_$lambda$8(this, arg_0));
        this.getMouse().getDragged().listen(arg_0 -> Colorpicker._init_$lambda$9(this, arg_0));
    }

    private final void generateColorMap() {
        block2: {
            Object object = this.colorMap;
            if (object == null || (object = ((ColorBuffer)object).getShadow()) == null) break block2;
            Object it = object;
            boolean bl = false;
            for (int y = 0; y < 50; ++y) {
                int n = it.getColorBuffer().getWidth();
                for (int x = 0; x < n; ++x) {
                    ColorHSVa hsv = new ColorHSVa(360.0 / (double)it.getColorBuffer().getWidth() * (double)x, this.saturation, (double)(49 - y) / 49.0, 0.0, 8, null);
                    it.write(x, y, hsv.toRGBa());
                }
            }
            it.upload();
        }
    }

    @Override
    public void draw(@NotNull Drawer drawer) {
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        if (this.colorMap == null) {
            this.colorMap = ColorBufferKt.colorBuffer$default((int)this.getLayout().getScreenWidth(), 50, 1.0, null, null, null, 0, null, 248, null);
            this.generateColorMap();
        }
        ColorBuffer colorBuffer = this.colorMap;
        Intrinsics.checkNotNull(colorBuffer);
        Drawer.image$default(drawer, colorBuffer, 0.0, 0.0, 0.0, 0.0, 24, null);
        drawer.setFill(this.getColor());
        drawer.setStroke(null);
        drawer.setShadeStyle(null);
        drawer.rectangle(0.0, 50.0, this.getLayout().getScreenWidth(), 20.0);
        Element element = this.root();
        Object object = element instanceof Body ? (Body)element : null;
        FontImageMap fontImageMap = object != null && (object = ((Body)object).getControlManager()) != null && (object = ((ControlManager)object).getFontManager()) != null ? ((FontManager)object).font(this.getComputedStyle()) : null;
        Intrinsics.checkNotNull(fontImageMap);
        FontImageMap f = fontImageMap;
        drawer.setFontMap(f);
        Color color = StyleSheetKt.getColor(this.getComputedStyle());
        Intrinsics.checkNotNull(color, "null cannot be cast to non-null type org.openrndr.panel.style.Color.RGBa");
        drawer.setFill(((Color.RGBa)color).getColor());
        if (!StringsKt.isBlank(this.keyboardInput)) {
            drawer.text("input: " + this.keyboardInput, 0.0, this.getLayout().getScreenHeight());
        }
    }

    private static final Unit _init_$lambda$0(Colorpicker this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.focussed = false;
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(Colorpicker this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        if (this$0.colorMap != null) {
            this$0.saturation = RangesKt.coerceIn(this$0.saturation - it.getRotation().y() * 0.01, 0.0, 1.0);
            this$0.generateColorMap();
            Object object = this$0.colorMap;
            if (object != null && (object = ((ColorBuffer)object).getShadow()) != null) {
                object.upload();
            }
            it.cancelPropagation();
            this$0.pick(it);
            ElementKt.requestRedraw(this$0);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(Colorpicker this$0, FocusEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.keyboardInput = "";
        this$0.getDraw().setDirty(true);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(Colorpicker this$0, CharacterEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.keyboardInput = this$0.keyboardInput + it.getCharacter();
        this$0.getDraw().setDirty(true);
        it.cancelPropagation();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(Colorpicker this$0, KeyEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        if ((it.getModifiers().contains((Object)KeyModifier.CTRL) || it.getModifiers().contains((Object)KeyModifier.SUPER)) && Intrinsics.areEqual(it.getName(), "v")) {
            Element element = this$0.root();
            Intrinsics.checkNotNull(element, "null cannot be cast to non-null type org.openrndr.panel.elements.Body");
            String string = ((Body)element).getControlManager().getProgram().getClipboard().getContents();
            if (string != null) {
                String it2 = string;
                boolean bl = false;
                this$0.keyboardInput = this$0.keyboardInput + it2;
                this$0.getDraw().setDirty(true);
            }
            it.cancelPropagation();
        }
        if (it.getKey() == 259) {
            if (!(((CharSequence)this$0.keyboardInput).length() == 0)) {
                String string = this$0.keyboardInput.substring(0, this$0.keyboardInput.length() - 1);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                this$0.keyboardInput = string;
                this$0.getDraw().setDirty(true);
            }
            it.cancelPropagation();
        }
        if (it.getKey() == 256) {
            this$0.keyboardInput = "";
            this$0.getDraw().setDirty(true);
            it.cancelPropagation();
        }
        if (it.getKey() == 257) {
            Integer number;
            Regex regex = new Regex("^#");
            CharSequence charSequence = this$0.keyboardInput;
            String bl = "";
            String cleanKeyboardInput = regex.replace(charSequence, bl);
            Integer n = number = cleanKeyboardInput.length() == 6 ? StringsKt.toIntOrNull(cleanKeyboardInput, 16) : null;
            if (n != null) {
                int it3 = ((Number)n).intValue();
                boolean bl2 = false;
                int r = number >> 16 & 0xFF;
                int g = number >> 8 & 0xFF;
                int b = number & 0xFF;
                ColorRGBa oldColor = this$0.getColor();
                this$0.setColor(new ColorRGBa((double)r / 255.0, (double)g / 255.0, (double)b / 255.0, 0.0, null, 24, null));
                this$0.events.getColorChanged().trigger(new ColorChangedEvent(this$0, oldColor, this$0.realColor));
                this$0.keyboardInput = "";
                this$0.getDraw().setDirty(true);
            }
            it.cancelPropagation();
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$7(Colorpicker this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        it.cancelPropagation();
        this$0.focussed = true;
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$8(Colorpicker this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        it.cancelPropagation();
        this$0.pick(it);
        this$0.focussed = true;
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$9(Colorpicker this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        it.cancelPropagation();
        this$0.pick(it);
        this$0.focussed = true;
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/openrndr/panel/elements/Colorpicker$ColorChangedEvent;", "", "source", "Lorg/openrndr/panel/elements/Colorpicker;", "oldColor", "Lorg/openrndr/color/ColorRGBa;", "newColor", "<init>", "(Lorg/openrndr/panel/elements/Colorpicker;Lorg/openrndr/color/ColorRGBa;Lorg/openrndr/color/ColorRGBa;)V", "getSource", "()Lorg/openrndr/panel/elements/Colorpicker;", "getOldColor", "()Lorg/openrndr/color/ColorRGBa;", "getNewColor", "orx-panel"})
    public static final class ColorChangedEvent {
        @NotNull
        private final Colorpicker source;
        @NotNull
        private final ColorRGBa oldColor;
        @NotNull
        private final ColorRGBa newColor;

        public ColorChangedEvent(@NotNull Colorpicker source, @NotNull ColorRGBa oldColor, @NotNull ColorRGBa newColor) {
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter(oldColor, "oldColor");
            Intrinsics.checkNotNullParameter(newColor, "newColor");
            this.source = source;
            this.oldColor = oldColor;
            this.newColor = newColor;
        }

        @NotNull
        public final Colorpicker getSource() {
            return this.source;
        }

        @NotNull
        public final ColorRGBa getOldColor() {
            return this.oldColor;
        }

        @NotNull
        public final ColorRGBa getNewColor() {
            return this.newColor;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/openrndr/panel/elements/Colorpicker$Events;", "", "<init>", "()V", "colorChanged", "Lorg/openrndr/events/Event;", "Lorg/openrndr/panel/elements/Colorpicker$ColorChangedEvent;", "getColorChanged", "()Lorg/openrndr/events/Event;", "orx-panel"})
    public static final class Events {
        @NotNull
        private final Event<ColorChangedEvent> colorChanged = new Event(null, false, 3, null);

        @NotNull
        public final Event<ColorChangedEvent> getColorChanged() {
            return this.colorChanged;
        }
    }
}

