/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.panel.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.MouseEvent;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.LineCap;
import org.openrndr.events.Event;
import org.openrndr.extra.textwriter.TextWriter;
import org.openrndr.panel.ControlManager;
import org.openrndr.panel.FontManager;
import org.openrndr.panel.elements.Body;
import org.openrndr.panel.elements.Colorpicker;
import org.openrndr.panel.elements.DisposableElement;
import org.openrndr.panel.elements.Element;
import org.openrndr.panel.elements.ElementKt;
import org.openrndr.panel.elements.ElementType;
import org.openrndr.panel.elements.Item;
import org.openrndr.panel.style.Color;
import org.openrndr.panel.style.CompoundSelector;
import org.openrndr.panel.style.LinearDimension;
import org.openrndr.panel.style.Overflow;
import org.openrndr.panel.style.Position;
import org.openrndr.panel.style.StyleSheet;
import org.openrndr.panel.style.StyleSheetKt;
import org.openrndr.panel.style.ZIndex;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0003%&'B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0001H\u0016J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006("}, d2={"Lorg/openrndr/panel/elements/ColorpickerButton;", "Lorg/openrndr/panel/elements/Element;", "Lorg/openrndr/panel/elements/DisposableElement;", "<init>", "()V", "disposed", "", "getDisposed", "()Z", "setDisposed", "(Z)V", "label", "", "getLabel", "()Ljava/lang/String;", "setLabel", "(Ljava/lang/String;)V", "value", "Lorg/openrndr/color/ColorRGBa;", "color", "getColor", "()Lorg/openrndr/color/ColorRGBa;", "setColor", "(Lorg/openrndr/color/ColorRGBa;)V", "events", "Lorg/openrndr/panel/elements/ColorpickerButton$Events;", "getEvents", "()Lorg/openrndr/panel/elements/ColorpickerButton$Events;", "append", "", "element", "items", "", "Lorg/openrndr/panel/elements/Item;", "draw", "drawer", "Lorg/openrndr/draw/Drawer;", "ColorChangedEvent", "Events", "SlideOut", "orx-panel"})
@SourceDebugExtension(value={"SMAP\nColorpickerButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorpickerButton.kt\norg/openrndr/panel/elements/ColorpickerButton\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n774#2:156\n865#2,2:157\n1557#2:159\n1628#2,3:160\n*S KotlinDebug\n*F\n+ 1 ColorpickerButton.kt\norg/openrndr/panel/elements/ColorpickerButton\n*L\n54#1:156\n54#1:157,2\n54#1:159\n54#1:160,3\n*E\n"})
public final class ColorpickerButton
extends Element
implements DisposableElement {
    private boolean disposed;
    @NotNull
    private String label = "OK";
    @NotNull
    private ColorRGBa color = new ColorRGBa(0.5, 0.5, 0.5, 0.0, null, 24, null);
    @NotNull
    private final Events events = new Events();

    public ColorpickerButton() {
        super(new ElementType("colorpicker-button"));
        this.getMouse().getPressed().listen(ColorpickerButton::_init_$lambda$0);
        this.getMouse().getClicked().listen(arg_0 -> ColorpickerButton._init_$lambda$1(this, arg_0));
    }

    @Override
    public boolean getDisposed() {
        return this.disposed;
    }

    @Override
    public void setDisposed(boolean bl) {
        this.disposed = bl;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.label = string;
    }

    @NotNull
    public final ColorRGBa getColor() {
        return this.color;
    }

    public final void setColor(@NotNull ColorRGBa value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        if (!Intrinsics.areEqual(value2, this.color)) {
            this.color = value2;
            ElementKt.requestRedraw(this);
            this.events.getValueChanged().trigger(new ColorChangedEvent(this, value2));
        }
    }

    @NotNull
    public final Events getEvents() {
        return this.events;
    }

    @Override
    public void append(@NotNull Element element) {
        Intrinsics.checkNotNullParameter(element, "element");
        Element element2 = element;
        if (!(element2 instanceof Item) && !(element2 instanceof SlideOut)) {
            throw new RuntimeException("only item and slideout");
        }
        super.append(element);
        super.append(element);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Item> items() {
        void $this$mapTo$iv$iv;
        Element it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getChildren();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Element)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof Item)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.openrndr.panel.elements.Item");
            collection.add((Item)it);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void draw(@NotNull Drawer drawer) {
        block2: {
            Intrinsics.checkNotNullParameter(drawer, "drawer");
            Object object = StyleSheetKt.getBackground(this.getComputedStyle());
            Object object2 = object instanceof Color.RGBa ? (Color.RGBa)object : null;
            if (object2 == null || (object2 = ((Color.RGBa)object2).getColor()) == null) {
                object2 = ColorRGBa.Companion.getPINK();
            }
            drawer.setFill((ColorRGBa)object2);
            drawer.setStroke(null);
            drawer.setStrokeWeight(0.0);
            drawer.rectangle(0.0, 0.0, this.getScreenArea().width(), this.getScreenArea().height());
            object = this.root();
            Object object3 = object instanceof Body ? (Body)object : null;
            if (object3 == null || (object3 = ((Body)object3).getControlManager()) == null || (object3 = ((ControlManager)object3).getFontManager()) == null) break block2;
            Object it = object3;
            boolean bl = false;
            FontImageMap font = ((FontManager)it).font(this.getComputedStyle());
            TextWriter writer = new TextWriter(drawer);
            drawer.setFontMap(font);
            String text = String.valueOf(this.label);
            double textWidth = writer.textWidth(text);
            double textHeight = font.getAscenderLength();
            long offset = Math.round((this.getLayout().getScreenWidth() - textWidth) / 2.0);
            double yOffset = (double)Math.round(this.getLayout().getScreenHeight() / (double)2 + textHeight / 2.0) - 2.0;
            Color color = StyleSheetKt.getColor(this.getComputedStyle());
            Object object4 = color instanceof Color.RGBa ? (Color.RGBa)color : null;
            if (object4 == null || (object4 = ((Color.RGBa)object4).getColor()) == null) {
                object4 = ColorRGBa.Companion.getWHITE();
            }
            drawer.setFill((ColorRGBa)object4);
            drawer.setFontMap(font);
            drawer.text(text, 0.0 + (double)offset, 0.0 + yOffset);
            drawer.setStroke(this.color);
            drawer.pushStyle();
            drawer.setStrokeWeight(4.0);
            drawer.setLineCap(LineCap.ROUND);
            drawer.lineSegment(2.0, this.getLayout().getScreenHeight() - 2.0, this.getLayout().getScreenWidth() - 2.0, this.getLayout().getScreenHeight() - 2.0);
            drawer.popStyle();
        }
    }

    @Override
    public void dispose() {
        DisposableElement.DefaultImpls.dispose(this);
    }

    private static final Unit _init_$lambda$0(MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.cancelPropagation();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(ColorpickerButton this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.append(new SlideOut(0.0, this$0.getScreenArea().height(), this$0.getScreenArea().width(), 200.0, this$0.color, this$0));
        it.cancelPropagation();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/openrndr/panel/elements/ColorpickerButton$ColorChangedEvent;", "", "source", "Lorg/openrndr/panel/elements/ColorpickerButton;", "color", "Lorg/openrndr/color/ColorRGBa;", "<init>", "(Lorg/openrndr/panel/elements/ColorpickerButton;Lorg/openrndr/color/ColorRGBa;)V", "getSource", "()Lorg/openrndr/panel/elements/ColorpickerButton;", "getColor", "()Lorg/openrndr/color/ColorRGBa;", "orx-panel"})
    public static final class ColorChangedEvent {
        @NotNull
        private final ColorpickerButton source;
        @NotNull
        private final ColorRGBa color;

        public ColorChangedEvent(@NotNull ColorpickerButton source, @NotNull ColorRGBa color) {
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter(color, "color");
            this.source = source;
            this.color = color;
        }

        @NotNull
        public final ColorpickerButton getSource() {
            return this.source;
        }

        @NotNull
        public final ColorRGBa getColor() {
            return this.color;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/openrndr/panel/elements/ColorpickerButton$Events;", "", "<init>", "()V", "valueChanged", "Lorg/openrndr/events/Event;", "Lorg/openrndr/panel/elements/ColorpickerButton$ColorChangedEvent;", "getValueChanged", "()Lorg/openrndr/events/Event;", "orx-panel"})
    public static final class Events {
        @NotNull
        private final Event<ColorChangedEvent> valueChanged = new Event(null, false, 3, null);

        @NotNull
        public final Event<ColorChangedEvent> getValueChanged() {
            return this.valueChanged;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/openrndr/panel/elements/ColorpickerButton$SlideOut;", "Lorg/openrndr/panel/elements/Element;", "x", "", "y", "width", "height", "color", "Lorg/openrndr/color/ColorRGBa;", "parent", "<init>", "(DDDDLorg/openrndr/color/ColorRGBa;Lorg/openrndr/panel/elements/Element;)V", "getX", "()D", "getY", "getWidth", "getHeight", "draw", "", "drawer", "Lorg/openrndr/draw/Drawer;", "dispose", "orx-panel"})
    public static final class SlideOut
    extends Element {
        private final double x;
        private final double y;
        private final double width;
        private final double height;

        /*
         * WARNING - void declaration
         */
        public SlideOut(double x, double y, double width, double height, @NotNull ColorRGBa color, @NotNull Element parent) {
            void $this$_init__u24lambda_u240;
            Intrinsics.checkNotNullParameter(color, "color");
            Intrinsics.checkNotNullParameter(parent, "parent");
            super(new ElementType("slide-out"));
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            StyleSheet styleSheet = new StyleSheet(CompoundSelector.Companion.getDUMMY());
            Object object = styleSheet;
            SlideOut slideOut = this;
            boolean bl = false;
            StyleSheetKt.setPosition((StyleSheet)$this$_init__u24lambda_u240, Position.ABSOLUTE);
            StyleSheetKt.setLeft((StyleSheet)$this$_init__u24lambda_u240, new LinearDimension.PX(this.x));
            StyleSheetKt.setTop((StyleSheet)$this$_init__u24lambda_u240, new LinearDimension.PX(this.y));
            StyleSheetKt.setWidth((StyleSheet)$this$_init__u24lambda_u240, new LinearDimension.PX(this.width));
            StyleSheetKt.setHeight((StyleSheet)$this$_init__u24lambda_u240, LinearDimension.Auto.INSTANCE);
            StyleSheetKt.setOverflow((StyleSheet)$this$_init__u24lambda_u240, Overflow.Scroll.INSTANCE);
            StyleSheetKt.setZIndex((StyleSheet)$this$_init__u24lambda_u240, new ZIndex.Value(1000));
            StyleSheetKt.setBackground((StyleSheet)$this$_init__u24lambda_u240, new Color.RGBa(new ColorRGBa(0.3, 0.3, 0.3, 0.0, null, 24, null)));
            slideOut.setStyle(styleSheet);
            Object $this$_init__u24lambda_u242 = object = new Colorpicker();
            boolean bl2 = false;
            ((Colorpicker)$this$_init__u24lambda_u242).setColor(color);
            ((Colorpicker)$this$_init__u24lambda_u242).setLabel(((ColorpickerButton)parent).getLabel());
            ((Colorpicker)$this$_init__u24lambda_u242).getEvents().getColorChanged().listen(arg_0 -> SlideOut.lambda$2$lambda$1(parent, arg_0));
            Object colorPicker = object;
            this.append((Element)colorPicker);
            this.getMouse().getExited().listen(arg_0 -> SlideOut._init_$lambda$3(this, arg_0));
        }

        public final double getX() {
            return this.x;
        }

        public final double getY() {
            return this.y;
        }

        public final double getWidth() {
            return this.width;
        }

        public final double getHeight() {
            return this.height;
        }

        @Override
        public void draw(@NotNull Drawer drawer) {
            Intrinsics.checkNotNullParameter(drawer, "drawer");
            Element element = this.root();
            Intrinsics.checkNotNull(element, "null cannot be cast to non-null type org.openrndr.panel.elements.Body");
            ControlManager.KeyboardInput keyboardInput = ((Body)element).getControlManager().getKeyboardInput();
            Object e = this.getChildren().get(0);
            Intrinsics.checkNotNullExpressionValue(e, "get(...)");
            keyboardInput.requestFocus((Element)e);
            Color color = StyleSheetKt.getBackground(this.getComputedStyle());
            Object object = color instanceof Color.RGBa ? (Color.RGBa)color : null;
            if (object == null || (object = ((Color.RGBa)object).getColor()) == null) {
                object = ColorRGBa.Companion.getPINK();
            }
            drawer.setFill((ColorRGBa)object);
            drawer.rectangle(0.0, 0.0, this.getScreenArea().width(), this.getScreenArea().height());
        }

        public final void dispose() {
            block0: {
                Element element = this.getParent();
                if (element == null) break block0;
                element.remove(this);
            }
        }

        private static final Unit lambda$2$lambda$1(Element $parent, Colorpicker.ColorChangedEvent it) {
            Intrinsics.checkNotNullParameter($parent, "$parent");
            Intrinsics.checkNotNullParameter(it, "it");
            ((ColorpickerButton)$parent).setColor(it.getNewColor());
            ((ColorpickerButton)$parent).getEvents().getValueChanged().trigger(new ColorChangedEvent((ColorpickerButton)$parent, ((ColorpickerButton)$parent).getColor()));
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$3(SlideOut this$0, MouseEvent it) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter(it, "it");
            this$0.dispose();
            return Unit.INSTANCE;
        }
    }
}

