/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.panel.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.KeyEvent;
import org.openrndr.MouseEvent;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.FontImageMap;
import org.openrndr.events.Event;
import org.openrndr.extra.textwriter.TextWriter;
import org.openrndr.panel.ControlManager;
import org.openrndr.panel.FontManager;
import org.openrndr.panel.collections.ObservableHashSet;
import org.openrndr.panel.elements.Body;
import org.openrndr.panel.elements.Button;
import org.openrndr.panel.elements.DisposableElement;
import org.openrndr.panel.elements.Element;
import org.openrndr.panel.elements.ElementPseudoClass;
import org.openrndr.panel.elements.ElementType;
import org.openrndr.panel.elements.Item;
import org.openrndr.panel.style.Color;
import org.openrndr.panel.style.CompoundSelector;
import org.openrndr.panel.style.LinearDimension;
import org.openrndr.panel.style.Overflow;
import org.openrndr.panel.style.Position;
import org.openrndr.panel.style.StyleSheet;
import org.openrndr.panel.style.StyleSheetKt;
import org.openrndr.panel.style.ZIndex;
import org.openrndr.shape.RectangleKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0003'()B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0001H\u0016J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00120#J\u0010\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020&H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006*"}, d2={"Lorg/openrndr/panel/elements/DropdownButton;", "Lorg/openrndr/panel/elements/Element;", "Lorg/openrndr/panel/elements/DisposableElement;", "<init>", "()V", "disposed", "", "getDisposed", "()Z", "setDisposed", "(Z)V", "label", "", "getLabel", "()Ljava/lang/String;", "setLabel", "(Ljava/lang/String;)V", "value", "Lorg/openrndr/panel/elements/Item;", "getValue", "()Lorg/openrndr/panel/elements/Item;", "setValue", "(Lorg/openrndr/panel/elements/Item;)V", "events", "Lorg/openrndr/panel/elements/DropdownButton$Events;", "getEvents", "()Lorg/openrndr/panel/elements/DropdownButton$Events;", "widthHint", "", "getWidthHint", "()Ljava/lang/Double;", "append", "", "element", "items", "", "draw", "drawer", "Lorg/openrndr/draw/Drawer;", "ValueChangedEvent", "Events", "SlideOut", "orx-panel"})
@SourceDebugExtension(value={"SMAP\nDropdownButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DropdownButton.kt\norg/openrndr/panel/elements/DropdownButton\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,286:1\n808#2,11:287\n1557#2:298\n1628#2,3:299\n2632#2,3:302\n230#2,2:305\n*S KotlinDebug\n*F\n+ 1 DropdownButton.kt\norg/openrndr/panel/elements/DropdownButton\n*L\n108#1:287,11\n108#1:298\n108#1:299,3\n60#1:302,3\n72#1:305,2\n*E\n"})
public final class DropdownButton
extends Element
implements DisposableElement {
    private boolean disposed;
    @NotNull
    private String label = "OK";
    @Nullable
    private Item value;
    @NotNull
    private final Events events = new Events();

    public DropdownButton() {
        super(new ElementType("dropdown-button"));
        this.getMouse().getPressed().listen(DropdownButton::_init_$lambda$0);
        this.getMouse().getClicked().listen(arg_0 -> DropdownButton._init_$lambda$3(this, arg_0));
    }

    @Override
    public boolean getDisposed() {
        return this.disposed;
    }

    @Override
    public void setDisposed(boolean bl) {
        this.disposed = bl;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.label = string;
    }

    @Nullable
    public final Item getValue() {
        return this.value;
    }

    public final void setValue(@Nullable Item item) {
        this.value = item;
    }

    @NotNull
    public final Events getEvents() {
        return this.events;
    }

    @Override
    @Nullable
    public Double getWidthHint() {
        StyleSheet style = this.getComputedStyle();
        boolean bl = false;
        Element element = this.root();
        Object object = element instanceof Body ? (Body)element : null;
        if (object == null || (object = ((Body)object).getControlManager()) == null || (object = ((ControlManager)object).getFontManager()) == null || (object = ((FontManager)object).resolve(StyleSheetKt.getFontFamily(style))) == null) {
            object = "broken";
        }
        Object fontUrl = object;
        LinearDimension linearDimension = StyleSheetKt.getFontSize(style);
        LinearDimension.PX pX = linearDimension instanceof LinearDimension.PX ? (LinearDimension.PX)linearDimension : null;
        double fontSize = pX != null ? pX.getValue() : 16.0;
        FontImageMap fontMap = FontImageMap.Companion.fromUrl$default(FontImageMap.Companion, (String)fontUrl, fontSize, null, 0.0, 12, null);
        TextWriter writer = new TextWriter(null);
        writer.setBox(RectangleKt.Rectangle(0.0, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
        Object object2 = this.value;
        if (object2 == null || (object2 = ((Item)object2).getLabel()) == null) {
            object2 = "<choose>";
        }
        String text = this.label + "  " + (String)object2;
        writer.getDrawStyle().setFontMap(fontMap);
        writer.newLine();
        writer.text(text, false);
        return writer.getCursor().getX() + 10.0;
    }

    @Override
    public void append(@NotNull Element element) {
        Intrinsics.checkNotNullParameter(element, "element");
        Element element2 = element;
        if (!(element2 instanceof Item) && !(element2 instanceof SlideOut)) {
            throw new RuntimeException("only item and slideout");
        }
        super.append(element);
        super.append(element);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Item> items() {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.getChildren();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Item)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Item item = (Item)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void draw(@NotNull Drawer drawer) {
        block3: {
            Intrinsics.checkNotNullParameter(drawer, "drawer");
            Object object = StyleSheetKt.getBackground(this.getComputedStyle());
            Object object2 = object instanceof Color.RGBa ? (Color.RGBa)object : null;
            if (object2 == null || (object2 = ((Color.RGBa)object2).getColor()) == null) {
                object2 = ColorRGBa.Companion.getPINK();
            }
            drawer.setFill((ColorRGBa)object2);
            drawer.setStroke(null);
            drawer.rectangle(0.0, 0.0, this.getScreenArea().width(), this.getScreenArea().height());
            object = this.root();
            Object object3 = object instanceof Body ? (Body)object : null;
            if (object3 == null || (object3 = ((Body)object3).getControlManager()) == null || (object3 = ((ControlManager)object3).getFontManager()) == null) break block3;
            Object it = object3;
            boolean bl = false;
            FontImageMap font = ((FontManager)it).font(this.getComputedStyle());
            TextWriter writer = new TextWriter(drawer);
            drawer.setFontMap(font);
            Object object4 = this.value;
            if (object4 == null || (object4 = ((Item)object4).getLabel()) == null) {
                object4 = "<choose>";
            }
            Object text = object4;
            double textWidth = writer.textWidth((String)text);
            double textHeight = font.getAscenderLength();
            long offset = Math.round(this.getLayout().getScreenWidth() - textWidth);
            double yOffset = (double)MathKt.roundToInt(this.getLayout().getScreenHeight() / (double)2 + textHeight / 2.0) - 2.0;
            Color color = StyleSheetKt.getColor(this.getComputedStyle());
            Object object5 = color instanceof Color.RGBa ? (Color.RGBa)color : null;
            if (object5 == null || (object5 = ((Color.RGBa)object5).getColor()) == null) {
                object5 = ColorRGBa.Companion.getWHITE();
            }
            drawer.setFill((ColorRGBa)object5);
            drawer.text(this.label, 5.0, 0.0 + yOffset);
            drawer.text((String)text, -5.0 + (double)offset, 0.0 + yOffset);
        }
    }

    @Override
    public void dispose() {
        DisposableElement.DefaultImpls.dispose(this);
    }

    private static final Unit _init_$lambda$0(MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.cancelPropagation();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(DropdownButton this$0, MouseEvent it) {
        block9: {
            Object element$iv3;
            block7: {
                block8: {
                    boolean bl;
                    int itemCount;
                    block6: {
                        Intrinsics.checkNotNullParameter(this$0, "this$0");
                        Intrinsics.checkNotNullParameter(it, "it");
                        itemCount = this$0.items().size();
                        Iterable $this$none$iv = this$0.getChildren();
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv2 : $this$none$iv) {
                                Element it2 = (Element)element$iv2;
                                boolean bl2 = false;
                                if (!(it2 instanceof SlideOut)) continue;
                                bl = false;
                                break block6;
                            }
                            bl = true;
                        }
                    }
                    if (!bl) break block8;
                    double height = Math.min(240.0, (double)itemCount * 24.0);
                    if (this$0.getScreenPosition().y() < this$0.root().getLayout().getScreenHeight() - height) {
                        so = new SlideOut(0.0, this$0.getScreenArea().height(), this$0.getScreenArea().width(), height, this$0, this$0.value);
                        this$0.append(so);
                        Element element = this$0.root();
                        Intrinsics.checkNotNull(element, "null cannot be cast to non-null type org.openrndr.panel.elements.Body");
                        ((Body)element).getControlManager().getKeyboardInput().requestFocus(so);
                    } else {
                        so = new SlideOut(0.0, this$0.getScreenArea().height() - height, this$0.getScreenArea().width(), height, this$0, this$0.value);
                        this$0.append(so);
                        Element element = this$0.root();
                        Intrinsics.checkNotNull(element, "null cannot be cast to non-null type org.openrndr.panel.elements.Body");
                        ((Body)element).getControlManager().getKeyboardInput().requestFocus(so);
                    }
                    break block9;
                }
                Iterable $this$first$iv = this$0.getChildren();
                boolean $i$f$first = false;
                for (Object element$iv3 : $this$first$iv) {
                    Element it3 = (Element)element$iv3;
                    boolean bl = false;
                    if (!(it3 instanceof SlideOut)) continue;
                    break block7;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            SlideOut slideOut = (SlideOut)element$iv3;
            if (slideOut == null) break block9;
            slideOut.dispose();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/openrndr/panel/elements/DropdownButton$Events;", "", "<init>", "()V", "valueChanged", "Lorg/openrndr/events/Event;", "Lorg/openrndr/panel/elements/DropdownButton$ValueChangedEvent;", "getValueChanged", "()Lorg/openrndr/events/Event;", "orx-panel"})
    public static final class Events {
        @NotNull
        private final Event<ValueChangedEvent> valueChanged = new Event(null, false, 3, null);

        @NotNull
        public final Event<ValueChangedEvent> getValueChanged() {
            return this.valueChanged;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0001\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/openrndr/panel/elements/DropdownButton$SlideOut;", "Lorg/openrndr/panel/elements/Element;", "x", "", "y", "width", "height", "parent", "active", "Lorg/openrndr/panel/elements/Item;", "<init>", "(DDDDLorg/openrndr/panel/elements/Element;Lorg/openrndr/panel/elements/Item;)V", "getX", "()D", "getY", "getWidth", "getHeight", "draw", "", "drawer", "Lorg/openrndr/draw/Drawer;", "dispose", "orx-panel"})
    @SourceDebugExtension(value={"SMAP\nDropdownButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DropdownButton.kt\norg/openrndr/panel/elements/DropdownButton$SlideOut\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,286:1\n1863#2,2:287\n*S KotlinDebug\n*F\n+ 1 DropdownButton.kt\norg/openrndr/panel/elements/DropdownButton$SlideOut\n*L\n228#1:287,2\n*E\n"})
    public static final class SlideOut
    extends Element {
        private final double x;
        private final double y;
        private final double width;
        private final double height;

        /*
         * WARNING - void declaration
         */
        public SlideOut(double x, double y, double width, double height, @NotNull Element parent, @Nullable Item active) {
            block2: {
                void $this$_init__u24lambda_u247;
                StyleSheet styleSheet;
                Intrinsics.checkNotNullParameter(parent, "parent");
                super(new ElementType("slide-out"));
                this.x = x;
                this.y = y;
                this.width = width;
                this.height = height;
                Map itemButtons = new LinkedHashMap();
                Ref.IntRef activeIndex = new Ref.IntRef();
                activeIndex.element = active != null ? ((DropdownButton)parent).items().indexOf(active) : -1;
                this.getKeyboard().getPressed().listen(arg_0 -> SlideOut._init_$lambda$4(this, activeIndex, parent, itemButtons, arg_0));
                this.getMouse().getScrolled().listen(arg_0 -> SlideOut._init_$lambda$5(this, arg_0));
                this.getMouse().getExited().listen(arg_0 -> SlideOut._init_$lambda$6(this, arg_0));
                StyleSheet styleSheet2 = styleSheet = new StyleSheet(CompoundSelector.Companion.getDUMMY());
                SlideOut slideOut = this;
                boolean bl = false;
                StyleSheetKt.setPosition((StyleSheet)$this$_init__u24lambda_u247, Position.ABSOLUTE);
                StyleSheetKt.setLeft((StyleSheet)$this$_init__u24lambda_u247, new LinearDimension.PX(this.x));
                StyleSheetKt.setTop((StyleSheet)$this$_init__u24lambda_u247, new LinearDimension.PX(this.y));
                StyleSheetKt.setWidth((StyleSheet)$this$_init__u24lambda_u247, new LinearDimension.PX(this.width));
                StyleSheetKt.setHeight((StyleSheet)$this$_init__u24lambda_u247, new LinearDimension.PX(this.height));
                StyleSheetKt.setOverflow((StyleSheet)$this$_init__u24lambda_u247, Overflow.Scroll.INSTANCE);
                StyleSheetKt.setZIndex((StyleSheet)$this$_init__u24lambda_u247, new ZIndex.Value(1000));
                StyleSheetKt.setBackground((StyleSheet)$this$_init__u24lambda_u247, Color.Inherit.INSTANCE);
                slideOut.setStyle(styleSheet);
                Iterable $this$forEach$iv = ((DropdownButton)parent).items();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void $this$lambda_u2410_u24lambda_u249;
                    Button button;
                    Item it = (Item)element$iv;
                    boolean bl2 = false;
                    Button button2 = button = new Button();
                    SlideOut slideOut2 = this;
                    boolean bl3 = false;
                    $this$lambda_u2410_u24lambda_u249.setData(it);
                    $this$lambda_u2410_u24lambda_u249.setLabel(it.getLabel());
                    itemButtons.put(it, $this$lambda_u2410_u24lambda_u249);
                    $this$lambda_u2410_u24lambda_u249.getEvents().getClicked().listen(arg_0 -> SlideOut.lambda$10$lambda$9$lambda$8(parent, (Button)$this$lambda_u2410_u24lambda_u249, this, arg_0));
                    slideOut2.append(button);
                }
                Item item = active;
                if (item == null) break block2;
                Item it = item;
                boolean bl4 = false;
                Object object = (Button)itemButtons.get(active);
                if (object != null && (object = ((Element)object).getPseudoClasses()) != null) {
                    ((ObservableHashSet)object).add(new ElementPseudoClass("selected"));
                }
            }
        }

        public final double getX() {
            return this.x;
        }

        public final double getY() {
            return this.y;
        }

        public final double getWidth() {
            return this.width;
        }

        public final double getHeight() {
            return this.height;
        }

        @Override
        public void draw(@NotNull Drawer drawer) {
            Intrinsics.checkNotNullParameter(drawer, "drawer");
            Color color = StyleSheetKt.getBackground(this.getComputedStyle());
            Object object = color instanceof Color.RGBa ? (Color.RGBa)color : null;
            if (object == null || (object = ((Color.RGBa)object).getColor()) == null) {
                object = ColorRGBa.Companion.getPINK();
            }
            drawer.setFill((ColorRGBa)object);
            drawer.setStroke(null);
            drawer.setStrokeWeight(0.0);
            drawer.rectangle(0.0, 0.0, this.getScreenArea().width(), this.getScreenArea().height());
            drawer.setStrokeWeight(1.0);
        }

        public final void dispose() {
            block0: {
                Element element = this.getParent();
                if (element == null) break block0;
                element.remove(this);
            }
        }

        private static final Unit _init_$lambda$4(SlideOut this$0, Ref.IntRef $activeIndex, Element $parent, Map $itemButtons, KeyEvent it) {
            double ypos;
            Item newValue;
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter($activeIndex, "$activeIndex");
            Intrinsics.checkNotNullParameter($parent, "$parent");
            Intrinsics.checkNotNullParameter($itemButtons, "$itemButtons");
            Intrinsics.checkNotNullParameter(it, "it");
            if (it.getKey() == 257) {
                it.cancelPropagation();
                this$0.dispose();
            }
            if (it.getKey() == 264) {
                $activeIndex.element = RangesKt.coerceAtMost($activeIndex.element + 1, ((DropdownButton)$parent).items().size() - 1);
                it.cancelPropagation();
                newValue = ((DropdownButton)$parent).items().get($activeIndex.element);
                Item item = ((DropdownButton)$parent).getValue();
                if (item != null) {
                    Item item2 = item;
                    boolean bl = false;
                    Object object = (Button)$itemButtons.get(item2);
                    if (object != null && (object = ((Element)object).getPseudoClasses()) != null) {
                        ((ObservableHashSet)object).remove(new ElementPseudoClass("selected"));
                    }
                }
                Item item3 = ((DropdownButton)$parent).getValue();
                if (item3 != null) {
                    Item it2 = item3;
                    boolean bl = false;
                    Object object = (Button)$itemButtons.get(newValue);
                    if (object != null && (object = ((Element)object).getPseudoClasses()) != null) {
                        ((ObservableHashSet)object).add(new ElementPseudoClass("selected"));
                    }
                }
                ((DropdownButton)$parent).setValue(newValue);
                ((DropdownButton)$parent).getEvents().getValueChanged().trigger(new ValueChangedEvent((DropdownButton)$parent, newValue));
                newValue.picked();
                this$0.getDraw().setDirty(true);
                ypos = 24.0 * (double)$activeIndex.element;
                if (ypos >= this$0.getScrollTop() + 240.0) {
                    this$0.setScrollTop(this$0.getScrollTop() + 24.0);
                }
            }
            if (it.getKey() == 265) {
                $activeIndex.element = RangesKt.coerceAtLeast($activeIndex.element - 1, 0);
                newValue = ((DropdownButton)$parent).items().get($activeIndex.element);
                ypos = 24.0 * (double)$activeIndex.element;
                if (ypos < this$0.getScrollTop()) {
                    this$0.setScrollTop(this$0.getScrollTop() - 24.0);
                }
                Item item = ((DropdownButton)$parent).getValue();
                if (item != null) {
                    Item item4 = item;
                    boolean bl = false;
                    Object object = (Button)$itemButtons.get(item4);
                    if (object != null && (object = ((Element)object).getPseudoClasses()) != null) {
                        ((ObservableHashSet)object).remove(new ElementPseudoClass("selected"));
                    }
                }
                Item item5 = ((DropdownButton)$parent).getValue();
                if (item5 != null) {
                    Item it3 = item5;
                    boolean bl = false;
                    Object object = (Button)$itemButtons.get(newValue);
                    if (object != null && (object = ((Element)object).getPseudoClasses()) != null) {
                        ((ObservableHashSet)object).add(new ElementPseudoClass("selected"));
                    }
                }
                ((DropdownButton)$parent).setValue(newValue);
                ((DropdownButton)$parent).getEvents().getValueChanged().trigger(new ValueChangedEvent((DropdownButton)$parent, newValue));
                newValue.picked();
                this$0.getDraw().setDirty(true);
            }
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$5(SlideOut this$0, MouseEvent it) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter(it, "it");
            this$0.setScrollTop(this$0.getScrollTop() - it.getRotation().y());
            this$0.setScrollTop(Math.max(0.0, this$0.getScrollTop()));
            this$0.getDraw().setDirty(true);
            it.cancelPropagation();
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$6(SlideOut this$0, MouseEvent it) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter(it, "it");
            it.cancelPropagation();
            this$0.dispose();
            return Unit.INSTANCE;
        }

        private static final Unit lambda$10$lambda$9$lambda$8(Element $parent, Button $this_apply, SlideOut this$0, Button.ButtonEvent it) {
            Intrinsics.checkNotNullParameter($parent, "$parent");
            Intrinsics.checkNotNullParameter($this_apply, "$this_apply");
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter(it, "it");
            DropdownButton dropdownButton = (DropdownButton)$parent;
            Object object = it.getSource().getData();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.openrndr.panel.elements.Item");
            dropdownButton.setValue((Item)object);
            Event<ValueChangedEvent> event = ((DropdownButton)$parent).getEvents().getValueChanged();
            DropdownButton dropdownButton2 = (DropdownButton)$parent;
            Object object2 = it.getSource().getData();
            Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type org.openrndr.panel.elements.Item");
            event.trigger(new ValueChangedEvent(dropdownButton2, (Item)object2));
            Object object3 = $this_apply.getData();
            Intrinsics.checkNotNull(object3, "null cannot be cast to non-null type org.openrndr.panel.elements.Item");
            ((Item)object3).picked();
            this$0.dispose();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/openrndr/panel/elements/DropdownButton$ValueChangedEvent;", "", "source", "Lorg/openrndr/panel/elements/DropdownButton;", "value", "Lorg/openrndr/panel/elements/Item;", "<init>", "(Lorg/openrndr/panel/elements/DropdownButton;Lorg/openrndr/panel/elements/Item;)V", "getSource", "()Lorg/openrndr/panel/elements/DropdownButton;", "getValue", "()Lorg/openrndr/panel/elements/Item;", "orx-panel"})
    public static final class ValueChangedEvent {
        @NotNull
        private final DropdownButton source;
        @NotNull
        private final Item value;

        public ValueChangedEvent(@NotNull DropdownButton source, @NotNull Item value2) {
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter(value2, "value");
            this.source = source;
            this.value = value2;
        }

        @NotNull
        public final DropdownButton getSource() {
            return this.source;
        }

        @NotNull
        public final Item getValue() {
            return this.value;
        }
    }
}

