/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.panel.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.CharacterEvent;
import org.openrndr.DropEvent;
import org.openrndr.KeyEvent;
import org.openrndr.MouseEvent;
import org.openrndr.draw.Drawer;
import org.openrndr.events.Event;
import org.openrndr.math.Vector2;
import org.openrndr.panel.collections.ObservableCopyOnWriteArrayList;
import org.openrndr.panel.collections.ObservableHashSet;
import org.openrndr.panel.elements.ElementClass;
import org.openrndr.panel.elements.ElementPseudoClass;
import org.openrndr.panel.elements.ElementType;
import org.openrndr.panel.elements.FocusEvent;
import org.openrndr.panel.style.CompoundSelector;
import org.openrndr.panel.style.StyleSheet;
import org.openrndr.shape.Rectangle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001:\u0007vwxyz{|B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010Q\u001a\u00020\u0000J\u0010\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\u0000H\u0016J\u000e\u0010U\u001a\u00020S2\u0006\u0010T\u001a\u00020\u0000J\u0010\u0010%\u001a\u00020S2\u0006\u0010V\u001a\u00020WH\u0016J \u0010X\u001a\b\u0012\u0004\u0012\u00020\u00000Y2\u0012\u0010Z\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000f0[J\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00000YJ\b\u0010]\u001a\u0004\u0018\u00010\u0000J\u0015\u0010^\u001a\u0004\u0018\u00010_2\u0006\u0010T\u001a\u00020\u0000\u00a2\u0006\u0002\u0010`J\f\u0010a\u001a\b\u0012\u0004\u0012\u00020\u00000YJ\b\u0010b\u001a\u0004\u0018\u00010\u0000J\b\u0010c\u001a\u0004\u0018\u00010\u0000J\u001c\u0010d\u001a\u0004\u0018\u00010\u00002\u0012\u0010e\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000f0[J\u001c\u0010f\u001a\u0004\u0018\u00010\u00002\u0012\u0010e\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000f0[J\u000e\u0010g\u001a\u00020S2\u0006\u0010h\u001a\u00020_J$\u0010i\u001a\u0004\u0018\u00010\u00002\u0006\u0010T\u001a\u00020\u00002\u0012\u0010j\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000f0[J \u0010k\u001a\u0004\u0018\u0001Hl\"\u0006\b\u0000\u0010l\u0018\u00012\u0006\u00101\u001a\u000202H\u0086\b\u00a2\u0006\u0002\u0010mR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u001c\u00101\u001a\u0004\u0018\u000102X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u0017\u00107\u001a\b\u0012\u0004\u0012\u00020908\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0017\u0010<\u001a\b\u0012\u0004\u0012\u00020=08\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010;R\u001c\u0010?\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u0019\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00000E8F\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u001a\u0010H\u001a\u00020IX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR\u001c\u0010N\u001a\u0004\u0018\u00010IX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010K\"\u0004\bP\u0010MR\u0011\u0010n\u001a\u00020o8F\u00a2\u0006\u0006\u001a\u0004\bp\u0010qR\u0011\u0010r\u001a\u00020s8F\u00a2\u0006\u0006\u001a\u0004\bt\u0010u\u00a8\u0006}"}, d2={"Lorg/openrndr/panel/elements/Element;", "", "type", "Lorg/openrndr/panel/elements/ElementType;", "<init>", "(Lorg/openrndr/panel/elements/ElementType;)V", "getType", "()Lorg/openrndr/panel/elements/ElementType;", "scrollTop", "", "getScrollTop", "()D", "setScrollTop", "(D)V", "handlesDoubleClick", "", "getHandlesDoubleClick", "()Z", "handlesKeyboardFocus", "getHandlesKeyboardFocus", "widthHint", "getWidthHint", "()Ljava/lang/Double;", "heightHint", "getHeightHint", "drop", "Lorg/openrndr/panel/elements/Element$DropObserverables;", "getDrop", "()Lorg/openrndr/panel/elements/Element$DropObserverables;", "mouse", "Lorg/openrndr/panel/elements/Element$MouseObservables;", "getMouse", "()Lorg/openrndr/panel/elements/Element$MouseObservables;", "keyboard", "Lorg/openrndr/panel/elements/Element$KeyboardObservables;", "getKeyboard", "()Lorg/openrndr/panel/elements/Element$KeyboardObservables;", "draw", "Lorg/openrndr/panel/elements/Element$Draw;", "getDraw", "()Lorg/openrndr/panel/elements/Element$Draw;", "layout", "Lorg/openrndr/panel/elements/Element$Layout;", "getLayout", "()Lorg/openrndr/panel/elements/Element$Layout;", "classEvents", "Lorg/openrndr/panel/elements/Element$ClassObserverables;", "getClassEvents", "()Lorg/openrndr/panel/elements/Element$ClassObserverables;", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "classes", "Lorg/openrndr/panel/collections/ObservableHashSet;", "Lorg/openrndr/panel/elements/ElementClass;", "getClasses", "()Lorg/openrndr/panel/collections/ObservableHashSet;", "pseudoClasses", "Lorg/openrndr/panel/elements/ElementPseudoClass;", "getPseudoClasses", "parent", "getParent", "()Lorg/openrndr/panel/elements/Element;", "setParent", "(Lorg/openrndr/panel/elements/Element;)V", "children", "Lorg/openrndr/panel/collections/ObservableCopyOnWriteArrayList;", "getChildren", "()Lorg/openrndr/panel/collections/ObservableCopyOnWriteArrayList;", "computedStyle", "Lorg/openrndr/panel/style/StyleSheet;", "getComputedStyle", "()Lorg/openrndr/panel/style/StyleSheet;", "setComputedStyle", "(Lorg/openrndr/panel/style/StyleSheet;)V", "style", "getStyle", "setStyle", "root", "append", "", "element", "remove", "drawer", "Lorg/openrndr/draw/Drawer;", "filter", "", "f", "Lkotlin/Function1;", "flatten", "previousSibling", "childIndex", "", "(Lorg/openrndr/panel/elements/Element;)Ljava/lang/Integer;", "ancestors", "previous", "next", "findNext", "premise", "findPrevious", "move", "steps", "findFirst", "matches", "elementWithId", "T", "(Ljava/lang/String;)Ljava/lang/Object;", "screenPosition", "Lorg/openrndr/math/Vector2;", "getScreenPosition", "()Lorg/openrndr/math/Vector2;", "screenArea", "Lorg/openrndr/shape/Rectangle;", "getScreenArea", "()Lorg/openrndr/shape/Rectangle;", "MouseObservables", "DropObserverables", "KeyboardObservables", "Layout", "Draw", "ClassEvent", "ClassObserverables", "orx-panel"})
@SourceDebugExtension(value={"SMAP\nElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Element.kt\norg/openrndr/panel/elements/Element\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,358:1\n1863#2:359\n1864#2:361\n1863#2,2:362\n1863#2,2:364\n1#3:360\n*S KotlinDebug\n*F\n+ 1 Element.kt\norg/openrndr/panel/elements/Element\n*L\n289#1:359\n289#1:361\n128#1:362,2\n131#1:364,2\n*E\n"})
public class Element {
    @NotNull
    private final ElementType type;
    private double scrollTop;
    private final boolean handlesDoubleClick;
    private final boolean handlesKeyboardFocus;
    @NotNull
    private final DropObserverables drop;
    @NotNull
    private final MouseObservables mouse;
    @NotNull
    private final KeyboardObservables keyboard;
    @NotNull
    private final Draw draw;
    @NotNull
    private final Layout layout;
    @NotNull
    private final ClassObserverables classEvents;
    @Nullable
    private String id;
    @NotNull
    private final ObservableHashSet<ElementClass> classes;
    @NotNull
    private final ObservableHashSet<ElementPseudoClass> pseudoClasses;
    @Nullable
    private Element parent;
    @NotNull
    private final ObservableCopyOnWriteArrayList<Element> children;
    @NotNull
    private StyleSheet computedStyle;
    @Nullable
    private StyleSheet style;

    public Element(@NotNull ElementType type) {
        Intrinsics.checkNotNullParameter(type, "type");
        this.type = type;
        this.drop = new DropObserverables();
        this.mouse = new MouseObservables();
        this.keyboard = new KeyboardObservables();
        this.draw = new Draw();
        this.layout = new Layout();
        this.classEvents = new ClassObserverables();
        this.classes = new ObservableHashSet();
        this.pseudoClasses = new ObservableHashSet();
        this.children = new ObservableCopyOnWriteArrayList();
        this.computedStyle = new StyleSheet(CompoundSelector.Companion.getDUMMY());
        this.pseudoClasses.getChanged().listen(arg_0 -> Element._init_$lambda$0(this, arg_0));
        this.classes.getChanged().listen(arg_0 -> Element._init_$lambda$3(this, arg_0));
        this.getChildren().getChanged().listen(arg_0 -> Element._init_$lambda$4(this, arg_0));
    }

    @NotNull
    public final ElementType getType() {
        return this.type;
    }

    public final double getScrollTop() {
        return this.scrollTop;
    }

    public final void setScrollTop(double d) {
        this.scrollTop = d;
    }

    public boolean getHandlesDoubleClick() {
        return this.handlesDoubleClick;
    }

    public boolean getHandlesKeyboardFocus() {
        return this.handlesKeyboardFocus;
    }

    @Nullable
    public Double getWidthHint() {
        return null;
    }

    @Nullable
    public Double getHeightHint() {
        return null;
    }

    @NotNull
    public final DropObserverables getDrop() {
        return this.drop;
    }

    @NotNull
    public final MouseObservables getMouse() {
        return this.mouse;
    }

    @NotNull
    public final KeyboardObservables getKeyboard() {
        return this.keyboard;
    }

    @NotNull
    public final Draw getDraw() {
        return this.draw;
    }

    @NotNull
    public final Layout getLayout() {
        return this.layout;
    }

    @NotNull
    public final ClassObserverables getClassEvents() {
        return this.classEvents;
    }

    @Nullable
    public final String getId() {
        return this.id;
    }

    public final void setId(@Nullable String string) {
        this.id = string;
    }

    @NotNull
    public final ObservableHashSet<ElementClass> getClasses() {
        return this.classes;
    }

    @NotNull
    public final ObservableHashSet<ElementPseudoClass> getPseudoClasses() {
        return this.pseudoClasses;
    }

    @Nullable
    public final Element getParent() {
        return this.parent;
    }

    public final void setParent(@Nullable Element element) {
        this.parent = element;
    }

    @NotNull
    public final ObservableCopyOnWriteArrayList<Element> getChildren() {
        return this.children;
    }

    @NotNull
    public final StyleSheet getComputedStyle() {
        return this.computedStyle;
    }

    public final void setComputedStyle(@NotNull StyleSheet styleSheet) {
        Intrinsics.checkNotNullParameter(styleSheet, "<set-?>");
        this.computedStyle = styleSheet;
    }

    @Nullable
    public final StyleSheet getStyle() {
        return this.style;
    }

    public final void setStyle(@Nullable StyleSheet styleSheet) {
        this.style = styleSheet;
    }

    @NotNull
    public final Element root() {
        Element element = this.parent;
        if (element == null || (element = element.root()) == null) {
            element = this;
        }
        return element;
    }

    public void append(@NotNull Element element) {
        Intrinsics.checkNotNullParameter(element, "element");
        if (!this.getChildren().contains(element)) {
            element.parent = this;
            this.getChildren().add(element);
        }
    }

    public final void remove(@NotNull Element element) {
        Intrinsics.checkNotNullParameter(element, "element");
        if (this.getChildren().contains(element)) {
            element.parent = null;
            this.getChildren().remove(element);
        }
    }

    public void draw(@NotNull Drawer drawer) {
        Intrinsics.checkNotNullParameter(drawer, "drawer");
    }

    @NotNull
    public final List<Element> filter(@NotNull Function1<? super Element, Boolean> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        ArrayList<Element> result2 = new ArrayList<Element>();
        Stack<Element> stack = new Stack<Element>();
        stack.add(this);
        while (!stack.isEmpty()) {
            Element node = (Element)stack.pop();
            Intrinsics.checkNotNull(node);
            if (!f.invoke(node).booleanValue()) continue;
            result2.add(node);
            stack.addAll((Collection)node.getChildren());
        }
        return result2;
    }

    @NotNull
    public final List<Element> flatten() {
        ArrayList<Element> result2 = new ArrayList<Element>();
        Stack<Element> stack = new Stack<Element>();
        stack.add(this);
        while (!stack.isEmpty()) {
            Element node = (Element)stack.pop();
            result2.add(node);
            stack.addAll((Collection)node.getChildren());
        }
        return result2;
    }

    @Nullable
    public final Element previousSibling() {
        Element element = this.parent;
        if (element != null) {
            Element p = element;
            boolean bl = false;
            Integer n = p.childIndex(this);
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                if (it > 0) {
                    return (Element)p.getChildren().get(it - 1);
                }
            }
        }
        return null;
    }

    @Nullable
    public final Integer childIndex(@NotNull Element element) {
        Intrinsics.checkNotNullParameter(element, "element");
        if (this.getChildren().contains(element)) {
            return this.getChildren().indexOf(element);
        }
        return null;
    }

    @NotNull
    public final List<Element> ancestors() {
        Element c2 = null;
        c2 = this;
        ArrayList<Element> result2 = new ArrayList<Element>();
        while (c2.parent != null) {
            Element it;
            if (c2.parent == null) continue;
            boolean bl = false;
            result2.add(it);
            c2 = it;
        }
        return result2;
    }

    @Nullable
    public final Element previous() {
        Element element;
        Element element2 = this.parent;
        if (element2 != null) {
            Element p = element2;
            boolean bl = false;
            int index = p.getChildren().indexOf(this);
            switch (index) {
                case -1: 
                case 0: {
                    element = null;
                    break;
                }
                default: {
                    element = (Element)p.getChildren().get(index - 1);
                }
            }
        } else {
            element = null;
        }
        return element;
    }

    @Nullable
    public final Element next() {
        Element element;
        Element element2 = this.parent;
        if (element2 != null) {
            Element p = element2;
            boolean bl = false;
            int index = p.getChildren().indexOf(this);
            element = index == -1 || index == p.getChildren().size() - 1 ? null : (Element)p.getChildren().get(index + 1);
        } else {
            element = null;
        }
        return element;
    }

    @Nullable
    public final Element findNext(@NotNull Function1<? super Element, Boolean> premise) {
        Intrinsics.checkNotNullParameter(premise, "premise");
        Element element = this.parent;
        if (element != null) {
            Element p = element;
            boolean bl = false;
            int index = p.getChildren().indexOf(this);
            int siblingCount = p.getChildren().size();
            for (int i = index + 1; i < siblingCount; ++i) {
                Object e = p.getChildren().get(i);
                Intrinsics.checkNotNullExpressionValue(e, "get(...)");
                if (!premise.invoke((Element)e).booleanValue()) continue;
                return (Element)p.getChildren().get(i);
            }
            return null;
        }
        return null;
    }

    @Nullable
    public final Element findPrevious(@NotNull Function1<? super Element, Boolean> premise) {
        Intrinsics.checkNotNullParameter(premise, "premise");
        Element element = this.parent;
        if (element != null) {
            Element p = element;
            boolean bl = false;
            int index = p.getChildren().indexOf(this);
            for (int i = index - 1; -1 < i; --i) {
                Object e = p.getChildren().get(i);
                Intrinsics.checkNotNullExpressionValue(e, "get(...)");
                if (!premise.invoke((Element)e).booleanValue()) continue;
                return (Element)p.getChildren().get(i);
            }
            return null;
        }
        return null;
    }

    public final void move(int steps2) {
        block1: {
            Element element = this.parent;
            if (element == null) break block1;
            Element p = element;
            boolean bl = false;
            if (steps2 != 0) {
                int index = p.getChildren().indexOf(this);
                p.getChildren().add(index + steps2, this);
                Element element2 = steps2 > 0 ? p.getChildren().remove(index) : p.getChildren().remove(index + 1);
            }
        }
    }

    @Nullable
    public final Element findFirst(@NotNull Element element, @NotNull Function1<? super Element, Boolean> matches) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(matches, "matches");
        if (matches.invoke(element).booleanValue()) {
            return element;
        }
        Iterable $this$forEach$iv = element.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element c2 = (Element)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(c2);
            Element element2 = this.findFirst(c2, matches);
            if (element2 == null) continue;
            Element it = element2;
            boolean bl2 = false;
            return it;
        }
        return null;
    }

    public final /* synthetic */ <T> T elementWithId(String id) {
        Intrinsics.checkNotNullParameter(id, "id");
        boolean $i$f$elementWithId = false;
        Intrinsics.needClassReification();
        Element element = this.findFirst(this, (Function1<? super Element, Boolean>)new Function1<Element, Boolean>(id){
            final /* synthetic */ String $id;
            {
                this.$id = $id;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Boolean invoke(Element e) {
                boolean bl;
                Intrinsics.checkNotNullParameter(e, "e");
                if (Intrinsics.areEqual(e.getId(), this.$id)) {
                    Intrinsics.reifiedOperationMarker(3, "T");
                    if (e instanceof Object) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        });
        Intrinsics.reifiedOperationMarker(1, "T");
        return (T)element;
    }

    @NotNull
    public final Vector2 getScreenPosition() {
        return new Vector2(this.layout.getScreenX(), this.layout.getScreenY());
    }

    @NotNull
    public final Rectangle getScreenArea() {
        return new Rectangle(new Vector2(this.layout.getScreenX(), this.layout.getScreenY()), this.layout.getScreenWidth(), this.layout.getScreenHeight());
    }

    private static final Unit _init_$lambda$0(Element this$0, ObservableHashSet.ChangeEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.draw.setDirty(true);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(Element this$0, ObservableHashSet.ChangeEvent it) {
        ElementClass it2;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.draw.setDirty(true);
        Iterable $this$forEach$iv = it.getAdded();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (ElementClass)element$iv;
            boolean bl = false;
            this$0.classEvents.getClassAdded().trigger(new ClassEvent(this$0, it2));
        }
        $this$forEach$iv = it.getRemoved();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (ElementClass)element$iv;
            boolean bl = false;
            this$0.classEvents.getClassRemoved().trigger(new ClassEvent(this$0, it2));
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(Element this$0, ObservableCopyOnWriteArrayList it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.draw.setDirty(true);
        return Unit.INSTANCE;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/openrndr/panel/elements/Element$ClassEvent;", "", "source", "Lorg/openrndr/panel/elements/Element;", "class", "Lorg/openrndr/panel/elements/ElementClass;", "<init>", "(Lorg/openrndr/panel/elements/Element;Lorg/openrndr/panel/elements/ElementClass;)V", "getSource", "()Lorg/openrndr/panel/elements/Element;", "getClass", "()Lorg/openrndr/panel/elements/ElementClass;", "orx-panel"})
    public static final class ClassEvent {
        @NotNull
        private final Element source;
        @NotNull
        private final ElementClass class;

        public ClassEvent(@NotNull Element source, @NotNull ElementClass elementClass) {
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter(elementClass, "class");
            this.source = source;
            this.class = elementClass;
        }

        @NotNull
        public final Element getSource() {
            return this.source;
        }

        @NotNull
        public final ElementClass getClass() {
            return this.class;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/openrndr/panel/elements/Element$ClassObserverables;", "", "<init>", "()V", "classAdded", "Lorg/openrndr/events/Event;", "Lorg/openrndr/panel/elements/Element$ClassEvent;", "getClassAdded", "()Lorg/openrndr/events/Event;", "classRemoved", "getClassRemoved", "orx-panel"})
    public static final class ClassObserverables {
        @NotNull
        private final Event<ClassEvent> classAdded = new Event("element-class-added", false, 2, null);
        @NotNull
        private final Event<ClassEvent> classRemoved = new Event("element-class-removed", false, 2, null);

        @NotNull
        public final Event<ClassEvent> getClassAdded() {
            return this.classAdded;
        }

        @NotNull
        public final Event<ClassEvent> getClassRemoved() {
            return this.classRemoved;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/openrndr/panel/elements/Element$Draw;", "", "<init>", "()V", "dirty", "", "getDirty", "()Z", "setDirty", "(Z)V", "orx-panel"})
    public static final class Draw {
        private boolean dirty = true;

        public final boolean getDirty() {
            return this.dirty;
        }

        public final void setDirty(boolean bl) {
            this.dirty = bl;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/openrndr/panel/elements/Element$DropObserverables;", "", "<init>", "()V", "dropped", "Lorg/openrndr/events/Event;", "Lorg/openrndr/DropEvent;", "getDropped", "()Lorg/openrndr/events/Event;", "orx-panel"})
    public static final class DropObserverables {
        @NotNull
        private final Event<DropEvent> dropped = new Event("element-dropped", false, 2, null);

        @NotNull
        public final Event<DropEvent> getDropped() {
            return this.dropped;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/openrndr/panel/elements/Element$KeyboardObservables;", "", "<init>", "()V", "pressed", "Lorg/openrndr/events/Event;", "Lorg/openrndr/KeyEvent;", "getPressed", "()Lorg/openrndr/events/Event;", "released", "getReleased", "repeated", "getRepeated", "character", "Lorg/openrndr/CharacterEvent;", "getCharacter", "focusGained", "Lorg/openrndr/panel/elements/FocusEvent;", "getFocusGained", "focusLost", "getFocusLost", "orx-panel"})
    public static final class KeyboardObservables {
        @NotNull
        private final Event<KeyEvent> pressed = new Event("element-keyboard-pressed", false, 2, null);
        @NotNull
        private final Event<KeyEvent> released = new Event("element-keyboard-released", false, 2, null);
        @NotNull
        private final Event<KeyEvent> repeated = new Event("element-keyboard-repeated", false, 2, null);
        @NotNull
        private final Event<CharacterEvent> character = new Event("element-keyboard-character", false, 2, null);
        @NotNull
        private final Event<FocusEvent> focusGained = new Event("element-keyboard-focus-gained", false, 2, null);
        @NotNull
        private final Event<FocusEvent> focusLost = new Event("element-keyboard-focus-lost", false, 2, null);

        @NotNull
        public final Event<KeyEvent> getPressed() {
            return this.pressed;
        }

        @NotNull
        public final Event<KeyEvent> getReleased() {
            return this.released;
        }

        @NotNull
        public final Event<KeyEvent> getRepeated() {
            return this.repeated;
        }

        @NotNull
        public final Event<CharacterEvent> getCharacter() {
            return this.character;
        }

        @NotNull
        public final Event<FocusEvent> getFocusGained() {
            return this.focusGained;
        }

        @NotNull
        public final Event<FocusEvent> getFocusLost() {
            return this.focusLost;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001f\u001a\u00020 H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0016\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000fR\u001a\u0010\u0019\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000fR\u001a\u0010\u001c\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\r\"\u0004\b\u001e\u0010\u000f\u00a8\u0006!"}, d2={"Lorg/openrndr/panel/elements/Element$Layout;", "", "<init>", "()V", "zIndex", "", "getZIndex", "()I", "setZIndex", "(I)V", "screenX", "", "getScreenX", "()D", "setScreenX", "(D)V", "screenY", "getScreenY", "setScreenY", "screenWidth", "getScreenWidth", "setScreenWidth", "screenHeight", "getScreenHeight", "setScreenHeight", "growWidth", "getGrowWidth", "setGrowWidth", "growHeight", "getGrowHeight", "setGrowHeight", "toString", "", "orx-panel"})
    public static final class Layout {
        private int zIndex;
        private double screenX;
        private double screenY;
        private double screenWidth;
        private double screenHeight;
        private double growWidth;
        private double growHeight;

        public final int getZIndex() {
            return this.zIndex;
        }

        public final void setZIndex(int n) {
            this.zIndex = n;
        }

        public final double getScreenX() {
            return this.screenX;
        }

        public final void setScreenX(double d) {
            this.screenX = d;
        }

        public final double getScreenY() {
            return this.screenY;
        }

        public final void setScreenY(double d) {
            this.screenY = d;
        }

        public final double getScreenWidth() {
            return this.screenWidth;
        }

        public final void setScreenWidth(double d) {
            this.screenWidth = d;
        }

        public final double getScreenHeight() {
            return this.screenHeight;
        }

        public final void setScreenHeight(double d) {
            this.screenHeight = d;
        }

        public final double getGrowWidth() {
            return this.growWidth;
        }

        public final void setGrowWidth(double d) {
            this.growWidth = d;
        }

        public final double getGrowHeight() {
            return this.growHeight;
        }

        public final void setGrowHeight(double d) {
            this.growHeight = d;
        }

        @NotNull
        public String toString() {
            return "Layout(screenX=" + this.screenX + ", screenY=" + this.screenY + ", screenWidth=" + this.screenWidth + ", screenHeight=" + this.screenHeight + ", growWidth=" + this.growWidth + ", growHeight=" + this.growHeight + ")";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\bR\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\b\u00a8\u0006\u0017"}, d2={"Lorg/openrndr/panel/elements/Element$MouseObservables;", "", "<init>", "()V", "clicked", "Lorg/openrndr/events/Event;", "Lorg/openrndr/MouseEvent;", "getClicked", "()Lorg/openrndr/events/Event;", "doubleClicked", "getDoubleClicked", "entered", "getEntered", "exited", "getExited", "dragged", "getDragged", "moved", "getMoved", "scrolled", "getScrolled", "pressed", "getPressed", "orx-panel"})
    public static final class MouseObservables {
        @NotNull
        private final Event<MouseEvent> clicked = new Event("element-mouse-clicked", false, 2, null);
        @NotNull
        private final Event<MouseEvent> doubleClicked = new Event("element-mouse-double-clicked", false, 2, null);
        @NotNull
        private final Event<MouseEvent> entered = new Event("element-mouse-entered", false, 2, null);
        @NotNull
        private final Event<MouseEvent> exited = new Event("element-mouse-exited", false, 2, null);
        @NotNull
        private final Event<MouseEvent> dragged = new Event("element-mouse-dragged", false, 2, null);
        @NotNull
        private final Event<MouseEvent> moved = new Event("element-mouse-moved", false, 2, null);
        @NotNull
        private final Event<MouseEvent> scrolled = new Event("element-mouse-scrolled", false, 2, null);
        @NotNull
        private final Event<MouseEvent> pressed = new Event("element-mouse-pressed", false, 2, null);

        @NotNull
        public final Event<MouseEvent> getClicked() {
            return this.clicked;
        }

        @NotNull
        public final Event<MouseEvent> getDoubleClicked() {
            return this.doubleClicked;
        }

        @NotNull
        public final Event<MouseEvent> getEntered() {
            return this.entered;
        }

        @NotNull
        public final Event<MouseEvent> getExited() {
            return this.exited;
        }

        @NotNull
        public final Event<MouseEvent> getDragged() {
            return this.dragged;
        }

        @NotNull
        public final Event<MouseEvent> getMoved() {
            return this.moved;
        }

        @NotNull
        public final Event<MouseEvent> getScrolled() {
            return this.scrolled;
        }

        @NotNull
        public final Event<MouseEvent> getPressed() {
            return this.pressed;
        }
    }
}

