/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.panel.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.MouseEvent;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.FontImageMap;
import org.openrndr.extra.textwriter.Cursor;
import org.openrndr.extra.textwriter.TextWriter;
import org.openrndr.math.Vector2;
import org.openrndr.panel.ControlManager;
import org.openrndr.panel.FontManager;
import org.openrndr.panel.elements.Body;
import org.openrndr.panel.elements.Button;
import org.openrndr.panel.elements.Element;
import org.openrndr.panel.elements.ElementType;
import org.openrndr.panel.elements.Envelope;
import org.openrndr.panel.elements.EnvelopeEditor;
import org.openrndr.panel.elements.Item;
import org.openrndr.panel.style.Color;
import org.openrndr.panel.style.CompoundSelector;
import org.openrndr.panel.style.LinearDimension;
import org.openrndr.panel.style.Overflow;
import org.openrndr.panel.style.Position;
import org.openrndr.panel.style.StyleSheet;
import org.openrndr.panel.style.StyleSheetKt;
import org.openrndr.panel.style.ZIndex;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0001H\u0016J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R(\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\""}, d2={"Lorg/openrndr/panel/elements/EnvelopeButton;", "Lorg/openrndr/panel/elements/Element;", "<init>", "()V", "label", "", "getLabel", "()Ljava/lang/String;", "setLabel", "(Ljava/lang/String;)V", "value", "Lorg/openrndr/panel/elements/Envelope;", "envelope", "getEnvelope", "()Lorg/openrndr/panel/elements/Envelope;", "setEnvelope", "(Lorg/openrndr/panel/elements/Envelope;)V", "envelopeSubscription", "Lkotlin/Function1;", "Lorg/openrndr/panel/elements/Envelope$EnvelopeChangedEvent;", "", "getEnvelopeSubscription", "()Lkotlin/jvm/functions/Function1;", "setEnvelopeSubscription", "(Lkotlin/jvm/functions/Function1;)V", "append", "element", "items", "", "Lorg/openrndr/panel/elements/Item;", "draw", "drawer", "Lorg/openrndr/draw/Drawer;", "SlideOut", "orx-panel"})
@SourceDebugExtension(value={"SMAP\nEnvelopeButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvelopeButton.kt\norg/openrndr/panel/elements/EnvelopeButton\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n774#2:142\n865#2,2:143\n1557#2:145\n1628#2,3:146\n1557#2:149\n1628#2,3:150\n*S KotlinDebug\n*F\n+ 1 EnvelopeButton.kt\norg/openrndr/panel/elements/EnvelopeButton\n*L\n46#1:142\n46#1:143,2\n46#1:145\n46#1:146,3\n69#1:149\n69#1:150,3\n*E\n"})
public final class EnvelopeButton
extends Element {
    @NotNull
    private String label = "OK";
    @NotNull
    private Envelope envelope = new Envelope(0.0, 1, null);
    @Nullable
    private Function1<? super Envelope.EnvelopeChangedEvent, Unit> envelopeSubscription;

    public EnvelopeButton() {
        super(new ElementType("envelope-button"));
        this.getMouse().getClicked().listen(arg_0 -> EnvelopeButton._init_$lambda$2(this, arg_0));
        this.envelopeSubscription = this.envelope.getEvents().getEnvelopeChanged().listen(arg_0 -> EnvelopeButton._init_$lambda$3(this, arg_0));
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.label = string;
    }

    @NotNull
    public final Envelope getEnvelope() {
        return this.envelope;
    }

    public final void setEnvelope(@NotNull Envelope value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        this.envelope = value2;
        Function1<? super Envelope.EnvelopeChangedEvent, Unit> function1 = this.envelopeSubscription;
        if (function1 != null) {
            Function1<? super Envelope.EnvelopeChangedEvent, Unit> it = function1;
            boolean bl = false;
            value2.getEvents().getEnvelopeChanged().cancel(it);
        }
        this.envelopeSubscription = value2.getEvents().getEnvelopeChanged().listen(arg_0 -> EnvelopeButton._set_envelope_$lambda$1(this, arg_0));
    }

    @Nullable
    public final Function1<Envelope.EnvelopeChangedEvent, Unit> getEnvelopeSubscription() {
        return this.envelopeSubscription;
    }

    public final void setEnvelopeSubscription(@Nullable Function1<? super Envelope.EnvelopeChangedEvent, Unit> function1) {
        this.envelopeSubscription = function1;
    }

    @Override
    public void append(@NotNull Element element) {
        Intrinsics.checkNotNullParameter(element, "element");
        Element element2 = element;
        if (!(element2 instanceof Item) && !(element2 instanceof SlideOut)) {
            throw new RuntimeException("only item and slideout");
        }
        super.append(element);
        super.append(element);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Item> items() {
        void $this$mapTo$iv$iv;
        Element it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getChildren();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Element)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof Item)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.openrndr.panel.elements.Item");
            collection.add((Item)it);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void draw(@NotNull Drawer drawer) {
        block5: {
            void $this$mapTo$iv$iv;
            Object writer;
            Intrinsics.checkNotNullParameter(drawer, "drawer");
            Object object = StyleSheetKt.getBackground(this.getComputedStyle());
            Object object2 = object instanceof Color.RGBa ? (Color.RGBa)object : null;
            if (object2 == null || (object2 = ((Color.RGBa)object2).getColor()) == null) {
                object2 = ColorRGBa.Companion.getPINK();
            }
            drawer.setFill((ColorRGBa)object2);
            drawer.rectangle(0.0, 0.0, this.getScreenArea().width(), this.getScreenArea().height());
            object = this.root();
            Object object3 = object instanceof Body ? (Body)object : null;
            if (object3 == null || (object3 = ((Body)object3).getControlManager()) == null || (object3 = ((ControlManager)object3).getFontManager()) == null) break block5;
            Object it = object3;
            boolean bl = false;
            double chartHeight = 0.0;
            Element element = this.root();
            Object object4 = element instanceof Body ? (Body)element : null;
            if (object4 != null && (object4 = ((Body)object4).getControlManager()) != null && (object4 = ((ControlManager)object4).getFontManager()) != null) {
                Object it2 = object4;
                boolean bl2 = false;
                FontImageMap font = ((FontManager)it2).font(this.getComputedStyle());
                writer = new TextWriter(drawer);
                drawer.setFontMap(font);
                drawer.setFill(ColorRGBa.Companion.getBLACK());
                ((TextWriter)writer).setCursor(new Cursor(0.0, this.getLayout().getScreenHeight() - 4.0));
                chartHeight = ((TextWriter)writer).getCursor().getY() - font.getHeight() - (double)4;
                TextWriter.text$default((TextWriter)writer, String.valueOf(this.label), false, 2, null);
            }
            double w = this.getLayout().getScreenWidth();
            double h = chartHeight;
            Iterable $this$map$iv = this.envelope.getPoints();
            boolean $i$f$map = false;
            writer = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                Vector2 vector2 = (Vector2)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                Vector2 v = new Vector2(w, h).times((Vector2)it3);
                collection.add(new Vector2(v.x(), h - v.y()));
            }
            List m = (List)destination$iv$iv;
            if (m.size() > 1) {
                drawer.setStroke(ColorRGBa.Companion.getWHITE());
                drawer.setStrokeWeight(2.0);
                drawer.lineStrip(m);
            }
            if (m.size() == 1) {
                drawer.setStroke(ColorRGBa.Companion.getWHITE());
                drawer.setStrokeWeight(2.0);
                drawer.lineSegment(0.0, ((Vector2)m.get(0)).y(), this.getLayout().getScreenWidth(), ((Vector2)m.get(0)).y());
            }
            drawer.setStroke(ColorRGBa.Companion.getBLACK().opacify(0.25));
            drawer.setStrokeWeight(1.0);
            drawer.lineSegment(this.envelope.getOffset() * w, 0.0, this.envelope.getOffset() * w, chartHeight);
            drawer.lineSegment(0.0, 0.0, 3.0, 0.0);
            drawer.lineSegment(0.0, 0.0, 0.0, chartHeight);
            drawer.lineSegment(0.0, chartHeight, 3.0, chartHeight);
            drawer.lineSegment(w, 0.0, w - 3.0, 0.0);
            drawer.lineSegment(w, 0.0, w, chartHeight);
            drawer.lineSegment(w, chartHeight, w - 3.0, chartHeight);
        }
    }

    private static final Unit _set_envelope_$lambda$1(EnvelopeButton this$0, Envelope.EnvelopeChangedEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.getDraw().setDirty(true);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(EnvelopeButton this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.append(new SlideOut(0.0, this$0.getScreenArea().height(), this$0.getScreenArea().width(), 200.0, this$0));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(EnvelopeButton this$0, Envelope.EnvelopeChangedEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.getDraw().setDirty(true);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/openrndr/panel/elements/EnvelopeButton$SlideOut;", "Lorg/openrndr/panel/elements/Element;", "x", "", "y", "width", "height", "parent", "Lorg/openrndr/panel/elements/EnvelopeButton;", "<init>", "(DDDDLorg/openrndr/panel/elements/EnvelopeButton;)V", "getX", "()D", "getY", "getWidth", "getHeight", "draw", "", "drawer", "Lorg/openrndr/draw/Drawer;", "dispose", "orx-panel"})
    public static final class SlideOut
    extends Element {
        private final double x;
        private final double y;
        private final double width;
        private final double height;

        /*
         * WARNING - void declaration
         */
        public SlideOut(double x, double y, double width, double height, @NotNull EnvelopeButton parent) {
            void $this$_init__u24lambda_u244;
            Object $this$_init__u24lambda_u242;
            Object $this$_init__u24lambda_u241;
            Intrinsics.checkNotNullParameter(parent, "parent");
            super(new ElementType("envelope-slide-out"));
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.getMouse().getClicked().listen(SlideOut::_init_$lambda$0);
            Object object = new StyleSheet(CompoundSelector.Companion.getDUMMY());
            StyleSheet styleSheet = object;
            SlideOut slideOut = this;
            boolean bl = false;
            StyleSheetKt.setPosition((StyleSheet)$this$_init__u24lambda_u241, Position.ABSOLUTE);
            StyleSheetKt.setLeft((StyleSheet)$this$_init__u24lambda_u241, new LinearDimension.PX(this.x));
            StyleSheetKt.setTop((StyleSheet)$this$_init__u24lambda_u241, new LinearDimension.PX(this.y));
            StyleSheetKt.setWidth((StyleSheet)$this$_init__u24lambda_u241, new LinearDimension.PX(this.width));
            StyleSheetKt.setHeight((StyleSheet)$this$_init__u24lambda_u241, LinearDimension.Auto.INSTANCE);
            StyleSheetKt.setOverflow((StyleSheet)$this$_init__u24lambda_u241, Overflow.Scroll.INSTANCE);
            StyleSheetKt.setZIndex((StyleSheet)$this$_init__u24lambda_u241, new ZIndex.Value(1));
            StyleSheetKt.setBackground((StyleSheet)$this$_init__u24lambda_u241, new Color.RGBa(new ColorRGBa(0.3, 0.3, 0.3, 0.0, null, 24, null)));
            slideOut.setStyle((StyleSheet)object);
            $this$_init__u24lambda_u241 = object = new EnvelopeEditor();
            slideOut = this;
            boolean bl2 = false;
            ((EnvelopeEditor)$this$_init__u24lambda_u242).setEnvelope(parent.getEnvelope());
            slideOut.append((Element)object);
            $this$_init__u24lambda_u242 = object = new Button();
            slideOut = this;
            boolean bl3 = false;
            $this$_init__u24lambda_u244.setLabel("done");
            $this$_init__u24lambda_u244.getEvents().getClicked().listen(arg_0 -> SlideOut.lambda$4$lambda$3(this, arg_0));
            slideOut.append((Element)object);
        }

        public final double getX() {
            return this.x;
        }

        public final double getY() {
            return this.y;
        }

        public final double getWidth() {
            return this.width;
        }

        public final double getHeight() {
            return this.height;
        }

        @Override
        public void draw(@NotNull Drawer drawer) {
            Intrinsics.checkNotNullParameter(drawer, "drawer");
            Color color = StyleSheetKt.getBackground(this.getComputedStyle());
            Object object = color instanceof Color.RGBa ? (Color.RGBa)color : null;
            if (object == null || (object = ((Color.RGBa)object).getColor()) == null) {
                object = ColorRGBa.Companion.getPINK();
            }
            drawer.setFill((ColorRGBa)object);
            drawer.rectangle(0.0, 0.0, this.getScreenArea().width(), this.getScreenArea().height());
        }

        public final void dispose() {
            block0: {
                Element element = this.getParent();
                if (element == null) break block0;
                element.remove(this);
            }
        }

        private static final Unit _init_$lambda$0(MouseEvent it) {
            Intrinsics.checkNotNullParameter(it, "it");
            it.cancelPropagation();
            return Unit.INSTANCE;
        }

        private static final Unit lambda$4$lambda$3(SlideOut this$0, Button.ButtonEvent it) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter(it, "it");
            this$0.dispose();
            return Unit.INSTANCE;
        }
    }
}

