/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.panel.elements;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.openrndr.CharacterEvent;
import org.openrndr.KeyEvent;
import org.openrndr.KeyModifier;
import org.openrndr.MouseEvent;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.LineCap;
import org.openrndr.events.Event;
import org.openrndr.extra.textwriter.Cursor;
import org.openrndr.extra.textwriter.TextWriter;
import org.openrndr.extra.textwriter.TextWriterKt;
import org.openrndr.panel.ControlManager;
import org.openrndr.panel.FontManager;
import org.openrndr.panel.elements.Body;
import org.openrndr.panel.elements.DisposableElement;
import org.openrndr.panel.elements.Element;
import org.openrndr.panel.elements.ElementKt;
import org.openrndr.panel.elements.ElementPseudoClass;
import org.openrndr.panel.elements.ElementType;
import org.openrndr.panel.style.Color;
import org.openrndr.panel.style.StyleSheetKt;
import org.openrndr.shape.RectangleKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0016\u001a\u00020\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lorg/openrndr/panel/elements/Textfield;", "Lorg/openrndr/panel/elements/Element;", "Lorg/openrndr/panel/elements/DisposableElement;", "<init>", "()V", "value", "", "getValue", "()Ljava/lang/String;", "setValue", "(Ljava/lang/String;)V", "label", "getLabel", "setLabel", "events", "Lorg/openrndr/panel/elements/Textfield$Events;", "getEvents", "()Lorg/openrndr/panel/elements/Textfield$Events;", "draw", "", "drawer", "Lorg/openrndr/draw/Drawer;", "disposed", "", "getDisposed", "()Z", "setDisposed", "(Z)V", "ValueChangedEvent", "Events", "orx-panel"})
public final class Textfield
extends Element
implements DisposableElement {
    @NotNull
    private String value = "";
    @NotNull
    private String label = "label";
    @NotNull
    private final Events events = new Events();
    private boolean disposed;

    public Textfield() {
        super(new ElementType("textfield"));
        this.getKeyboard().getRepeated().listen(arg_0 -> Textfield._init_$lambda$0(this, arg_0));
        this.getKeyboard().getPressed().listen(arg_0 -> Textfield._init_$lambda$2(this, arg_0));
        this.getKeyboard().getCharacter().listen(arg_0 -> Textfield._init_$lambda$3(this, arg_0));
        this.getMouse().getPressed().listen(Textfield::_init_$lambda$4);
        this.getMouse().getClicked().listen(Textfield::_init_$lambda$5);
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    public final void setValue(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.value = string;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.label = string;
    }

    @NotNull
    public final Events getEvents() {
        return this.events;
    }

    @Override
    public void draw(@NotNull Drawer drawer) {
        block5: {
            Intrinsics.checkNotNullParameter(drawer, "drawer");
            drawer.setFill(StyleSheetKt.getEffectiveBackground(this.getComputedStyle()));
            drawer.setStroke(null);
            drawer.rectangle(0.0, 0.0, this.getLayout().getScreenWidth(), this.getLayout().getScreenHeight());
            Element element = this.root();
            Object object = element instanceof Body ? (Body)element : null;
            if (object == null || (object = ((Body)object).getControlManager()) == null || (object = ((ControlManager)object).getFontManager()) == null) break block5;
            Object it = object;
            boolean bl = false;
            FontImageMap font = ((FontManager)it).font(this.getComputedStyle());
            drawer.setFontMap(font);
            double textHeight = font.getAscenderLength();
            double offset = 5.0;
            double yOffset = (double)Math.round(this.getLayout().getScreenHeight() / (double)2 + textHeight / 2.0 - 2.0) * 1.0;
            Color color = StyleSheetKt.getColor(this.getComputedStyle());
            Object object2 = color instanceof Color.RGBa ? (Color.RGBa)color : null;
            if (object2 == null || (object2 = ((Color.RGBa)object2).getColor()) == null) {
                object2 = ColorRGBa.Companion.getWHITE();
            }
            drawer.setFill((ColorRGBa)object2);
            drawer.text(this.label, 0.0 + offset, 0.0 + yOffset - textHeight * 1.5);
            color = StyleSheetKt.getColor(this.getComputedStyle());
            Object object3 = color instanceof Color.RGBa ? (Color.RGBa)color : null;
            if (object3 == null || (object3 = ((Color.RGBa)object3).getColor()) == null) {
                object3 = ColorRGBa.Companion.getWHITE();
            }
            drawer.setFill(((ColorRGBa)object3).opacify(0.05));
            drawer.rectangle(0.0 + offset, 0.0 + yOffset - (textHeight + (double)2), this.getLayout().getScreenWidth() - 10.0, textHeight + 8.0);
            drawer.getDrawStyle().setClip(RectangleKt.Rectangle(this.getScreenPosition().x() + offset, this.getScreenPosition().y() + yOffset - (textHeight + (double)2), this.getLayout().getScreenWidth() - 10.0, textHeight + 8.0));
            color = StyleSheetKt.getColor(this.getComputedStyle());
            Object object4 = color instanceof Color.RGBa ? (Color.RGBa)color : null;
            if (object4 == null || (object4 = ((Color.RGBa)object4).getColor()) == null) {
                object4 = ColorRGBa.Companion.getWHITE();
            }
            drawer.setFill((ColorRGBa)object4);
            Ref.DoubleRef cursorX = new Ref.DoubleRef();
            TextWriterKt.writer(drawer, arg_0 -> Textfield.draw$lambda$7$lambda$6(offset, yOffset, this, cursorX, arg_0));
            if (this.getPseudoClasses().contains(new ElementPseudoClass("active"))) {
                drawer.setStroke(ColorRGBa.Companion.getWHITE());
                drawer.lineSegment(cursorX.element + 1.0, yOffset, cursorX.element + 1.0, yOffset - textHeight);
            }
            drawer.getDrawStyle().setClip(null);
            Color color2 = StyleSheetKt.getColor(this.getComputedStyle());
            Object object5 = color2 instanceof Color.RGBa ? (Color.RGBa)color2 : null;
            if (object5 == null || (object5 = ((Color.RGBa)object5).getColor()) == null) {
                object5 = ColorRGBa.Companion.getWHITE();
            }
            drawer.setStroke((ColorRGBa)object5);
            drawer.setStrokeWeight(1.0);
            ColorRGBa colorRGBa = StyleSheetKt.getEffectiveColor(this.getComputedStyle());
            drawer.setStroke(colorRGBa != null ? colorRGBa.shade(0.25) : null);
            drawer.setLineCap(LineCap.ROUND);
        }
    }

    @Override
    public boolean getDisposed() {
        return this.disposed;
    }

    @Override
    public void setDisposed(boolean bl) {
        this.disposed = bl;
    }

    @Override
    public void dispose() {
        DisposableElement.DefaultImpls.dispose(this);
    }

    private static final Unit _init_$lambda$0(Textfield this$0, KeyEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        if (it.getKey() == 259 && ((CharSequence)this$0.value).length() > 0) {
            String oldValue = this$0.value;
            String string = this$0.value.substring(0, this$0.value.length() - 1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            this$0.value = string;
            this$0.events.getValueChanged().trigger(new ValueChangedEvent(this$0, oldValue, this$0.value));
            ElementKt.requestRedraw(this$0);
        }
        it.cancelPropagation();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(Textfield this$0, KeyEvent it) {
        String oldValue;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        if ((it.getModifiers().contains((Object)KeyModifier.CTRL) || it.getModifiers().contains((Object)KeyModifier.SUPER)) && Intrinsics.areEqual(it.getName(), "v")) {
            oldValue = this$0.value;
            Element element = this$0.root();
            Intrinsics.checkNotNull(element, "null cannot be cast to non-null type org.openrndr.panel.elements.Body");
            String string = ((Body)element).getControlManager().getProgram().getClipboard().getContents();
            if (string != null) {
                String it2 = string;
                boolean bl = false;
                this$0.value = this$0.value + it2;
            }
            this$0.events.getValueChanged().trigger(new ValueChangedEvent(this$0, oldValue, this$0.value));
            it.cancelPropagation();
        }
        if (it.getKey() == 259 && ((CharSequence)this$0.value).length() > 0) {
            oldValue = this$0.value;
            String string = this$0.value.substring(0, this$0.value.length() - 1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            this$0.value = string;
            this$0.events.getValueChanged().trigger(new ValueChangedEvent(this$0, oldValue, this$0.value));
        }
        ElementKt.requestRedraw(this$0);
        it.cancelPropagation();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(Textfield this$0, CharacterEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        String oldValue = this$0.value;
        this$0.value = this$0.value + it.getCharacter();
        this$0.events.getValueChanged().trigger(new ValueChangedEvent(this$0, oldValue, this$0.value));
        ElementKt.requestRedraw(this$0);
        it.cancelPropagation();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.cancelPropagation();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.cancelPropagation();
        return Unit.INSTANCE;
    }

    private static final Unit draw$lambda$7$lambda$6(double $offset, double $yOffset, Textfield this$0, Ref.DoubleRef $cursorX, TextWriter $this$writer) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($cursorX, "$cursorX");
        Intrinsics.checkNotNullParameter($this$writer, "$this$writer");
        double emWidth = $this$writer.textWidth("m") * (double)2;
        $this$writer.setCursor(new Cursor($offset, $yOffset));
        $this$writer.text(this$0.value, false);
        double width = $this$writer.getCursor().getX() - $offset;
        double scroll = width > this$0.getScreenArea().width() - emWidth ? this$0.getScreenArea().width() - emWidth - width : 0.0;
        $this$writer.setCursor(new Cursor($offset + scroll, $yOffset));
        TextWriter.text$default($this$writer, this$0.value, false, 2, null);
        $cursorX.element = $this$writer.getCursor().getX();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/openrndr/panel/elements/Textfield$Events;", "", "<init>", "()V", "valueChanged", "Lorg/openrndr/events/Event;", "Lorg/openrndr/panel/elements/Textfield$ValueChangedEvent;", "getValueChanged", "()Lorg/openrndr/events/Event;", "orx-panel"})
    public static final class Events {
        @NotNull
        private final Event<ValueChangedEvent> valueChanged = new Event("textfield-value-changed", false, 2, null);

        @NotNull
        public final Event<ValueChangedEvent> getValueChanged() {
            return this.valueChanged;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/openrndr/panel/elements/Textfield$ValueChangedEvent;", "", "source", "Lorg/openrndr/panel/elements/Textfield;", "oldValue", "", "newValue", "<init>", "(Lorg/openrndr/panel/elements/Textfield;Ljava/lang/String;Ljava/lang/String;)V", "getSource", "()Lorg/openrndr/panel/elements/Textfield;", "getOldValue", "()Ljava/lang/String;", "getNewValue", "orx-panel"})
    public static final class ValueChangedEvent {
        @NotNull
        private final Textfield source;
        @NotNull
        private final String oldValue;
        @NotNull
        private final String newValue;

        public ValueChangedEvent(@NotNull Textfield source, @NotNull String oldValue, @NotNull String newValue) {
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter(oldValue, "oldValue");
            Intrinsics.checkNotNullParameter(newValue, "newValue");
            this.source = source;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @NotNull
        public final Textfield getSource() {
            return this.source;
        }

        @NotNull
        public final String getOldValue() {
            return this.oldValue;
        }

        @NotNull
        public final String getNewValue() {
            return this.newValue;
        }
    }
}

