/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.panel.elements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.KeyEvent;
import org.openrndr.KeyModifier;
import org.openrndr.MouseEvent;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.Drawer;
import org.openrndr.events.Event;
import org.openrndr.extra.textwriter.TextWriter;
import org.openrndr.math.FunctionsKt;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Vector2;
import org.openrndr.panel.ControlManager;
import org.openrndr.panel.FontManager;
import org.openrndr.panel.elements.Body;
import org.openrndr.panel.elements.Element;
import org.openrndr.panel.elements.ElementKt;
import org.openrndr.panel.elements.ElementType;
import org.openrndr.panel.elements.XYPadKt;
import org.openrndr.panel.style.Color;
import org.openrndr.panel.style.StyleSheet;
import org.openrndr.panel.style.StyleSheetKt;
import org.openrndr.shape.LineSegment;
import org.openrndr.shape.LineSegmentKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002HIB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010:\u001a\u0002072\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010E\u001a\u0002072\u0006\u0010F\u001a\u00020GH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R$\u0010/\u001a\u00020)2\u0006\u0010.\u001a\u00020)8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b0\u0010+\"\u0004\b1\u0010-R\u0011\u00102\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0016\u0010=\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0014\u0010@\u001a\u00020)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010+R\u0014\u0010B\u001a\b\u0012\u0004\u0012\u00020D0CX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lorg/openrndr/panel/elements/XYPad;", "Lorg/openrndr/panel/elements/Element;", "<init>", "()V", "minX", "", "getMinX", "()D", "setMinX", "(D)V", "minY", "getMinY", "setMinY", "maxX", "getMaxX", "setMaxX", "maxY", "getMaxY", "setMaxY", "label", "", "getLabel", "()Ljava/lang/String;", "setLabel", "(Ljava/lang/String;)V", "precision", "", "getPrecision", "()I", "setPrecision", "(I)V", "showVector", "", "getShowVector", "()Z", "setShowVector", "(Z)V", "invertY", "getInvertY", "setInvertY", "normalizedValue", "Lorg/openrndr/math/Vector2;", "getNormalizedValue", "()Lorg/openrndr/math/Vector2;", "setNormalizedValue", "(Lorg/openrndr/math/Vector2;)V", "newValue", "value", "getValue", "setValue", "events", "Lorg/openrndr/panel/elements/XYPad$Events;", "getEvents", "()Lorg/openrndr/panel/elements/XYPad$Events;", "handleKeyEvent", "", "keyEvent", "Lorg/openrndr/KeyEvent;", "pick", "e", "Lorg/openrndr/MouseEvent;", "widthHint", "getWidthHint", "()Ljava/lang/Double;", "ballPosition", "getBallPosition", "grid", "", "Lorg/openrndr/shape/LineSegment;", "draw", "drawer", "Lorg/openrndr/draw/Drawer;", "ValueChangedEvent", "Events", "orx-panel"})
public final class XYPad
extends Element {
    private double minX = -1.0;
    private double minY = -1.0;
    private double maxX = 1.0;
    private double maxY = 1.0;
    @NotNull
    private String label = "";
    private int precision = 2;
    private boolean showVector;
    private boolean invertY = true;
    @NotNull
    private Vector2 normalizedValue = new Vector2(0.0, 0.0);
    @NotNull
    private final Events events;
    @NotNull
    private final List<LineSegment> grid;

    public XYPad() {
        super(new ElementType("xy-pad"));
        this.getMouse().getClicked().listen(arg_0 -> XYPad._init_$lambda$0(this, arg_0));
        this.getMouse().getDragged().listen(arg_0 -> XYPad._init_$lambda$1(this, arg_0));
        this.getMouse().getPressed().listen(XYPad::_init_$lambda$2);
        this.getKeyboard().getPressed().listen(arg_0 -> XYPad._init_$lambda$3(this, arg_0));
        this.getKeyboard().getRepeated().listen(arg_0 -> XYPad._init_$lambda$4(this, arg_0));
        this.events = new Events();
        this.grid = new ArrayList();
    }

    public final double getMinX() {
        return this.minX;
    }

    public final void setMinX(double d) {
        this.minX = d;
    }

    public final double getMinY() {
        return this.minY;
    }

    public final void setMinY(double d) {
        this.minY = d;
    }

    public final double getMaxX() {
        return this.maxX;
    }

    public final void setMaxX(double d) {
        this.maxX = d;
    }

    public final double getMaxY() {
        return this.maxY;
    }

    public final void setMaxY(double d) {
        this.maxY = d;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.label = string;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final void setPrecision(int n) {
        this.precision = n;
    }

    public final boolean getShowVector() {
        return this.showVector;
    }

    public final void setShowVector(boolean bl) {
        this.showVector = bl;
    }

    public final boolean getInvertY() {
        return this.invertY;
    }

    public final void setInvertY(boolean bl) {
        this.invertY = bl;
    }

    @NotNull
    public final Vector2 getNormalizedValue() {
        return this.normalizedValue;
    }

    public final void setNormalizedValue(@NotNull Vector2 vector2) {
        Intrinsics.checkNotNullParameter(vector2, "<set-?>");
        this.normalizedValue = vector2;
    }

    @NotNull
    public final Vector2 getValue() {
        return new Vector2(XYPadKt.round(MappingKt.map$default(-1.0, 1.0, this.minX, this.maxX, this.normalizedValue.x(), false, 32, null), this.precision), XYPadKt.round(MappingKt.map$default(-1.0, 1.0, this.minY, this.maxY, this.normalizedValue.y(), false, 32, null), this.precision));
    }

    public final void setValue(@NotNull Vector2 newValue) {
        Intrinsics.checkNotNullParameter(newValue, "newValue");
        this.normalizedValue = new Vector2(FunctionsKt.clamp(MappingKt.map$default(this.minX, this.maxX, -1.0, 1.0, newValue.x(), false, 32, null), -1.0, 1.0), FunctionsKt.clamp(MappingKt.map$default(this.minY, this.maxY, -1.0, 1.0, newValue.y(), false, 32, null), -1.0, 1.0));
        ElementKt.requestRedraw(this);
    }

    @NotNull
    public final Events getEvents() {
        return this.events;
    }

    private final void handleKeyEvent(KeyEvent keyEvent) {
        double keyboardIncrementX = keyEvent.getModifiers().contains((Object)KeyModifier.SHIFT) ? (this.maxX - this.minX) / 10.0 : Math.pow(10.0, -((double)this.precision - 0.0));
        double keyboardIncrementY = keyEvent.getModifiers().contains((Object)KeyModifier.SHIFT) ? (this.maxY - this.minY) / 10.0 : Math.pow(10.0, -((double)this.precision - 0.0));
        Vector2 old = this.getValue();
        if (keyEvent.getKey() == 262) {
            this.setValue(new Vector2(this.getValue().x() + keyboardIncrementX, this.getValue().y()));
        }
        if (keyEvent.getKey() == 263) {
            this.setValue(new Vector2(this.getValue().x() - keyboardIncrementX, this.getValue().y()));
        }
        if (keyEvent.getKey() == 265) {
            this.setValue(new Vector2(this.getValue().x(), this.getValue().y() - keyboardIncrementY * (this.invertY ? -1.0 : 1.0)));
        }
        if (keyEvent.getKey() == 264) {
            this.setValue(new Vector2(this.getValue().x(), this.getValue().y() + keyboardIncrementY * (this.invertY ? -1.0 : 1.0)));
        }
        ElementKt.requestRedraw(this);
        this.events.getValueChanged().trigger(new ValueChangedEvent(this, old, this.getValue()));
        keyEvent.cancelPropagation();
    }

    private final void pick(MouseEvent e) {
        Vector2 old = this.getValue();
        double dx = e.getPosition().x() - this.getLayout().getScreenX();
        double dy = e.getPosition().y() - this.getLayout().getScreenY();
        double nx = FunctionsKt.clamp(dx / this.getLayout().getScreenWidth() * 2.0 - 1.0, -1.0, 1.0);
        double ny = FunctionsKt.clamp(dy / this.getLayout().getScreenHeight() * 2.0 - 1.0, -1.0, 1.0) * (this.invertY ? -1.0 : 1.0);
        this.normalizedValue = new Vector2(nx, ny);
        this.events.getValueChanged().trigger(new ValueChangedEvent(this, old, this.getValue()));
        ElementKt.requestRedraw(this);
    }

    @Override
    @Nullable
    public Double getWidthHint() {
        return 200.0;
    }

    private final Vector2 getBallPosition() {
        return new Vector2(MappingKt.map$default(-1.0, 1.0, 0.0, this.getLayout().getScreenWidth(), this.normalizedValue.x(), false, 32, null), this.invertY ? MappingKt.map$default(1.0, -1.0, 0.0, this.getLayout().getScreenHeight(), this.normalizedValue.y(), false, 32, null) : MappingKt.map$default(-1.0, 1.0, 0.0, this.getLayout().getScreenHeight(), this.normalizedValue.y(), false, 32, null));
    }

    @Override
    public void draw(@NotNull Drawer drawer) {
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        if (this.grid.isEmpty()) {
            int n = 21;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                boolean bl = false;
                this.grid.add(LineSegmentKt.LineSegment(0.0, this.getLayout().getScreenHeight() / (double)20 * (double)n3, this.getLayout().getScreenWidth() - 1.0, this.getLayout().getScreenHeight() / (double)20 * (double)n3));
                this.grid.add(LineSegmentKt.LineSegment(this.getLayout().getScreenWidth() / (double)20 * (double)n3, 0.0, this.getLayout().getScreenWidth() / (double)20 * (double)n3, this.getLayout().getScreenHeight() - 1.0));
            }
        }
        StyleSheet it = this.getComputedStyle();
        boolean bl = false;
        drawer.pushTransforms();
        drawer.pushStyle();
        drawer.setFill(ColorRGBa.Companion.getGRAY());
        drawer.setStroke(null);
        drawer.setStrokeWeight(0.0);
        drawer.rectangle(0.0, 0.0, this.getLayout().getScreenWidth(), this.getLayout().getScreenHeight());
        drawer.setStroke(ColorRGBa.Companion.getGRAY().shade(1.1));
        drawer.setStrokeWeight(1.0);
        drawer.lineSegmentsFromLineSegmentList(this.grid);
        drawer.setStroke(ColorRGBa.Companion.getGRAY().shade(1.6));
        if (this.showVector) {
            drawer.lineSegment(new Vector2(this.getLayout().getScreenHeight() / 2.0, this.getLayout().getScreenWidth() / 2.0), this.getBallPosition());
        }
        drawer.setFill(ColorRGBa.Companion.getPINK());
        drawer.setStroke(ColorRGBa.Companion.getWHITE());
        drawer.circle(this.getBallPosition(), 8.0);
        Object object = "%.0" + this.precision + "f";
        Object[] objectArray = new Object[]{this.getValue().x()};
        String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        object = "%.0" + this.precision + "f";
        objectArray = new Object[]{this.getValue().y()};
        String string2 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        String valueLabel = string + ", " + string2;
        object = this.root();
        Object object2 = object instanceof Body ? (Body)object : null;
        if (object2 != null && (object2 = ((Body)object2).getControlManager()) != null && (object2 = ((ControlManager)object2).getFontManager()) != null) {
            Object it2 = object2;
            boolean bl2 = false;
            TextWriter writer = new TextWriter(drawer);
            drawer.setFontMap(((FontManager)it2).font(this.getComputedStyle()));
            double textWidth = writer.textWidth(valueLabel);
            Color color = StyleSheetKt.getColor(this.getComputedStyle());
            Object object3 = color instanceof Color.RGBa ? (Color.RGBa)color : null;
            if (object3 == null || (object3 = ((Color.RGBa)object3).getColor()) == null) {
                object3 = ColorRGBa.Companion.getWHITE();
            }
            drawer.setFill(((ColorRGBa)object3).opacify(this.getPseudoClasses().contains(ElementKt.getDisabled()) ? 0.25 : 1.0));
            drawer.text(valueLabel, this.getLayout().getScreenWidth() - textWidth - 4.0, this.getLayout().getScreenHeight() - 4.0);
            drawer.text(this.label, 0.0, this.getLayout().getScreenHeight() + 18.0);
        }
        drawer.popStyle();
        drawer.popTransforms();
    }

    private static final Unit _init_$lambda$0(XYPad this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        it.cancelPropagation();
        this$0.pick(it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(XYPad this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        it.cancelPropagation();
        this$0.pick(it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(MouseEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.cancelPropagation();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(XYPad this$0, KeyEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.handleKeyEvent(it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(XYPad this$0, KeyEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.handleKeyEvent(it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/openrndr/panel/elements/XYPad$Events;", "", "<init>", "()V", "valueChanged", "Lorg/openrndr/events/Event;", "Lorg/openrndr/panel/elements/XYPad$ValueChangedEvent;", "getValueChanged", "()Lorg/openrndr/events/Event;", "orx-panel"})
    public static final class Events {
        @NotNull
        private final Event<ValueChangedEvent> valueChanged = new Event("xypad-value-changed", false, 2, null);

        @NotNull
        public final Event<ValueChangedEvent> getValueChanged() {
            return this.valueChanged;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/openrndr/panel/elements/XYPad$ValueChangedEvent;", "", "source", "Lorg/openrndr/panel/elements/XYPad;", "oldValue", "Lorg/openrndr/math/Vector2;", "newValue", "<init>", "(Lorg/openrndr/panel/elements/XYPad;Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;)V", "getSource", "()Lorg/openrndr/panel/elements/XYPad;", "getOldValue", "()Lorg/openrndr/math/Vector2;", "getNewValue", "orx-panel"})
    public static final class ValueChangedEvent {
        @NotNull
        private final XYPad source;
        @NotNull
        private final Vector2 oldValue;
        @NotNull
        private final Vector2 newValue;

        public ValueChangedEvent(@NotNull XYPad source, @NotNull Vector2 oldValue, @NotNull Vector2 newValue) {
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter(oldValue, "oldValue");
            Intrinsics.checkNotNullParameter(newValue, "newValue");
            this.source = source;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @NotNull
        public final XYPad getSource() {
            return this.source;
        }

        @NotNull
        public final Vector2 getOldValue() {
            return this.oldValue;
        }

        @NotNull
        public final Vector2 getNewValue() {
            return this.newValue;
        }
    }
}

