/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.panel.tools;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.FontImageMap;
import org.openrndr.extra.textwriter.TextWriter;
import org.openrndr.extra.textwriter.TextWriterKt;
import org.openrndr.math.Vector2;
import org.openrndr.panel.elements.Body;
import org.openrndr.panel.elements.Element;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/openrndr/panel/tools/Tooltip;", "", "parent", "Lorg/openrndr/panel/elements/Element;", "position", "Lorg/openrndr/math/Vector2;", "message", "", "<init>", "(Lorg/openrndr/panel/elements/Element;Lorg/openrndr/math/Vector2;Ljava/lang/String;)V", "getParent", "()Lorg/openrndr/panel/elements/Element;", "getPosition", "()Lorg/openrndr/math/Vector2;", "getMessage", "()Ljava/lang/String;", "draw", "", "drawer", "Lorg/openrndr/draw/Drawer;", "orx-panel"})
public final class Tooltip {
    @NotNull
    private final Element parent;
    @NotNull
    private final Vector2 position;
    @NotNull
    private final String message;

    public Tooltip(@NotNull Element parent, @NotNull Vector2 position, @NotNull String message) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(message, "message");
        this.parent = parent;
        this.position = position;
        this.message = message;
    }

    @NotNull
    public final Element getParent() {
        return this.parent;
    }

    @NotNull
    public final Vector2 getPosition() {
        return this.position;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    public final void draw(@NotNull Drawer drawer) {
        Intrinsics.checkNotNullParameter(drawer, "drawer");
        Element element = this.parent.root();
        Intrinsics.checkNotNull(element, "null cannot be cast to non-null type org.openrndr.panel.elements.Body");
        String string = ((Body)element).getControlManager().getFontManager().resolve("default");
        if (string == null) {
            throw new IllegalStateException("no font".toString());
        }
        String fontUrl = string;
        double fontSize = 14.0;
        FontImageMap fontMap = FontImageMap.Companion.fromUrl$default(FontImageMap.Companion, fontUrl, fontSize, null, 0.0, 12, null);
        String[] stringArray = new String[]{"\n"};
        List lines = StringsKt.split$default((CharSequence)this.message, stringArray, false, 0, 6, null);
        DrawerKt.isolated(drawer, arg_0 -> Tooltip.draw$lambda$2(drawer, fontMap, this, lines, arg_0));
    }

    private static final Unit draw$lambda$2$lambda$0(List $lines, Ref.DoubleRef $maxX, Ref.DoubleRef $maxY, TextWriter $this$writer) {
        Intrinsics.checkNotNullParameter($lines, "$lines");
        Intrinsics.checkNotNullParameter($maxX, "$maxX");
        Intrinsics.checkNotNullParameter($maxY, "$maxY");
        Intrinsics.checkNotNullParameter($this$writer, "$this$writer");
        for (String line : $lines) {
            $this$writer.newLine();
            $this$writer.text(line, false);
            $maxX.element = Math.max($maxX.element, $this$writer.getCursor().getX());
            $maxY.element = $this$writer.getCursor().getY();
        }
        $this$writer.gaplessNewLine();
        $maxY.element = $this$writer.getCursor().getY();
        return Unit.INSTANCE;
    }

    private static final Unit draw$lambda$2$lambda$1(List $lines, TextWriter $this$writer) {
        Intrinsics.checkNotNullParameter($lines, "$lines");
        Intrinsics.checkNotNullParameter($this$writer, "$this$writer");
        for (String line : $lines) {
            $this$writer.newLine();
            TextWriter.text$default($this$writer, line, false, 2, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit draw$lambda$2(Drawer $drawer, FontImageMap $fontMap, Tooltip this$0, List $lines, Drawer $this$isolated) {
        Intrinsics.checkNotNullParameter($drawer, "$drawer");
        Intrinsics.checkNotNullParameter($fontMap, "$fontMap");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($lines, "$lines");
        Intrinsics.checkNotNullParameter($this$isolated, "$this$isolated");
        $drawer.setFontMap($fontMap);
        Ref.DoubleRef maxX = new Ref.DoubleRef();
        Ref.DoubleRef maxY = new Ref.DoubleRef();
        TextWriterKt.writer($drawer, arg_0 -> Tooltip.draw$lambda$2$lambda$0($lines, maxX, maxY, arg_0));
        Drawer.translate$default($drawer, this$0.position, null, 2, null);
        Drawer.translate$default($drawer, 10.0, 0.0, null, 4, null);
        $drawer.setStrokeWeight(0.5);
        $drawer.setStroke(ColorRGBa.Companion.getWHITE().opacify(0.25));
        $drawer.setFill(ColorRGBa.Companion.getGRAY());
        $drawer.rectangle(0.0, 0.0, maxX.element + 20.0, maxY.element);
        $drawer.setFill(ColorRGBa.Companion.getBLACK());
        Drawer.translate$default($drawer, 10.0, 0.0, null, 4, null);
        TextWriterKt.writer($drawer, arg_0 -> Tooltip.draw$lambda$2$lambda$1($lines, arg_0));
        return Unit.INSTANCE;
    }
}

