/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.platform;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.platform.PlatformDriver;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/openrndr/platform/MacOSPlatformDriver;", "Lorg/openrndr/platform/PlatformDriver;", "<init>", "()V", "temporaryDirectory", "Ljava/io/File;", "cacheDirectory", "programName", "", "supportDirectory", "path", "", "Companion", "openrndr-platform"})
@SourceDebugExtension(value={"SMAP\nMacOSPlatformDriver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacOSPlatformDriver.kt\norg/openrndr/platform/MacOSPlatformDriver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1557#2:78\n1628#2,3:79\n*S KotlinDebug\n*F\n+ 1 MacOSPlatformDriver.kt\norg/openrndr/platform/MacOSPlatformDriver\n*L\n34#1:78\n34#1:79,3\n*E\n"})
public final class MacOSPlatformDriver
implements PlatformDriver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static String randomID;

    @Override
    @NotNull
    public File temporaryDirectory() {
        String directoryName = System.getProperty("java.io.tmpdir") + "OPENRNDR-" + randomID;
        File file = new File(directoryName);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    @Override
    @NotNull
    public File cacheDirectory(@NotNull String programName) {
        Intrinsics.checkNotNullParameter(programName, "programName");
        String directoryName = System.getProperty("user.home") + "/Library/Caches/" + programName;
        File file = new File(directoryName);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    @Override
    @NotNull
    public File supportDirectory(@NotNull String programName) {
        Intrinsics.checkNotNullParameter(programName, "programName");
        String directoryName = System.getProperty("user.home") + "/Library/Application Support/" + programName;
        File file = new File(directoryName);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<File> path() {
        void $this$mapTo$iv$iv;
        String string = System.getenv("PATH");
        Intrinsics.checkNotNullExpressionValue(string, "getenv(...)");
        String[] stringArray = new String[]{":"};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new File((String)it));
        }
        return (List)destination$iv$iv;
    }

    static {
        char[] cArray = new char[]{'a', 'b', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        char[] alphabet = cArray;
        Object id = "";
        for (int i = 0; i < 8; ++i) {
            id = (String)id + alphabet[i];
        }
        randomID = id;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/openrndr/platform/MacOSPlatformDriver$Companion;", "", "<init>", "()V", "randomID", "", "getRandomID", "()Ljava/lang/String;", "setRandomID", "(Ljava/lang/String;)V", "openrndr-platform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getRandomID() {
            return randomID;
        }

        public final void setRandomID(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            randomID = string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

