/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.Transient;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.EuclideanVector;
import org.openrndr.math.LinearType;
import org.openrndr.math.MappingKt;
import org.openrndr.shape.SegmentType;
import org.openrndr.shape.ShapeToolsKt;
import org.openrndr.shape.internal.BezierCubicSamplerT;
import org.openrndr.shape.internal.BezierQuadraticSamplerT;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003J\u0015\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u001aH&\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u001aH&\u00a2\u0006\u0002\u0010\u001bJ\r\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u001aH\u0016J#\u0010\"\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000#2\u0006\u0010\u001d\u001a\u00020\u001aH&\u00a2\u0006\u0002\u0010$J\u0010\u0010-\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001aH&J\u001d\u0010.\u001a\u00028\u00002\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u00100J\u0018\u00104\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\b\b\u0002\u0010/\u001a\u00020\u001aH\u0016J$\u00105\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001a060\b2\b\b\u0002\u0010/\u001a\u00020\u001aH\u0016J \u00107\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u00108\u001a\u0002092\b\b\u0002\u0010/\u001a\u00020\u001aH\u0016J,\u0010:\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001a060\b2\u0006\u00108\u001a\u0002092\b\b\u0002\u0010/\u001a\u00020\u001aH\u0016R\u0012\u0010\u0004\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u001a\u0010\r\u001a\u00020\u000e8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u00148VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010%\u001a\u00020\u001a8&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b&\u0010\u0010\u001a\u0004\b'\u0010(R \u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u00008&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b*\u0010\u0010\u001a\u0004\b+\u0010,R \u00101\u001a\b\u0012\u0004\u0012\u00028\u00000\u00008&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b2\u0010\u0010\u001a\u0004\b3\u0010,\u00a8\u0006;"}, d2={"Lorg/openrndr/shape/BezierSegment;", "T", "Lorg/openrndr/math/EuclideanVector;", "", "start", "getStart", "()Lorg/openrndr/math/EuclideanVector;", "control", "", "getControl", "()Ljava/util/List;", "end", "getEnd", "linear", "", "getLinear$annotations", "()V", "getLinear", "()Z", "type", "Lorg/openrndr/shape/SegmentType;", "getType$annotations", "getType", "()Lorg/openrndr/shape/SegmentType;", "position", "ut", "", "(D)Lorg/openrndr/math/EuclideanVector;", "derivative", "t", "direction", "sub", "t0", "t1", "split", "", "(D)[Lorg/openrndr/shape/BezierSegment;", "length", "getLength$annotations", "getLength", "()D", "cubic", "getCubic$annotations", "getCubic", "()Lorg/openrndr/shape/BezierSegment;", "tForLength", "pointAtLength", "distanceTolerance", "(DD)Lorg/openrndr/math/EuclideanVector;", "reverse", "getReverse$annotations", "getReverse", "adaptivePositions", "adaptivePositionsWithT", "Lkotlin/Pair;", "equidistantPositions", "pointCount", "", "equidistantPositionsWithT", "openrndr-shape"})
public interface BezierSegment<T extends EuclideanVector<T>> {
    @NotNull
    public T getStart();

    @NotNull
    public List<T> getControl();

    @NotNull
    public T getEnd();

    public boolean getLinear();

    @NotNull
    public SegmentType getType();

    @NotNull
    public T position(double var1);

    @NotNull
    public T derivative(double var1);

    @NotNull
    public T direction();

    @NotNull
    public T direction(double var1);

    @NotNull
    public BezierSegment<T> sub(double var1, double var3);

    @NotNull
    public BezierSegment<T>[] split(double var1);

    public double getLength();

    @NotNull
    public BezierSegment<T> getCubic();

    public double tForLength(double var1);

    @NotNull
    public T pointAtLength(double var1, double var3);

    @NotNull
    public BezierSegment<T> getReverse();

    @NotNull
    public List<T> adaptivePositions(double var1);

    @NotNull
    public List<Pair<T, Double>> adaptivePositionsWithT(double var1);

    @NotNull
    public List<T> equidistantPositions(int var1, double var2);

    @NotNull
    public List<Pair<T, Double>> equidistantPositionsWithT(int var1, double var2);

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nSegment2D.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Segment2D.kt\norg/openrndr/shape/BezierSegment$DefaultImpls\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,938:1\n1557#2:939\n1628#2,3:940\n1#3:943\n*S KotlinDebug\n*F\n+ 1 Segment2D.kt\norg/openrndr/shape/BezierSegment$DefaultImpls\n*L\n137#1:939\n137#1:940,3\n*E\n"})
    public static final class DefaultImpls {
        public static <T extends EuclideanVector<T>> boolean getLinear(@NotNull BezierSegment<T> $this) {
            return $this.getControl().isEmpty();
        }

        @Transient
        public static /* synthetic */ void getLinear$annotations() {
        }

        @NotNull
        public static <T extends EuclideanVector<T>> SegmentType getType(@NotNull BezierSegment<T> $this) {
            return $this.getLinear() ? SegmentType.LINEAR : ($this.getControl().size() == 1 ? SegmentType.QUADRATIC : SegmentType.CUBIC);
        }

        @Transient
        public static /* synthetic */ void getType$annotations() {
        }

        @NotNull
        public static <T extends EuclideanVector<T>> T direction(@NotNull BezierSegment<T> $this) {
            return ((EuclideanVector)$this.getEnd().minus((LinearType)((LinearType)$this.getStart()))).getNormalized();
        }

        @NotNull
        public static <T extends EuclideanVector<T>> T direction(@NotNull BezierSegment<T> $this, double t) {
            return $this.derivative(t).getNormalized();
        }

        @NotNull
        public static <T extends EuclideanVector<T>> BezierSegment<T> sub(@NotNull BezierSegment<T> $this, double t0, double t1) {
            double z0 = t0;
            double z1 = t1;
            if (t0 > t1) {
                z1 = t0;
                z0 = t1;
            }
            return z0 == 0.0 ? $this.split(z1)[0] : (z1 == 1.0 ? ArraysKt.last($this.split(z0)) : ArraysKt.last($this.split(z0)).split(MappingKt.map$default(z0, 1.0, 0.0, 1.0, z1, false, 32, null))[0]);
        }

        @Transient
        public static /* synthetic */ void getLength$annotations() {
        }

        @Transient
        public static /* synthetic */ void getCubic$annotations() {
        }

        @NotNull
        public static <T extends EuclideanVector<T>> T pointAtLength(@NotNull BezierSegment<T> $this, double length, double distanceTolerance) {
            if (length <= 0.0) {
                return $this.getStart();
            }
            if (length >= $this.getLength()) {
                return $this.getEnd();
            }
            double remainingLength = length;
            Object currentPoint = $this.getStart();
            List<T> points2 = $this.adaptivePositions(distanceTolerance);
            for (EuclideanVector point : points2) {
                double segmentLength = currentPoint.distanceTo((EuclideanVector)point);
                if (remainingLength <= segmentLength) {
                    EuclideanVector currentVector = (EuclideanVector)point.minus((LinearType)currentPoint);
                    EuclideanVector tangent = (EuclideanVector)currentVector.div(segmentLength);
                    return (T)((EuclideanVector)currentPoint.plus(tangent.times(remainingLength)));
                }
                remainingLength -= segmentLength;
                currentPoint = point;
            }
            return $this.getEnd();
        }

        @Transient
        public static /* synthetic */ void getReverse$annotations() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static <T extends EuclideanVector<T>> List<T> adaptivePositions(@NotNull BezierSegment<T> $this, double distanceTolerance) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this.adaptivePositionsWithT(distanceTolerance);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((EuclideanVector)it.getFirst());
            }
            return (List)destination$iv$iv;
        }

        public static /* synthetic */ List adaptivePositions$default(BezierSegment bezierSegment, double d, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: adaptivePositions");
            }
            if ((n & 1) != 0) {
                d = 0.5;
            }
            return bezierSegment.adaptivePositions(d);
        }

        @NotNull
        public static <T extends EuclideanVector<T>> List<Pair<T, Double>> adaptivePositionsWithT(@NotNull BezierSegment<T> $this, double distanceTolerance) {
            return switch ($this.getControl().size()) {
                case 0 -> {
                    Pair[] var3_2 = new Pair[]{TuplesKt.to($this.getStart(), 0.0), TuplesKt.to($this.getEnd(), 1.0)};
                    yield CollectionsKt.listOf(var3_2);
                }
                case 1 -> {
                    BezierQuadraticSamplerT<EuclideanVector> var3_3;
                    BezierQuadraticSamplerT<EuclideanVector> $this$adaptivePositionsWithT_u24lambda_u241 = var3_3 = new BezierQuadraticSamplerT<EuclideanVector>();
                    boolean $i$a$-apply-BezierSegment$adaptivePositionsWithT$1 = false;
                    $this$adaptivePositionsWithT_u24lambda_u241.setDistanceTolerance(distanceTolerance);
                    yield var3_3.sample((EuclideanVector)$this.getStart(), (EuclideanVector)$this.getControl().get(0), (EuclideanVector)$this.getEnd());
                }
                case 2 -> {
                    BezierCubicSamplerT<EuclideanVector> var3_4;
                    BezierCubicSamplerT<EuclideanVector> $this$adaptivePositionsWithT_u24lambda_u242 = var3_4 = new BezierCubicSamplerT<EuclideanVector>();
                    boolean $i$a$-apply-BezierSegment$adaptivePositionsWithT$2 = false;
                    $this$adaptivePositionsWithT_u24lambda_u242.setDistanceTolerance(distanceTolerance);
                    yield var3_4.sample((EuclideanVector)$this.getStart(), (EuclideanVector)$this.getControl().get(0), (EuclideanVector)$this.getControl().get(1), (EuclideanVector)$this.getEnd());
                }
                default -> throw new RuntimeException("unsupported number of control points");
            };
        }

        public static /* synthetic */ List adaptivePositionsWithT$default(BezierSegment bezierSegment, double d, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: adaptivePositionsWithT");
            }
            if ((n & 1) != 0) {
                d = 0.5;
            }
            return bezierSegment.adaptivePositionsWithT(d);
        }

        @NotNull
        public static <T extends EuclideanVector<T>> List<T> equidistantPositions(@NotNull BezierSegment<T> $this, int pointCount, double distanceTolerance) {
            return ShapeToolsKt.sampleEquidistant($this.adaptivePositions(distanceTolerance), pointCount);
        }

        public static /* synthetic */ List equidistantPositions$default(BezierSegment bezierSegment, int n, double d, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: equidistantPositions");
            }
            if ((n2 & 2) != 0) {
                d = 0.5;
            }
            return bezierSegment.equidistantPositions(n, d);
        }

        @NotNull
        public static <T extends EuclideanVector<T>> List<Pair<T, Double>> equidistantPositionsWithT(@NotNull BezierSegment<T> $this, int pointCount, double distanceTolerance) {
            return ShapeToolsKt.sampleEquidistantWithT($this.adaptivePositionsWithT(distanceTolerance), pointCount);
        }

        public static /* synthetic */ List equidistantPositionsWithT$default(BezierSegment bezierSegment, int n, double d, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: equidistantPositionsWithT");
            }
            if ((n2 & 2) != 0) {
                d = 0.5;
            }
            return bezierSegment.equidistantPositionsWithT(n, d);
        }
    }
}

