/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.Vector2;
import org.openrndr.math.YPolarity;
import org.openrndr.shape.Circle;
import org.openrndr.shape.LineSegment;
import org.openrndr.shape.Segment2D;
import org.openrndr.shape.Segment2DKt;
import org.openrndr.shape.ShapeContour;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b!\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00152\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0007J\u0016\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001bJ\u000e\u0010 \u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0007J\u0016\u0010 \u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001bJ\u0016\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007J&\u0010!\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001bJ\u001e\u0010!\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007J6\u0010!\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001bJ\u000e\u0010+\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0007J\u0016\u0010+\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001bJ\u0016\u0010,\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007J&\u0010,\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001bJ\u001e\u0010,\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007J6\u0010,\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001bJ\u0006\u0010-\u001a\u00020\u0018J\u0006\u0010.\u001a\u00020\u0018J\u0016\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u0007J>\u00102\u001a\u00020\u00182\u0006\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u001bJ6\u00102\u001a\u00020\u00182\u0006\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0007J\u0018\u0010:\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u00072\b\b\u0002\u0010;\u001a\u00020\u001bJ \u0010:\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001b2\b\b\u0002\u0010;\u001a\u00020\u001bJ \u0010:\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u00072\b\b\u0002\u0010;\u001a\u00020\u001bJ0\u0010:\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001b2\b\b\u0002\u0010;\u001a\u00020\u001bJ#\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00070=2\u0006\u0010>\u001a\u00020\u001b2\u0006\u0010?\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010@J\u000e\u0010A\u001a\u00020\u00182\u0006\u0010A\u001a\u00020\u0011J\b\u0010B\u001a\u0004\u0018\u00010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0013\u0010C\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\u0017\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00150G8F\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u0013\u00a8\u0006I"}, d2={"Lorg/openrndr/shape/ContourBuilder;", "", "multipleContours", "", "<init>", "(Z)V", "cursor", "Lorg/openrndr/math/Vector2;", "getCursor", "()Lorg/openrndr/math/Vector2;", "setCursor", "(Lorg/openrndr/math/Vector2;)V", "anchor", "getAnchor", "setAnchor", "segments", "", "Lorg/openrndr/shape/Segment2D;", "getSegments", "()Ljava/util/List;", "contours", "Lorg/openrndr/shape/ShapeContour;", "getContours$openrndr_shape", "copy", "", "source", "connectEpsilon", "", "moveTo", "position", "x", "y", "moveOrLineTo", "moveOrCurveTo", "control", "cx", "cy", "control0", "control1", "c0x", "c0y", "c1x", "c1y", "lineTo", "curveTo", "close", "reverse", "circularArcTo", "through", "end", "arcTo", "crx", "cry", "angle", "largeArcFlag", "sweepFlag", "tx", "ty", "continueTo", "tangentScale", "arcToBeziers", "", "angleStart", "angleExtent", "(DD)[Lorg/openrndr/math/Vector2;", "segment", "undo", "lastSegment", "getLastSegment", "()Lorg/openrndr/shape/Segment2D;", "result", "", "getResult", "openrndr-shape"})
@SourceDebugExtension(value={"SMAP\nShapeBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShapeBuilder.kt\norg/openrndr/shape/ContourBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Functions.kt\norg/openrndr/math/FunctionsKt\n*L\n1#1,510:1\n1557#2:511\n1628#2,3:512\n1557#2:515\n1628#2,3:516\n1872#2,3:519\n1557#2:523\n1628#2,3:524\n110#3:522\n*S KotlinDebug\n*F\n+ 1 ShapeBuilder.kt\norg/openrndr/shape/ContourBuilder\n*L\n75#1:511\n75#1:512,3\n205#1:515\n205#1:516,3\n213#1:519,3\n472#1:523\n472#1:524,3\n246#1:522\n*E\n"})
public final class ContourBuilder {
    private final boolean multipleContours;
    @NotNull
    private Vector2 cursor;
    @NotNull
    private Vector2 anchor;
    @NotNull
    private final List<Segment2D> segments;
    @NotNull
    private final List<ShapeContour> contours;

    public ContourBuilder(boolean multipleContours) {
        this.multipleContours = multipleContours;
        this.cursor = Vector2.Companion.getINFINITY();
        this.anchor = Vector2.Companion.getINFINITY();
        this.segments = new ArrayList();
        this.contours = new ArrayList();
    }

    @NotNull
    public final Vector2 getCursor() {
        return this.cursor;
    }

    public final void setCursor(@NotNull Vector2 vector2) {
        Intrinsics.checkNotNullParameter(vector2, "<set-?>");
        this.cursor = vector2;
    }

    @NotNull
    public final Vector2 getAnchor() {
        return this.anchor;
    }

    public final void setAnchor(@NotNull Vector2 vector2) {
        Intrinsics.checkNotNullParameter(vector2, "<set-?>");
        this.anchor = vector2;
    }

    @NotNull
    public final List<Segment2D> getSegments() {
        return this.segments;
    }

    @NotNull
    public final List<ShapeContour> getContours$openrndr_shape() {
        return this.contours;
    }

    public final void copy(@NotNull ShapeContour source, double connectEpsilon) {
        Intrinsics.checkNotNullParameter(source, "source");
        if (this.segments.isEmpty() && !source.getEmpty()) {
            this.segments.addAll((Collection<Segment2D>)source.getSegments());
            this.anchor = CollectionsKt.first(this.segments).getStart();
            this.cursor = CollectionsKt.last(this.segments).getEnd();
        } else if (!source.getEmpty()) {
            Vector2 d = this.cursor.minus(CollectionsKt.first(source.getSegments()).getStart());
            if (d.squaredLength() > connectEpsilon * connectEpsilon) {
                this.lineTo(CollectionsKt.first(source.getSegments()).getStart());
            }
            for (Segment2D segment : source.getSegments()) {
                this.segment(segment);
            }
        }
    }

    public static /* synthetic */ void copy$default(ContourBuilder contourBuilder, ShapeContour shapeContour, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 1.0E-6;
        }
        contourBuilder.copy(shapeContour, d);
    }

    /*
     * WARNING - void declaration
     */
    public final void moveTo(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        if (!(this.multipleContours || this.anchor == Vector2.Companion.getINFINITY())) {
            boolean $i$a$-require-ContourBuilder$moveTo$22 = false;
            String $i$a$-require-ContourBuilder$moveTo$22 = "pen only can only be moved once per contour, use 'org.openrndr.shape.contours {}' to create multiple org.openrndr.shape.contours";
            throw new IllegalArgumentException($i$a$-require-ContourBuilder$moveTo$22.toString());
        }
        if (this.multipleContours && !((Collection)this.segments).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.segments;
            List<ShapeContour> list = this.contours;
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Segment2D segment2D = (Segment2D)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it);
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 4;
            YPolarity yPolarity = null;
            boolean bl = false;
            List list2 = (List)destination$iv$iv;
            list.add(new ShapeContour(list2, bl, yPolarity, n, defaultConstructorMarker));
            this.segments.clear();
        }
        this.cursor = position;
        this.anchor = position;
    }

    public final void moveTo(double x, double y) {
        this.moveTo(new Vector2(x, y));
    }

    public final void moveOrLineTo(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        if (this.anchor == Vector2.Companion.getINFINITY()) {
            this.moveTo(position);
        } else {
            this.lineTo(position);
        }
    }

    public final void moveOrLineTo(double x, double y) {
        this.moveOrLineTo(new Vector2(x, y));
    }

    public final void moveOrCurveTo(@NotNull Vector2 control, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(control, "control");
        Intrinsics.checkNotNullParameter(position, "position");
        if (this.anchor == Vector2.Companion.getINFINITY()) {
            this.moveTo(position);
        } else {
            this.curveTo(control, position);
        }
    }

    public final void moveOrCurveTo(double cx, double cy, double x, double y) {
        this.moveOrCurveTo(new Vector2(cx, cy), new Vector2(x, y));
    }

    public final void moveOrCurveTo(@NotNull Vector2 control0, @NotNull Vector2 control1, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(control0, "control0");
        Intrinsics.checkNotNullParameter(control1, "control1");
        Intrinsics.checkNotNullParameter(position, "position");
        if (this.anchor == Vector2.Companion.getINFINITY()) {
            this.moveTo(position);
        } else {
            this.curveTo(control0, control1, position);
        }
    }

    public final void moveOrCurveTo(double c0x, double c0y, double c1x, double c1y, double x, double y) {
        this.moveOrCurveTo(new Vector2(c0x, c0y), new Vector2(c1x, c1y), new Vector2(x, y));
    }

    public final void lineTo(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        if (!(this.cursor != Vector2.Companion.getINFINITY())) {
            boolean bl = false;
            String string = "use moveTo first";
            throw new IllegalArgumentException(string.toString());
        }
        if (position.minus(this.cursor).length() > 0.0) {
            Segment2D segment = Segment2DKt.Segment2D$default(this.cursor, position, false, 4, null);
            this.segments.add(segment);
            this.cursor = position;
        }
    }

    public final void lineTo(double x, double y) {
        this.lineTo(new Vector2(x, y));
    }

    public final void curveTo(@NotNull Vector2 control, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(control, "control");
        Intrinsics.checkNotNullParameter(position, "position");
        if (!(this.cursor != Vector2.Companion.getINFINITY())) {
            boolean bl = false;
            String string = "use moveTo first";
            throw new IllegalArgumentException(string.toString());
        }
        if (position.minus(this.cursor).squaredLength() > 0.0) {
            Segment2D segment = Segment2DKt.Segment2D$default(this.cursor, control, position, false, 8, null);
            this.segments.add(segment);
            this.cursor = position;
        }
    }

    public final void curveTo(double cx, double cy, double x, double y) {
        this.curveTo(new Vector2(cx, cy), new Vector2(x, y));
    }

    public final void curveTo(@NotNull Vector2 control0, @NotNull Vector2 control1, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(control0, "control0");
        Intrinsics.checkNotNullParameter(control1, "control1");
        Intrinsics.checkNotNullParameter(position, "position");
        if (!(this.cursor != Vector2.Companion.getINFINITY())) {
            boolean bl = false;
            String string = "use moveTo first";
            throw new IllegalArgumentException(string.toString());
        }
        if (position.minus(this.cursor).squaredLength() > 0.0) {
            Segment2D segment = Segment2DKt.Segment2D$default(this.cursor, control0, control1, position, false, 16, null);
            this.segments.add(segment);
            this.cursor = position;
        }
    }

    public final void curveTo(double c0x, double c0y, double c1x, double c1y, double x, double y) {
        this.curveTo(new Vector2(c0x, c0y), new Vector2(c1x, c1y), new Vector2(x, y));
    }

    /*
     * WARNING - void declaration
     */
    public final void close() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (!(!((Collection)this.segments).isEmpty())) {
            boolean $i$a$-require-ContourBuilder$close$22 = false;
            String $i$a$-require-ContourBuilder$close$22 = "cannot close contour with 0 segments";
            throw new IllegalArgumentException($i$a$-require-ContourBuilder$close$22.toString());
        }
        if (this.anchor.minus(this.cursor).length() > 0.001) {
            this.segments.add(Segment2DKt.Segment2D$default(this.cursor, this.anchor, false, 4, null));
        }
        Iterable iterable = this.segments;
        List<ShapeContour> list = this.contours;
        boolean $i$f$map = false;
        void var3_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Segment2D segment2D = (Segment2D)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it);
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 4;
        YPolarity yPolarity = null;
        boolean bl = true;
        List list2 = (List)destination$iv$iv;
        list.add(new ShapeContour(list2, bl, yPolarity, n, defaultConstructorMarker));
        this.segments.clear();
    }

    /*
     * WARNING - void declaration
     */
    public final void reverse() {
        Iterable $this$forEachIndexed$iv = this.segments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void segment;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Segment2D segment2D = (Segment2D)item$iv;
            int index = n;
            boolean bl = false;
            this.segments.set(index, segment.getReverse());
        }
        CollectionsKt.reverse(this.segments);
    }

    public final void circularArcTo(@NotNull Vector2 through, @NotNull Vector2 end) {
        boolean centerSide;
        Intrinsics.checkNotNullParameter(through, "through");
        Intrinsics.checkNotNullParameter(end, "end");
        Circle circle = Circle.Companion.fromPoints(this.cursor, through, end);
        boolean side = new LineSegment(this.cursor, end).side(through) < 0.0;
        boolean bl = centerSide = new LineSegment(this.cursor, end).side(circle.center()) < 0.0;
        if (side == centerSide) {
            this.arcTo(circle.radius(), circle.radius(), 90.0, true, side, end);
        } else {
            this.arcTo(circle.radius(), circle.radius(), 90.0, false, side, end);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void arcTo(double crx, double cry, double angle, boolean largeArcFlag, boolean sweepFlag, double tx, double ty) {
        int i;
        double n1;
        double p1;
        double tdy;
        void $this$asRadians$iv;
        if (!(this.cursor != Vector2.Companion.getINFINITY())) {
            boolean bl = false;
            String string = "use moveTo first";
            throw new IllegalArgumentException(string.toString());
        }
        double d = angle;
        double d2 = 360.0;
        double d3 = d % d2;
        d = !(d3 == 0.0) && !(Math.signum(d3) == Math.signum(d2)) ? d3 + d2 : d3;
        boolean $i$f$getAsRadians = false;
        void angleRad = $this$asRadians$iv * (Math.PI / 180);
        double tdx = this.cursor.x() - tx;
        if (tdx * tdx + (tdy = this.cursor.y() - ty) * tdy == 0.0) {
            return;
        }
        double radiiEpsilon = 1.0E-5;
        if (Math.abs(crx) <= radiiEpsilon || Math.abs(cry) <= radiiEpsilon) {
            this.lineTo(new Vector2(tx, ty));
            return;
        }
        double rx = Math.abs(crx);
        double ry = Math.abs(cry);
        double cosAngle = Math.cos((double)angleRad);
        double sinAngle = Math.sin((double)angleRad);
        double dx2 = (this.cursor.x() - tx) / 2.0;
        double dy2 = (this.cursor.y() - ty) / 2.0;
        double x1 = cosAngle * dx2 + sinAngle * dy2;
        double y1 = -sinAngle * dx2 + cosAngle * dy2;
        double rxSqr = rx * rx;
        double rySqr = ry * ry;
        double y1Sqr = y1 * y1;
        double x1Sqr = x1 * x1;
        double radiiCheck = x1 * x1 / (rx * rx) + y1 * y1 / (ry * ry);
        if (radiiCheck > 1.0) {
            rx *= Math.sqrt(radiiCheck);
            ry *= Math.sqrt(radiiCheck);
        }
        double sign0 = largeArcFlag == sweepFlag ? -1.0 : 1.0;
        double sq = (rxSqr * rySqr - rxSqr * y1Sqr - rySqr * x1Sqr) / (rxSqr * y1Sqr + rySqr * x1Sqr);
        sq = sq < 0.0 ? 0.0 : sq;
        double coefficient = sign0 * Math.sqrt(sq);
        double cx1 = coefficient * (rx * y1 / ry);
        double cy1 = coefficient * -(ry * x1 / rx);
        double sx2 = (this.cursor.x() + tx) / 2.0;
        double sy2 = (this.cursor.y() + ty) / 2.0;
        double cx = sx2 + (cosAngle * cx1 - sinAngle * cy1);
        double cy = sy2 + (sinAngle * cx1 + cosAngle * cy1);
        double ux = (x1 - cx1) / rx;
        double uy = (y1 - cy1) / ry;
        double vx = (-x1 - cx1) / rx;
        double vy = (-y1 - cy1) / ry;
        double n0 = Math.sqrt(ux * ux + uy * uy);
        double sign1 = uy < 0.0 ? -1.0 : 1.0;
        double angleStart = sign1 * Math.acos(ux / n0);
        double sign2 = ux * vy - uy * vx < 0.0 ? -1.0 : 1.0;
        double angleExtent = sign2 * ContourBuilder.arcTo$checkedACos((p1 = ux * vx + uy * vy) / (n1 = Math.sqrt((ux * ux + uy * uy) * (vx * vx + vy * vy))));
        if (angleExtent == 0.0) {
            this.lineTo(tx, ty);
            return;
        }
        if (!sweepFlag && angleExtent > 0.0) {
            angleExtent -= Math.PI * 2;
        } else if (sweepFlag && angleExtent < 0.0) {
            angleExtent += Math.PI * 2;
        }
        Vector2[] bezierPoints = this.arcToBeziers(angleStart %= Math.PI * 2, angleExtent %= Math.PI * 2);
        if (bezierPoints.length == 0) {
            return;
        }
        bezierPoints[ArraysKt.getLastIndex(bezierPoints)] = new Vector2(tx, ty);
        int n = bezierPoints.length;
        for (i = 0; i < n; ++i) {
            double x = bezierPoints[i].x();
            double y = bezierPoints[i].y();
            bezierPoints[i] = new Vector2(cosAngle * rx * x + -sinAngle * ry * y + cx, sinAngle * rx * x + cosAngle * ry * y + cy);
        }
        if (!(bezierPoints.length == 0)) {
            bezierPoints[bezierPoints.length - 1] = new Vector2(tx, ty);
            for (i = 0; i < bezierPoints.length; i += 3) {
                try {
                    this.curveTo(bezierPoints[i], bezierPoints[i + 1], bezierPoints[i + 2]);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException(("radii: " + crx + " " + cry + ", deltas: " + tdx + " " + tdy + " [" + i + "] " + bezierPoints[i] + ", " + bezierPoints[i + 1] + ", " + bezierPoints[i + 2]).toString());
                }
            }
        }
        this.cursor = new Vector2(tx, ty);
    }

    public final void arcTo(double crx, double cry, double angle, boolean largeArcFlag, boolean sweepFlag, @NotNull Vector2 end) {
        Intrinsics.checkNotNullParameter(end, "end");
        this.arcTo(crx, cry, angle, largeArcFlag, sweepFlag, end.x(), end.y());
    }

    public final void continueTo(@NotNull Vector2 end, double tangentScale) {
        Intrinsics.checkNotNullParameter(end, "end");
        if (this.cursor.minus(end).squaredLength() > 0.0) {
            if (!((Collection)this.segments).isEmpty() && !((Collection)CollectionsKt.last(this.segments).getControl()).isEmpty()) {
                Segment2D last2 = CollectionsKt.last(this.segments);
                Vector2 delta = CollectionsKt.last(last2.getControl()).minus(last2.getEnd());
                this.curveTo(last2.getEnd().minus(delta.times(tangentScale)), end);
            } else {
                this.curveTo(this.cursor.plus(end.minus(this.cursor).div(2.0)), end);
            }
        }
    }

    public static /* synthetic */ void continueTo$default(ContourBuilder contourBuilder, Vector2 vector2, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        contourBuilder.continueTo(vector2, d);
    }

    public final void continueTo(double x, double y, double tangentScale) {
        this.continueTo(new Vector2(x, y), tangentScale);
    }

    public static /* synthetic */ void continueTo$default(ContourBuilder contourBuilder, double d, double d2, double d3, int n, Object object) {
        if ((n & 4) != 0) {
            d3 = 1.0;
        }
        contourBuilder.continueTo(d, d2, d3);
    }

    public final void continueTo(@NotNull Vector2 control, @NotNull Vector2 end, double tangentScale) {
        Intrinsics.checkNotNullParameter(control, "control");
        Intrinsics.checkNotNullParameter(end, "end");
        if (!((Collection)this.segments).isEmpty() && !((Collection)CollectionsKt.last(this.segments).getControl()).isEmpty()) {
            Segment2D last2 = CollectionsKt.last(this.segments);
            Vector2 delta = CollectionsKt.last(last2.getControl()).minus(last2.getEnd());
            this.curveTo(last2.getEnd().minus(delta.times(tangentScale)), control, end);
        } else {
            this.curveTo(this.cursor.plus(end.minus(this.cursor).div(3.0)), control, end);
        }
    }

    public static /* synthetic */ void continueTo$default(ContourBuilder contourBuilder, Vector2 vector2, Vector2 vector22, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 1.0;
        }
        contourBuilder.continueTo(vector2, vector22, d);
    }

    public final void continueTo(double cx, double cy, double x, double y, double tangentScale) {
        this.continueTo(new Vector2(cx, cy), new Vector2(x, y), tangentScale);
    }

    public static /* synthetic */ void continueTo$default(ContourBuilder contourBuilder, double d, double d2, double d3, double d4, double d5, int n, Object object) {
        if ((n & 0x10) != 0) {
            d5 = 1.0;
        }
        contourBuilder.continueTo(d, d2, d3, d4, d5);
    }

    private final Vector2[] arcToBeziers(double angleStart, double angleExtent) {
        int numSegments = (int)Math.ceil(Math.abs(angleExtent) * 2.0 / Math.PI);
        double angleIncrement = angleExtent / (double)numSegments;
        double controlLength = 1.3333333333333333 * Math.sin(angleIncrement / 2.0) / (1.0 + Math.cos(angleIncrement / 2.0));
        int n = 0;
        int n2 = numSegments * 3;
        Vector2[] vector2Array = new Vector2[n2];
        while (n < n2) {
            int n3 = n++;
            vector2Array[n3] = Vector2.Companion.getZERO();
        }
        Vector2[] coordinates = vector2Array;
        int pos = 0;
        for (int i = 0; i < numSegments; ++i) {
            double angle = angleStart + (double)i * angleIncrement;
            double dx = Math.cos(angle);
            double dy = Math.sin(angle);
            coordinates[pos] = new Vector2(dx - controlLength * dy, dy + controlLength * dx);
            dx = Math.cos(angle += angleIncrement);
            dy = Math.sin(angle);
            coordinates[++pos] = new Vector2(dx + controlLength * dy, dy - controlLength * dx);
            coordinates[++pos] = new Vector2(dx, dy);
            ++pos;
        }
        return coordinates;
    }

    public final void segment(@NotNull Segment2D segment) {
        Intrinsics.checkNotNullParameter(segment, "segment");
        if (this.cursor != Vector2.Companion.getINFINITY() && !(segment.getStart().minus(this.cursor).length() < 0.01)) {
            boolean bl = false;
            String string = "segment is disconnected: cursor: " + this.cursor + ", segment.start: " + segment.getStart() + ", distance: " + this.cursor.minus(segment.getStart()).length();
            throw new IllegalArgumentException(string.toString());
        }
        if (this.cursor == Vector2.Companion.getINFINITY()) {
            this.moveTo(segment.getStart());
        }
        if (segment.getLinear()) {
            this.lineTo(segment.getEnd());
        } else if (segment.getControl().size() == 1) {
            this.curveTo(segment.getControl().get(0), segment.getEnd());
        } else {
            this.curveTo(segment.getControl().get(0), segment.getControl().get(1), segment.getEnd());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Segment2D undo() {
        Segment2D segment2D;
        if (!((Collection)this.segments).isEmpty()) {
            void var1_1;
            Segment2D r = this.segments.remove(CollectionsKt.getLastIndex(this.segments));
            this.cursor = r.getStart();
            segment2D = var1_1;
        } else {
            segment2D = null;
        }
        return segment2D;
    }

    @Nullable
    public final Segment2D getLastSegment() {
        return CollectionsKt.lastOrNull(this.segments);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ShapeContour> getResult() {
        List<Object> list;
        Collection collection = this.contours;
        if (!((Collection)this.segments).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.segments;
            Collection collection2 = collection;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Segment2D segment2D = (Segment2D)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                collection3.add(it);
            }
            collection = collection2;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 4;
            YPolarity yPolarity = null;
            boolean bl = false;
            List list2 = (List)destination$iv$iv;
            list = CollectionsKt.listOf(new ShapeContour(list2, bl, yPolarity, n, defaultConstructorMarker));
        } else {
            list = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus(collection, (Iterable)list);
    }

    private static final double arcTo$checkedACos(double v) {
        return v < -1.0 ? Math.PI : (v > 1.0 ? 0.0 : Math.acos(v));
    }
}

