/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.LinearType;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector2$;
import org.openrndr.math.YPolarity;
import org.openrndr.shape.LineSegment$;
import org.openrndr.shape.Segment2D;
import org.openrndr.shape.Segment2DKt;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.ShapeContourProvider;
import org.openrndr.shape.ShapeProvider;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 N2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002MNB\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tB/\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\b\u0010\u000eJ\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0006J\u0016\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015J\u0019\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00000\u001a2\u0006\u0010\u001b\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0015J\u001a\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u00152\b\b\u0002\u0010\u001b\u001a\u00020\u0015H\u0007J\u0018\u0010 \u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u00152\b\b\u0002\u0010\u001b\u001a\u00020\u0015J\u0010\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0015H\u0007J\u0018\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u00152\b\b\u0002\u0010%\u001a\u00020\u0015J\u0018\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u00152\b\b\u0002\u0010%\u001a\u00020\u0015J\u000e\u0010(\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0015J\u0011\u0010\"\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u0015H\u0096\u0002J\u0011\u00105\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u0015H\u0096\u0002J\u0011\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0000H\u0096\u0002J\u0011\u00108\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0000H\u0096\u0002J\u000e\u00109\u001a\u00020\u00152\u0006\u0010:\u001a\u00020\u0006J\t\u0010;\u001a\u00020\u0006H\u00c6\u0003J\t\u0010<\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010=\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010>\u001a\u00020?2\b\u0010@\u001a\u0004\u0018\u00010AH\u00d6\u0003J\t\u0010B\u001a\u00020\u000bH\u00d6\u0001J\t\u0010C\u001a\u00020DH\u00d6\u0001J%\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\u00002\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0001\u00a2\u0006\u0002\bLR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010$\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b$\u0010)R\u0011\u0010*\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b*\u0010)R\u0011\u0010+\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010-R\u0014\u0010.\u001a\u00020/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u00100R\u0014\u00101\u001a\u0002028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00103\u00a8\u0006O"}, d2={"Lorg/openrndr/shape/LineSegment;", "Lorg/openrndr/math/LinearType;", "Lorg/openrndr/shape/ShapeProvider;", "Lorg/openrndr/shape/ShapeContourProvider;", "Ljava/lang/Record;", "start", "Lorg/openrndr/math/Vector2;", "end", "<init>", "(Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()Lorg/openrndr/math/Vector2;", "direction", "normal", "nearest", "query", "distance", "", "sub", "t0", "t1", "split", "", "t", "(D)[Lorg/openrndr/shape/LineSegment;", "position", "rotate", "degrees", "rotateBy", "extend", "times", "extendBy", "length", "anchorT", "extendTo", "targetLength", "pointAtLength", "()D", "squaredLength", "segment", "Lorg/openrndr/shape/Segment2D;", "()Lorg/openrndr/shape/Segment2D;", "contour", "Lorg/openrndr/shape/ShapeContour;", "()Lorg/openrndr/shape/ShapeContour;", "shape", "Lorg/openrndr/shape/Shape;", "()Lorg/openrndr/shape/Shape;", "scale", "div", "plus", "right", "minus", "side", "v", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_shape", "$serializer", "Companion", "openrndr-shape"})
public final class LineSegment
extends Record
implements LinearType<LineSegment>,
ShapeProvider,
ShapeContourProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector2 start;
    @NotNull
    private final Vector2 end;

    public LineSegment(@NotNull Vector2 start, @NotNull Vector2 end) {
        Intrinsics.checkNotNullParameter(start, "start");
        Intrinsics.checkNotNullParameter(end, "end");
        this.start = start;
        this.end = end;
    }

    @NotNull
    public final Vector2 start() {
        return this.start;
    }

    @NotNull
    public final Vector2 end() {
        return this.end;
    }

    @NotNull
    public final Vector2 direction() {
        return this.end.minus(this.start);
    }

    @NotNull
    public final Vector2 normal() {
        return ((Vector2)this.end.minus(this.start).getNormalized()).perpendicular(YPolarity.CW_NEGATIVE_Y);
    }

    @NotNull
    public final Vector2 nearest(@NotNull Vector2 query) {
        Intrinsics.checkNotNullParameter(query, "query");
        double l2 = this.end.minus(this.start).squaredLength();
        if (l2 == 0.0) {
            return this.start;
        }
        double t = ((query.x() - this.start.x()) * (this.end.x() - this.start.x()) + (query.y() - this.start.y()) * (this.end.y() - this.start.y())) / l2;
        t = Math.max(0.0, Math.min(1.0, t));
        return new Vector2(this.start.x() + t * (this.end.x() - this.start.x()), this.start.y() + t * (this.end.y() - this.start.y()));
    }

    public final double distance(@NotNull Vector2 query) {
        Intrinsics.checkNotNullParameter(query, "query");
        return this.nearest(query).distanceTo(query);
    }

    @NotNull
    public final LineSegment sub(double t0, double t1) {
        double z0 = t0;
        double z1 = t1;
        if (t0 > t1) {
            z1 = t0;
            z0 = t1;
        }
        return z0 == 0.0 ? this.split(z1)[0] : (z1 == 1.0 ? this.split(z0)[1] : this.split(z0)[1].split(MappingKt.map$default(z0, 1.0, 0.0, 1.0, z1, false, 32, null))[0]);
    }

    @NotNull
    public final LineSegment[] split(double t) {
        double u = RangesKt.coerceIn(t, 0.0, 1.0);
        Vector2 cut = this.start.plus(this.end.minus(this.start).times(u));
        LineSegment[] lineSegmentArray = new LineSegment[]{new LineSegment(this.start, cut), new LineSegment(cut, this.end)};
        return lineSegmentArray;
    }

    @NotNull
    public final Vector2 position(double t) {
        return this.start.plus(this.end.minus(this.start).times(t));
    }

    @Deprecated(message="t value is not according to convention", replaceWith=@ReplaceWith(expression="rotateBy", imports={}))
    @NotNull
    public final LineSegment rotate(double degrees, double t) {
        Vector2 anchorPoint = this.end.mix(this.start, RangesKt.coerceIn(t, 0.0, 1.0));
        return new LineSegment(this.start.rotate(degrees, anchorPoint), this.end.rotate(degrees, anchorPoint));
    }

    public static /* synthetic */ LineSegment rotate$default(LineSegment lineSegment, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = 0.5;
        }
        return lineSegment.rotate(d, d2);
    }

    @NotNull
    public final LineSegment rotateBy(double degrees, double t) {
        Vector2 anchorPoint = this.start.mix(this.end, RangesKt.coerceIn(t, 0.0, 1.0));
        return new LineSegment(this.start.rotate(degrees, anchorPoint), this.end.rotate(degrees, anchorPoint));
    }

    public static /* synthetic */ LineSegment rotateBy$default(LineSegment lineSegment, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = 0.5;
        }
        return lineSegment.rotateBy(d, d2);
    }

    @Deprecated(message="extends by twice the amount", replaceWith=@ReplaceWith(expression="extendBy", imports={}))
    @NotNull
    public final LineSegment extend(double times) {
        return new LineSegment(this.start.minus(this.direction().times(times)), this.end.plus(this.direction().times(times)));
    }

    @NotNull
    public final LineSegment extendBy(double length, double anchorT) {
        Vector2 tangent = (Vector2)this.direction().getNormalized();
        return new LineSegment(this.start.minus(tangent.times(length).times(1.0 - anchorT)), this.end.plus(tangent.times(length).times(anchorT)));
    }

    public static /* synthetic */ LineSegment extendBy$default(LineSegment lineSegment, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = 0.5;
        }
        return lineSegment.extendBy(d, d2);
    }

    @NotNull
    public final LineSegment extendTo(double targetLength, double anchorT) {
        return this.extendBy(targetLength - this.length(), anchorT);
    }

    public static /* synthetic */ LineSegment extendTo$default(LineSegment lineSegment, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = 0.5;
        }
        return lineSegment.extendTo(d, d2);
    }

    @NotNull
    public final Vector2 pointAtLength(double length) {
        return length <= 0.0 ? this.start : (length >= this.length() ? this.end : this.start.plus(this.direction().div(this.length()).times(length)));
    }

    public final double length() {
        return this.start.distanceTo(this.end);
    }

    public final double squaredLength() {
        return this.start.squaredDistanceTo(this.end);
    }

    @NotNull
    public final Segment2D segment() {
        return Segment2DKt.Segment2D$default(this.start, this.end, false, 4, null);
    }

    @NotNull
    public ShapeContour contour() {
        Vector2[] vector2Array = new Vector2[]{this.start, this.end};
        return ShapeContour.Companion.fromPoints(CollectionsKt.listOf(vector2Array), false, YPolarity.CW_NEGATIVE_Y);
    }

    @NotNull
    public Shape shape() {
        return new Shape(CollectionsKt.listOf(this.contour()));
    }

    @Override
    @NotNull
    public LineSegment times(double scale) {
        return new LineSegment(this.start.times(scale), this.end.times(scale));
    }

    @Override
    @NotNull
    public LineSegment div(double scale) {
        return new LineSegment(this.start.div(scale), this.end.div(scale));
    }

    @Override
    @NotNull
    public LineSegment plus(@NotNull LineSegment right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new LineSegment(this.start.plus(right.start), this.end.plus(right.end));
    }

    @Override
    @NotNull
    public LineSegment minus(@NotNull LineSegment right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return new LineSegment(this.start.minus(right.start), this.end.minus(right.end));
    }

    public final double side(@NotNull Vector2 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return Math.signum((this.end.x() - this.start.x()) * (v.y() - this.start.y()) - (this.end.y() - this.start.y()) * (v.x() - this.start.x()));
    }

    @NotNull
    public final Vector2 component1() {
        return this.start;
    }

    @NotNull
    public final Vector2 component2() {
        return this.end;
    }

    @NotNull
    public final LineSegment copy(@NotNull Vector2 start, @NotNull Vector2 end) {
        Intrinsics.checkNotNullParameter(start, "start");
        Intrinsics.checkNotNullParameter(end, "end");
        return new LineSegment(start, end);
    }

    public static /* synthetic */ LineSegment copy$default(LineSegment lineSegment, Vector2 vector2, Vector2 vector22, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = lineSegment.start;
        }
        if ((n & 2) != 0) {
            vector22 = lineSegment.end;
        }
        return lineSegment.copy(vector2, vector22);
    }

    @Override
    @NotNull
    public String toString() {
        return "LineSegment(start=" + this.start + ", end=" + this.end + ")";
    }

    @Override
    public int hashCode() {
        int result2 = this.start.hashCode();
        result2 = result2 * 31 + this.end.hashCode();
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LineSegment)) {
            return false;
        }
        LineSegment lineSegment = (LineSegment)other;
        if (!Intrinsics.areEqual(this.start, lineSegment.start)) {
            return false;
        }
        return Intrinsics.areEqual(this.end, lineSegment.end);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_shape(LineSegment self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeSerializableElement(serialDesc, 0, Vector2$.serializer.INSTANCE, self.start);
        output.encodeSerializableElement(serialDesc, 1, Vector2$.serializer.INSTANCE, self.end);
    }

    public /* synthetic */ LineSegment(int seen0, Vector2 start, Vector2 end, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 3, $serializer.INSTANCE.getDescriptor());
        }
        this.start = start;
        this.end = end;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/shape/LineSegment$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/openrndr/shape/LineSegment;", "openrndr-shape"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<LineSegment> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

