/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector3$;
import org.openrndr.shape.LineSegment3D$;
import org.openrndr.shape.Path3D;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 12\u00020\u0001:\u000201B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B/\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0003J\u0016\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011J\u0019\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00000\u00172\u0006\u0010\u0018\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0011J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020\bH\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001J%\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0001\u00a2\u0006\u0002\b/R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\fR\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\fR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001d\u00a8\u00062"}, d2={"Lorg/openrndr/shape/LineSegment3D;", "Ljava/lang/Record;", "start", "Lorg/openrndr/math/Vector3;", "end", "<init>", "(Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()Lorg/openrndr/math/Vector3;", "direction", "nearest", "query", "distance", "", "squaredDistance", "sub", "t0", "t1", "split", "", "t", "(D)[Lorg/openrndr/shape/LineSegment3D;", "position", "path", "Lorg/openrndr/shape/Path3D;", "()Lorg/openrndr/shape/Path3D;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_shape", "$serializer", "Companion", "openrndr-shape"})
public final class LineSegment3D
extends Record {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector3 start;
    @NotNull
    private final Vector3 end;

    public LineSegment3D(@NotNull Vector3 start, @NotNull Vector3 end) {
        Intrinsics.checkNotNullParameter(start, "start");
        Intrinsics.checkNotNullParameter(end, "end");
        this.start = start;
        this.end = end;
    }

    @NotNull
    public final Vector3 start() {
        return this.start;
    }

    @NotNull
    public final Vector3 end() {
        return this.end;
    }

    @NotNull
    public final Vector3 direction() {
        return this.end.minus(this.start);
    }

    @NotNull
    public final Vector3 nearest(@NotNull Vector3 query) {
        Intrinsics.checkNotNullParameter(query, "query");
        double l2 = this.end.minus(this.start).squaredLength();
        if (l2 == 0.0) {
            return this.start;
        }
        double t = ((query.x() - this.start.x()) * (this.end.x() - this.start.x()) + (query.y() - this.start.y()) * (this.end.y() - this.start.y()) + (query.z() - this.start.z()) * (this.end.z() - this.start.z())) / l2;
        t = Math.max(0.0, Math.min(1.0, t));
        return new Vector3(this.start.x() + t * (this.end.x() - this.start.x()), this.start.y() + t * (this.end.y() - this.start.y()), this.start.z() + t * (this.end.z() - this.start.z()));
    }

    public final double distance(@NotNull Vector3 query) {
        Intrinsics.checkNotNullParameter(query, "query");
        return this.nearest(query).minus(query).length();
    }

    public final double squaredDistance(@NotNull Vector3 query) {
        Intrinsics.checkNotNullParameter(query, "query");
        return this.nearest(query).minus(query).squaredLength();
    }

    @NotNull
    public final LineSegment3D sub(double t0, double t1) {
        double z0 = t0;
        double z1 = t1;
        if (t0 > t1) {
            z1 = t0;
            z0 = t1;
        }
        return z0 == 0.0 ? this.split(z1)[0] : (z1 == 1.0 ? this.split(z0)[1] : this.split(z0)[1].split(MappingKt.map$default(z0, 1.0, 0.0, 1.0, z1, false, 32, null))[0]);
    }

    @NotNull
    public final LineSegment3D[] split(double t) {
        double u = RangesKt.coerceIn(t, 0.0, 1.0);
        Vector3 cut = this.start.plus(this.end.minus(this.start).times(u));
        LineSegment3D[] lineSegment3DArray = new LineSegment3D[]{new LineSegment3D(this.start, cut), new LineSegment3D(cut, this.end)};
        return lineSegment3DArray;
    }

    @NotNull
    public final Vector3 position(double t) {
        return this.start.plus(this.end.minus(this.start).times(t));
    }

    @NotNull
    public final Path3D path() {
        Vector3[] vector3Array = new Vector3[]{this.start, this.end};
        return Path3D.Companion.fromPoints(CollectionsKt.listOf(vector3Array), false);
    }

    @NotNull
    public final Vector3 component1() {
        return this.start;
    }

    @NotNull
    public final Vector3 component2() {
        return this.end;
    }

    @NotNull
    public final LineSegment3D copy(@NotNull Vector3 start, @NotNull Vector3 end) {
        Intrinsics.checkNotNullParameter(start, "start");
        Intrinsics.checkNotNullParameter(end, "end");
        return new LineSegment3D(start, end);
    }

    public static /* synthetic */ LineSegment3D copy$default(LineSegment3D lineSegment3D, Vector3 vector3, Vector3 vector32, int n, Object object) {
        if ((n & 1) != 0) {
            vector3 = lineSegment3D.start;
        }
        if ((n & 2) != 0) {
            vector32 = lineSegment3D.end;
        }
        return lineSegment3D.copy(vector3, vector32);
    }

    @Override
    @NotNull
    public String toString() {
        return "LineSegment3D(start=" + this.start + ", end=" + this.end + ")";
    }

    @Override
    public int hashCode() {
        int result2 = this.start.hashCode();
        result2 = result2 * 31 + this.end.hashCode();
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LineSegment3D)) {
            return false;
        }
        LineSegment3D lineSegment3D = (LineSegment3D)other;
        if (!Intrinsics.areEqual(this.start, lineSegment3D.start)) {
            return false;
        }
        return Intrinsics.areEqual(this.end, lineSegment3D.end);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_shape(LineSegment3D self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeSerializableElement(serialDesc, 0, Vector3$.serializer.INSTANCE, self.start);
        output.encodeSerializableElement(serialDesc, 1, Vector3$.serializer.INSTANCE, self.end);
    }

    public /* synthetic */ LineSegment3D(int seen0, Vector3 start, Vector3 end, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 3, $serializer.INSTANCE.getDescriptor());
        }
        this.start = start;
        this.end = end;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/shape/LineSegment3D$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/openrndr/shape/LineSegment3D;", "openrndr-shape"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<LineSegment3D> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

