/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector3$;
import org.openrndr.shape.BezierSegment;
import org.openrndr.shape.Path;
import org.openrndr.shape.Path3D$;
import org.openrndr.shape.PathProjection3D;
import org.openrndr.shape.Segment3D;
import org.openrndr.shape.Segment3D$;
import org.openrndr.shape.Segment3DKt;
import org.openrndr.shape.SegmentProjection3D;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 @2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002@AB\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB=\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\b\u0010\u000fJ\u0011\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000H\u0086\u0002J\u0010\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u000b2\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"J\u0018\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001eH\u0002J\u0018\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u001eH\u0016J\u001f\u0010)\u001a\u0004\u0018\u00010\u001e2\u0006\u0010*\u001a\u00020\u00022\b\b\u0002\u0010+\u001a\u00020\u001e\u00a2\u0006\u0002\u0010,J\u000e\u0010-\u001a\u00020.2\u0006\u0010*\u001a\u00020\u0002J$\u00102\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000504J\u0013\u00105\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u000106H\u0096\u0002J\b\u00107\u001a\u00020\u000bH\u0016J%\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0001\u00a2\u0006\u0002\b?R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00000\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0014\u0010\f\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0013R\u0011\u0010/\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u0006B"}, d2={"Lorg/openrndr/shape/Path3D;", "Lorg/openrndr/shape/Path;", "Lorg/openrndr/math/Vector3;", "segments", "", "Lorg/openrndr/shape/Segment3D;", "closed", "", "<init>", "(Ljava/util/List;Z)V", "seen0", "", "infinity", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/List;ZLorg/openrndr/math/Vector3;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getSegments", "()Ljava/util/List;", "getClosed", "()Z", "exploded", "getExploded", "plus", "other", "getInfinity", "()Lorg/openrndr/math/Vector3;", "empty", "getEmpty", "sampleLinear", "distanceTolerance", "", "sampleEquidistant", "pointCount", "transform", "Lorg/openrndr/math/Matrix44;", "mod", "a", "b", "sub", "t0", "t1", "on", "point", "error", "(Lorg/openrndr/math/Vector3;D)Ljava/lang/Double;", "project", "Lorg/openrndr/shape/PathProjection3D;", "reversed", "getReversed", "()Lorg/openrndr/shape/Path3D;", "map", "mapper", "Lkotlin/Function1;", "equals", "", "hashCode", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_shape", "Companion", "$serializer", "openrndr-shape"})
@SourceDebugExtension(value={"SMAP\nPath3D.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Path3D.kt\norg/openrndr/shape/Path3D\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,251:1\n1557#2:252\n1628#2,3:253\n1557#2:256\n1628#2,3:257\n1557#2:260\n1628#2,3:261\n1567#2:264\n1598#2,4:265\n2341#2,14:269\n1557#2:283\n1628#2,3:284\n1557#2:287\n1628#2,3:288\n*S KotlinDebug\n*F\n+ 1 Path3D.kt\norg/openrndr/shape/Path3D\n*L\n47#1:252\n47#1:253,3\n81#1:256\n81#1:257,3\n86#1:260\n86#1:261,3\n199#1:264\n199#1:265,4\n199#1:269,14\n208#1:283\n208#1:284,3\n212#1:287\n212#1:288,3\n*E\n"})
public final class Path3D
implements Path<Vector3> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Segment3D> segments;
    private final boolean closed;
    @NotNull
    private final Vector3 infinity;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;
    @NotNull
    private static final Path3D EMPTY;

    public Path3D(@NotNull List<Segment3D> segments, boolean closed) {
        Intrinsics.checkNotNullParameter(segments, "segments");
        this.segments = segments;
        this.closed = closed;
        this.infinity = Vector3.Companion.getINFINITY();
    }

    @Override
    @NotNull
    public List<Segment3D> getSegments() {
        return this.segments;
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Path3D> getExploded() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getSegments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Segment3D segment3D = (Segment3D)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Path3D(CollectionsKt.listOf(it), false));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Path3D plus(@NotNull Path3D other) {
        Intrinsics.checkNotNullParameter(other, "other");
        double epsilon = 0.001;
        List segments = new ArrayList();
        segments.addAll((Collection)this.getSegments());
        if (this.getSegments().get(this.getSegments().size() - 1).getEnd().minus(other.getSegments().get(0).getStart()).length() > epsilon) {
            segments.add(Segment3DKt.Segment3D(this.getSegments().get(this.getSegments().size() - 1).getEnd(), other.getSegments().get(0).getStart()));
        }
        segments.addAll((Collection)other.getSegments());
        return new Path3D(segments, false);
    }

    @Override
    @NotNull
    public Vector3 getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean getEmpty() {
        return this.getSegments().isEmpty();
    }

    @NotNull
    public final Path3D sampleLinear(double distanceTolerance) {
        return Companion.fromPoints(this.adaptivePositions(distanceTolerance), this.getClosed());
    }

    public static /* synthetic */ Path3D sampleLinear$default(Path3D path3D, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return path3D.sampleLinear(d);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Path3D sampleEquidistant(int pointCount, double distanceTolerance) {
        void $this$mapTo$iv$iv;
        List<Vector3> points2 = this.equidistantPositions(pointCount, distanceTolerance);
        Iterable $this$map$iv = RangesKt.until(0, points2.size() - 1);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Segment3DKt.Segment3D(points2.get((int)it), points2.get((int)(it + true))));
        }
        List segments = (List)destination$iv$iv;
        return new Path3D(segments, this.getClosed());
    }

    public static /* synthetic */ Path3D sampleEquidistant$default(Path3D path3D, int n, double d, int n2, Object object) {
        if ((n2 & 2) != 0) {
            d = 0.5;
        }
        return path3D.sampleEquidistant(n, d);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Path3D transform(@NotNull Matrix44 transform2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(transform2, "transform");
        Iterable $this$map$iv = this.getSegments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Segment3D segment3D = (Segment3D)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.transform(transform2));
        }
        boolean bl = this.getClosed();
        List list = (List)destination$iv$iv;
        return new Path3D(list, bl);
    }

    private final double mod(double a, double b) {
        return (a % b + b) % b;
    }

    @NotNull
    public Path3D sub(double t0, double t1) {
        double length;
        int segment0;
        double u0 = t0;
        double u1 = t1;
        if (this.getClosed() && (u1 < u0 || u1 > 1.0 || u0 > 1.0 || u0 < 0.0 || u1 < 0.0)) {
            double diff = u1 - u0;
            u0 = this.mod(u0, 1.0);
            if (Math.abs(diff) < 0.9999999999999998) {
                return diff > 0.0 ? ((u1 = u0 + diff) > 1.0 ? this.sub(u0, 1.0).plus(this.sub(0.0, u1 - 1.0)) : this.sub(u0, u1)) : ((u1 = u0 + diff) < 0.0 ? this.sub(u1 + 1.0, 1.0).plus(this.sub(0.0, u0)) : this.sub(u1, u0));
            }
            double d = u1 = diff < 0.0 ? u0 - 1.0 : u0 + 1.0;
            if (u1 > 1.0) {
                return this.sub(u0, 1.0).plus(this.sub(0.0, u1 - 1.0));
            }
            if (u1 < 1.0) {
                return this.sub(u0, 1.0).plus(this.sub(0.0, u1 + 1.0));
            }
        }
        u0 = RangesKt.coerceIn(u0, 0.0, 1.0);
        u1 = RangesKt.coerceIn(u1, 0.0, 1.0);
        double z0 = u0;
        double z1 = u1;
        if (u0 > u1) {
            z0 = u1;
            z1 = u0;
        }
        double segmentOffset0 = (segment0 = (int)(z0 * (length = (double)this.getSegments().size()))) < this.getSegments().size() ? z0 * length % 1.0 : 1.0;
        int segment1 = (int)(z1 * length);
        double segmentOffset1 = segment1 < this.getSegments().size() ? z1 * length % 1.0 : 1.0;
        segment1 = Math.min(this.getSegments().size() - 1, segment1);
        segment0 = Math.min(this.getSegments().size() - 1, segment0);
        List newSegments = new ArrayList();
        double epsilon = 1.0E-6;
        int s = segment0;
        int n = segment1;
        if (s <= n) {
            while (true) {
                if (s == segment0 && s == segment1) {
                    BezierSegment<Vector3> bezierSegment = this.getSegments().get(s).sub(segmentOffset0, segmentOffset1);
                    Intrinsics.checkNotNull(bezierSegment, "null cannot be cast to non-null type org.openrndr.shape.Segment3D");
                    newSegments.add((Segment3D)bezierSegment);
                } else if (s == segment0) {
                    if (segmentOffset0 < 1.0 - epsilon) {
                        BezierSegment<Vector3> bezierSegment = this.getSegments().get(s).sub(segmentOffset0, 1.0);
                        Intrinsics.checkNotNull(bezierSegment, "null cannot be cast to non-null type org.openrndr.shape.Segment3D");
                        newSegments.add((Segment3D)bezierSegment);
                    }
                } else if (s == segment1) {
                    if (segmentOffset1 > epsilon) {
                        BezierSegment<Vector3> bezierSegment = this.getSegments().get(s).sub(0.0, segmentOffset1);
                        Intrinsics.checkNotNull(bezierSegment, "null cannot be cast to non-null type org.openrndr.shape.Segment3D");
                        newSegments.add((Segment3D)bezierSegment);
                    }
                } else {
                    newSegments.add(this.getSegments().get(s));
                }
                if (s == n) break;
                ++s;
            }
        }
        return new Path3D(newSegments, false);
    }

    @Nullable
    public final Double on(@NotNull Vector3 point, double error) {
        Intrinsics.checkNotNullParameter(point, "point");
        int n = ((Collection)this.getSegments()).size();
        for (int i = 0; i < n; ++i) {
            Double st = this.getSegments().get(i).on(point, error);
            if (st == null) continue;
            return ((double)i + st) / (double)this.getSegments().size();
        }
        return null;
    }

    public static /* synthetic */ Double on$default(Path3D path3D, Vector3 vector3, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 5.0;
        }
        return path3D.on(vector3, d);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PathProjection3D project(@NotNull Vector3 point) {
        Object v0;
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(point, "point");
        Iterable $this$mapIndexed$iv = this.getSegments();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void it;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Segment3D segment3D = (Segment3D)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair<Integer, SegmentProjection3D>((int)index, it.project(point)));
        }
        Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                Pair it = (Pair)minElem$iv;
                boolean bl = false;
                double minValue$iv = ((SegmentProjection3D)it.getSecond()).getDistance();
                do {
                    Object e$iv = iterator$iv.next();
                    Pair it2 = (Pair)e$iv;
                    $i$a$-minByOrNull-Path3D$project$nearest$2 = false;
                    double v$iv = ((SegmentProjection3D)it2.getSecond()).getDistance();
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        Intrinsics.checkNotNull(v0);
        Pair nearest = v0;
        return new PathProjection3D((SegmentProjection3D)nearest.getSecond(), (((Number)nearest.getFirst()).doubleValue() + ((SegmentProjection3D)nearest.getSecond()).getProjection()) / (double)this.getSegments().size(), ((SegmentProjection3D)nearest.getSecond()).getDistance(), ((SegmentProjection3D)nearest.getSecond()).getPoint());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Path3D getReversed() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getSegments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Segment3D segment3D = (Segment3D)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getReverse());
        }
        boolean bl = this.getClosed();
        List<Segment3D> list = CollectionsKt.reversed((List)destination$iv$iv);
        return new Path3D(list, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Path3D map(boolean closed, @NotNull Function1<? super Segment3D, Segment3D> mapper) {
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(mapper, "mapper");
        Iterable $this$map$iv = this.getSegments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            destination$iv$iv.add(mapper.invoke((Segment3D)item$iv$iv));
        }
        List segments = (List)destination$iv$iv;
        List fixedSegments = new ArrayList();
        if (segments.size() > 1) {
            int $this$mapTo$iv$iv2 = segments.size() - 1;
            for (int i = 0; i < $this$mapTo$iv$iv2; ++i) {
                Segment3D left = (Segment3D)segments.get(i);
                Segment3D right = (Segment3D)segments.get(i + 1);
                Segment3D fixLeft = new Segment3D(left.getStart(), left.getControl(), right.getStart());
                fixedSegments.add(fixLeft);
            }
            if (closed) {
                Segment3D left = (Segment3D)CollectionsKt.last(segments);
                Segment3D right = (Segment3D)CollectionsKt.first(segments);
                v0 = fixedSegments.add(new Segment3D(left.getStart(), left.getControl(), right.getStart()));
            } else {
                v0 = fixedSegments.add(CollectionsKt.last(segments));
            }
        }
        return new Path3D(segments.size() > 1 ? fixedSegments : segments, closed);
    }

    public static /* synthetic */ Path3D map$default(Path3D path3D, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = path3D.getClosed();
        }
        return path3D.map(bl, function1);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Class<?> clazz = this.getClass();
        Object object = other;
        Intrinsics.checkNotNull(object);
        if (clazz != object.getClass()) {
            Path3D cfr_ignored_0 = (Path3D)other;
        }
        if (!Intrinsics.areEqual(this.getSegments(), ((Path3D)other).getSegments())) {
            return false;
        }
        return this.getClosed() == ((Path3D)other).getClosed();
    }

    public int hashCode() {
        int result2 = ((Object)this.getSegments()).hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.getClosed());
        return result2;
    }

    @Override
    public double getLength() {
        return Path.DefaultImpls.getLength(this);
    }

    @Override
    @NotNull
    public Vector3 position(double ut) {
        return Path.DefaultImpls.position(this, ut);
    }

    @Override
    @NotNull
    public Vector3 direction(double ut) {
        return Path.DefaultImpls.direction(this, ut);
    }

    @Override
    public double tForLength(double length) {
        return Path.DefaultImpls.tForLength(this, length);
    }

    @Override
    @NotNull
    public Pair<Integer, Double> segment(double ut) {
        return Path.DefaultImpls.segment(this, ut);
    }

    @Override
    @NotNull
    public Vector3 pointAtLength(double length, double distanceTolerance) {
        return Path.DefaultImpls.pointAtLength(this, length, distanceTolerance);
    }

    @Override
    @NotNull
    public List<Vector3> adaptivePositions(double distanceTolerance) {
        return Path.DefaultImpls.adaptivePositions(this, distanceTolerance);
    }

    @Override
    @NotNull
    public List<Pair<Vector3, Double>> adaptivePositionsWithT(double distanceTolerance) {
        return Path.DefaultImpls.adaptivePositionsWithT(this, distanceTolerance);
    }

    @Override
    @NotNull
    public List<Vector3> equidistantPositions(int pointCount, double distanceTolerance) {
        return Path.DefaultImpls.equidistantPositions(this, pointCount, distanceTolerance);
    }

    @Override
    @NotNull
    public List<Pair<Vector3, Double>> equidistantPositionsWithT(int pointCount, double distanceTolerance) {
        return Path.DefaultImpls.equidistantPositionsWithT(this, pointCount, distanceTolerance);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_shape(Path3D self, CompositeEncoder output, SerialDescriptor serialDesc) {
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], self.getSegments());
        output.encodeBooleanElement(serialDesc, 1, self.getClosed());
        if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : !Intrinsics.areEqual(self.getInfinity(), Vector3.Companion.getINFINITY())) {
            output.encodeSerializableElement(serialDesc, 2, Vector3$.serializer.INSTANCE, self.getInfinity());
        }
    }

    public /* synthetic */ Path3D(int seen0, List segments, boolean closed, Vector3 infinity, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 3, $serializer.INSTANCE.getDescriptor());
        }
        this.segments = segments;
        this.closed = closed;
        this.infinity = (seen0 & 4) == 0 ? Vector3.Companion.getINFINITY() : infinity;
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{new ArrayListSerializer(Segment3D$.serializer.INSTANCE), null, null};
        $childSerializers = kSerializerArray;
        EMPTY = new Path3D(CollectionsKt.emptyList(), false);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ&\u0010\u000e\u001a\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/openrndr/shape/Path3D$Companion;", "", "<init>", "()V", "EMPTY", "Lorg/openrndr/shape/Path3D;", "getEMPTY", "()Lorg/openrndr/shape/Path3D;", "fromPoints", "points", "", "Lorg/openrndr/math/Vector3;", "closed", "", "fromSegments", "segments", "Lorg/openrndr/shape/Segment3D;", "distanceTolerance", "", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-shape"})
    @SourceDebugExtension(value={"SMAP\nPath3D.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Path3D.kt\norg/openrndr/shape/Path3D$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,251:1\n1557#2:252\n1628#2,3:253\n1557#2:256\n1628#2,3:257\n1557#2:260\n1628#2,3:261\n*S KotlinDebug\n*F\n+ 1 Path3D.kt\norg/openrndr/shape/Path3D$Companion\n*L\n22#1:252\n22#1:253,3\n24#1:256\n24#1:257,3\n35#1:260\n35#1:261,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Path3D getEMPTY() {
            return EMPTY;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Path3D fromPoints(@NotNull List<Vector3> points2, boolean closed) {
            Path3D path3D;
            Intrinsics.checkNotNullParameter(points2, "points");
            if (!closed) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = RangesKt.until(0, points2.size() - 1);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Segment3DKt.Segment3D(points2.get((int)it), points2.get((int)(it + true))));
                }
                boolean bl = closed;
                List list = (List)destination$iv$iv;
                path3D = new Path3D(list, bl);
            } else {
                Iterable $this$map$iv = CollectionsKt.getIndices((Collection)points2);
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator3 = $this$mapTo$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    int item$iv$iv;
                    int it = item$iv$iv = ((IntIterator)iterator3).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Segment3DKt.Segment3D(points2.get(it), points2.get((it + 1) % points2.size())));
                }
                boolean bl = closed;
                List list = (List)destination$iv$iv;
                path3D = new Path3D(list, bl);
            }
            return path3D;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Path3D fromSegments(@NotNull List<Segment3D> segments, boolean closed, double distanceTolerance) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(segments, "segments");
            if (segments.isEmpty()) {
                return this.getEMPTY();
            }
            Iterable $this$map$iv = CollectionsKt.zipWithNext((Iterable)segments);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                double distance = ((Segment3D)it.getFirst()).getEnd().squaredDistanceTo(((Segment3D)it.getSecond()).getStart());
                if (!(distance < distanceTolerance)) {
                    boolean bl2 = false;
                    String string = "distance between segment end and start is " + distance + " (max: " + distanceTolerance + ")";
                    throw new IllegalArgumentException(string.toString());
                }
                collection.add(Segment3D.copy$default((Segment3D)it.getFirst(), null, null, ((Segment3D)it.getSecond()).getStart(), 3, null));
            }
            boolean bl = closed;
            List<Segment3D> list = CollectionsKt.plus((Collection)((List)destination$iv$iv), CollectionsKt.last(segments));
            return new Path3D(list, bl);
        }

        public static /* synthetic */ Path3D fromSegments$default(Companion companion, List list, boolean bl, double d, int n, Object object) {
            if ((n & 4) != 0) {
                d = 0.001;
            }
            return companion.fromSegments(list, bl, d);
        }

        @NotNull
        public final KSerializer<Path3D> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

