/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Matrix33;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.shape.ContourBuilder;
import org.openrndr.shape.Path3D;
import org.openrndr.shape.Segment2D;
import org.openrndr.shape.Segment3D;
import org.openrndr.shape.Segment3DKt;
import org.openrndr.shape.ShapeBuilderKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b%\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0015J\u000e\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0005J\u001e\u0010\u001f\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001dJ\u000e\u0010$\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0005J\u001e\u0010$\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001dJ\u0016\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005J6\u0010%\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001dJ\u001e\u0010%\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005JN\u0010%\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001dJ\u000e\u00102\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0005J\u001e\u00102\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001dJ\u0016\u00103\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005J6\u00103\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001dJ\u001e\u00103\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005JN\u00103\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001dJ\u0006\u00104\u001a\u00020\u0019J\u0006\u00105\u001a\u00020\u0019J\u0018\u00106\u001a\u00020\u00192\u0006\u00107\u001a\u00020\u00052\b\b\u0002\u00108\u001a\u00020\u001dJ(\u00106\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001d2\b\b\u0002\u00108\u001a\u00020\u001dJ \u00106\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00052\u0006\u00107\u001a\u00020\u00052\b\b\u0002\u00108\u001a\u00020\u001dJ@\u00106\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001d2\b\b\u0002\u00108\u001a\u00020\u001dJ>\u00109\u001a\u00020\u00192\u0006\u0010:\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020\u001d2\u0006\u0010<\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020\u000e2\u0006\u0010>\u001a\u00020\u001d2\u0006\u0010?\u001a\u00020\u001d2\u0006\u0010@\u001a\u00020\u001dJ.\u00109\u001a\u00020\u00192\u0006\u0010A\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020\u001d2\u0006\u0010<\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020\u000e2\u0006\u00107\u001a\u00020\u0005R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006B"}, d2={"Lorg/openrndr/shape/Path3DBuilder;", "", "<init>", "()V", "cursor", "Lorg/openrndr/math/Vector3;", "getCursor", "()Lorg/openrndr/math/Vector3;", "setCursor", "(Lorg/openrndr/math/Vector3;)V", "anchor", "getAnchor", "setAnchor", "closed", "", "getClosed$openrndr_shape", "()Z", "setClosed$openrndr_shape", "(Z)V", "segments", "", "Lorg/openrndr/shape/Segment3D;", "getSegments", "()Ljava/util/List;", "copy", "", "source", "Lorg/openrndr/shape/Path3D;", "connectEpsilon", "", "segment", "moveTo", "position", "x", "y", "z", "moveOrLineTo", "moveOrCurveTo", "control", "cx", "cy", "cz", "control0", "control1", "c0x", "c0y", "c0z", "c1x", "c1y", "c1z", "lineTo", "curveTo", "close", "reverse", "continueTo", "end", "tangentScale", "arcTo", "sr", "angle", "largeArcFlag", "sweepFlag", "tx", "ty", "tz", "cr", "openrndr-shape"})
@SourceDebugExtension(value={"SMAP\nPath3DBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Path3DBuilder.kt\norg/openrndr/shape/Path3DBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n1872#2,3:231\n1557#2:234\n1628#2,2:235\n1557#2:237\n1628#2,3:238\n1630#2:241\n*S KotlinDebug\n*F\n+ 1 Path3DBuilder.kt\norg/openrndr/shape/Path3DBuilder\n*L\n130#1:231,3\n200#1:234\n200#1:235,2\n201#1:237\n201#1:238,3\n200#1:241\n*E\n"})
public final class Path3DBuilder {
    @NotNull
    private Vector3 cursor = Vector3.Companion.getINFINITY();
    @NotNull
    private Vector3 anchor = Vector3.Companion.getINFINITY();
    private boolean closed;
    @NotNull
    private final List<Segment3D> segments = new ArrayList();

    @NotNull
    public final Vector3 getCursor() {
        return this.cursor;
    }

    public final void setCursor(@NotNull Vector3 vector3) {
        Intrinsics.checkNotNullParameter(vector3, "<set-?>");
        this.cursor = vector3;
    }

    @NotNull
    public final Vector3 getAnchor() {
        return this.anchor;
    }

    public final void setAnchor(@NotNull Vector3 vector3) {
        Intrinsics.checkNotNullParameter(vector3, "<set-?>");
        this.anchor = vector3;
    }

    public final boolean getClosed$openrndr_shape() {
        return this.closed;
    }

    public final void setClosed$openrndr_shape(boolean bl) {
        this.closed = bl;
    }

    @NotNull
    public final List<Segment3D> getSegments() {
        return this.segments;
    }

    public final void copy(@NotNull Path3D source, double connectEpsilon) {
        Intrinsics.checkNotNullParameter(source, "source");
        if (this.segments.isEmpty() && !source.getEmpty()) {
            this.segments.addAll((Collection<Segment3D>)source.getSegments());
            this.anchor = CollectionsKt.first(this.segments).getStart();
            this.cursor = CollectionsKt.last(this.segments).getEnd();
        } else if (!source.getEmpty()) {
            Vector3 d = this.cursor.minus(CollectionsKt.first(source.getSegments()).getStart());
            if (d.squaredLength() > connectEpsilon * connectEpsilon) {
                this.lineTo(CollectionsKt.first(source.getSegments()).getStart());
            }
            for (Segment3D segment : source.getSegments()) {
                this.segment(segment);
            }
        }
    }

    public static /* synthetic */ void copy$default(Path3DBuilder path3DBuilder, Path3D path3D, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 1.0E-6;
        }
        path3DBuilder.copy(path3D, d);
    }

    public final void segment(@NotNull Segment3D segment) {
        Intrinsics.checkNotNullParameter(segment, "segment");
        if (this.cursor != Vector3.Companion.getINFINITY() && !(segment.getStart().minus(this.cursor).length() < 0.01)) {
            boolean bl = false;
            String string = "segment is disconnected: cursor: " + this.cursor + ", segment.start: " + segment.getStart() + ", distance: " + this.cursor.minus(segment.getStart()).length();
            throw new IllegalArgumentException(string.toString());
        }
        if (this.cursor == Vector3.Companion.getINFINITY()) {
            this.moveTo(segment.getStart());
        }
        if (segment.getLinear()) {
            this.lineTo(segment.getEnd());
        } else if (segment.getControl().size() == 1) {
            this.curveTo(segment.getControl().get(0), segment.getEnd());
        } else {
            this.curveTo(segment.getControl().get(0), segment.getControl().get(1), segment.getEnd());
        }
    }

    public final void moveTo(@NotNull Vector3 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        this.cursor = position;
        this.anchor = position;
    }

    public final void moveTo(double x, double y, double z) {
        this.moveTo(new Vector3(x, y, z));
    }

    public final void moveOrLineTo(@NotNull Vector3 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        if (this.anchor == Vector3.Companion.getINFINITY()) {
            this.moveTo(position);
        } else {
            this.lineTo(position);
        }
    }

    public final void moveOrLineTo(double x, double y, double z) {
        this.moveOrLineTo(new Vector3(x, y, z));
    }

    public final void moveOrCurveTo(@NotNull Vector3 control, @NotNull Vector3 position) {
        Intrinsics.checkNotNullParameter(control, "control");
        Intrinsics.checkNotNullParameter(position, "position");
        if (this.anchor == Vector3.Companion.getINFINITY()) {
            this.moveTo(position);
        } else {
            this.curveTo(control, position);
        }
    }

    public final void moveOrCurveTo(double cx, double cy, double cz, double x, double y, double z) {
        this.moveOrCurveTo(new Vector3(cx, cy, cz), new Vector3(x, y, z));
    }

    public final void moveOrCurveTo(@NotNull Vector3 control0, @NotNull Vector3 control1, @NotNull Vector3 position) {
        Intrinsics.checkNotNullParameter(control0, "control0");
        Intrinsics.checkNotNullParameter(control1, "control1");
        Intrinsics.checkNotNullParameter(position, "position");
        if (this.anchor == Vector3.Companion.getINFINITY()) {
            this.moveTo(position);
        } else {
            this.curveTo(control0, control1, position);
        }
    }

    public final void moveOrCurveTo(double c0x, double c0y, double c0z, double c1x, double c1y, double c1z, double x, double y, double z) {
        this.moveOrCurveTo(new Vector3(c0x, c0y, c0z), new Vector3(c1x, c1y, c1z), new Vector3(x, y, z));
    }

    public final void lineTo(@NotNull Vector3 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        Segment3D segment = Segment3DKt.Segment3D(this.cursor, position);
        this.segments.add(segment);
        this.cursor = position;
    }

    public final void lineTo(double x, double y, double z) {
        this.lineTo(new Vector3(x, y, z));
    }

    public final void curveTo(@NotNull Vector3 control, @NotNull Vector3 position) {
        Intrinsics.checkNotNullParameter(control, "control");
        Intrinsics.checkNotNullParameter(position, "position");
        Segment3D segment = Segment3DKt.Segment3D(this.cursor, control, position);
        this.segments.add(segment);
        this.cursor = position;
    }

    public final void curveTo(double cx, double cy, double cz, double x, double y, double z) {
        this.curveTo(new Vector3(cx, cy, cz), new Vector3(x, y, z));
    }

    public final void curveTo(@NotNull Vector3 control0, @NotNull Vector3 control1, @NotNull Vector3 position) {
        Intrinsics.checkNotNullParameter(control0, "control0");
        Intrinsics.checkNotNullParameter(control1, "control1");
        Intrinsics.checkNotNullParameter(position, "position");
        Segment3D segment = Segment3DKt.Segment3D(this.cursor, control0, control1, position);
        this.segments.add(segment);
        this.cursor = position;
    }

    public final void curveTo(double c0x, double c0y, double c0z, double c1x, double c1y, double c1z, double x, double y, double z) {
        this.curveTo(new Vector3(c0x, c0y, c0z), new Vector3(c1x, c1y, c1z), new Vector3(x, y, z));
    }

    public final void close() {
        this.closed = true;
    }

    /*
     * WARNING - void declaration
     */
    public final void reverse() {
        Iterable $this$forEachIndexed$iv = this.segments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void segment;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Segment3D segment3D = (Segment3D)item$iv;
            int index = n;
            boolean bl = false;
            this.segments.set(index, segment.getReverse());
        }
        CollectionsKt.reverse(this.segments);
    }

    public final void continueTo(@NotNull Vector3 end, double tangentScale) {
        Intrinsics.checkNotNullParameter(end, "end");
        if (!((Collection)this.segments).isEmpty()) {
            Segment3D last2 = CollectionsKt.last(this.segments);
            Vector3 delta = CollectionsKt.last(last2.getControl()).minus(last2.getEnd());
            this.curveTo(last2.getEnd().minus(delta.times(tangentScale)), end);
        } else {
            this.curveTo(this.cursor, end);
        }
    }

    public static /* synthetic */ void continueTo$default(Path3DBuilder path3DBuilder, Vector3 vector3, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        path3DBuilder.continueTo(vector3, d);
    }

    public final void continueTo(double x, double y, double z, double tangentScale) {
        this.continueTo(new Vector3(x, y, z), tangentScale);
    }

    public static /* synthetic */ void continueTo$default(Path3DBuilder path3DBuilder, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        path3DBuilder.continueTo(d, d2, d3, d4);
    }

    public final void continueTo(@NotNull Vector3 control, @NotNull Vector3 end, double tangentScale) {
        Intrinsics.checkNotNullParameter(control, "control");
        Intrinsics.checkNotNullParameter(end, "end");
        if (!((Collection)this.segments).isEmpty()) {
            Segment3D last2 = CollectionsKt.last(this.segments);
            Vector3 delta = CollectionsKt.last(last2.getControl()).minus(last2.getEnd());
            this.curveTo(last2.getEnd().minus(delta.times(tangentScale)), control, end);
        } else {
            this.curveTo(this.cursor, control, end);
        }
    }

    public static /* synthetic */ void continueTo$default(Path3DBuilder path3DBuilder, Vector3 vector3, Vector3 vector32, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 1.0;
        }
        path3DBuilder.continueTo(vector3, vector32, d);
    }

    public final void continueTo(double cx, double cy, double cz, double x, double y, double z, double tangentScale) {
        this.continueTo(new Vector3(cx, cy, cz), new Vector3(x, y, z), tangentScale);
    }

    public static /* synthetic */ void continueTo$default(Path3DBuilder path3DBuilder, double d, double d2, double d3, double d4, double d5, double d6, double d7, int n, Object object) {
        if ((n & 0x40) != 0) {
            d7 = 1.0;
        }
        path3DBuilder.continueTo(d, d2, d3, d4, d5, d6, d7);
    }

    /*
     * WARNING - void declaration
     */
    public final void arcTo(double sr, double angle, boolean largeArcFlag, boolean sweepFlag, double tx, double ty, double tz) {
        void $this$mapTo$iv$iv;
        Vector3 d = new Vector3(tx, ty, tz).minus(this.cursor);
        Vector3 xn = (Vector3)d.getNormalized();
        Vector3 zn = ((Vector3)new Vector3(tx, ty, tz).getNormalized()).cross((Vector3)this.cursor.getNormalized());
        Vector3 yn = (Vector3)zn.cross(xn).getNormalized();
        Matrix33 mat = Matrix33.Companion.fromColumnVectors(xn, yn, zn);
        Matrix33 imat = mat.transposed();
        Vector3 d2 = imat.times(d);
        Iterable $this$map$iv = ShapeBuilderKt.contour(arg_0 -> Path3DBuilder.arcTo$lambda$2(sr, angle, largeArcFlag, sweepFlag, d2, arg_0)).getSegments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void it;
            Segment2D segment2D = (Segment2D)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable iterable2 = it.getControl();
            Vector3 vector3 = mat.times(it.getStart().xy0()).plus(this.cursor);
            boolean $i$f$map2 = false;
            void var33_28 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it2;
                Vector2 vector2 = (Vector2)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(mat.times(it2.xy0()).plus(this.cursor));
            }
            Vector3 vector32 = mat.times(it.getEnd().xy0()).plus(this.cursor);
            List list = (List)destination$iv$iv2;
            Vector3 vector33 = vector3;
            collection.add(new Segment3D(vector33, list, vector32));
        }
        List s2 = (List)destination$iv$iv;
        for (Segment3D s : s2) {
            this.segment(s);
        }
        this.cursor = new Vector3(tx, ty, tz);
    }

    public final void arcTo(double cr, double angle, boolean largeArcFlag, boolean sweepFlag, @NotNull Vector3 end) {
        Intrinsics.checkNotNullParameter(end, "end");
        this.arcTo(cr, angle, largeArcFlag, sweepFlag, end.x(), end.y(), end.z());
    }

    private static final Unit arcTo$lambda$2(double $sr, double $angle, boolean $largeArcFlag, boolean $sweepFlag, Vector3 $d2, ContourBuilder $this$contour) {
        Intrinsics.checkNotNullParameter($d2, "$d2");
        Intrinsics.checkNotNullParameter($this$contour, "$this$contour");
        $this$contour.moveTo(0.0, 0.0);
        $this$contour.arcTo($sr, $sr, $angle, $largeArcFlag, $sweepFlag, $d2.x(), $d2.y());
        return Unit.INSTANCE;
    }
}

