/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.DoubleSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.ReferenceArraySerializer;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.BezierKt;
import org.openrndr.math.FunctionsKt;
import org.openrndr.math.LinearType;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector1;
import org.openrndr.math.Vector4;
import org.openrndr.shape.Segment1D$;
import org.openrndr.shape.Segment1DKt;
import org.openrndr.shape.ShapeToolsKt;
import org.openrndr.shape.internal.BezierCubicSamplerT;
import org.openrndr.shape.internal.BezierQuadraticSamplerT;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 B2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0002ABB%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tB;\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\b\u0010\u000eJ\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004J\u0016\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004J\u0019\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00000\u00062\u0006\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u001eJ\u0011\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010#\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0004H\u0096\u0002J\u0011\u0010&\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0004H\u0096\u0002J\b\u0010'\u001a\u00020(H\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040*2\b\b\u0002\u0010+\u001a\u00020\u0004J\"\u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040-0*2\b\b\u0002\u0010+\u001a\u00020\u0004J\u001e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040*2\u0006\u0010/\u001a\u00020\u000b2\b\b\u0002\u0010+\u001a\u00020\u0004J\t\u00100\u001a\u00020\u0004H\u00c6\u0003J\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\t\u00102\u001a\u00020\u0004H\u00c6\u0003J2\u00103\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0002\u00104J\u0013\u00105\u001a\u00020\u00132\b\u00106\u001a\u0004\u0018\u000107H\u00d6\u0003J\t\u00108\u001a\u00020\u000bH\u00d6\u0001J%\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0001\u00a2\u0006\u0002\b@R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u000fR\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0005\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0011\u0010\u0017\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u001f\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0018R\u0011\u0010 \u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0018\u00a8\u0006C"}, d2={"Lorg/openrndr/shape/Segment1D;", "Lorg/openrndr/math/LinearType;", "Ljava/lang/Record;", "start", "", "control", "", "end", "<init>", "(D[Ljava/lang/Double;D)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ID[Ljava/lang/Double;DLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "()D", "()[Ljava/lang/Double;", "[Ljava/lang/Double;", "linear", "", "()Z", "position", "ut", "reverse", "()Lorg/openrndr/shape/Segment1D;", "sub", "t0", "t1", "split", "t", "(D)[Lorg/openrndr/shape/Segment1D;", "quadratic", "cubic", "plus", "right", "minus", "times", "scale", "div", "toString", "", "adaptivePositions", "", "distanceTolerance", "adaptivePositionsWithT", "Lkotlin/Pair;", "equidistantPositions", "pointCount", "component1", "component2", "component3", "copy", "(D[Ljava/lang/Double;D)Lorg/openrndr/shape/Segment1D;", "equals", "other", "", "hashCode", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_shape", "$serializer", "Companion", "openrndr-shape"})
@SourceDebugExtension(value={"SMAP\nSegment1D.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Segment1D.kt\norg/openrndr/shape/Segment1D\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,308:1\n37#2,2:309\n1557#3:311\n1628#3,3:312\n1557#3:316\n1628#3,3:317\n1557#3:320\n1628#3,3:321\n1557#3:324\n1628#3,3:325\n1#4:315\n*S KotlinDebug\n*F\n+ 1 Segment1D.kt\norg/openrndr/shape/Segment1D\n*L\n35#1:309,2\n280#1:311\n280#1:312,3\n284#1:316\n284#1:317,3\n285#1:320\n285#1:321,3\n290#1:324\n290#1:325,3\n*E\n"})
public final class Segment1D
extends Record
implements LinearType<Segment1D> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double start;
    @NotNull
    private final Double[] control;
    private final double end;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;

    public Segment1D(double start, @NotNull Double[] control, double end) {
        Intrinsics.checkNotNullParameter(control, "control");
        this.start = start;
        this.control = control;
        this.end = end;
    }

    public final double start() {
        return this.start;
    }

    @NotNull
    public final Double[] control() {
        return this.control;
    }

    public final double end() {
        return this.end;
    }

    public final boolean linear() {
        return this.control.length == 0;
    }

    public final double position(double ut) {
        double t = RangesKt.coerceIn(ut, 0.0, 1.0);
        return switch (this.control.length) {
            case 0 -> this.start * (1.0 - t) + this.end * t;
            case 1 -> BezierKt.bezier(this.start, this.control[0], this.end, t);
            case 2 -> BezierKt.bezier(this.start, this.control[0], this.control[1], this.end, t);
            default -> throw new RuntimeException("unsupported number of control points");
        };
    }

    @NotNull
    public final Segment1D reverse() {
        return switch (this.control.length) {
            case 0 -> Segment1DKt.Segment1D(this.end, this.start);
            case 1 -> new Segment1D(this.end, this.control, this.start);
            case 2 -> {
                Collection $this$toTypedArray$iv = ArraysKt.reversed(this.control);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Segment1D v1 = new Segment1D(this.end, thisCollection$iv.toArray(new Double[0]), this.start);
                yield v1;
            }
            default -> throw new RuntimeException("unsupported number of control points");
        };
    }

    @NotNull
    public final Segment1D sub(double t0, double t1) {
        double z0 = t0;
        double z1 = t1;
        if (t0 > t1) {
            z1 = t0;
            z0 = t1;
        }
        return z0 == 0.0 ? this.split(z1)[0] : (z1 == 1.0 ? ArraysKt.last(this.split(z0)) : ArraysKt.last(this.split(z0)).split(MappingKt.map$default(z0, 1.0, 0.0, 1.0, z1, false, 32, null))[0]);
    }

    @NotNull
    public final Segment1D[] split(double t) {
        double splitSigma;
        double u = FunctionsKt.doubleClamp(t, 0.0, 1.0);
        if (u < (splitSigma = 1.0E-5)) {
            Segment1D[] segment1DArray = new Segment1D[]{Segment1DKt.Segment1D(this.start, this.start), this};
            return segment1DArray;
        }
        if (u >= 1.0 - splitSigma) {
            Segment1D[] segment1DArray = new Segment1D[]{this, Segment1DKt.Segment1D(this.end, this.end)};
            return segment1DArray;
        }
        if (this.linear()) {
            double cut = this.start + (this.end - this.start) * u;
            Segment1D[] segment1DArray = new Segment1D[]{Segment1DKt.Segment1D(this.start, cut), Segment1DKt.Segment1D(cut, this.end)};
            return segment1DArray;
        }
        switch (this.control.length) {
            case 2: {
                double z = u;
                double z2 = z * z;
                double z3 = z * z * z;
                double iz = 1.0 - z;
                double iz2 = iz * iz;
                double iz3 = iz * iz * iz;
                Matrix44 lsm = new Matrix44(1.0, 0.0, 0.0, 0.0, iz, z, 0.0, 0.0, iz2, 2.0 * iz * z, z2, 0.0, iz3, 3.0 * iz2 * z, 3.0 * iz * z2, z3);
                Vector4 px = new Vector4(this.start, this.control[0], this.control[1], this.end);
                Vector4 pl = lsm.times(px);
                double pl0 = pl.x();
                double pl1 = pl.y();
                double pl2 = pl.z();
                double pl3 = pl.w();
                Double[] doubleArray = new Double[]{pl1, pl2};
                Segment1D left = new Segment1D(pl0, doubleArray, pl3);
                Matrix44 rsm = new Matrix44(iz3, 3.0 * iz2 * z, 3.0 * iz * z2, z3, 0.0, iz2, 2.0 * iz * z, z2, 0.0, 0.0, iz, z, 0.0, 0.0, 0.0, 1.0);
                Vector4 pr = rsm.times(px);
                double pr0 = pr.x();
                double pr1 = pr.y();
                double pr2 = pr.z();
                double pr3 = pr.w();
                Object[] objectArray = new Double[]{pr1, pr2};
                Segment1D right = new Segment1D(pr0, (Double[])objectArray, pr3);
                objectArray = new Segment1D[]{left, right};
                return objectArray;
            }
            case 1: {
                double z = u;
                double iz = 1.0 - z;
                double iz2 = iz * iz;
                double z2 = z * z;
                Matrix44 lsm = new Matrix44(1.0, 0.0, 0.0, 0.0, iz, z, 0.0, 0.0, iz2, 2.0 * iz * z, z2, 0.0, 0.0, 0.0, 0.0, 0.0);
                Vector4 p = new Vector4(this.start, this.control[0], this.end, 0.0);
                Vector4 pl = lsm.times(p);
                Segment1D left = Segment1DKt.Segment1D(pl.x(), pl.y(), pl.z());
                Matrix44 rsm = new Matrix44(iz2, 2.0 * iz * z, z2, 0.0, 0.0, iz, z, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                Vector4 pr = rsm.times(p);
                double rd0 = pr.y() - pr.x();
                double rd1 = pr.z() - pr.y();
                if (!(rd0 * rd0 > 0.0)) {
                    boolean $i$a$-require-Segment1D$split$32 = false;
                    String $i$a$-require-Segment1D$split$32 = "Q start/c0 overlap after split on " + t + " " + this;
                    throw new IllegalArgumentException($i$a$-require-Segment1D$split$32.toString());
                }
                if (!(rd1 * rd1 > 0.0)) {
                    boolean bl = false;
                    String string = "Q end/c0 overlap after split on " + t + " " + this;
                    throw new IllegalArgumentException(string.toString());
                }
                Segment1D right = Segment1DKt.Segment1D(pr.x(), pr.y(), pr.z());
                Segment1D[] segment1DArray = new Segment1D[]{left, right};
                return segment1DArray;
            }
        }
        throw new IllegalStateException("unsupported number of control points".toString());
    }

    @NotNull
    public final Segment1D quadratic() {
        Segment1D segment1D;
        if (this.control.length == 1) {
            segment1D = this;
        } else if (this.linear()) {
            double delta = this.end - this.start;
            segment1D = Segment1DKt.Segment1D(this.start, this.start + delta * 0.5, this.end);
        } else {
            throw new IllegalStateException("cannot convert to quadratic segment".toString());
        }
        return segment1D;
    }

    @NotNull
    public final Segment1D cubic() {
        Segment1D segment1D;
        if (this.control.length == 2) {
            segment1D = this;
        } else if (this.control.length == 1) {
            Double[] doubleArray = new Double[]{this.start * 0.3333333333333333 + this.control[0] * 0.6666666666666666, this.control[0] * 0.6666666666666666 + this.end * 0.3333333333333333};
            Segment1D segment1D2 = new Segment1D(this.start, doubleArray, this.end);
            segment1D = segment1D2;
        } else if (this.linear()) {
            double delta = this.end - this.start;
            Double[] doubleArray = new Double[]{this.start + delta * 0.3333333333333333, this.start + delta * 0.6666666666666666};
            Segment1D segment1D3 = new Segment1D(this.start, doubleArray, this.end);
            segment1D = segment1D3;
        } else {
            throw new IllegalStateException("cannot convert to cubic segment".toString());
        }
        return segment1D;
    }

    @Override
    @NotNull
    public Segment1D plus(@NotNull Segment1D right) {
        Intrinsics.checkNotNullParameter(right, "right");
        int cmax = Math.max(this.control.length, right.control.length);
        switch (cmax) {
            case 0: {
                return Segment1DKt.Segment1D(this.start + right.start, this.end + right.end);
            }
            case 1: {
                Segment1D qthis = this.quadratic();
                Segment1D qright = right.quadratic();
                return Segment1DKt.Segment1D(qthis.start + qright.start, qthis.control[0] + qright.control[0], qthis.end + qright.end);
            }
            case 2: {
                Segment1D cthis = this.cubic();
                Segment1D cright = right.cubic();
                Double[] doubleArray = new Double[]{cthis.control[0] + cright.control[0], cthis.control[1] + cright.control[1]};
                return new Segment1D(cthis.start + cright.start, doubleArray, cthis.end + cright.end);
            }
        }
        throw new IllegalStateException(("number of control points (" + cmax + ") is not supported").toString());
    }

    @Override
    @NotNull
    public Segment1D minus(@NotNull Segment1D right) {
        Intrinsics.checkNotNullParameter(right, "right");
        int cmax = Math.max(this.control.length, right.control.length);
        switch (cmax) {
            case 0: {
                return Segment1DKt.Segment1D(this.start - right.start, this.end - right.end);
            }
            case 1: {
                Segment1D qthis = this.quadratic();
                Segment1D qright = right.quadratic();
                return Segment1DKt.Segment1D(qthis.start - qright.start, qthis.control[0] - qright.control[0], qthis.end - qright.end);
            }
            case 2: {
                Segment1D cthis = this.cubic();
                Segment1D cright = right.cubic();
                Double[] doubleArray = new Double[]{cthis.control[0] - cright.control[0], cthis.control[1] - cright.control[1]};
                return new Segment1D(cthis.start - cright.start, doubleArray, cthis.end - cright.end);
            }
        }
        throw new IllegalStateException(("number of control points (" + cmax + ") is not supported").toString());
    }

    @Override
    @NotNull
    public Segment1D times(double scale) {
        return switch (this.control.length) {
            case 0 -> Segment1DKt.Segment1D(this.start * scale, this.end * scale);
            case 1 -> Segment1DKt.Segment1D(this.start * scale, this.control[0] * scale, this.end * scale);
            case 2 -> Segment1DKt.Segment1D(this.start * scale, this.control[0] * scale, this.control[1] * scale, this.end * scale);
            default -> throw new IllegalStateException(("number of control points (" + this.control.length + ") is not supported").toString());
        };
    }

    @Override
    @NotNull
    public Segment1D div(double scale) {
        return switch (this.control.length) {
            case 0 -> Segment1DKt.Segment1D(this.start / scale, this.end / scale);
            case 1 -> Segment1DKt.Segment1D(this.start / scale, this.control[0] / scale, this.end / scale);
            case 2 -> Segment1DKt.Segment1D(this.start / scale, this.control[0] / scale, this.control[1] / scale, this.end / scale);
            default -> throw new IllegalStateException(("number of control points (" + this.control.length + ") is not supported").toString());
        };
    }

    @Override
    @NotNull
    public String toString() {
        String string = Arrays.toString((Object[])this.control);
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return "Segment1D(start=" + this.start + ", end=" + this.end + ", control=" + string + ")";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Double> adaptivePositions(double distanceTolerance) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.adaptivePositionsWithT(distanceTolerance);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)it.getFirst()).doubleValue());
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List adaptivePositions$default(Segment1D segment1D, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 25.0;
        }
        return segment1D.adaptivePositions(d);
    }

    @NotNull
    public final List<Pair<Double, Double>> adaptivePositionsWithT(double distanceTolerance) {
        return switch (this.control.length) {
            case 0 -> {
                Pair[] var3_2 = new Pair[]{TuplesKt.to(this.start, 0.0), TuplesKt.to(this.end, 1.0)};
                yield CollectionsKt.listOf(var3_2);
            }
            case 1 -> {
                void $this$mapTo$iv$iv;
                BezierQuadraticSamplerT<Vector1> var3_3;
                BezierQuadraticSamplerT<Vector1> $this$adaptivePositionsWithT_u24lambda_u243 = var3_3 = new BezierQuadraticSamplerT<Vector1>();
                boolean $i$a$-apply-Segment1D$adaptivePositionsWithT$2 = false;
                $this$adaptivePositionsWithT_u24lambda_u243.setDistanceTolerance(distanceTolerance);
                Iterable $this$map$iv = var3_3.sample(Vector1.box-impl(Vector1.constructor-impl(this.start)), Vector1.box-impl(Vector1.constructor-impl(this.control[0])), Vector1.box-impl(Vector1.constructor-impl(this.end)));
                boolean $i$f$map = false;
                Iterable $i$a$-apply-Segment1D$adaptivePositionsWithT$2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair var10_21 = (Pair)item$iv$iv;
                    Collection var12_25 = destination$iv$iv;
                    boolean $i$a$-map-Segment1D$adaptivePositionsWithT$2 = false;
                    var12_25.add(new Pair(((Vector1)it.getFirst()).unbox-impl(), it.getSecond()));
                }
                yield (List)destination$iv$iv;
            }
            case 2 -> {
                void $this$mapTo$iv$iv;
                Object $this$map$iv = new BezierCubicSamplerT<Vector1>();
                BezierCubicSamplerT<Vector1> $this$adaptivePositionsWithT_u24lambda_u245 = $this$map$iv;
                boolean $i$a$-apply-Segment1D$adaptivePositionsWithT$4 = false;
                $this$adaptivePositionsWithT_u24lambda_u245.setDistanceTolerance(distanceTolerance);
                $this$map$iv = ((BezierCubicSamplerT)$this$map$iv).sample(Vector1.box-impl(Vector1.constructor-impl(this.start)), Vector1.box-impl(Vector1.constructor-impl(this.control[0])), Vector1.box-impl(Vector1.constructor-impl(this.control[1])), Vector1.box-impl(Vector1.constructor-impl(this.end)));
                boolean $i$f$map = false;
                Object $i$a$-apply-Segment1D$adaptivePositionsWithT$4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Pair it = (Pair)item$iv$iv;
                    Collection var12_26 = destination$iv$iv;
                    boolean $i$a$-map-Segment1D$adaptivePositionsWithT$4 = false;
                    var12_26.add(new Pair(((Vector1)it.getFirst()).unbox-impl(), it.getSecond()));
                }
                yield (List)destination$iv$iv;
            }
            default -> throw new RuntimeException("unsupported number of control points");
        };
    }

    public static /* synthetic */ List adaptivePositionsWithT$default(Segment1D segment1D, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 25.0;
        }
        return segment1D.adaptivePositionsWithT(d);
    }

    @NotNull
    public final List<Double> equidistantPositions(int pointCount, double distanceTolerance) {
        double it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.adaptivePositions(distanceTolerance);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            double d = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Vector1.box-impl(Vector1.constructor-impl(it)));
        }
        $this$map$iv = ShapeToolsKt.sampleEquidistant((List)destination$iv$iv, pointCount);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = ((Vector1)item$iv$iv).unbox-impl();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List equidistantPositions$default(Segment1D segment1D, int n, double d, int n2, Object object) {
        if ((n2 & 2) != 0) {
            d = 0.5;
        }
        return segment1D.equidistantPositions(n, d);
    }

    public final double component1() {
        return this.start;
    }

    @NotNull
    public final Double[] component2() {
        return this.control;
    }

    public final double component3() {
        return this.end;
    }

    @NotNull
    public final Segment1D copy(double start, @NotNull Double[] control, double end) {
        Intrinsics.checkNotNullParameter(control, "control");
        return new Segment1D(start, control, end);
    }

    public static /* synthetic */ Segment1D copy$default(Segment1D segment1D, double d, Double[] doubleArray, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = segment1D.start;
        }
        if ((n & 2) != 0) {
            doubleArray = segment1D.control;
        }
        if ((n & 4) != 0) {
            d2 = segment1D.end;
        }
        return segment1D.copy(d, doubleArray, d2);
    }

    @Override
    public int hashCode() {
        int result2 = Double.hashCode(this.start);
        result2 = result2 * 31 + Arrays.hashCode((Object[])this.control);
        result2 = result2 * 31 + Double.hashCode(this.end);
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Segment1D)) {
            return false;
        }
        Segment1D segment1D = (Segment1D)other;
        if (Double.compare(this.start, segment1D.start) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual(this.control, segment1D.control)) {
            return false;
        }
        return Double.compare(this.end, segment1D.end) == 0;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_shape(Segment1D self, CompositeEncoder output, SerialDescriptor serialDesc) {
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        output.encodeDoubleElement(serialDesc, 0, self.start);
        output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)kSerializerArray[1], self.control);
        output.encodeDoubleElement(serialDesc, 2, self.end);
    }

    public /* synthetic */ Segment1D(int seen0, double start, Double[] control, double end, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 7, $serializer.INSTANCE.getDescriptor());
        }
        this.start = start;
        this.control = control;
        this.end = end;
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{null, new ReferenceArraySerializer(Reflection.getOrCreateKotlinClass(Double.class), DoubleSerializer.INSTANCE), null};
        $childSerializers = kSerializerArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/shape/Segment1D$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/openrndr/shape/Segment1D;", "openrndr-shape"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<Segment1D> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

