/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.Transient;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.BezierKt;
import org.openrndr.math.EquationsKt;
import org.openrndr.math.FunctionsKt;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector2$;
import org.openrndr.math.Vector4;
import org.openrndr.math.YPolarity;
import org.openrndr.shape.BezierSegment;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.RectangleKt;
import org.openrndr.shape.Segment2D$;
import org.openrndr.shape.Segment2DKt;
import org.openrndr.shape.SegmentPoint;
import org.openrndr.shape.SegmentType;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.ShapeContourProvider;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 s2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002rsB/\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bBG\b\u0010\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\n\u0010\u0010J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\b\b\u0002\u0010\u001b\u001a\u00020\rJ\u0018\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u001f\u0010 \u001a\u0004\u0018\u00010\u001e2\u0006\u0010!\u001a\u00020\u00022\b\b\u0002\u0010\"\u001a\u00020\u001e\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001eH\u0016J*\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010)\u001a\u00020\u0002H\u0002J\u000e\u0010*\u001a\u00020+2\u0006\u0010!\u001a\u00020\u0002J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010,\u001a\u00020-J\u0010\u00102\u001a\u00020\u00022\u0006\u00103\u001a\u00020\u001eH\u0016J\u0018\u00104\u001a\u00020-2\u0006\u00105\u001a\u00020\u001e2\b\b\u0002\u00106\u001a\u000207J\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0006J\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006J\u0014\u0010>\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00060\u0006H\u0002J \u0010?\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020\u00022\u0006\u0010A\u001a\u00020\u00022\u0006\u0010B\u001a\u00020\u0002H\u0002J\u0010\u0010C\u001a\u00020\t2\b\b\u0002\u0010D\u001a\u00020\u001eJ\u0010\u0010N\u001a\u00020\u00022\u0006\u00105\u001a\u00020\u001eH\u0016J\u0018\u0010O\u001a\u00020\u00022\u0006\u00103\u001a\u00020\u001e2\b\b\u0002\u00106\u001a\u000207J\u001b\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00000S2\u0006\u00105\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010TJ\b\u0010U\u001a\u00020VH\u0016J\u0013\u0010W\u001a\u00020\t2\b\u0010X\u001a\u0004\u0018\u00010YH\u0096\u0002J\b\u0010Z\u001a\u00020\rH\u0016J\u0011\u0010[\u001a\u00020\u00002\u0006\u0010\\\u001a\u00020\u001eH\u0086\u0002J\u0011\u0010]\u001a\u00020\u00002\u0006\u0010\\\u001a\u00020\u001eH\u0086\u0002J\u0011\u0010^\u001a\u00020\u00002\u0006\u0010_\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010`\u001a\u00020\u00002\u0006\u0010_\u001a\u00020\u0000H\u0086\u0002J\t\u0010e\u001a\u00020\u0002H\u00c6\u0003J\u000f\u0010f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u00c6\u0003J\t\u0010g\u001a\u00020\u0002H\u00c6\u0003J\t\u0010h\u001a\u00020\tH\u00c6\u0003J7\u0010i\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00022\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J%\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020\u00002\u0006\u0010m\u001a\u00020n2\u0006\u0010o\u001a\u00020pH\u0001\u00a2\u0006\u0002\bqR\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0007\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0019\u0010\u001aR\u001b\u0010%\u001a\u00020\u001e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b.\u0010/R\u0011\u0010:\u001a\u00020;8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0011\u0010E\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u0017R\u0011\u0010G\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u0017R\u0014\u0010I\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010KR\u0011\u0010L\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bM\u0010KR\u0014\u0010P\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u0010KR\u0014\u0010a\u001a\u00020b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bc\u0010d\u00a8\u0006t"}, d2={"Lorg/openrndr/shape/Segment2D;", "Lorg/openrndr/shape/BezierSegment;", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/shape/ShapeContourProvider;", "start", "control", "", "end", "corner", "", "<init>", "(Lorg/openrndr/math/Vector2;Ljava/util/List;Lorg/openrndr/math/Vector2;Z)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILorg/openrndr/math/Vector2;Ljava/util/List;Lorg/openrndr/math/Vector2;ZLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getStart", "()Lorg/openrndr/math/Vector2;", "getControl", "()Ljava/util/List;", "getEnd", "getCorner", "()Z", "lut", "getLut$annotations", "()V", "size", "sub", "t0", "", "t1", "on", "point", "error", "(Lorg/openrndr/math/Vector2;D)Ljava/lang/Double;", "tForLength", "length", "closest", "Lkotlin/Pair;", "points", "query", "nearest", "Lorg/openrndr/shape/SegmentPoint;", "transform", "Lorg/openrndr/math/Matrix44;", "getLength", "()D", "length$delegate", "Lkotlin/Lazy;", "position", "ut", "pose", "t", "polarity", "Lorg/openrndr/math/YPolarity;", "extrema", "extremaPoints", "bounds", "Lorg/openrndr/shape/Rectangle;", "getBounds", "()Lorg/openrndr/shape/Rectangle;", "dPoints", "angle", "o", "v1", "v2", "isStraight", "tolerance", "simple", "getSimple", "clockwise", "getClockwise", "cubic", "getCubic", "()Lorg/openrndr/shape/Segment2D;", "quadratic", "getQuadratic", "derivative", "normal", "reverse", "getReverse", "split", "", "(D)[Lorg/openrndr/shape/Segment2D;", "toString", "", "equals", "other", "", "hashCode", "times", "scale", "div", "minus", "right", "plus", "contour", "Lorg/openrndr/shape/ShapeContour;", "getContour", "()Lorg/openrndr/shape/ShapeContour;", "component1", "component2", "component3", "component4", "copy", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_shape", "$serializer", "Companion", "openrndr-shape"})
@SourceDebugExtension(value={"SMAP\nSegment2D.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Segment2D.kt\norg/openrndr/shape/Segment2D\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,938:1\n1557#2:939\n1628#2,3:940\n1557#2:943\n1628#2,3:944\n1557#2:947\n1628#2,3:948\n774#2:951\n865#2,2:952\n1557#2:954\n1628#2,3:955\n1557#2:958\n1628#2,3:959\n1557#2:962\n1628#2,3:963\n1557#2:966\n1628#2,3:967\n774#2:970\n865#2,2:971\n1557#2:973\n1628#2,3:974\n*S KotlinDebug\n*F\n+ 1 Segment2D.kt\norg/openrndr/shape/Segment2D\n*L\n183#1:939\n183#1:940,3\n441#1:943\n441#1:944,3\n442#1:947\n442#1:948,3\n443#1:951\n443#1:952,2\n447#1:954\n447#1:955,3\n447#1:958\n447#1:959,3\n448#1:962\n448#1:963,3\n448#1:966\n448#1:967,3\n449#1:970\n449#1:971,2\n458#1:973\n458#1:974,3\n*E\n"})
public final class Segment2D
implements BezierSegment<Vector2>,
ShapeContourProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector2 start;
    @NotNull
    private final List<Vector2> control;
    @NotNull
    private final Vector2 end;
    private final boolean corner;
    @Nullable
    private List<Vector2> lut;
    @NotNull
    private final Lazy length$delegate;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;

    public Segment2D(@NotNull Vector2 start, @NotNull List<Vector2> control, @NotNull Vector2 end, boolean corner) {
        Intrinsics.checkNotNullParameter(start, "start");
        Intrinsics.checkNotNullParameter(control, "control");
        Intrinsics.checkNotNullParameter(end, "end");
        this.start = start;
        this.control = control;
        this.end = end;
        this.corner = corner;
        this.length$delegate = LazyKt.lazy(() -> Segment2D.length_delegate$lambda$1(this));
    }

    public /* synthetic */ Segment2D(Vector2 vector2, List list, Vector2 vector22, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(vector2, list, vector22, bl);
    }

    @Override
    @NotNull
    public Vector2 getStart() {
        return this.start;
    }

    @Override
    @NotNull
    public List<Vector2> getControl() {
        return this.control;
    }

    @Override
    @NotNull
    public Vector2 getEnd() {
        return this.end;
    }

    public final boolean getCorner() {
        return this.corner;
    }

    @Transient
    private static /* synthetic */ void getLut$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vector2> lut(int size) {
        block4: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            block3: {
                if (this.lut == null) break block3;
                List<Vector2> list = this.lut;
                Intrinsics.checkNotNull(list);
                if (list.size() == size) break block4;
            }
            Iterable iterable = new IntRange(0, size);
            Segment2D segment2D = this;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.position((double)it / (double)size));
            }
            segment2D.lut = (List)destination$iv$iv;
        }
        List<Vector2> list = this.lut;
        Intrinsics.checkNotNull(list);
        return list;
    }

    public static /* synthetic */ List lut$default(Segment2D segment2D, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 100;
        }
        return segment2D.lut(n);
    }

    @NotNull
    public Segment2D sub(double t0, double t1) {
        BezierSegment<Vector2> bezierSegment = BezierSegment.DefaultImpls.sub(this, t0, t1);
        Intrinsics.checkNotNull(bezierSegment, "null cannot be cast to non-null type org.openrndr.shape.Segment2D");
        return (Segment2D)bezierSegment;
    }

    @Nullable
    public final Double on(@NotNull Vector2 point, double error) {
        Intrinsics.checkNotNullParameter(point, "point");
        List lut = Segment2D.lut$default(this, 0, 1, null);
        int hits = 0;
        double t = 0.0;
        int n = ((Collection)lut).size();
        for (int i = 0; i < n; ++i) {
            if (!(((Vector2)lut.get(i)).minus(point).squaredLength() < error * error)) continue;
            ++hits;
            t += (double)i / (double)lut.size();
        }
        return hits > 0 ? Double.valueOf(t / (double)hits) : null;
    }

    public static /* synthetic */ Double on$default(Segment2D segment2D, Vector2 vector2, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 5.0;
        }
        return segment2D.on(vector2, d);
    }

    @Override
    public double tForLength(double length) {
        if (this.getType() == SegmentType.LINEAR) {
            return RangesKt.coerceIn(length / this.getLength(), 0.0, 1.0);
        }
        double segmentLength = this.getLength();
        double cLength = RangesKt.coerceIn(length, 0.0, segmentLength);
        if (cLength == 0.0) {
            return 0.0;
        }
        if (cLength >= segmentLength) {
            return 1.0;
        }
        double summedLength = 0.0;
        this.lut(100);
        List<Vector2> list = this.lut;
        if (list == null) {
            throw new IllegalStateException("no lut".toString());
        }
        List<Vector2> cLut = list;
        int partitionCount = cLut.size() - 1;
        double dt = 1.0 / (double)partitionCount;
        List<Vector2> list2 = this.lut;
        Intrinsics.checkNotNull(list2);
        Iterator iterator2 = ((Iterable)list2).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            Vector2 p1;
            Vector2 p0;
            double partitionLength;
            int index = n++;
            iterator2.next();
            List<Vector2> list3 = this.lut;
            Intrinsics.checkNotNull(list3);
            if (index >= list3.size() - 1 || !((summedLength += (partitionLength = (p0 = cLut.get(index)).distanceTo(p1 = cLut.get(index + 1)))) >= length)) continue;
            double localT = (double)index / (double)partitionCount;
            double overshoot = summedLength - length;
            return localT + overshoot / partitionLength * dt;
        }
        return 1.0;
    }

    private final Pair<Integer, Vector2> closest(List<Vector2> points2, Vector2 query) {
        int closestIndex = 0;
        Vector2 closestValue = points2.get(0);
        double closestDistance = Double.POSITIVE_INFINITY;
        int n = ((Collection)points2).size();
        for (int i = 0; i < n; ++i) {
            double distance = points2.get(i).minus(query).squaredLength();
            if (!(distance < closestDistance)) continue;
            closestIndex = i;
            closestValue = points2.get(i);
            closestDistance = distance;
        }
        return new Pair<Integer, Vector2>(closestIndex, closestValue);
    }

    @NotNull
    public final SegmentPoint nearest(@NotNull Vector2 point) {
        Intrinsics.checkNotNullParameter(point, "point");
        double t = switch (WhenMappings.$EnumSwitchMapping$0[this.getType().ordinal()]) {
            case 1 -> {
                Vector2 dir = this.getEnd().minus(this.getStart());
                Vector2 relativePoint = point.minus(this.getStart());
                yield RangesKt.coerceIn(dir.dot(relativePoint) / dir.squaredLength(), 0.0, 1.0);
            }
            case 2 -> {
                Vector2 qa = this.getStart().minus(point);
                Vector2 ab = this.getControl().get(0).minus(this.getStart());
                Vector2 bc = this.getEnd().minus(this.getControl().get(0));
                Vector2 qc = this.getEnd().minus(point);
                Vector2 ac = this.getEnd().minus(this.getStart());
                Vector2 br = this.getStart().plus(this.getEnd()).minus(this.getControl().get(0)).minus(this.getControl().get(0));
                double minDistance = Math.signum(ab.cross(qa)) * qa.length();
                double param = -qa.dot(ab) / ab.dot(ab);
                double distance = Math.signum(bc.cross(qc)) * qc.length();
                if (Math.abs(distance) < Math.abs(minDistance)) {
                    minDistance = distance;
                    param = Math.max(1.0, point.minus(this.getControl().get(0)).dot(bc) / bc.dot(bc));
                }
                double a = br.dot(br);
                double b = 3.0 * ab.dot(br);
                double c = 2.0 * ab.dot(ab) + qa.dot(br);
                double d = qa.dot(ab);
                for (double t : EquationsKt.solveCubic(a, b, c, d)) {
                    Vector2 endpoint;
                    double distance2;
                    if (!(t > 0.0) || !(t < 1.0) || !(Math.abs(distance2 = Math.signum(ac.cross((endpoint = this.position(t)).minus(point))) * endpoint.minus(point).length()) < Math.abs(minDistance))) continue;
                    minDistance = distance2;
                    param = t;
                }
                yield RangesKt.coerceIn(param, 0.0, 1.0);
            }
            case 3 -> {
                Vector2 qa = this.getStart().minus(point);
                Vector2 ab = this.getControl().get(0).minus(this.getStart());
                Vector2 bc = this.getControl().get(1).minus(this.getControl().get(0));
                Vector2 cd = this.getEnd().minus(this.getControl().get(1));
                Vector2 qd = this.getEnd().minus(point);
                Vector2 br = bc.minus(ab);
                Vector2 ax = cd.minus(bc).minus(br);
                double minDistance = Segment2D.nearest$sign(ab.cross(qa)) * qa.length();
                double param = -qa.dot(ab) / ab.dot(ab);
                double distance = Segment2D.nearest$sign(cd.cross(qd)) * qd.length();
                if (Math.abs(distance) < Math.abs(minDistance)) {
                    minDistance = distance;
                    param = Math.max(1.0, point.minus(this.getControl().get(1)).dot(cd) / cd.dot(cd));
                }
                int searchStarts = 4;
                int searchSteps = 8;
                block6: for (int i = 0; i < searchStarts; ++i) {
                    double t = (double)i / (double)(searchStarts - 1);
                    int step = 0;
                    while (true) {
                        Vector2 qpt = this.position(t).minus(point);
                        distance = Segment2D.nearest$sign(((Vector2)this.direction(t)).cross(qpt)) * qpt.length();
                        if (Math.abs(distance) < Math.abs(minDistance)) {
                            minDistance = distance;
                            param = t;
                        }
                        if (step == searchSteps) continue block6;
                        Vector2 d1 = ax.times((double)3 * t * t).plus(br.times((double)6 * t)).plus(ab.times(3.0));
                        Vector2 d2 = ax.times((double)6 * t).plus(br.times(6.0));
                        double dt = qpt.dot(d1) / (d1.dot(d1) + qpt.dot(d2));
                        if (Math.abs(dt) < 1.0E-14 || (t -= dt) < 0.0 || t > 1.0) continue block6;
                        ++step;
                    }
                }
                yield RangesKt.coerceIn(param, 0.0, 1.0);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        Vector2 closest = this.position(t);
        return new SegmentPoint(this, t, closest);
    }

    @NotNull
    public final Segment2D transform(@NotNull Matrix44 transform2) {
        Segment2D segment2D;
        Intrinsics.checkNotNullParameter(transform2, "transform");
        if (transform2 == Matrix44.Companion.getIDENTITY()) {
            segment2D = this;
        } else {
            Vector2 tStart = transform2.times(this.getStart().xy01()).div().xy();
            Vector2 tEnd = transform2.times(this.getEnd().xy01()).div().xy();
            List tControl = switch (this.getControl().size()) {
                case 2 -> {
                    Vector2[] var5_4 = new Vector2[]{transform2.times(this.getControl().get(0).xy01()).div().xy(), transform2.times(this.getControl().get(1).xy01()).div().xy()};
                    yield CollectionsKt.listOf(var5_4);
                }
                case 1 -> CollectionsKt.listOf(transform2.times(this.getControl().get(0).xy01()).div().xy());
                default -> CollectionsKt.emptyList();
            };
            segment2D = Segment2D.copy$default(this, tStart, tControl, tEnd, false, 8, null);
        }
        return segment2D;
    }

    @Override
    public double getLength() {
        Lazy lazy = this.length$delegate;
        return ((Number)lazy.getValue()).doubleValue();
    }

    @Override
    @NotNull
    public Vector2 position(double ut) {
        double t = RangesKt.coerceIn(ut, 0.0, 1.0);
        return switch (this.getControl().size()) {
            case 0 -> new Vector2(this.getStart().x() * (1.0 - t) + this.getEnd().x() * t, this.getStart().y() * (1.0 - t) + this.getEnd().y() * t);
            case 1 -> BezierKt.bezier(this.getStart(), this.getControl().get(0), this.getEnd(), t);
            case 2 -> BezierKt.bezier(this.getStart(), this.getControl().get(0), this.getControl().get(1), this.getEnd(), t);
            default -> throw new IllegalStateException("unsupported number of control points".toString());
        };
    }

    @NotNull
    public final Matrix44 pose(double t, @NotNull YPolarity polarity) {
        Intrinsics.checkNotNullParameter((Object)polarity, "polarity");
        Vector4 dx = ((Vector2)this.direction(t)).xy0().xyz0();
        Vector4 dy = ((Vector2)this.direction(t)).perpendicular(polarity).xy0().xyz0();
        Vector4 dt = this.position(t).xy01();
        return Matrix44.Companion.fromColumnVectors(dx, dy, Vector4.Companion.getUNIT_Z(), dt);
    }

    public static /* synthetic */ Matrix44 pose$default(Segment2D segment2D, double d, YPolarity yPolarity, int n, Object object) {
        if ((n & 2) != 0) {
            yPolarity = YPolarity.CW_NEGATIVE_Y;
        }
        return segment2D.pose(d, yPolarity);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Double> extrema() {
        List list;
        List<List<Vector2>> dPoints = this.dPoints();
        if (this.getLinear()) {
            list = CollectionsKt.emptyList();
        } else if (this.getControl().size() == 1) {
            void $this$filterTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv = dPoints.get(0);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Vector2 vector2 = (Vector2)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.x());
            }
            List<Double> xRoots = BezierKt.roots((List)destination$iv$iv);
            Iterable $this$map$iv2 = dPoints.get(0);
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Vector2 bl = (Vector2)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.y());
            }
            List<Double> yRoots = BezierKt.roots((List)destination$iv$iv2);
            Iterable $this$filter$iv = CollectionsKt.sorted(CollectionsKt.distinct(CollectionsKt.plus((Collection)xRoots, (Iterable)yRoots)));
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                double it = ((Number)element$iv$iv).doubleValue();
                boolean bl = false;
                boolean bl3 = 0.0 <= it ? it <= 1.0 : false;
                if (!bl3) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            list = (List)destination$iv$iv2;
        } else if (this.getControl().size() == 2) {
            void $this$filterTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Collection collection;
            Vector2 it;
            Collection collection2;
            Iterable $this$mapTo$iv$iv3;
            Iterable $this$map$iv = dPoints.get(0);
            boolean $i$f$map = false;
            Iterable $i$f$filter = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                Vector2 element$iv$iv = (Vector2)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.x());
            }
            $this$map$iv = dPoints.get(1);
            collection2 = BezierKt.roots((List)destination$iv$iv);
            $i$f$map = false;
            $this$mapTo$iv$iv3 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                it = (Vector2)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.x());
            }
            List xRoots = CollectionsKt.plus(collection2, (Iterable)BezierKt.roots((List)destination$iv$iv));
            Iterable $this$map$iv3 = dPoints.get(0);
            boolean $i$f$map3 = false;
            destination$iv$iv = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Vector2 bl = (Vector2)item$iv$iv;
                collection2 = destination$iv$iv3;
                boolean bl4 = false;
                collection2.add(it2.y());
            }
            $this$map$iv3 = dPoints.get(1);
            collection2 = BezierKt.roots((List)destination$iv$iv3);
            $i$f$map3 = false;
            $this$mapTo$iv$iv = $this$map$iv3;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
            $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Vector2 it2 = (Vector2)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl = false;
                collection.add(it2.y());
            }
            List yRoots = CollectionsKt.plus(collection2, (Iterable)BezierKt.roots((List)destination$iv$iv3));
            Iterable $this$filter$iv = CollectionsKt.sorted(CollectionsKt.distinct(CollectionsKt.plus((Collection)xRoots, (Iterable)yRoots)));
            boolean $i$f$filter2 = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Vector2 element$iv$iv : $this$filterTo$iv$iv) {
                double it3 = ((Number)((Object)element$iv$iv)).doubleValue();
                boolean bl = false;
                boolean bl5 = 0.0 <= it3 ? it3 <= 1.0 : false;
                if (!bl5) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            list = (List)destination$iv$iv3;
        } else {
            throw new RuntimeException("not supported");
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vector2> extremaPoints() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.extrema();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double d = ((Number)item$iv$iv).doubleValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.position((double)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Rectangle getBounds() {
        Vector2[] vector2Array = new Vector2[]{this.getStart(), this.getEnd()};
        return RectangleKt.getVector2Bounds(CollectionsKt.plus((Collection)CollectionsKt.listOf(vector2Array), (Iterable)this.extremaPoints()));
    }

    private final List<List<Vector2>> dPoints() {
        List points2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf(this.getStart()), (Iterable)this.getControl()), (Iterable)CollectionsKt.listOf(this.getEnd()));
        int d = points2.size();
        int c2 = d - 1;
        List dPoints = new ArrayList();
        List p = points2;
        while (d > 1) {
            List list = new ArrayList();
            int n = c2;
            for (int j = 0; j < n; ++j) {
                list.add(new Vector2((double)c2 * (((Vector2)p.get(j + 1)).x() - ((Vector2)p.get(j)).x()), (double)c2 * (((Vector2)p.get(j + 1)).y() - ((Vector2)p.get(j)).y())));
            }
            dPoints.add(list);
            p = list;
            --d;
            --c2;
        }
        return dPoints;
    }

    private final double angle(Vector2 o, Vector2 v1, Vector2 v2) {
        double dx1 = v1.x() - o.x();
        double dy1 = v1.y() - o.y();
        double dx2 = v2.x() - o.x();
        double dy2 = v2.y() - o.y();
        double cross = dx1 * dy2 - dy1 * dx2;
        double dot = dx1 * dx2 + dy1 * dy2;
        return Math.atan2(cross, dot);
    }

    public final boolean isStraight(double tolerance) {
        return switch (this.getControl().size()) {
            case 2 -> {
                Vector2 dl = (Vector2)this.getEnd().minus(this.getStart()).getNormalized();
                Vector2 d0 = (Vector2)this.getControl().get(0).minus(this.getStart()).getNormalized();
                Vector2 d1 = (Vector2)this.getEnd().minus(this.getControl().get(0)).getNormalized();
                double dp0 = dl.dot(d0);
                double dp1 = dl.unaryMinus().dot(d1);
                if (dp0 * dp0 + dp1 * dp1 > 2.0 - (double)2 * tolerance) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                Vector2 dl = (Vector2)this.getEnd().minus(this.getStart()).getNormalized();
                Vector2 d0 = (Vector2)this.getControl().get(0).minus(this.getStart()).getNormalized();
                double dp0 = dl.dot(d0);
                if (dp0 * dp0 > 1.0 - tolerance) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    public static /* synthetic */ boolean isStraight$default(Segment2D segment2D, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.01;
        }
        return segment2D.isStraight(d);
    }

    public final boolean getSimple() {
        Vector2 n2;
        Vector2 n1;
        double s;
        if (this.getLinear()) {
            return true;
        }
        if (this.getControl().size() == 2) {
            double a1 = this.angle(this.getStart(), this.getEnd(), this.getControl().get(0));
            double a2 = this.angle(this.getStart(), this.getEnd(), this.getControl().get(1));
            if (a1 > 0.0 && a2 < 0.0 || a1 < 0.0 && a2 > 0.0) {
                return false;
            }
        }
        return (s = (n1 = this.normal(0.0, YPolarity.CW_NEGATIVE_Y)).dot(n2 = this.normal(1.0, YPolarity.CW_NEGATIVE_Y))) >= 0.9;
    }

    public final boolean getClockwise() {
        return this.angle(this.getStart(), this.getEnd(), this.getControl().get(0)) > 0.0;
    }

    @NotNull
    public Segment2D getCubic() {
        Segment2D segment2D;
        if (this.getControl().size() == 2) {
            segment2D = this;
        } else if (this.getControl().size() == 1) {
            segment2D = Segment2DKt.Segment2D(this.getStart(), this.getStart().times(0.3333333333333333).plus(this.getControl().get(0).times(0.6666666666666666)), this.getControl().get(0).times(0.6666666666666666).plus(this.getEnd().times(0.3333333333333333)), this.getEnd(), this.corner);
        } else if (this.getLinear()) {
            Vector2 delta = this.getEnd().minus(this.getStart());
            segment2D = Segment2DKt.Segment2D(this.getStart(), this.getStart().plus(delta.times(0.3333333333333333)), this.getStart().plus(delta.times(0.6666666666666666)), this.getEnd(), this.corner);
        } else {
            throw new IllegalStateException("cannot convert to cubic segment".toString());
        }
        return segment2D;
    }

    @NotNull
    public final Segment2D getQuadratic() {
        Segment2D segment2D;
        if (this.getControl().size() == 1) {
            segment2D = this;
        } else if (this.getLinear()) {
            Vector2 delta = this.getEnd().minus(this.getStart());
            segment2D = Segment2DKt.Segment2D(this.getStart(), this.getStart().plus(delta.times(0.5)), this.getEnd(), this.corner);
        } else {
            throw new IllegalStateException("cannot convert to quadratic segment".toString());
        }
        return segment2D;
    }

    @Override
    @NotNull
    public Vector2 derivative(double t) {
        Vector2 vector2;
        if (this.getLinear()) {
            vector2 = this.getEnd().minus(this.getStart());
        } else if (this.getControl().size() == 1) {
            vector2 = BezierKt.safeDerivative(this.getStart(), this.getControl().get(0), this.getEnd(), t);
        } else if (this.getControl().size() == 2) {
            vector2 = BezierKt.safeDerivative(this.getStart(), this.getControl().get(0), this.getControl().get(1), this.getEnd(), t);
        } else {
            throw new RuntimeException("not implemented");
        }
        return vector2;
    }

    @NotNull
    public final Vector2 normal(double ut, @NotNull YPolarity polarity) {
        Intrinsics.checkNotNullParameter((Object)polarity, "polarity");
        return ((Vector2)this.direction(ut)).perpendicular(polarity);
    }

    public static /* synthetic */ Vector2 normal$default(Segment2D segment2D, double d, YPolarity yPolarity, int n, Object object) {
        if ((n & 2) != 0) {
            yPolarity = YPolarity.CW_NEGATIVE_Y;
        }
        return segment2D.normal(d, yPolarity);
    }

    @NotNull
    public Segment2D getReverse() {
        return switch (this.getControl().size()) {
            case 0 -> Segment2DKt.Segment2D$default(this.getEnd(), this.getStart(), false, 4, null);
            case 1 -> Segment2DKt.Segment2D$default(this.getEnd(), this.getControl().get(0), this.getStart(), false, 8, null);
            case 2 -> Segment2DKt.Segment2D$default(this.getEnd(), this.getControl().get(1), this.getControl().get(0), this.getStart(), false, 16, null);
            default -> throw new RuntimeException("unsupported number of control points");
        };
    }

    @NotNull
    public Segment2D[] split(double t) {
        double splitSigma;
        double u = FunctionsKt.doubleClamp(t, 0.0, 1.0);
        if (u < (splitSigma = 1.0E-5)) {
            Segment2D[] segment2DArray = new Segment2D[]{Segment2DKt.Segment2D$default(this.getStart(), this.getStart(), false, 4, null), this};
            return segment2DArray;
        }
        if (u >= 1.0 - splitSigma) {
            Segment2D[] segment2DArray = new Segment2D[]{this, Segment2DKt.Segment2D$default(this.getEnd(), this.getEnd(), false, 4, null)};
            return segment2DArray;
        }
        if (this.getLinear()) {
            Vector2 cut = this.getStart().plus(this.getEnd().minus(this.getStart()).times(u));
            Segment2D[] segment2DArray = new Segment2D[]{Segment2DKt.Segment2D$default(this.getStart(), cut, false, 4, null), Segment2DKt.Segment2D$default(cut, this.getEnd(), false, 4, null)};
            return segment2DArray;
        }
        switch (this.getControl().size()) {
            case 2: {
                double z = u;
                double z2 = z * z;
                double z3 = z * z * z;
                double iz = 1.0 - z;
                double iz2 = iz * iz;
                double iz3 = iz * iz * iz;
                Matrix44 lsm = new Matrix44(1.0, 0.0, 0.0, 0.0, iz, z, 0.0, 0.0, iz2, 2.0 * iz * z, z2, 0.0, iz3, 3.0 * iz2 * z, 3.0 * iz * z2, z3);
                Vector4 px = new Vector4(this.getStart().x(), this.getControl().get(0).x(), this.getControl().get(1).x(), this.getEnd().x());
                Vector4 py = new Vector4(this.getStart().y(), this.getControl().get(0).y(), this.getControl().get(1).y(), this.getEnd().y());
                Vector4 plx = lsm.times(px);
                Vector4 ply = lsm.times(py);
                Vector2 pl0 = new Vector2(plx.x(), ply.x());
                Vector2 pl1 = new Vector2(plx.y(), ply.y());
                Vector2 pl2 = new Vector2(plx.z(), ply.z());
                Vector2 pl3 = new Vector2(plx.w(), ply.w());
                Segment2D left = Segment2DKt.Segment2D$default(pl0, pl1, pl2, pl3, false, 16, null);
                Matrix44 rsm = new Matrix44(iz3, 3.0 * iz2 * z, 3.0 * iz * z2, z3, 0.0, iz2, 2.0 * iz * z, z2, 0.0, 0.0, iz, z, 0.0, 0.0, 0.0, 1.0);
                Vector4 prx = rsm.times(px);
                Vector4 pry = rsm.times(py);
                Vector2 pr0 = new Vector2(prx.x(), pry.x());
                Vector2 pr1 = new Vector2(prx.y(), pry.y());
                Vector2 pr2 = new Vector2(prx.z(), pry.z());
                Vector2 pr3 = new Vector2(prx.w(), pry.w());
                Segment2D right = Segment2DKt.Segment2D$default(pr0, pr1, pr2, pr3, false, 16, null);
                Segment2D[] segment2DArray = new Segment2D[]{left, right};
                return segment2DArray;
            }
            case 1: {
                double z = u;
                double iz = 1.0 - z;
                double iz2 = iz * iz;
                double z2 = z * z;
                Matrix44 lsm = new Matrix44(1.0, 0.0, 0.0, 0.0, iz, z, 0.0, 0.0, iz2, 2.0 * iz * z, z2, 0.0, 0.0, 0.0, 0.0, 0.0);
                Vector4 px = new Vector4(this.getStart().x(), this.getControl().get(0).x(), this.getEnd().x(), 0.0);
                Vector4 py = new Vector4(this.getStart().y(), this.getControl().get(0).y(), this.getEnd().y(), 0.0);
                Vector4 plx = lsm.times(px);
                Vector4 ply = lsm.times(py);
                Segment2D left = Segment2DKt.Segment2D$default(new Vector2(plx.x(), ply.x()), new Vector2(plx.y(), ply.y()), new Vector2(plx.z(), ply.z()), false, 8, null);
                Matrix44 rsm = new Matrix44(iz2, 2.0 * iz * z, z2, 0.0, 0.0, iz, z, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                Vector4 prx = rsm.times(px);
                Vector4 pry = rsm.times(py);
                double rdx0 = prx.y() - prx.x();
                double rdy0 = pry.y() - pry.x();
                double rdx1 = prx.z() - prx.y();
                double rdy1 = pry.z() - pry.y();
                if (!(rdx0 * rdx0 + rdy0 * rdy0 > 0.0)) {
                    boolean $i$a$-require-Segment2D$split$32 = false;
                    String $i$a$-require-Segment2D$split$32 = "Q start/c0 overlap after split on " + t + " " + this;
                    throw new IllegalArgumentException($i$a$-require-Segment2D$split$32.toString());
                }
                if (!(rdx1 * rdx1 + rdy1 * rdy1 > 0.0)) {
                    boolean bl = false;
                    String string = "Q end/c0 overlap after split on " + t + " " + this;
                    throw new IllegalArgumentException(string.toString());
                }
                Segment2D right = Segment2DKt.Segment2D$default(new Vector2(prx.x(), pry.x()), new Vector2(prx.y(), pry.y()), new Vector2(prx.z(), pry.z()), false, 8, null);
                Segment2D[] segment2DArray = new Segment2D[]{left, right};
                return segment2DArray;
            }
        }
        throw new IllegalStateException("unsupported number of control points".toString());
    }

    @NotNull
    public String toString() {
        return "Segment(start=" + this.getStart() + ", end=" + this.getEnd() + ", control=" + this.getControl() + ")";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Segment2D cfr_ignored_0 = (Segment2D)other;
        if (!Intrinsics.areEqual(this.getStart(), ((Segment2D)other).getStart())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getEnd(), ((Segment2D)other).getEnd())) {
            return false;
        }
        return Intrinsics.areEqual(this.getControl(), ((Segment2D)other).getControl());
    }

    public int hashCode() {
        int result2 = this.getStart().hashCode();
        result2 = 31 * result2 + this.getEnd().hashCode();
        result2 = 31 * result2 + ((Object)this.getControl()).hashCode();
        return result2;
    }

    @NotNull
    public final Segment2D times(double scale) {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getType().ordinal()]) {
            case 1 -> Segment2DKt.Segment2D$default(this.getStart().times(scale), this.getEnd().times(scale), false, 4, null);
            case 2 -> Segment2DKt.Segment2D$default(this.getStart().times(scale), this.getControl().get(0).times(scale), this.getEnd().times(scale), false, 8, null);
            case 3 -> Segment2DKt.Segment2D$default(this.getStart().times(scale), this.getControl().get(0).times(scale), this.getControl().get(1).times(scale), this.getEnd().times(scale), false, 16, null);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final Segment2D div(double scale) {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getType().ordinal()]) {
            case 1 -> Segment2DKt.Segment2D$default(this.getStart().div(scale), this.getEnd().div(scale), false, 4, null);
            case 2 -> Segment2DKt.Segment2D$default(this.getStart().div(scale), this.getControl().get(0).div(scale), this.getEnd().div(scale), false, 8, null);
            case 3 -> Segment2DKt.Segment2D$default(this.getStart().div(scale), this.getControl().get(0).div(scale), this.getControl().get(1).div(scale), this.getEnd().div(scale), false, 16, null);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final Segment2D minus(@NotNull Segment2D right) {
        Segment2D segment2D;
        block16: {
            block17: {
                block15: {
                    Intrinsics.checkNotNullParameter(right, "right");
                    if (this.getType() != right.getType()) break block15;
                    switch (WhenMappings.$EnumSwitchMapping$0[this.getType().ordinal()]) {
                        case 1: {
                            segment2D = Segment2DKt.Segment2D$default(this.getStart().minus(right.getStart()), this.getEnd().minus(right.getEnd()), false, 4, null);
                            break block16;
                        }
                        case 2: {
                            segment2D = Segment2DKt.Segment2D$default(this.getStart().minus(right.getStart()), this.getControl().get(0).minus(right.getControl().get(0)), this.getEnd().minus(right.getEnd()), false, 8, null);
                            break block16;
                        }
                        case 3: {
                            segment2D = Segment2DKt.Segment2D$default(this.getStart().minus(right.getStart()), this.getControl().get(0).minus(right.getControl().get(0)), this.getControl().get(1).minus(right.getControl().get(1)), this.getEnd().minus(right.getEnd()), false, 16, null);
                            break block16;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                if (this.getType().ordinal() <= right.getType().ordinal()) break block17;
                switch (WhenMappings.$EnumSwitchMapping$0[this.getType().ordinal()]) {
                    case 1: {
                        throw new IllegalStateException("impossible?".toString());
                    }
                    case 2: {
                        segment2D = this.minus(right.getQuadratic());
                        break block16;
                    }
                    case 3: {
                        segment2D = this.minus(right.getCubic());
                        break block16;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$0[right.getType().ordinal()]) {
                case 1: {
                    throw new IllegalStateException("impossible?".toString());
                }
                case 2: {
                    segment2D = this.getQuadratic().minus(right);
                    break;
                }
                case 3: {
                    segment2D = this.getCubic().minus(right);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return segment2D;
    }

    @NotNull
    public final Segment2D plus(@NotNull Segment2D right) {
        Segment2D segment2D;
        block16: {
            block17: {
                block15: {
                    Intrinsics.checkNotNullParameter(right, "right");
                    if (this.getType() != right.getType()) break block15;
                    switch (WhenMappings.$EnumSwitchMapping$0[this.getType().ordinal()]) {
                        case 1: {
                            segment2D = Segment2DKt.Segment2D$default(this.getStart().plus(right.getStart()), this.getEnd().plus(right.getEnd()), false, 4, null);
                            break block16;
                        }
                        case 2: {
                            segment2D = Segment2DKt.Segment2D$default(this.getStart().plus(right.getStart()), this.getControl().get(0).plus(right.getControl().get(0)), this.getEnd().plus(right.getEnd()), false, 8, null);
                            break block16;
                        }
                        case 3: {
                            segment2D = Segment2DKt.Segment2D$default(this.getStart().plus(right.getStart()), this.getControl().get(0).plus(right.getControl().get(0)), this.getControl().get(1).plus(right.getControl().get(1)), this.getEnd().plus(right.getEnd()), false, 16, null);
                            break block16;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                if (this.getType().ordinal() <= right.getType().ordinal()) break block17;
                switch (WhenMappings.$EnumSwitchMapping$0[this.getType().ordinal()]) {
                    case 1: {
                        throw new IllegalStateException("impossible?".toString());
                    }
                    case 2: {
                        segment2D = this.plus(right.getQuadratic());
                        break block16;
                    }
                    case 3: {
                        segment2D = this.plus(right.getCubic());
                        break block16;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$0[right.getType().ordinal()]) {
                case 1: {
                    throw new IllegalStateException("impossible?".toString());
                }
                case 2: {
                    segment2D = this.getQuadratic().plus(right);
                    break;
                }
                case 3: {
                    segment2D = this.getCubic().plus(right);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return segment2D;
    }

    @Override
    @NotNull
    public ShapeContour getContour() {
        return new ShapeContour(CollectionsKt.listOf(this), false, null, 4, null);
    }

    @NotNull
    public final Vector2 component1() {
        return this.start;
    }

    @NotNull
    public final List<Vector2> component2() {
        return this.control;
    }

    @NotNull
    public final Vector2 component3() {
        return this.end;
    }

    public final boolean component4() {
        return this.corner;
    }

    @NotNull
    public final Segment2D copy(@NotNull Vector2 start, @NotNull List<Vector2> control, @NotNull Vector2 end, boolean corner) {
        Intrinsics.checkNotNullParameter(start, "start");
        Intrinsics.checkNotNullParameter(control, "control");
        Intrinsics.checkNotNullParameter(end, "end");
        return new Segment2D(start, control, end, corner);
    }

    public static /* synthetic */ Segment2D copy$default(Segment2D segment2D, Vector2 vector2, List list, Vector2 vector22, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = segment2D.start;
        }
        if ((n & 2) != 0) {
            list = segment2D.control;
        }
        if ((n & 4) != 0) {
            vector22 = segment2D.end;
        }
        if ((n & 8) != 0) {
            bl = segment2D.corner;
        }
        return segment2D.copy(vector2, list, vector22, bl);
    }

    @Override
    public boolean getLinear() {
        return BezierSegment.DefaultImpls.getLinear(this);
    }

    @Override
    @NotNull
    public SegmentType getType() {
        return BezierSegment.DefaultImpls.getType(this);
    }

    @Override
    @NotNull
    public Vector2 direction() {
        return BezierSegment.DefaultImpls.direction(this);
    }

    @Override
    @NotNull
    public Vector2 direction(double t) {
        return BezierSegment.DefaultImpls.direction(this, t);
    }

    @Override
    @NotNull
    public Vector2 pointAtLength(double length, double distanceTolerance) {
        return BezierSegment.DefaultImpls.pointAtLength(this, length, distanceTolerance);
    }

    @Override
    @NotNull
    public List<Vector2> adaptivePositions(double distanceTolerance) {
        return BezierSegment.DefaultImpls.adaptivePositions(this, distanceTolerance);
    }

    @Override
    @NotNull
    public List<Pair<Vector2, Double>> adaptivePositionsWithT(double distanceTolerance) {
        return BezierSegment.DefaultImpls.adaptivePositionsWithT(this, distanceTolerance);
    }

    @Override
    @NotNull
    public List<Vector2> equidistantPositions(int pointCount, double distanceTolerance) {
        return BezierSegment.DefaultImpls.equidistantPositions(this, pointCount, distanceTolerance);
    }

    @Override
    @NotNull
    public List<Pair<Vector2, Double>> equidistantPositionsWithT(int pointCount, double distanceTolerance) {
        return BezierSegment.DefaultImpls.equidistantPositionsWithT(this, pointCount, distanceTolerance);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_shape(Segment2D self, CompositeEncoder output, SerialDescriptor serialDesc) {
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, Vector2$.serializer.INSTANCE, self.getStart());
        output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)kSerializerArray[1], self.getControl());
        output.encodeSerializableElement(serialDesc, 2, Vector2$.serializer.INSTANCE, self.getEnd());
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : self.corner) {
            output.encodeBooleanElement(serialDesc, 3, self.corner);
        }
    }

    public /* synthetic */ Segment2D(int seen0, Vector2 start, List control, Vector2 end, boolean corner, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 7, $serializer.INSTANCE.getDescriptor());
        }
        this.start = start;
        this.control = control;
        this.end = end;
        this.corner = (seen0 & 8) == 0 ? false : corner;
        this.lut = null;
        this.length$delegate = LazyKt.lazy(() -> Segment2D._init_$lambda$13(this));
    }

    private static final double nearest$sign(double n) {
        double s = Math.signum(n);
        return s == 0.0 ? -1.0 : s;
    }

    private static final double length_delegate$lambda$1(Segment2D this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return switch (this$0.getControl().size()) {
            case 0 -> this$0.getEnd().minus(this$0.getStart()).length();
            case 1, 2 -> Segment2DKt.access$sumDifferences(BezierSegment.DefaultImpls.adaptivePositions$default(this$0, 0.0, 1, null));
            default -> throw new RuntimeException("unsupported number of control points");
        };
    }

    private static final double _init_$lambda$13(Segment2D this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return switch (this$0.getControl().size()) {
            case 0 -> this$0.getEnd().minus(this$0.getStart()).length();
            case 1, 2 -> Segment2DKt.access$sumDifferences(BezierSegment.DefaultImpls.adaptivePositions$default(this$0, 0.0, 1, null));
            default -> throw new RuntimeException("unsupported number of control points");
        };
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{null, new ArrayListSerializer(Vector2$.serializer.INSTANCE), null, null};
        $childSerializers = kSerializerArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/shape/Segment2D$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/openrndr/shape/Segment2D;", "openrndr-shape"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<Segment2D> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SegmentType.values().length];
            try {
                nArray[SegmentType.LINEAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SegmentType.QUADRATIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SegmentType.CUBIC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

