/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.BezierKt;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector3$;
import org.openrndr.math.Vector4;
import org.openrndr.shape.BezierSegment;
import org.openrndr.shape.Segment3D$;
import org.openrndr.shape.Segment3DKt;
import org.openrndr.shape.SegmentProjection3D;
import org.openrndr.shape.SegmentType;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 H2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002GHB%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bBO\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0002\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0005\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u0007\u0010\u000eJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\b\b\u0002\u0010\u0014\u001a\u00020\nJ\u001f\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00022\b\b\u0002\u0010\u0018\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0019J*\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0002H\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0002J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010 \u001a\u00020!J\u0010\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u0016H\u0016J\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00160\u0005J\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005J\u0014\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00050\u0005H\u0002J\u0010\u0010/\u001a\u00020\u00022\u0006\u00100\u001a\u00020\u0016H\u0016J\u001b\u00103\u001a\b\u0012\u0004\u0012\u00020\u0000042\u0006\u00100\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u00105J\b\u00106\u001a\u000207H\u0016J*\u00108\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0002J\u0013\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010<H\u0096\u0002J\b\u0010=\u001a\u00020\nH\u0016J\u0010\u0010>\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u0016H\u0016J%\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0001\u00a2\u0006\u0002\bFR\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\"\u001a\u00020\u00168VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b#\u0010$R\u0014\u0010,\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u00101\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010.\u00a8\u0006I"}, d2={"Lorg/openrndr/shape/Segment3D;", "Lorg/openrndr/shape/BezierSegment;", "Lorg/openrndr/math/Vector3;", "start", "control", "", "end", "<init>", "(Lorg/openrndr/math/Vector3;Ljava/util/List;Lorg/openrndr/math/Vector3;)V", "seen0", "", "lut", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILorg/openrndr/math/Vector3;Ljava/util/List;Lorg/openrndr/math/Vector3;Ljava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getStart", "()Lorg/openrndr/math/Vector3;", "getControl", "()Ljava/util/List;", "getEnd", "size", "on", "", "point", "error", "(Lorg/openrndr/math/Vector3;D)Ljava/lang/Double;", "closest", "Lkotlin/Pair;", "points", "query", "project", "Lorg/openrndr/shape/SegmentProjection3D;", "transform", "Lorg/openrndr/math/Matrix44;", "length", "getLength", "()D", "length$delegate", "Lkotlin/Lazy;", "position", "ut", "extrema", "extremaPoints", "dpoints", "cubic", "getCubic", "()Lorg/openrndr/shape/Segment3D;", "derivative", "t", "reverse", "getReverse", "split", "", "(D)[Lorg/openrndr/shape/Segment3D;", "toString", "", "copy", "equals", "", "other", "", "hashCode", "tForLength", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_shape", "$serializer", "Companion", "openrndr-shape"})
@SourceDebugExtension(value={"SMAP\nSegment3D.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Segment3D.kt\norg/openrndr/shape/Segment3D\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,419:1\n1557#2:420\n1628#2,3:421\n1557#2:424\n1628#2,3:425\n1557#2:428\n1628#2,3:429\n774#2:432\n865#2,2:433\n1557#2:435\n1628#2,3:436\n1557#2:439\n1628#2,3:440\n1557#2:443\n1628#2,3:444\n1557#2:447\n1628#2,3:448\n774#2:451\n865#2,2:452\n1557#2:454\n1628#2,3:455\n*S KotlinDebug\n*F\n+ 1 Segment3D.kt\norg/openrndr/shape/Segment3D\n*L\n27#1:420\n27#1:421,3\n133#1:424\n133#1:425,3\n134#1:428\n134#1:429,3\n135#1:432\n135#1:433,2\n139#1:435\n139#1:436,3\n139#1:439\n139#1:440,3\n140#1:443\n140#1:444,3\n140#1:447\n140#1:448,3\n141#1:451\n141#1:452,2\n148#1:454\n148#1:455,3\n*E\n"})
public final class Segment3D
implements BezierSegment<Vector3> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector3 start;
    @NotNull
    private final List<Vector3> control;
    @NotNull
    private final Vector3 end;
    @Nullable
    private List<Vector3> lut;
    @NotNull
    private final Lazy length$delegate;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;

    public Segment3D(@NotNull Vector3 start, @NotNull List<Vector3> control, @NotNull Vector3 end) {
        Intrinsics.checkNotNullParameter(start, "start");
        Intrinsics.checkNotNullParameter(control, "control");
        Intrinsics.checkNotNullParameter(end, "end");
        this.start = start;
        this.control = control;
        this.end = end;
        this.length$delegate = LazyKt.lazy(() -> Segment3D.length_delegate$lambda$1(this));
    }

    @Override
    @NotNull
    public Vector3 getStart() {
        return this.start;
    }

    @Override
    @NotNull
    public List<Vector3> getControl() {
        return this.control;
    }

    @Override
    @NotNull
    public Vector3 getEnd() {
        return this.end;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vector3> lut(int size) {
        block4: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            block3: {
                if (this.lut == null) break block3;
                List<Vector3> list = this.lut;
                Intrinsics.checkNotNull(list);
                if (list.size() == size) break block4;
            }
            Iterable iterable = new IntRange(0, size);
            Segment3D segment3D = this;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.position((double)it / (double)size));
            }
            segment3D.lut = (List)destination$iv$iv;
        }
        List<Vector3> list = this.lut;
        Intrinsics.checkNotNull(list);
        return list;
    }

    public static /* synthetic */ List lut$default(Segment3D segment3D, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 100;
        }
        return segment3D.lut(n);
    }

    @Nullable
    public final Double on(@NotNull Vector3 point, double error) {
        Intrinsics.checkNotNullParameter(point, "point");
        List lut = Segment3D.lut$default(this, 0, 1, null);
        int hits = 0;
        double t = 0.0;
        int n = ((Collection)lut).size();
        for (int i = 0; i < n; ++i) {
            if (!(((Vector3)lut.get(i)).minus(point).squaredLength() < error * error)) continue;
            ++hits;
            t += (double)i / (double)lut.size();
        }
        return hits > 0 ? Double.valueOf(t / (double)hits) : null;
    }

    public static /* synthetic */ Double on$default(Segment3D segment3D, Vector3 vector3, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 5.0;
        }
        return segment3D.on(vector3, d);
    }

    private final Pair<Integer, Vector3> closest(List<Vector3> points2, Vector3 query) {
        int closestIndex = 0;
        Vector3 closestValue = points2.get(0);
        double closestDistance = Double.POSITIVE_INFINITY;
        int n = ((Collection)points2).size();
        for (int i = 0; i < n; ++i) {
            double distance = points2.get(i).minus(query).squaredLength();
            if (!(distance < closestDistance)) continue;
            closestIndex = i;
            closestValue = points2.get(i);
            closestDistance = distance;
        }
        return new Pair<Integer, Vector3>(closestIndex, closestValue);
    }

    @NotNull
    public final SegmentProjection3D project(@NotNull Vector3 point) {
        Vector3 p;
        Intrinsics.checkNotNullParameter(point, "point");
        List lut = Segment3D.lut$default(this, 0, 1, null);
        double l = lut.size() - 1;
        Pair<Integer, Vector3> closest = this.closest(lut, point);
        double closestDistance = point.minus(closest.getSecond()).squaredLength();
        if (((Number)closest.getFirst()).intValue() == 0 || ((Number)closest.getFirst()).intValue() == lut.size() - 1) {
            double t = (double)((Number)closest.getFirst()).intValue() / l;
            return new SegmentProjection3D(this, t, closestDistance, closest.getSecond());
        }
        double t1 = (double)(((Number)closest.getFirst()).intValue() - 1) / l;
        double t2 = (double)(((Number)closest.getFirst()).intValue() + 1) / l;
        double step = 0.1 / l;
        double ft = t1;
        for (double t = t1; t < t2 + step; t += step) {
            p = this.position(t);
            double d = p.minus(point).squaredLength();
            if (!(d < closestDistance)) continue;
            closestDistance = d;
            ft = t;
        }
        p = this.position(ft);
        return new SegmentProjection3D(this, ft, closestDistance, p);
    }

    @NotNull
    public final Segment3D transform(@NotNull Matrix44 transform2) {
        Intrinsics.checkNotNullParameter(transform2, "transform");
        Vector3 tstart = transform2.times(this.getStart().xyz1()).div();
        Vector3 tend = transform2.times(this.getEnd().xyz1()).div();
        List<Vector3> tcontrol = switch (this.getControl().size()) {
            case 2 -> {
                Vector3[] var5_4 = new Vector3[]{transform2.times(this.getControl().get(0).xyz1()).div(), transform2.times(this.getControl().get(1).xyz1()).div()};
                yield CollectionsKt.listOf(var5_4);
            }
            case 1 -> CollectionsKt.listOf(transform2.times(this.getControl().get(0).xyz1()).div());
            default -> CollectionsKt.emptyList();
        };
        return new Segment3D(tstart, tcontrol, tend);
    }

    @Override
    public double getLength() {
        Lazy lazy = this.length$delegate;
        return ((Number)lazy.getValue()).doubleValue();
    }

    @Override
    @NotNull
    public Vector3 position(double ut) {
        double t = RangesKt.coerceIn(ut, 0.0, 1.0);
        return switch (this.getControl().size()) {
            case 0 -> new Vector3(this.getStart().x() * (1.0 - t) + this.getEnd().x() * t, this.getStart().y() * (1.0 - t) + this.getEnd().y() * t, this.getStart().z() * (1.0 - t) + this.getEnd().z() * t);
            case 1 -> BezierKt.bezier(this.getStart(), this.getControl().get(0), this.getEnd(), t);
            case 2 -> BezierKt.bezier(this.getStart(), this.getControl().get(0), this.getControl().get(1), this.getEnd(), t);
            default -> throw new RuntimeException("unsupported number of control points");
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Double> extrema() {
        List list;
        List<List<Vector3>> dpoints = this.dpoints();
        if (this.getLinear()) {
            list = CollectionsKt.emptyList();
        } else if (this.getControl().size() == 1) {
            void $this$filterTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv = dpoints.get(0);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Vector3 vector3 = (Vector3)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.x());
            }
            List<Double> xRoots = BezierKt.roots((List)destination$iv$iv);
            Iterable $this$map$iv2 = dpoints.get(0);
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Vector3 bl = (Vector3)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.y());
            }
            List<Double> yRoots = BezierKt.roots((List)destination$iv$iv2);
            Iterable $this$filter$iv = CollectionsKt.sorted(CollectionsKt.distinct(CollectionsKt.plus((Collection)xRoots, (Iterable)yRoots)));
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                double it = ((Number)element$iv$iv).doubleValue();
                boolean bl = false;
                boolean bl3 = 0.0 <= it ? it <= 1.0 : false;
                if (!bl3) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            list = (List)destination$iv$iv2;
        } else if (this.getControl().size() == 2) {
            void $this$filterTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Collection collection;
            Vector3 it;
            Collection collection2;
            Iterable $this$mapTo$iv$iv3;
            Iterable $this$map$iv = dpoints.get(0);
            boolean $i$f$map = false;
            Iterable $i$f$filter = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                Vector3 element$iv$iv = (Vector3)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.x());
            }
            $this$map$iv = dpoints.get(1);
            collection2 = BezierKt.roots((List)destination$iv$iv);
            $i$f$map = false;
            $this$mapTo$iv$iv3 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                it = (Vector3)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.x());
            }
            List xRoots = CollectionsKt.plus(collection2, (Iterable)BezierKt.roots((List)destination$iv$iv));
            Iterable $this$map$iv3 = dpoints.get(0);
            boolean $i$f$map3 = false;
            destination$iv$iv = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Vector3 bl = (Vector3)item$iv$iv;
                collection2 = destination$iv$iv3;
                boolean bl4 = false;
                collection2.add(it2.y());
            }
            $this$map$iv3 = dpoints.get(1);
            collection2 = BezierKt.roots((List)destination$iv$iv3);
            $i$f$map3 = false;
            $this$mapTo$iv$iv = $this$map$iv3;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
            $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Vector3 it2 = (Vector3)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl = false;
                collection.add(it2.y());
            }
            List yRoots = CollectionsKt.plus(collection2, (Iterable)BezierKt.roots((List)destination$iv$iv3));
            Iterable $this$filter$iv = CollectionsKt.sorted(CollectionsKt.distinct(CollectionsKt.plus((Collection)xRoots, (Iterable)yRoots)));
            boolean $i$f$filter2 = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Vector3 element$iv$iv : $this$filterTo$iv$iv) {
                double it3 = ((Number)((Object)element$iv$iv)).doubleValue();
                boolean bl = false;
                boolean bl5 = 0.0 <= it3 ? it3 <= 1.0 : false;
                if (!bl5) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            list = (List)destination$iv$iv3;
        } else {
            throw new RuntimeException("not supported");
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vector3> extremaPoints() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.extrema();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double d = ((Number)item$iv$iv).doubleValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.position((double)it));
        }
        return (List)destination$iv$iv;
    }

    private final List<List<Vector3>> dpoints() {
        List points2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf(this.getStart()), (Iterable)this.getControl()), (Iterable)CollectionsKt.listOf(this.getEnd()));
        int d = points2.size();
        int c2 = d - 1;
        List dpoints = new ArrayList();
        List p = points2;
        while (d > 1) {
            List list = new ArrayList();
            int n = c2;
            for (int j = 0; j < n; ++j) {
                list.add(new Vector3((double)c2 * (((Vector3)p.get(j + 1)).x() - ((Vector3)p.get(j)).x()), (double)c2 * (((Vector3)p.get(j + 1)).y() - ((Vector3)p.get(j)).y()), (double)c2 * (((Vector3)p.get(j + 1)).z() - ((Vector3)p.get(j)).z())));
            }
            dpoints.add(list);
            p = list;
            --d;
            --c2;
        }
        return dpoints;
    }

    @NotNull
    public Segment3D getCubic() {
        Segment3D segment3D;
        if (this.getControl().size() == 2) {
            segment3D = this;
        } else if (this.getControl().size() == 1) {
            segment3D = Segment3DKt.Segment3D(this.getStart(), this.getStart().times(0.3333333333333333).plus(this.getControl().get(0).times(0.6666666666666666)), this.getControl().get(0).times(0.6666666666666666).plus(this.getEnd().times(0.3333333333333333)), this.getEnd());
        } else if (this.getLinear()) {
            Vector3 delta = this.getEnd().minus(this.getStart());
            segment3D = Segment3DKt.Segment3D(this.getStart(), this.getStart().plus(delta.times(0.3333333333333333)), this.getStart().plus(delta.times(0.6666666666666666)), this.getEnd());
        } else {
            throw new RuntimeException("cannot convert to cubic segment");
        }
        return segment3D;
    }

    @Override
    @NotNull
    public Vector3 derivative(double t) {
        Vector3 vector3;
        if (this.getLinear()) {
            vector3 = this.getStart().minus(this.getEnd());
        } else if (this.getControl().size() == 1) {
            vector3 = BezierKt.derivative(this.getStart(), this.getControl().get(0), this.getEnd(), t);
        } else if (this.getControl().size() == 2) {
            vector3 = BezierKt.derivative(this.getStart(), this.getControl().get(0), this.getControl().get(1), this.getEnd(), t);
        } else {
            throw new RuntimeException("not implemented");
        }
        return vector3;
    }

    @NotNull
    public Segment3D getReverse() {
        return switch (this.getControl().size()) {
            case 0 -> Segment3DKt.Segment3D(this.getEnd(), this.getStart());
            case 1 -> Segment3DKt.Segment3D(this.getEnd(), this.getControl().get(0), this.getStart());
            case 2 -> Segment3DKt.Segment3D(this.getEnd(), this.getControl().get(1), this.getControl().get(0), this.getStart());
            default -> throw new RuntimeException("unsupported number of control points");
        };
    }

    @NotNull
    public Segment3D[] split(double t) {
        double u = RangesKt.coerceIn(t, 0.0, 1.0);
        if (this.getLinear()) {
            Vector3 cut = this.getStart().plus(this.getEnd().minus(this.getStart()).times(u));
            Segment3D[] segment3DArray = new Segment3D[]{Segment3DKt.Segment3D(this.getStart(), cut), Segment3DKt.Segment3D(cut, this.getEnd())};
            return segment3DArray;
        }
        switch (this.getControl().size()) {
            case 2: {
                double z = u;
                double z2 = z * z;
                double z3 = z * z * z;
                double iz = 1.0 - z;
                double iz2 = iz * iz;
                double iz3 = iz * iz * iz;
                Matrix44 lsm = new Matrix44(1.0, 0.0, 0.0, 0.0, iz, z, 0.0, 0.0, iz2, 2.0 * iz * z, z2, 0.0, iz3, 3.0 * iz2 * z, 3.0 * iz * z2, z3);
                Vector4 px = new Vector4(this.getStart().x(), this.getControl().get(0).x(), this.getControl().get(1).x(), this.getEnd().x());
                Vector4 py = new Vector4(this.getStart().y(), this.getControl().get(0).y(), this.getControl().get(1).y(), this.getEnd().y());
                Vector4 pz = new Vector4(this.getStart().z(), this.getControl().get(0).z(), this.getControl().get(1).z(), this.getEnd().z());
                Vector4 plx = lsm.times(px);
                Vector4 ply = lsm.times(py);
                Vector4 plz = lsm.times(pz);
                Vector3 pl0 = new Vector3(plx.x(), ply.x(), plz.x());
                Vector3 pl1 = new Vector3(plx.y(), ply.y(), plz.y());
                Vector3 pl2 = new Vector3(plx.z(), ply.z(), plz.z());
                Vector3 pl3 = new Vector3(plx.w(), ply.w(), plz.w());
                Segment3D left = Segment3DKt.Segment3D(pl0, pl1, pl2, pl3);
                Matrix44 rsm = new Matrix44(iz3, 3.0 * iz2 * z, 3.0 * iz * z2, z3, 0.0, iz2, 2.0 * iz * z, z2, 0.0, 0.0, iz, z, 0.0, 0.0, 0.0, 1.0);
                Vector4 prx = rsm.times(px);
                Vector4 pry = rsm.times(py);
                Vector4 prz = rsm.times(pz);
                Vector3 pr0 = new Vector3(prx.x(), pry.x(), prz.x());
                Vector3 pr1 = new Vector3(prx.y(), pry.y(), prz.y());
                Vector3 pr2 = new Vector3(prx.z(), pry.z(), prz.z());
                Vector3 pr3 = new Vector3(prx.w(), pry.w(), prz.w());
                Segment3D right = Segment3DKt.Segment3D(pr0, pr1, pr2, pr3);
                Segment3D[] segment3DArray = new Segment3D[]{left, right};
                return segment3DArray;
            }
            case 1: {
                double z = u;
                double iz = 1.0 - z;
                double iz2 = iz * iz;
                double z2 = z * z;
                Matrix44 lsm = new Matrix44(1.0, 0.0, 0.0, 0.0, iz, z, 0.0, 0.0, iz2, 2.0 * iz * z, z2, 0.0, 0.0, 0.0, 0.0, 0.0);
                Vector4 px = new Vector4(this.getStart().x(), this.getControl().get(0).x(), this.getEnd().x(), 0.0);
                Vector4 py = new Vector4(this.getStart().y(), this.getControl().get(0).y(), this.getEnd().y(), 0.0);
                Vector4 pz = new Vector4(this.getStart().z(), this.getControl().get(0).z(), this.getEnd().z(), 0.0);
                Vector4 plx = lsm.times(px);
                Vector4 ply = lsm.times(py);
                Vector4 plz = lsm.times(pz);
                Segment3D left = Segment3DKt.Segment3D(new Vector3(plx.x(), ply.x(), plz.x()), new Vector3(plx.y(), ply.y(), plz.y()), new Vector3(plx.z(), ply.z(), plz.z()));
                Matrix44 rsm = new Matrix44(iz2, 2.0 * iz * z, z2, 0.0, 0.0, iz, z, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                Vector4 prx = rsm.times(px);
                Vector4 pry = rsm.times(py);
                Vector4 prz = rsm.times(pz);
                Segment3D right = Segment3DKt.Segment3D(new Vector3(prx.x(), pry.x(), prz.x()), new Vector3(prx.y(), pry.y(), prz.y()), new Vector3(prx.z(), pry.z(), prz.z()));
                Segment3D[] segment3DArray = new Segment3D[]{left, right};
                return segment3DArray;
            }
        }
        throw new RuntimeException("not implemented");
    }

    @NotNull
    public String toString() {
        return "Segment(start=" + this.getStart() + ", end=" + this.getEnd() + ", control=" + this.getControl() + ")";
    }

    @NotNull
    public final Segment3D copy(@NotNull Vector3 start, @NotNull List<Vector3> control, @NotNull Vector3 end) {
        Intrinsics.checkNotNullParameter(start, "start");
        Intrinsics.checkNotNullParameter(control, "control");
        Intrinsics.checkNotNullParameter(end, "end");
        return new Segment3D(start, control, end);
    }

    public static /* synthetic */ Segment3D copy$default(Segment3D segment3D, Vector3 vector3, List list, Vector3 vector32, int n, Object object) {
        if ((n & 1) != 0) {
            vector3 = segment3D.getStart();
        }
        if ((n & 2) != 0) {
            list = segment3D.getControl();
        }
        if ((n & 4) != 0) {
            vector32 = segment3D.getEnd();
        }
        return segment3D.copy(vector3, list, vector32);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Segment3D cfr_ignored_0 = (Segment3D)other;
        if (!Intrinsics.areEqual(this.getStart(), ((Segment3D)other).getStart())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getEnd(), ((Segment3D)other).getEnd())) {
            return false;
        }
        return Intrinsics.areEqual(this.getControl(), ((Segment3D)other).getControl());
    }

    public int hashCode() {
        int result2 = this.getStart().hashCode();
        result2 = 31 * result2 + this.getEnd().hashCode();
        result2 = 31 * result2 + ((Object)this.getControl()).hashCode();
        return result2;
    }

    @Override
    public double tForLength(double length) {
        if (this.getType() == SegmentType.LINEAR) {
            return RangesKt.coerceIn(length / this.getLength(), 0.0, 1.0);
        }
        double segmentLength = this.getLength();
        double cLength = RangesKt.coerceIn(length, 0.0, segmentLength);
        if (cLength == 0.0) {
            return 0.0;
        }
        if (cLength >= segmentLength) {
            return 1.0;
        }
        double summedLength = 0.0;
        this.lut(100);
        List<Vector3> list = this.lut;
        if (list == null) {
            throw new IllegalStateException("no lut".toString());
        }
        List<Vector3> cLut = list;
        int partitionCount = cLut.size() - 1;
        double dt = 1.0 / (double)partitionCount;
        List<Vector3> list2 = this.lut;
        Intrinsics.checkNotNull(list2);
        Iterator iterator2 = ((Iterable)list2).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            Vector3 p1;
            Vector3 p0;
            double partitionLength;
            int index = n++;
            iterator2.next();
            List<Vector3> list3 = this.lut;
            Intrinsics.checkNotNull(list3);
            if (index >= list3.size() - 1 || !((summedLength += (partitionLength = (p0 = cLut.get(index)).distanceTo(p1 = cLut.get(index + 1)))) >= length)) continue;
            double localT = (double)index / (double)partitionCount;
            double overshoot = summedLength - length;
            return localT + overshoot / partitionLength * dt;
        }
        return 1.0;
    }

    @Override
    public boolean getLinear() {
        return BezierSegment.DefaultImpls.getLinear(this);
    }

    @Override
    @NotNull
    public SegmentType getType() {
        return BezierSegment.DefaultImpls.getType(this);
    }

    @Override
    @NotNull
    public Vector3 direction() {
        return BezierSegment.DefaultImpls.direction(this);
    }

    @Override
    @NotNull
    public Vector3 direction(double t) {
        return BezierSegment.DefaultImpls.direction(this, t);
    }

    @Override
    @NotNull
    public BezierSegment<Vector3> sub(double t0, double t1) {
        return BezierSegment.DefaultImpls.sub(this, t0, t1);
    }

    @Override
    @NotNull
    public Vector3 pointAtLength(double length, double distanceTolerance) {
        return BezierSegment.DefaultImpls.pointAtLength(this, length, distanceTolerance);
    }

    @Override
    @NotNull
    public List<Vector3> adaptivePositions(double distanceTolerance) {
        return BezierSegment.DefaultImpls.adaptivePositions(this, distanceTolerance);
    }

    @Override
    @NotNull
    public List<Pair<Vector3, Double>> adaptivePositionsWithT(double distanceTolerance) {
        return BezierSegment.DefaultImpls.adaptivePositionsWithT(this, distanceTolerance);
    }

    @Override
    @NotNull
    public List<Vector3> equidistantPositions(int pointCount, double distanceTolerance) {
        return BezierSegment.DefaultImpls.equidistantPositions(this, pointCount, distanceTolerance);
    }

    @Override
    @NotNull
    public List<Pair<Vector3, Double>> equidistantPositionsWithT(int pointCount, double distanceTolerance) {
        return BezierSegment.DefaultImpls.equidistantPositionsWithT(this, pointCount, distanceTolerance);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_shape(Segment3D self, CompositeEncoder output, SerialDescriptor serialDesc) {
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, Vector3$.serializer.INSTANCE, self.getStart());
        output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)kSerializerArray[1], self.getControl());
        output.encodeSerializableElement(serialDesc, 2, Vector3$.serializer.INSTANCE, self.getEnd());
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : self.lut != null) {
            output.encodeNullableSerializableElement(serialDesc, 3, (SerializationStrategy)kSerializerArray[3], self.lut);
        }
    }

    public /* synthetic */ Segment3D(int seen0, Vector3 start, List control, Vector3 end, List lut, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 7, $serializer.INSTANCE.getDescriptor());
        }
        this.start = start;
        this.control = control;
        this.end = end;
        this.lut = (seen0 & 8) == 0 ? null : lut;
        this.length$delegate = LazyKt.lazy(() -> Segment3D._init_$lambda$11(this));
    }

    private static final double length_delegate$lambda$1(Segment3D this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return switch (this$0.getControl().size()) {
            case 0 -> this$0.getEnd().minus(this$0.getStart()).length();
            case 1, 2 -> Segment3DKt.access$sumDifferences(BezierSegment.DefaultImpls.adaptivePositions$default(this$0, 0.0, 1, null));
            default -> throw new RuntimeException("unsupported number of control points");
        };
    }

    private static final double _init_$lambda$11(Segment3D this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return switch (this$0.getControl().size()) {
            case 0 -> this$0.getEnd().minus(this$0.getStart()).length();
            case 1, 2 -> Segment3DKt.access$sumDifferences(BezierSegment.DefaultImpls.adaptivePositions$default(this$0, 0.0, 1, null));
            default -> throw new RuntimeException("unsupported number of control points");
        };
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{null, new ArrayListSerializer(Vector3$.serializer.INSTANCE), null, new ArrayListSerializer(Vector3$.serializer.INSTANCE)};
        $childSerializers = kSerializerArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/shape/Segment3D$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/openrndr/shape/Segment3D;", "openrndr-shape"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<Segment3D> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

