/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.reflect.KProperty;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.Transient;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.kartifex.Path2;
import org.openrndr.kartifex.Region2;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.shape.ContourPoint;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.RectangleKt;
import org.openrndr.shape.Segment2D;
import org.openrndr.shape.Shape$;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.ShapeContour$;
import org.openrndr.shape.ShapeProvider;
import org.openrndr.shape.ShapeTopology;
import org.openrndr.shape.Triangle;
import org.openrndr.shape.TriangulatorKt;
import org.openrndr.shape.Winding;
import org.openrndr.utils.ResettableDelegate;
import org.openrndr.utils.ResettableDelegateKt;

@Serializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 n2\u00020\u0001:\u0002noB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B+\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u0010\u0010-\u001a\u00020\u00002\b\b\u0002\u0010.\u001a\u00020/J\u0006\u0010I\u001a\u00020JJ\u001e\u0010K\u001a\b\u0012\u0004\u0012\u00020*0\u00032\u0006\u0010L\u001a\u00020\b2\b\b\u0002\u0010M\u001a\u00020NJ\u000e\u0010R\u001a\u00020\u00042\u0006\u0010S\u001a\u00020\bJ\u000e\u0010T\u001a\u00020\u00002\u0006\u0010T\u001a\u00020UJ\u001a\u0010V\u001a\u00020\u00002\u0012\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040XJ\u0016\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00000\u00032\b\b\u0002\u0010\\\u001a\u00020]J\u0013\u0010a\u001a\u00020$2\b\u0010b\u001a\u0004\u0018\u00010cH\u0096\u0002J\b\u0010d\u001a\u00020\bH\u0016J\b\u0010e\u001a\u00020fH\u0016J%\u0010g\u001a\u00020J2\u0006\u0010h\u001a\u00020\u00002\u0006\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020lH\u0001\u00a2\u0006\u0002\bmR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0013\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017*\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0018\u001a\u00020\u00198\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u0012\u001a\u0004\b\u001b\u0010\u001cR\"\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001e\u0010\u0012\u001a\u0004\b\u001f\u0010\rR\"\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b!\u0010\u0012\u001a\u0004\b\"\u0010\rR\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010+\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010&R\"\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002010\u00030\u000f8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b2\u0010\u0012R!\u00103\u001a\b\u0012\u0004\u0012\u0002010\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b5\u0010\r*\u0004\b4\u0010\u0015R\u001c\u00106\u001a\b\u0012\u0004\u0012\u00020/0\u000f8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b7\u0010\u0012R\u001b\u00108\u001a\u00020/8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b:\u0010;*\u0004\b9\u0010\u0015R\u001c\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\u000f8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b>\u0010\u0012R\u001b\u0010?\u001a\u00020=8@X\u0080\u0084\u0002\u00a2\u0006\f\u001a\u0004\bA\u0010B*\u0004\b@\u0010\u0015R\"\u0010C\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020D0\u00030\u000f8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\bE\u0010\u0012R!\u0010F\u001a\b\u0012\u0004\u0012\u00020D0\u00038@X\u0080\u0084\u0002\u00a2\u0006\f\u001a\u0004\bH\u0010\r*\u0004\bG\u0010\u0015R\u0011\u0010O\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\bP\u0010QR\u0011\u0010Y\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\bZ\u0010&R\u0014\u0010^\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b_\u0010`\u00a8\u0006p"}, d2={"Lorg/openrndr/shape/Shape;", "Lorg/openrndr/shape/ShapeProvider;", "contours", "", "Lorg/openrndr/shape/ShapeContour;", "<init>", "(Ljava/util/List;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getContours", "()Ljava/util/List;", "boundsDelegate", "Lorg/openrndr/utils/ResettableDelegate;", "Lorg/openrndr/shape/Rectangle;", "getBoundsDelegate$annotations", "()V", "bounds", "getBounds$delegate", "(Lorg/openrndr/shape/Shape;)Ljava/lang/Object;", "getBounds", "()Lorg/openrndr/shape/Rectangle;", "topology", "Lorg/openrndr/shape/ShapeTopology;", "getTopology$annotations", "getTopology", "()Lorg/openrndr/shape/ShapeTopology;", "openContours", "getOpenContours$annotations", "getOpenContours", "closedContours", "getClosedContours$annotations", "getClosedContours", "empty", "", "getEmpty", "()Z", "nearest", "Lorg/openrndr/shape/ContourPoint;", "point", "Lorg/openrndr/math/Vector2;", "linear", "getLinear", "polygon", "distanceTolerance", "", "triangulationDelegate", "Lorg/openrndr/shape/Triangle;", "getTriangulationDelegate$annotations", "triangulation", "getTriangulation$delegate", "getTriangulation", "areaDelegate", "getAreaDelegate$annotations", "area", "getArea$delegate", "getArea", "()D", "region2Delegate", "Lorg/openrndr/kartifex/Region2;", "getRegion2Delegate$annotations", "region2", "getRegion2$openrndr_shape$delegate", "getRegion2$openrndr_shape", "()Lorg/openrndr/kartifex/Region2;", "path2Delegate", "Lorg/openrndr/kartifex/Path2;", "getPath2Delegate$annotations", "path2", "getPath2$openrndr_shape$delegate", "getPath2$openrndr_shape", "resetCache", "", "randomPoints", "pointCount", "random", "Lkotlin/random/Random;", "outline", "getOutline", "()Lorg/openrndr/shape/ShapeContour;", "hole", "index", "transform", "Lorg/openrndr/math/Matrix44;", "map", "mapper", "Lkotlin/Function1;", "compound", "getCompound", "splitCompounds", "winding", "Lorg/openrndr/shape/Winding;", "shape", "getShape", "()Lorg/openrndr/shape/Shape;", "equals", "other", "", "hashCode", "toString", "", "write$Self", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$openrndr_shape", "Companion", "$serializer", "openrndr-shape"})
@SourceDebugExtension(value={"SMAP\nShape.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Shape.kt\norg/openrndr/shape/Shape\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n1734#2,3:255\n1734#2,3:258\n774#2:261\n865#2,2:262\n774#2:264\n865#2,2:265\n1557#2:267\n1628#2,3:268\n2341#2,14:271\n1734#2,3:285\n1557#2:288\n1628#2,3:289\n1863#2,2:292\n1557#2:295\n1628#2,3:296\n1557#2:299\n1628#2,3:300\n1782#2,4:303\n3193#2,10:307\n1557#2:317\n1628#2,2:318\n774#2:320\n865#2,2:321\n1630#2:323\n1557#2:324\n1628#2,3:325\n1557#2:328\n1628#2,3:329\n1734#2,3:332\n774#2:335\n865#2,2:336\n774#2:338\n865#2,2:339\n1611#2,9:341\n1863#2:350\n1864#2:352\n1620#2:353\n1557#2:354\n1628#2,3:355\n1557#2:358\n1628#2,3:359\n1557#2:362\n1628#2,3:363\n1611#2,9:366\n1863#2,2:375\n1620#2:377\n1557#2:378\n1628#2,3:379\n1557#2:382\n1628#2,3:383\n1557#2:386\n1628#2,3:387\n1#3:294\n1#3:351\n*S KotlinDebug\n*F\n+ 1 Shape.kt\norg/openrndr/shape/Shape\n*L\n53#1:255,3\n54#1:258,3\n64#1:261\n64#1:262,2\n74#1:264\n74#1:265,2\n90#1:267\n90#1:268,3\n90#1:271,14\n98#1:285,3\n103#1:288\n103#1:289,3\n145#1:292,2\n193#1:295\n193#1:296,3\n197#1:299\n197#1:300,3\n210#1:303,4\n219#1:307,10\n220#1:317\n220#1:318,2\n221#1:320\n221#1:321,2\n220#1:323\n224#1:324\n224#1:325,3\n224#1:328\n224#1:329,3\n54#1:332,3\n64#1:335\n64#1:336,2\n74#1:338\n74#1:339,2\n36#1:341,9\n36#1:350\n36#1:352\n36#1:353\n108#1:354\n108#1:355,3\n127#1:358\n127#1:359,3\n134#1:362\n134#1:363,3\n36#1:366,9\n36#1:375,2\n36#1:377\n108#1:378\n108#1:379,3\n127#1:382\n127#1:383,3\n134#1:386\n134#1:387,3\n36#1:351\n*E\n"})
public final class Shape
implements ShapeProvider {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final List<ShapeContour> contours;
    @NotNull
    private final ResettableDelegate<Rectangle> boundsDelegate;
    @NotNull
    private final ShapeTopology topology;
    @NotNull
    private final List<ShapeContour> openContours;
    @NotNull
    private final List<ShapeContour> closedContours;
    @NotNull
    private final ResettableDelegate<List<Triangle>> triangulationDelegate;
    @NotNull
    private final ResettableDelegate<Double> areaDelegate;
    @NotNull
    private final ResettableDelegate<Region2> region2Delegate;
    @NotNull
    private final ResettableDelegate<List<Path2>> path2Delegate;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;
    @NotNull
    private static final Shape EMPTY;

    public Shape(@NotNull List<ShapeContour> contours) {
        List list;
        ShapeContour it;
        Iterable $this$filterTo$iv$iv;
        boolean $i$f$filterTo;
        Iterable $this$filter$iv;
        List list2;
        ShapeContour it2;
        Shape shape;
        ShapeTopology shapeTopology;
        Intrinsics.checkNotNullParameter(contours, "contours");
        this.contours = contours;
        this.boundsDelegate = ResettableDelegateKt.resettableLazy(() -> Shape.boundsDelegate$lambda$1(this));
        Shape shape2 = this;
        if (this.contours.isEmpty()) {
            shapeTopology = ShapeTopology.OPEN;
        } else {
            boolean bl;
            Iterable $this$all$iv;
            boolean $i$f$all;
            block22: {
                Iterable iterable = this.contours;
                shape = shape2;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it2 = (ShapeContour)element$iv;
                        boolean bl2 = false;
                        if (it2.getClosed()) continue;
                        bl = false;
                        break block22;
                    }
                    bl = true;
                }
            }
            boolean bl3 = bl;
            shape2 = shape;
            if (bl3) {
                shapeTopology = ShapeTopology.CLOSED;
            } else {
                boolean bl4;
                block23: {
                    $this$all$iv = this.contours;
                    shape = shape2;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl4 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it2 = (ShapeContour)element$iv;
                            boolean bl5 = false;
                            if (!it2.getClosed()) continue;
                            bl4 = false;
                            break block23;
                        }
                        bl4 = true;
                    }
                }
                bl3 = bl4;
                shape2 = shape;
                shapeTopology = bl3 ? ShapeTopology.OPEN : ShapeTopology.MIXED;
            }
        }
        shape2.topology = shapeTopology;
        Shape shape3 = this;
        switch (WhenMappings.$EnumSwitchMapping$0[this.topology.ordinal()]) {
            case 1: {
                list2 = this.contours;
                break;
            }
            case 2: {
                list2 = CollectionsKt.emptyList();
                break;
            }
            case 3: {
                Iterator iterator2 = this.contours;
                shape = shape3;
                boolean $i$f$filter = false;
                it2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ShapeContour)element$iv$iv;
                    boolean bl = false;
                    if (!(!it.getClosed())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
                shape3 = shape;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        shape3.openContours = list2;
        Shape shape4 = this;
        switch (WhenMappings.$EnumSwitchMapping$0[this.topology.ordinal()]) {
            case 1: {
                list = CollectionsKt.emptyList();
                break;
            }
            case 2: {
                list = this.contours;
                break;
            }
            case 3: {
                $this$filter$iv = this.contours;
                shape = shape4;
                boolean $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ShapeContour)element$iv$iv;
                    boolean bl = false;
                    if (!it.getClosed()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                shape4 = shape;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        shape4.closedContours = list;
        this.triangulationDelegate = ResettableDelegateKt.resettableLazy(() -> Shape.triangulationDelegate$lambda$13(this));
        this.areaDelegate = ResettableDelegateKt.resettableLazy(() -> Shape.areaDelegate$lambda$15(this));
        this.region2Delegate = ResettableDelegateKt.resettableLazy(() -> Shape.region2Delegate$lambda$17(this));
        this.path2Delegate = ResettableDelegateKt.resettableLazy(() -> Shape.path2Delegate$lambda$19(this));
    }

    @NotNull
    public final List<ShapeContour> getContours() {
        return this.contours;
    }

    @Transient
    private static /* synthetic */ void getBoundsDelegate$annotations() {
    }

    @NotNull
    public final Rectangle getBounds() {
        return this.boundsDelegate.getValue(this, $$delegatedProperties[0]);
    }

    private static Object getBounds$delegate(Shape shape) {
        return shape.boundsDelegate;
    }

    @NotNull
    public final ShapeTopology getTopology() {
        return this.topology;
    }

    @Transient
    public static /* synthetic */ void getTopology$annotations() {
    }

    @NotNull
    public final List<ShapeContour> getOpenContours() {
        return this.openContours;
    }

    @Transient
    public static /* synthetic */ void getOpenContours$annotations() {
    }

    @NotNull
    public final List<ShapeContour> getClosedContours() {
        return this.closedContours;
    }

    @Transient
    public static /* synthetic */ void getClosedContours$annotations() {
    }

    public final boolean getEmpty() {
        return this == EMPTY || this.contours.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ContourPoint nearest(@NotNull Vector2 point) {
        Object v0;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(point, "point");
        if (!(!this.getEmpty())) {
            boolean $i$a$-require-Shape$nearest$22 = false;
            String $i$a$-require-Shape$nearest$22 = "cannot perform nearest point query on empty shape";
            throw new IllegalArgumentException($i$a$-require-Shape$nearest$22.toString());
        }
        Iterable $this$map$iv = this.contours;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ShapeContour shapeContour = (ShapeContour)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.nearest(point));
        }
        Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                ContourPoint it = (ContourPoint)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.position().squaredDistanceTo(point);
                do {
                    Object e$iv = iterator$iv.next();
                    ContourPoint it2 = (ContourPoint)e$iv;
                    $i$a$-minByOrNull-Shape$nearest$3 = false;
                    double v$iv = it2.position().squaredDistanceTo(point);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        ContourPoint contourPoint = v0;
        if (contourPoint == null) {
            throw new IllegalStateException("no nearest segment".toString());
        }
        return contourPoint;
    }

    public final boolean getLinear() {
        boolean bl;
        block7: {
            Iterable $this$all$iv = this.contours;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl2;
                    block6: {
                        ShapeContour it = (ShapeContour)element$iv;
                        boolean bl3 = false;
                        Iterable $this$all$iv2 = it.getSegments();
                        boolean $i$f$all2 = false;
                        if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv2 : $this$all$iv2) {
                                Segment2D segment = (Segment2D)element$iv2;
                                boolean bl4 = false;
                                if (segment.getLinear()) continue;
                                bl2 = false;
                                break block6;
                            }
                            bl2 = true;
                        }
                    }
                    if (bl2) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Shape polygon(double distanceTolerance) {
        Shape shape;
        if (this.getEmpty()) {
            shape = EMPTY;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.contours;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ShapeContour shapeContour = (ShapeContour)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.sampleLinear(distanceTolerance));
            }
            List list = (List)destination$iv$iv;
            shape = new Shape(list);
        }
        return shape;
    }

    public static /* synthetic */ Shape polygon$default(Shape shape, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return shape.polygon(d);
    }

    @Transient
    private static /* synthetic */ void getTriangulationDelegate$annotations() {
    }

    @NotNull
    public final List<Triangle> getTriangulation() {
        return this.triangulationDelegate.getValue(this, $$delegatedProperties[1]);
    }

    private static Object getTriangulation$delegate(Shape shape) {
        return shape.triangulationDelegate;
    }

    @Transient
    private static /* synthetic */ void getAreaDelegate$annotations() {
    }

    public final double getArea() {
        return ((Number)this.areaDelegate.getValue(this, $$delegatedProperties[2])).doubleValue();
    }

    private static Object getArea$delegate(Shape shape) {
        return shape.areaDelegate;
    }

    @Transient
    private static /* synthetic */ void getRegion2Delegate$annotations() {
    }

    @NotNull
    public final Region2 getRegion2$openrndr_shape() {
        return this.region2Delegate.getValue(this, $$delegatedProperties[3]);
    }

    private static Object getRegion2$openrndr_shape$delegate(Shape shape) {
        return shape.region2Delegate;
    }

    @Transient
    private static /* synthetic */ void getPath2Delegate$annotations() {
    }

    @NotNull
    public final List<Path2> getPath2$openrndr_shape() {
        return this.path2Delegate.getValue(this, $$delegatedProperties[4]);
    }

    private static Object getPath2$openrndr_shape$delegate(Shape shape) {
        return shape.path2Delegate;
    }

    public final void resetCache() {
        this.boundsDelegate.reset();
        this.triangulationDelegate.reset();
        this.areaDelegate.reset();
        this.region2Delegate.reset();
        this.path2Delegate.reset();
        Iterable $this$forEach$iv = this.contours;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShapeContour it = (ShapeContour)element$iv;
            boolean bl = false;
            it.resetCache();
        }
    }

    @NotNull
    public final List<Vector2> randomPoints(int pointCount, @NotNull Random random) {
        Intrinsics.checkNotNullParameter(random, "random");
        ArrayList<Double> arrayList = new ArrayList<Double>(pointCount);
        int n = 0;
        while (n < pointCount) {
            int n2;
            int n3 = n2 = n++;
            ArrayList<Double> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(random.nextDouble() * this.getArea());
        }
        List randomValues = CollectionsKt.toMutableList(CollectionsKt.sortedDescending((Iterable)arrayList));
        double sum = 0.0;
        List result2 = new ArrayList();
        block1: for (Triangle triangle : this.getTriangulation()) {
            sum += triangle.getArea();
            if (randomValues.isEmpty()) break;
            while (sum > ((Number)CollectionsKt.last(randomValues)).doubleValue()) {
                result2.add(Triangle.randomPoint$default(triangle, null, 1, null));
                CollectionsKt.removeLastOrNull(randomValues);
                if (!randomValues.isEmpty()) continue;
                continue block1;
            }
        }
        return result2;
    }

    public static /* synthetic */ List randomPoints$default(Shape shape, int n, Random random, int n2, Object object) {
        if ((n2 & 2) != 0) {
            random = Random.Default;
        }
        return shape.randomPoints(n, random);
    }

    @NotNull
    public final ShapeContour getOutline() {
        return this.contours.get(0);
    }

    @NotNull
    public final ShapeContour hole(int index) {
        return this.contours.get(index + 1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Shape transform(@NotNull Matrix44 transform2) {
        Shape shape;
        Intrinsics.checkNotNullParameter(transform2, "transform");
        if (this.getEmpty()) {
            shape = EMPTY;
        } else if (transform2 == Matrix44.Companion.getIDENTITY()) {
            shape = this;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.contours;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ShapeContour shapeContour = (ShapeContour)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.transform(transform2));
            }
            List list = (List)destination$iv$iv;
            shape = new Shape(list);
        }
        return shape;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Shape map(@NotNull Function1<? super ShapeContour, ShapeContour> mapper) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(mapper, "mapper");
        Iterable $this$map$iv = this.contours;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ShapeContour shapeContour = (ShapeContour)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(mapper.invoke((ShapeContour)it));
        }
        List list = (List)destination$iv$iv;
        return new Shape(list);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean getCompound() {
        boolean bl;
        if (this.contours.isEmpty()) {
            bl = false;
        } else {
            boolean bl2;
            Iterable $this$count$iv = this.contours;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                bl2 = false;
            } else {
                void var3_3;
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    ShapeContour it = (ShapeContour)element$iv;
                    boolean bl3 = false;
                    if (!(it.getWinding() == Winding.CLOCKWISE) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                bl2 = var3_3;
            }
            bl = bl2 > true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Shape> splitCompounds(@NotNull Winding winding) {
        List list;
        Intrinsics.checkNotNullParameter((Object)winding, "winding");
        if (this.contours.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            List it;
            ShapeContour outer;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Object element$iv2;
            Iterable $this$partition$iv = this.closedContours;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv2 : $this$partition$iv) {
                ShapeContour it2 = (ShapeContour)element$iv2;
                boolean bl = false;
                if (it2.getWinding() == winding) {
                    first$iv.add(element$iv2);
                    continue;
                }
                second$iv.add(element$iv2);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List cw2 = pair.component1();
            List ccw = pair.component2();
            Iterable $this$map$iv = cw2;
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$filterTo$iv$iv;
                ShapeContour shapeContour = (ShapeContour)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Iterable $this$filter$iv = ccw;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    ShapeContour it3 = (ShapeContour)element$iv$iv;
                    boolean bl2 = false;
                    if (!it3.getBounds().intersects(outer.getBounds())) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List cs = (List)destination$iv$iv2;
                collection.add(CollectionsKt.plus((Collection)CollectionsKt.listOf(outer), (Iterable)cs));
            }
            List candidates = (List)destination$iv$iv;
            $this$map$iv = this.openContours;
            collection = candidates;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                outer = (ShapeContour)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(CollectionsKt.listOf(it));
            }
            $this$map$iv = CollectionsKt.plus(collection, (Iterable)((List)destination$iv$iv));
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (List)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Shape(it));
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    public static /* synthetic */ List splitCompounds$default(Shape shape, Winding winding, int n, Object object) {
        if ((n & 1) != 0) {
            winding = Winding.CLOCKWISE;
        }
        return shape.splitCompounds(winding);
    }

    @Override
    @NotNull
    public Shape getShape() {
        return this;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Shape)) {
            return false;
        }
        return Intrinsics.areEqual(this.contours, ((Shape)other).contours);
    }

    public int hashCode() {
        return ((Object)this.contours).hashCode();
    }

    @NotNull
    public String toString() {
        return "Shape(org.openrndr.shape.contours=" + this.contours + ", topology=" + this.topology + ")";
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$openrndr_shape(Shape self, CompositeEncoder output, SerialDescriptor serialDesc) {
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], self.contours);
    }

    public /* synthetic */ Shape(int seen0, List contours, SerializationConstructorMarker serializationConstructorMarker) {
        List list;
        ShapeContour it;
        Iterable $this$filterTo$iv$iv;
        boolean $i$f$filterTo;
        Iterable $this$filter$iv;
        List list2;
        ShapeContour it2;
        Shape shape;
        ShapeTopology shapeTopology;
        if (1 != (1 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException(seen0, 1, $serializer.INSTANCE.getDescriptor());
        }
        this.contours = contours;
        this.boundsDelegate = ResettableDelegateKt.resettableLazy(() -> Shape._init_$lambda$31(this));
        Shape shape2 = this;
        if (this.contours.isEmpty()) {
            shapeTopology = ShapeTopology.OPEN;
        } else {
            boolean bl;
            Iterable $this$all$iv;
            boolean $i$f$all;
            block23: {
                Iterable iterable = this.contours;
                shape = shape2;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it2 = (ShapeContour)element$iv;
                        boolean bl2 = false;
                        if (it2.getClosed()) continue;
                        bl = false;
                        break block23;
                    }
                    bl = true;
                }
            }
            boolean bl3 = bl;
            shape2 = shape;
            if (bl3) {
                shapeTopology = ShapeTopology.CLOSED;
            } else {
                boolean bl4;
                block24: {
                    $this$all$iv = this.contours;
                    shape = shape2;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl4 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it2 = (ShapeContour)element$iv;
                            boolean bl5 = false;
                            if (!it2.getClosed()) continue;
                            bl4 = false;
                            break block24;
                        }
                        bl4 = true;
                    }
                }
                bl3 = bl4;
                shape2 = shape;
                shapeTopology = bl3 ? ShapeTopology.OPEN : ShapeTopology.MIXED;
            }
        }
        shape2.topology = shapeTopology;
        Shape shape3 = this;
        switch (WhenMappings.$EnumSwitchMapping$0[this.topology.ordinal()]) {
            case 1: {
                list2 = this.contours;
                break;
            }
            case 2: {
                list2 = CollectionsKt.emptyList();
                break;
            }
            case 3: {
                Iterator iterator2 = this.contours;
                shape = shape3;
                boolean $i$f$filter = false;
                it2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ShapeContour)element$iv$iv;
                    boolean bl = false;
                    if (!(!it.getClosed())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
                shape3 = shape;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        shape3.openContours = list2;
        Shape shape4 = this;
        switch (WhenMappings.$EnumSwitchMapping$0[this.topology.ordinal()]) {
            case 1: {
                list = CollectionsKt.emptyList();
                break;
            }
            case 2: {
                list = this.contours;
                break;
            }
            case 3: {
                $this$filter$iv = this.contours;
                shape = shape4;
                boolean $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ShapeContour)element$iv$iv;
                    boolean bl = false;
                    if (!it.getClosed()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                shape4 = shape;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        shape4.closedContours = list;
        this.triangulationDelegate = ResettableDelegateKt.resettableLazy(() -> Shape._init_$lambda$37(this));
        this.areaDelegate = ResettableDelegateKt.resettableLazy(() -> Shape._init_$lambda$39(this));
        this.region2Delegate = ResettableDelegateKt.resettableLazy(() -> Shape._init_$lambda$41(this));
        this.path2Delegate = ResettableDelegateKt.resettableLazy(() -> Shape._init_$lambda$43(this));
    }

    /*
     * WARNING - void declaration
     */
    private static final Rectangle boundsDelegate$lambda$1(Shape this$0) {
        Rectangle rectangle;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if (this$0.getEmpty()) {
            rectangle = RectangleKt.Rectangle(0.0, 0.0, 0.0, 0.0);
        } else {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = this$0.contours;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Rectangle it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                ShapeContour it = (ShapeContour)element$iv$iv;
                boolean bl2 = false;
                if ((it.getEmpty() ? null : it.getBounds()) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List result2 = (List)destination$iv$iv;
            rectangle = RectangleKt.getRectangleBounds(result2);
        }
        return rectangle;
    }

    /*
     * WARNING - void declaration
     */
    private static final List triangulationDelegate$lambda$13(Shape this$0) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Iterable $this$map$iv = CollectionsKt.windowed$default(TriangulatorKt.triangulate$default(this$0, 0.0, null, 6, null), 3, 3, false, 4, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Triangle((Vector2)it.get(0), (Vector2)it.get(1), (Vector2)it.get(2)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final double areaDelegate$lambda$15(Shape this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Iterable iterable = this$0.getTriangulation();
        double d = 0.0;
        for (Object t : iterable) {
            void it;
            Triangle triangle = (Triangle)t;
            double d2 = d;
            boolean bl = false;
            double d3 = it.getArea();
            d = d2 + d3;
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    private static final Region2 region2Delegate$lambda$17(Shape this$0) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Iterable $this$map$iv = this$0.contours;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ShapeContour shapeContour = (ShapeContour)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getRing2$openrndr_shape());
        }
        Iterable iterable2 = (List)destination$iv$iv;
        return new Region2(iterable2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List path2Delegate$lambda$19(Shape this$0) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Iterable $this$map$iv = this$0.contours;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ShapeContour shapeContour = (ShapeContour)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath2$openrndr_shape());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Rectangle _init_$lambda$31(Shape this$0) {
        Rectangle rectangle;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if (this$0.getEmpty()) {
            rectangle = RectangleKt.Rectangle(0.0, 0.0, 0.0, 0.0);
        } else {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = this$0.contours;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Rectangle it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                ShapeContour it = (ShapeContour)element$iv$iv;
                boolean bl2 = false;
                if ((it.getEmpty() ? null : it.getBounds()) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List result2 = (List)destination$iv$iv;
            rectangle = RectangleKt.getRectangleBounds(result2);
        }
        return rectangle;
    }

    /*
     * WARNING - void declaration
     */
    private static final List _init_$lambda$37(Shape this$0) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Iterable $this$map$iv = CollectionsKt.windowed$default(TriangulatorKt.triangulate$default(this$0, 0.0, null, 6, null), 3, 3, false, 4, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Triangle((Vector2)it.get(0), (Vector2)it.get(1), (Vector2)it.get(2)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final double _init_$lambda$39(Shape this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Iterable iterable = this$0.getTriangulation();
        double d = 0.0;
        for (Object t : iterable) {
            void it;
            Triangle triangle = (Triangle)t;
            double d2 = d;
            boolean bl = false;
            double d3 = it.getArea();
            d = d2 + d3;
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    private static final Region2 _init_$lambda$41(Shape this$0) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Iterable $this$map$iv = this$0.contours;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ShapeContour shapeContour = (ShapeContour)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getRing2$openrndr_shape());
        }
        Iterable iterable2 = (List)destination$iv$iv;
        return new Region2(iterable2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List _init_$lambda$43(Shape this$0) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Iterable $this$map$iv = this$0.contours;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ShapeContour shapeContour = (ShapeContour)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath2$openrndr_shape());
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Shape.class, "bounds", "getBounds()Lorg/openrndr/shape/Rectangle;", 0)), Reflection.property1(new PropertyReference1Impl(Shape.class, "triangulation", "getTriangulation()Ljava/util/List;", 0)), Reflection.property1(new PropertyReference1Impl(Shape.class, "area", "getArea()D", 0)), Reflection.property1(new PropertyReference1Impl(Shape.class, "region2", "getRegion2$openrndr_shape()Lorg/openrndr/kartifex/Region2;", 0)), Reflection.property1(new PropertyReference1Impl(Shape.class, "path2", "getPath2$openrndr_shape()Ljava/util/List;", 0))};
        $$delegatedProperties = objectArray;
        Companion = new Companion(null);
        objectArray = new KSerializer[]{new ArrayListSerializer(ShapeContour$.serializer.INSTANCE)};
        $childSerializers = objectArray;
        EMPTY = new Shape(CollectionsKt.emptyList());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/openrndr/shape/Shape$Companion;", "", "<init>", "()V", "EMPTY", "Lorg/openrndr/shape/Shape;", "getEMPTY", "()Lorg/openrndr/shape/Shape;", "compound", "shapes", "", "serializer", "Lkotlinx/serialization/KSerializer;", "openrndr-shape"})
    @SourceDebugExtension(value={"SMAP\nShape.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Shape.kt\norg/openrndr/shape/Shape$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,254:1\n1368#2:255\n1454#2,5:256\n*S KotlinDebug\n*F\n+ 1 Shape.kt\norg/openrndr/shape/Shape$Companion\n*L\n27#1:255\n27#1:256,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Shape getEMPTY() {
            return EMPTY;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Shape compound(@NotNull List<Shape> shapes) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter(shapes, "shapes");
            Iterable $this$flatMap$iv = shapes;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Shape it = (Shape)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getContours();
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            List list = (List)destination$iv$iv;
            return new Shape(list);
        }

        @NotNull
        public final KSerializer<Shape> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ShapeTopology.values().length];
            try {
                nArray[ShapeTopology.OPEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeTopology.CLOSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeTopology.MIXED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

